/*
 * Decompiled with CFR 0.152.
 */
package quadbase.common.param;

import java.util.Vector;
import quadbase.common.formula.Formula;
import quadbase.common.param.Param;
import quadbase.common.paramquery.QueryParser;
import quadbase.common.paramquery.QueryXMLFileInfo;
import quadbase.common.util.IQueryFileInfo;
import quadbase.common.util.internal.DBInfoBasic;
import quadbase.reportdesigner.report.Operand;
import quadbase.reportdesigner.report.Parameter;
import quadbase.reportdesigner.report.Report;

public abstract class AbstractParam
implements Param {
    protected String parent;
    protected Parameter parameter;

    public AbstractParam(String parent) {
        this.parent = parent;
    }

    public AbstractParam(String parent, Parameter parameter) {
        this(parent);
        this.parameter = parameter;
    }

    @Override
    public String parent() {
        return this.parent;
    }

    @Override
    public String name() {
        return this.parameter.getName();
    }

    @Override
    public String getPromptName() {
        return this.parameter.getPromptText();
    }

    @Override
    public void setPromptName(String promptName) {
        this.parameter.setPromptText(promptName);
    }

    @Override
    public boolean isCustomDateFormat() {
        return this.parameter.isCustomDateFormat();
    }

    @Override
    public String getDateFormat() {
        return this.parameter.getDateFormat();
    }

    @Override
    public boolean isMapToColumn() {
        return this.parameter.isMapToColumn();
    }

    @Override
    public void setMapToColumn(boolean mapToColumn) {
        this.parameter.setMapToColumn(mapToColumn);
    }

    @Override
    public String getTableName() {
        return this.parameter.getTableName();
    }

    @Override
    public void setTableName(String tableName) {
        this.parameter.setTableName(tableName);
    }

    @Override
    public String getColumnName() {
        return this.parameter.getColumnName();
    }

    @Override
    public void setColumnName(String columnName) {
        this.parameter.setColumnName(columnName);
    }

    @Override
    public int getSqlType() {
        return this.parameter.getSQLType();
    }

    @Override
    public void setSqlType(int sqlType) {
        this.parameter.setDatatype(Operand.mapToOperandType((int)sqlType));
    }

    @Override
    public boolean multiValue() {
        return this.parameter.isMultiValueParam();
    }

    @Override
    public Object getValue() {
        return this.parameter.getValue();
    }

    @Override
    public void setValue(Object value) {
        this.parameter.setValue(value);
    }

    @Override
    public Vector getValues() {
        return this.parameter.getValues();
    }

    @Override
    public void setValues(Vector values) {
        this.parameter.setValues(values);
    }

    @Override
    public Object getDefaultValue() {
        if (this.multiValue() && !(this.parameter.getDefaultValue() instanceof Vector)) {
            Vector<Object> values = new Vector<Object>();
            values.add(this.parameter.getDefaultValue());
            return values;
        }
        return this.parameter.getDefaultValue();
    }

    @Override
    public void setDefaultValue(Object defaultValue) {
        this.parameter.setDefaultValue(defaultValue);
    }

    @Override
    public Formula getDefaultValueVariable() {
        return this.parameter.getDefaultValueVariable();
    }

    @Override
    public void setDefaultValueVariable(Formula formula) {
        this.parameter.setDefaultValueVariable(formula);
    }

    @Override
    public Formula getValueVariable() {
        return this.parameter.getValueVariable();
    }

    @Override
    public void setValueVariable(Formula formula) {
        this.parameter.setValueVariable(formula);
    }

    @Override
    public Vector getSelectionChoices() {
        if (this.isMapToColumn() && this.isFormulaParam()) {
            if (this.getQueryFileInfo() instanceof QueryXMLFileInfo) {
                return QueryParser.getDistinctValues(((QueryXMLFileInfo)this.getQueryFileInfo()).getXMLFileQueryInfo(), this.getColumnName());
            }
            return QueryParser.getDistinctValues((DBInfoBasic)((Object)this.getQueryFileInfo()), this.getTableName(), this.getColumnName());
        }
        if (this.parameter != null) {
            return this.parameter.getSelectionChoices();
        }
        return null;
    }

    @Override
    public IQueryFileInfo getQueryFileInfo() {
        return this.parameter.getQueryFileInfo();
    }

    @Override
    public void setQueryFileInfo(IQueryFileInfo qf) {
        this.parameter.setQueryFileInfo(qf);
    }

    @Override
    public Report getReport() {
        return this.parameter.getReport();
    }

    @Override
    public void setReport(Report r) {
        this.parameter.setReport(r);
    }

    public boolean isShared() {
        return this.parameter.isShared();
    }

    public String getSharedReportName() {
        return this.parameter.getSharedReportName();
    }

    public String getSharedParamName() {
        return this.parameter.getSharedParamName();
    }

    public int getReferenceDegree() {
        return this.parameter.getReferenceDegree();
    }

    public Parameter getParameter() {
        return this.parameter;
    }

    @Override
    public String getSqlSelect() {
        return this.parameter.getSqlSelect();
    }

    @Override
    public void setSqlSelect(String sql) {
        this.parameter.setSqlSelect(sql);
    }

    @Override
    public String getDefaultSql() {
        return this.parameter.getDefaultSql();
    }

    @Override
    public void setDefaultSql(String sql) {
        this.parameter.setDefaultSql(sql);
    }

    @Override
    public boolean isUnmapped() {
        return (this.getSqlSelect() == null || this.getSqlSelect().equals("")) && !this.isMapToColumn();
    }
}

