/*
 * Decompiled with CFR 0.152.
 */
package quadbase.common.param;

import java.util.Vector;
import quadbase.common.param.AbstractParam;
import quadbase.common.param.FormulaParam;
import quadbase.common.param.OrderedParameterSet;
import quadbase.common.param.ParameterSet;
import quadbase.common.param.QueryParam;
import quadbase.common.param.QueryParamObj;
import quadbase.common.param.ReportParamSet;
import quadbase.common.param.RootQueryParam;
import quadbase.common.util.IQueryFileInfo;
import quadbase.reportdesigner.ReportElements.SubReportObject;
import quadbase.reportdesigner.report.DrillDownNode;
import quadbase.reportdesigner.report.Parameter;
import quadbase.reportdesigner.report.Report;
import quadbase.reportdesigner.util.IReport;

public class MergeParameters {
    ReportParamSet[] reportParamSets;
    Vector<ParameterSet> parameterVect = null;
    Report report;
    Report[] subreports;
    int[] ddMap;
    boolean debug = false;
    boolean hasSubReport = true;
    boolean ignoreSubreports = false;

    public MergeParameters(Report report, DrillDownNode ddnode, boolean ignoreSubreports) {
        this.ignoreSubreports = ignoreSubreports;
        this.setParametersForEachReport(report, ddnode);
        this.updateSharedSelectedReports();
    }

    public MergeParameters(Report report, DrillDownNode ddnode) {
        this(report, ddnode, false);
    }

    public MergeParameters(Report report) {
        this(report, null);
    }

    public MergeParameters(Report report, boolean ignoreSubreports) throws Exception {
        this(report, report.currentNode, ignoreSubreports);
    }

    public static OrderedParameterSet getParametersInSequence(Report report, DrillDownNode ddnode) {
        try {
            MergeParameters mp = new MergeParameters(report, ddnode);
            return mp.getParametersInSequence();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private void updateSharedSelectedReports() {
        for (ReportParamSet reportParamSet : this.reportParamSets) {
            QueryParamObj[] params = reportParamSet.getParamsInOrigSequence();
            for (int j = 0; params != null && j < params.length; ++j) {
                if (!params[j].isSelected()) continue;
                this.setSelected(params[j], true);
            }
        }
    }

    public int[] getDrillDownMap(DrillDownNode ddnode) {
        if (ddnode == null || ddnode.getColumnMapping().length == 0) {
            return null;
        }
        return ddnode.getColumnMapping();
    }

    public void setParametersForEachReport(Report report, DrillDownNode ddnode) {
        this.report = report;
        this.subreports = report.getSubReportArray(true);
        int size = 1;
        if (!this.ignoreSubreports && this.subreports != null && this.subreports.length > 0) {
            for (Report subreport : this.subreports) {
                if (subreport == null) continue;
                ++size;
                this.hasSubReport = true;
            }
        } else {
            this.hasSubReport = false;
            this.subreports = null;
        }
        this.reportParamSets = new ReportParamSet[size];
        this.ddMap = this.getDrillDownMap(ddnode);
        this.reportParamSets[0] = new ReportParamSet(report, "MAIN_REPORT", null, report.getPreviewSecurityLevel(), null);
        if (this.ignoreSubreports) {
            return;
        }
        if (this.subreports != null && this.subreports.length > 0) {
            report.setupSubReportParamMap((IReport[])this.subreports);
        }
        for (int i = 0; this.subreports != null && i < this.subreports.length; ++i) {
            if (this.subreports[i] == null) continue;
            String name = ((SubReportObject)report.subReports.get(i)).getParamShareReportID();
            this.reportParamSets[i + 1] = new ReportParamSet(this.subreports[i], name, ((SubReportObject)report.subReports.get(i)).getParameterMap(), report.getPreviewSecurityLevel(), report);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void merge(boolean remerge) throws Exception {
        if (this.parameterVect != null && !remerge) {
            return;
        }
        Vector<ParameterSet> vector = this.parameterVect = new Vector();
        synchronized (vector) {
            boolean runDD;
            if (this.parameterVect != null && !remerge) {
                return;
            }
            int reportCt = this.reportParamSets.length;
            boolean hasParameters = false;
            for (int i = 0; i < reportCt; ++i) {
                if (this.reportParamSets[i].getOrderCount() <= 0 && (this.reportParamSets[i].getFormulaParams() == null || this.reportParamSets[i].getFormulaParams().size() <= 0)) continue;
                hasParameters = true;
            }
            if (!hasParameters) {
                this.parameterVect = null;
                return;
            }
            boolean allFinished = false;
            boolean[] finished = new boolean[reportCt];
            int[] curOrder = new int[reportCt];
            int[] prevOrder = new int[reportCt];
            for (int i = 0; i < reportCt; ++i) {
                prevOrder[i] = -2;
            }
            boolean includeFormulaParameters = true;
            boolean bl = runDD = this.ddMap != null && this.ddMap.length > 0;
            while (!allFinished) {
                int i;
                for (int i2 = 0; i2 < reportCt; ++i2) {
                    curOrder[i2] = this.updateCurOrder(i2, curOrder[i2], includeFormulaParameters);
                    this.debug("CurOrder for report " + i2 + " after update : " + curOrder[i2]);
                    if (curOrder[i2] != -1) continue;
                    finished[i2] = true;
                }
                boolean sameAsPrev = true;
                for (i = 0; i < reportCt; ++i) {
                    if (curOrder[i] == prevOrder[i]) continue;
                    sameAsPrev = false;
                }
                if (sameAsPrev) {
                    throw new Exception("Unable to Merge Parameters.");
                }
                allFinished = this.checkFinished(finished);
                if (!allFinished) {
                    if (runDD) {
                        ParameterSet ps = new ParameterSet();
                        for (int i3 = 0; i3 < this.ddMap.length; ++i3) {
                            if (this.ddMap[i3] == -1) continue;
                            QueryParamObj qPObj = this.reportParamSets[0].getParamsInOrigSequence()[i3];
                            RootQueryParam qp = new RootQueryParam("Main_Report", qPObj.getQueryInParam());
                            ((AbstractParam)qp).setQueryFileInfo((IQueryFileInfo)((Object)this.report.dbInfo));
                            ((AbstractParam)qp).setReport(this.report);
                            ps.add(qp);
                            this.setSelected(qPObj, true);
                        }
                        this.parameterVect.add(ps);
                    } else {
                        this.parameterVect.add(this.getParametersForCurrentOrder(curOrder, includeFormulaParameters));
                        if (includeFormulaParameters) {
                            includeFormulaParameters = false;
                        }
                    }
                }
                if (!runDD) {
                    for (i = 0; i < reportCt; ++i) {
                        prevOrder[i] = curOrder[i];
                    }
                }
                runDD = false;
            }
        }
    }

    public OrderedParameterSet getParametersInSequence() throws Exception {
        this.merge(true);
        if (this.parameterVect == null) {
            return new OrderedParameterSet(new Vector());
        }
        return new OrderedParameterSet(this.parameterVect);
    }

    public OrderedParameterSet getParametersInSequence(int order) throws Exception {
        this.merge(true);
        if (this.parameterVect == null) {
            return new OrderedParameterSet(new Vector());
        }
        for (int i = order - 1; i >= 0; --i) {
            this.parameterVect.remove(i);
        }
        return new OrderedParameterSet(this.parameterVect);
    }

    public void fixTransitiveLinks() {
        for (ReportParamSet reportParamSet : this.reportParamSets) {
            for (int j = 0; reportParamSet.paramsInOrigSequence != null && j < reportParamSet.paramsInOrigSequence.length; ++j) {
                QueryParamObj tmpParam;
                QueryParamObj paramObj = reportParamSet.getParamsInOrigSequence()[j];
                Parameter param = paramObj.getParameter();
                if (!param.isShared()) continue;
                QueryParamObj shareRoot = this.getSharedTarget(paramObj);
                while (shareRoot.getParameter().isShared() && (tmpParam = this.getSharedTarget(shareRoot)) != shareRoot) {
                    shareRoot = tmpParam;
                }
                if (!shareRoot.getParameter().isShared()) {
                    param.setSharedReportName(shareRoot.getReportName());
                    param.setSharedParamName(shareRoot.getParameter().getName());
                    continue;
                }
                param.setShared(false);
                param.setSharedReportName(null);
                param.setSharedParamName(null);
            }
        }
    }

    public void fixSharedParamReferences() {
        if (!this.hasSubReport) {
            return;
        }
        this.fixTransitiveLinks();
        for (ReportParamSet reportParamSet : this.reportParamSets) {
            for (int j = 0; reportParamSet.paramsInOrigSequence != null && j < reportParamSet.paramsInOrigSequence.length; ++j) {
                Vector<QueryParamObj> sharedParams;
                QueryParamObj paramObj = reportParamSet.getParamsInOrigSequence()[j];
                Parameter param = paramObj.getParameter();
                if (param.isShared() || (sharedParams = this.getSharedParameters(paramObj, true)) == null || sharedParams.size() <= 1) continue;
                param.setReferenceDegree(sharedParams.size() - 1);
            }
        }
    }

    private ParameterSet getParametersForCurrentOrder(int[] order, boolean includeFormulaParameters) {
        String parentName;
        int i;
        ParameterSet pSet = new ParameterSet();
        for (i = 0; i < order.length; ++i) {
            parentName = "Main_Report";
            if (i > 0) {
                parentName = "Sub_Report_" + i;
            }
            if (!includeFormulaParameters) continue;
            Vector<Parameter> formParams = this.reportParamSets[i].getFormulaParams();
            for (int j = 0; j < formParams.size(); ++j) {
                boolean exists = false;
                if (exists || formParams.get(j).isShared()) continue;
                FormulaParam fp = new FormulaParam(parentName, formParams.get(j));
                if (i == 0) {
                    fp.setReport(this.report);
                } else {
                    fp.setReport(this.subreports[i - 1]);
                }
                pSet.add(fp);
            }
        }
        for (i = 0; i < order.length; ++i) {
            parentName = "Main_Report";
            if (order[i] == -1 || order[i] > this.reportParamSets[i].getMaxOrder()) continue;
            for (int j = 0; j < this.reportParamSets[i].getParamCountAt(order[i]); ++j) {
                QueryParamObj qPObj = this.reportParamSets[i].getParamObj(order[i], j);
                if (qPObj.isSelected() || qPObj.getOrder() != this.getSharedParamWithMaxOrder(qPObj).getOrder()) continue;
                QueryParam qp = null;
                QueryParamObj target = this.getSharedTarget(qPObj);
                if (target.reportName.equals(this.reportParamSets[0].getReportName())) {
                    qp = new RootQueryParam(parentName, target.getQueryInParam());
                    qp.setQueryFileInfo((IQueryFileInfo)((Object)this.report.dbInfo));
                    qp.setReport(this.report);
                } else {
                    Report tarReport = null;
                    for (int k = 0; k < this.reportParamSets.length; ++k) {
                        if (!target.reportName.equals(this.reportParamSets[k].getReportName())) continue;
                        tarReport = this.subreports[k - 1];
                        parentName = "Sub_Report_" + k;
                    }
                    qp = new QueryParam(parentName, target.getParameter());
                    if (tarReport != null) {
                        qp.setQueryFileInfo((IQueryFileInfo)((Object)tarReport.dbInfo));
                        qp.setReport(tarReport);
                    }
                }
                pSet.add(qp);
                this.setSelected(qPObj, true);
            }
        }
        return pSet;
    }

    public ReportParamSet getReportParamSet(int index) {
        return this.reportParamSets[index];
    }

    private int updateCurOrder(int reportIndex, int start, boolean considerFormulaParams) {
        if (start == -1) {
            return -1;
        }
        int order = start;
        while (true) {
            ReportParamSet rps = this.reportParamSets[reportIndex];
            if (considerFormulaParams) {
                if (this.ddMap == null && rps.getMaxOrder() == -1 && rps.getFormulaParams() != null && rps.getFormulaParams().size() > 0) {
                    return 0;
                }
                if (this.ddMap != null && rps.getMaxOrder() == 0 && rps.getFormulaParams() != null && rps.getFormulaParams().size() > 0) {
                    return 0;
                }
            }
            if (order > rps.getMaxOrder()) {
                return -1;
            }
            for (int i = 0; i < rps.getParamCountAt(order); ++i) {
                if (rps.getParamObj(order, i).isSelected()) continue;
                this.debug("reportIndex -- " + reportIndex + " order -- " + order + " param -- " + rps.getParamObj(order, i).getParameter().getName());
                return order;
            }
            ++order;
        }
    }

    private boolean checkFinished(boolean[] fin) {
        for (int i = 0; i < fin.length; ++i) {
            if (fin[i]) continue;
            return false;
        }
        return true;
    }

    public void setSelected(QueryParamObj qPObj, boolean selected) {
        Vector<QueryParamObj> sharedParams = this.getSharedParameters(qPObj);
        for (int i = 0; i < sharedParams.size(); ++i) {
            sharedParams.get(i).setSelected(selected);
        }
    }

    public int getReportCount() {
        return this.reportParamSets.length;
    }

    public QueryParamObj getSharedTarget(QueryParamObj param) {
        if (!param.getParameter().isShared() || param.getParameter().getSharedParamName() == null) {
            return param;
        }
        for (ReportParamSet paramSet : this.reportParamSets) {
            for (int porder = 0; porder < paramSet.getOrderCount(); ++porder) {
                for (int pindex = 0; pindex < paramSet.getParamCountAt(porder); ++pindex) {
                    Parameter p = paramSet.getParamObj(porder, pindex).getParameter();
                    if (!param.getParameter().getSharedParamName().equals(p.getName()) || p.getReferenceDegree() <= 0) continue;
                    return paramSet.getParamObj(porder, pindex);
                }
            }
        }
        return param;
    }

    public QueryParamObj getSharedParamWithMaxOrder(ReportParamSet param, int order, int index) {
        return this.getSharedParamWithMaxOrder(param.getParamObj(order, index));
    }

    public QueryParamObj getSharedParamWithMaxOrder(QueryParamObj param) {
        Vector<QueryParamObj> sharedParams = this.getSharedParameters(param);
        QueryParamObj maxOrder = param;
        for (int i = 0; i < sharedParams.size(); ++i) {
            QueryParamObj paramObj = sharedParams.get(i);
            if (paramObj.getOrder() <= maxOrder.getOrder()) continue;
            maxOrder = paramObj;
        }
        return maxOrder;
    }

    public Vector<QueryParamObj> getSharedParameters(ReportParamSet origReportParamSet, int order, int index) {
        return this.getSharedParameters(origReportParamSet.getParamObj(order, index));
    }

    public Vector<QueryParamObj> getSharedParameters(QueryParamObj paramObj) {
        return this.getSharedParameters(paramObj, false);
    }

    public Vector<QueryParamObj> getSharedParameters(QueryParamObj paramObj, boolean exhaustive) {
        Parameter param = paramObj.getParameter();
        Vector<QueryParamObj> sharedParams = new Vector<QueryParamObj>();
        sharedParams.add(paramObj);
        if (!this.hasSubReport) {
            return sharedParams;
        }
        if (!exhaustive && !param.isShared() && param.getReferenceDegree() == 0) {
            return sharedParams;
        }
        for (ReportParamSet paramSet : this.reportParamSets) {
            if (param.isShared() && !param.getSharedReportName().equals(paramSet.name)) continue;
            for (int porder = 0; porder < paramSet.getOrderCount(); ++porder) {
                for (int pindex = 0; pindex < paramSet.getParamCountAt(porder); ++pindex) {
                    Parameter p = paramSet.getParameter(porder, pindex);
                    if (param.isShared()) {
                        if (!param.getSharedParamName().equals(p.getName())) continue;
                        return this.getSharedParameters(paramSet, porder, pindex);
                    }
                    if (!p.isShared() || !p.getSharedReportName().equals(paramObj.getReportName()) || !p.getSharedParamName().equals(param.getName())) continue;
                    sharedParams.add(paramSet.getParamObj(porder, pindex));
                }
            }
        }
        return sharedParams;
    }

    private void debug(String msg) {
        if (this.debug) {
            System.out.println(msg);
        }
    }
}

