/*
 * Decompiled with CFR 0.152.
 */
package quadbase.common.param;

import java.util.Vector;
import quadbase.common.param.Param;
import quadbase.common.param.ParameterSet;
import quadbase.common.param.Parameters;

public class OrderedParameterSet
implements Parameters {
    Vector orderedParamSet = null;

    public OrderedParameterSet(Vector orderedParamSet) {
        this.orderedParamSet = orderedParamSet;
    }

    @Override
    public Param get(int index) {
        for (int order = 0; order < this.orderedParamSet.size(); ++order) {
            if (this.getParamsAt(order).size() <= index) {
                index -= this.getParamsAt(order).size();
                continue;
            }
            return this.getParamsAt(order).get(index);
        }
        return null;
    }

    public Parameters getParamsAt(int order) {
        return (Parameters)this.orderedParamSet.get(order);
    }

    public Param get(int order, int index) {
        return this.getParamsAt(order).get(index);
    }

    @Override
    public Param get(String parent, String name, boolean isFormula) {
        for (int i = 0; i < this.orderedParamSet.size(); ++i) {
            Parameters params = this.getParamsAt(i);
            for (int j = 0; j < params.size(); ++j) {
                Param param = params.get(j);
                if (!param.parent().equals(parent) || !param.name().equals(name) || param.isFormulaParam() != isFormula) continue;
                return param;
            }
        }
        return null;
    }

    @Override
    public Parameters get(String name) {
        ParameterSet pset = new ParameterSet();
        for (int i = 0; i < this.orderedParamSet.size(); ++i) {
            Parameters params = this.getParamsAt(i);
            for (int j = 0; j < params.size(); ++j) {
                Param param = params.get(j);
                if (!param.name().equals(name)) continue;
                pset.add(param);
            }
        }
        return pset;
    }

    public int getParamCount() {
        int size = 0;
        for (int i = 0; i < this.orderedParamSet.size(); ++i) {
            size += this.getParamsAt(i).size();
        }
        return size;
    }

    public int getOrderCount() {
        return this.orderedParamSet.size();
    }

    @Override
    public int size() {
        return this.getParamCount();
    }

    public Parameters get(int order, String name) {
        ParameterSet pset = new ParameterSet();
        Parameters params = this.getParamsAt(order);
        for (int j = 0; j < params.size(); ++j) {
            Param param = params.get(j);
            if (!param.name().equals(name)) continue;
            pset.add(param);
        }
        return pset;
    }

    public int getOrder(int index) {
        int i = 0;
        int len = this.getParamsAt(i).size();
        while (index >= len) {
            index -= len;
            if (++i == this.getOrderCount()) {
                return i;
            }
            len = this.getParamsAt(i).size();
        }
        return i;
    }

    public int getParamIndex(int order) {
        int sum = 0;
        for (int i = 0; i < order; ++i) {
            int ct = 0;
            for (int j = 0; j < this.getParamsAt(i).size(); ++j) {
                ct = j + 1;
            }
            sum += ct;
        }
        return sum;
    }

    public void remove(int order) {
        this.orderedParamSet.remove(order);
    }
}

