/*
 * Decompiled with CFR 0.152.
 */
package quadbase.common.param;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.Vector;
import quadbase.common.param.Param;
import quadbase.common.param.ParameterPage;
import quadbase.common.param.Parameters;
import quadbase.common.param.ReportParameterPage;
import quadbase.common.util.IQueryFileInfo;
import quadbase.common.util.internal.DataType;

public abstract class ParameterPageWriter
extends PrintWriter {
    protected ParameterPage page;
    protected String[] paramPageExportFormats;
    protected String securityLevel;
    protected String targetLoc;
    protected int format;
    protected String extraFormContent;
    protected String[] paramNameArr;
    protected String[] paramValueArr;
    protected String[] paramDateFormat;
    protected IQueryFileInfo dbInfo;
    protected boolean paramPageResetEnabled;
    protected int paramPageLayout;
    protected int alignment;
    protected String header;
    protected String footer;
    protected boolean tableOuterBorderOnly;
    protected String tableBackgroundColor;
    protected String tableBorderColor;
    protected int tableBorderThickness;
    protected String textColor;
    protected String textFont;
    protected int textSize;
    protected int textStyle;
    protected String titleText;
    protected String titleTextColor;
    protected String titleTextFont;
    protected int titleTextSize;
    protected int titleTextStyle;
    protected String docTitle;
    protected String backgroundImage;
    protected String backgroundColor;
    protected boolean dateParameterSelection;
    protected boolean dateParameterCalendar;
    protected String dateParameterCalendarDatepicker = "../datepicker/";
    protected boolean dateVariable;
    protected String dateVariableDatepicker = "../datepicker/";

    public ParameterPageWriter(ParameterPage page, Writer out) {
        super(out);
        this.page = page;
        this.paramPageExportFormats = page.getParamPageExportFormats();
        this.targetLoc = page.getTargetLoc();
        this.format = page.getFormat();
        if (page instanceof ReportParameterPage) {
            this.securityLevel = ((ReportParameterPage)page).getSecurityLevel();
        }
        this.extraFormContent = page.getExtraFormContent();
        this.paramPageResetEnabled = page.getResetEnabled();
        this.paramPageLayout = page.getTableLayout();
        this.alignment = page.getAlignment();
        this.header = page.getHeader();
        this.footer = page.getFooter();
        this.tableOuterBorderOnly = page.getTableOuterBorderOnly();
        this.tableBackgroundColor = page.getTableBackgroundColorHex();
        this.tableBorderColor = page.getTableBorderColorHex();
        this.tableBorderThickness = page.getTableBorderThickness();
        this.textColor = page.getTextColorHex();
        this.textFont = page.getTextFont();
        this.textSize = page.getTextSize();
        this.textStyle = page.getTextStyle();
        this.titleText = page.getTitleText();
        this.titleTextColor = page.getTitleTextColorHex();
        this.titleTextFont = page.getTitleTextFont();
        this.titleTextSize = page.getTitleTextSize();
        this.titleTextStyle = page.getTitleTextStyle();
        this.docTitle = page.getDocumentTitle();
        this.backgroundImage = page.getBackgroundImage();
        this.backgroundColor = page.getBackgroundColorHex();
        this.dateParameterSelection = page.getDateParameterSelection();
        this.dateParameterCalendar = page.getDateParameterCalendar();
        this.dateParameterCalendarDatepicker = page.getDateParameterCalendarDatepicker();
        this.dateVariable = page.getDateVariable();
        this.dateVariableDatepicker = page.getDateVariableDatepicker();
        this.initFilterTableContent();
    }

    public abstract void writePage() throws IOException;

    public void refresh() {
        this.initFilterTableContent();
    }

    private void initFilterTableContent() {
        this.dbInfo = this.page.getDbInfo();
        Parameters params = this.page.getParameters();
        int paramSetSize = params.size();
        this.paramNameArr = new String[paramSetSize];
        this.paramValueArr = new String[paramSetSize];
        this.paramDateFormat = new String[paramSetSize];
        for (int i = 0; i < paramSetSize; ++i) {
            Param p = params.get(i);
            if (p.isCustomDateFormat()) {
                this.paramDateFormat[i] = p.getDateFormat();
            }
            this.paramNameArr[i] = p.getPromptName();
            Object value = null;
            if (p.multiValue()) {
                Vector vec = p.getValues();
                if (vec != null) {
                    for (int j = 0; j < vec.size(); ++j) {
                        value = j == 0 ? DataType.toString(vec.elementAt(j), this.paramDateFormat[i]) : value + ", " + DataType.toString(vec.elementAt(j), this.paramDateFormat[i]);
                    }
                }
            } else {
                value = p.getValue();
            }
            if (value == null) {
                value = p.getDefaultValue();
            }
            if (value == null || p.getSqlType() != 12 && value.equals("")) {
                value = p.getDefaultValue();
            }
            if (p.getDefaultValueVariable() != null) {
                value = p.getDefaultValue();
            }
            this.paramValueArr[i] = value == null || value.toString().equals("[null]") ? "To be filled in" : DataType.toString(value, this.paramDateFormat[i]);
        }
    }
}

