/*
 * Decompiled with CFR 0.152.
 */
package quadbase.common.param;

import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;
import quadbase.common.param.Param;
import quadbase.common.param.ParameterSet;
import quadbase.common.param.Parameters;

class ParameterTable {
    Hashtable hashtable = new Hashtable();

    ParameterTable() {
    }

    void add(Param p) {
        Object value = this.hashtable.get(p.name());
        if (value == null) {
            this.hashtable.put(p.name(), p);
        } else if (value instanceof Vector) {
            ((Vector)value).add(p);
        } else {
            Vector<Object> v = new Vector<Object>();
            v.add(value);
            v.add(p);
            this.hashtable.put(p.name(), v);
        }
    }

    Param get(String parent, String name, boolean isFormula) {
        Object value = this.hashtable.get(name);
        if (value == null) {
            return null;
        }
        if (value instanceof Vector) {
            Vector v = (Vector)value;
            for (Param p : v) {
                if (!p.parent().equals(parent) || p.isFormulaParam() != isFormula) continue;
                return p;
            }
            return null;
        }
        Param p = (Param)value;
        if (p.parent().equals(parent) && p.isFormulaParam() == isFormula) {
            return p;
        }
        return null;
    }

    Parameters get(String name) {
        Object value = this.hashtable.get(name);
        if (value == null) {
            return null;
        }
        ParameterSet result = new ParameterSet();
        if (value instanceof Vector) {
            Vector v = (Vector)value;
            Iterator i = v.iterator();
            while (i.hasNext()) {
                result.add((Param)i.next());
            }
        } else {
            result.add((Param)value);
        }
        return result;
    }
}

