/*
 * Decompiled with CFR 0.152.
 */
package quadbase.common.paramquery;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTree;
import javax.swing.ToolTipManager;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreeCellRenderer;
import quadbase.common.swing.UndoTextArea;
import quadbase.common.util.internal.JMessageDialog;
import quadbase.common.util.internal.LanguageEncoder;
import quadbase.common.util.internal.QbDateFormat;

public class BuildDateFormatDialog
extends JDialog
implements ActionListener,
MouseListener {
    private boolean modified = false;
    private String dateFormat;
    private UndoTextArea ta;
    private JButton okBtn;
    private JButton cancelBtn;
    private JTree tableTree;
    protected String[][][] types = new String[][][]{{{LanguageEncoder.getText("Year"), LanguageEncoder.getText("4 Digit"), "yyyy", LanguageEncoder.getText("Ex: 1984, 2000, 2008")}, {LanguageEncoder.getText("Year"), LanguageEncoder.getText("2 Digit"), "yy", LanguageEncoder.getText("Ex: 84, 00, 08")}}, {{LanguageEncoder.getText("Month"), LanguageEncoder.getText("Numeric With Leading 0"), "MM", LanguageEncoder.getText("Ex: 02, 07, 12")}, {LanguageEncoder.getText("Month"), LanguageEncoder.getText("Numeric Without Leading 0"), "M", LanguageEncoder.getText("Ex: 2, 7, 12")}, {LanguageEncoder.getText("Month"), LanguageEncoder.getText("Full Name"), "MMMM", LanguageEncoder.getText("Ex: February, July, December")}, {LanguageEncoder.getText("Month"), LanguageEncoder.getText("Abbrev. Name"), "MMM", LanguageEncoder.getText("Ex: Feb, Jul, Dec")}}, {{LanguageEncoder.getText("Day"), LanguageEncoder.getText("With Leading 0"), "dd", LanguageEncoder.getText("Ex: 01, 14, 31")}, {LanguageEncoder.getText("Day"), LanguageEncoder.getText("Without Leading 0"), "d", LanguageEncoder.getText("Ex: 1, 14, 31")}}, {{LanguageEncoder.getText("Era"), LanguageEncoder.getText("Abbrev. Name"), "G", LanguageEncoder.getText("Ex: AD")}}, {{LanguageEncoder.getText("Day in Week"), LanguageEncoder.getText("Full Name"), "EEEE", LanguageEncoder.getText("Ex: Monday, Friday, Sunday")}, {LanguageEncoder.getText("Day in Week"), LanguageEncoder.getText("Abbrev. Name"), "E", LanguageEncoder.getText("Ex: Mon, Fri, Sun")}}, {{LanguageEncoder.getText("Day in Year"), LanguageEncoder.getText("With Leading 0"), "DDD", LanguageEncoder.getText("Ex: 001, 065, 365")}, {LanguageEncoder.getText("Day in Year"), LanguageEncoder.getText("Without Leading 0"), "D", LanguageEncoder.getText("Ex: 1, 65, 365")}}, {{LanguageEncoder.getText("Day of Week in Month"), LanguageEncoder.getText("One Digit Number"), "F", LanguageEncoder.getText("Ex: For a given Wed - 2 (Second Wed of that month), 4 (Fourth Wed of that month)")}}, {{LanguageEncoder.getText("Week in Year"), LanguageEncoder.getText("With Leading 0"), "ww", LanguageEncoder.getText("Ex: 05, 12, 52")}, {LanguageEncoder.getText("Week in Year"), LanguageEncoder.getText("Without Leading 0"), "w", LanguageEncoder.getText("Ex: 5, 12, 52")}}, {{LanguageEncoder.getText("Week in Month"), LanguageEncoder.getText("One Digit Number"), "W", LanguageEncoder.getText("Ex: 2, 4")}}, {{LanguageEncoder.getText("Hour"), LanguageEncoder.getText("1-12 With Leading 0"), "hh", LanguageEncoder.getText("Ex: 02, 04, 12")}, {LanguageEncoder.getText("Hour"), LanguageEncoder.getText("1-12 Without Leading 0"), "h", LanguageEncoder.getText("Ex: 2, 4, 12")}, {LanguageEncoder.getText("Hour"), LanguageEncoder.getText("0-23 With Leading 0"), "HH", LanguageEncoder.getText("Ex: 00, 01, 03")}, {LanguageEncoder.getText("Hour"), LanguageEncoder.getText("0-23 Without Leading 0"), "H", LanguageEncoder.getText("Ex: 0, 1, 3")}, {LanguageEncoder.getText("Hour"), LanguageEncoder.getText("0-11 With Leading 0"), "KK", LanguageEncoder.getText("Ex: 00, 01, 03")}, {LanguageEncoder.getText("Hour"), LanguageEncoder.getText("0-11 Without Leading 0"), "K", LanguageEncoder.getText("Ex: 0, 1, 3")}, {LanguageEncoder.getText("Hour"), LanguageEncoder.getText("1-24 With Leading 0"), "kk", LanguageEncoder.getText("Ex: 01, 03, 24")}, {LanguageEncoder.getText("Hour"), LanguageEncoder.getText("1-24 Without Leading 0"), "k", LanguageEncoder.getText("Ex: 1, 3, 24")}}, {{LanguageEncoder.getText("Minute"), LanguageEncoder.getText("With Leading 0"), "mm", LanguageEncoder.getText("Ex: 05, 20, 59")}, {LanguageEncoder.getText("Minute"), LanguageEncoder.getText("Without Leading 0"), "m", LanguageEncoder.getText("Ex: 5, 20, 59")}}, {{LanguageEncoder.getText("Second"), LanguageEncoder.getText("With Leading 0"), "ss", LanguageEncoder.getText("Ex: 05, 20, 59")}, {LanguageEncoder.getText("Second"), LanguageEncoder.getText("Without Leading 0"), "s", LanguageEncoder.getText("Ex: 5, 20, 59")}}, {{LanguageEncoder.getText("Millisecond"), LanguageEncoder.getText("With Leading 0"), "SSS", LanguageEncoder.getText("Ex: 000, 017, 132")}, {LanguageEncoder.getText("Millisecond"), LanguageEncoder.getText("Without Leading 0"), "S", LanguageEncoder.getText("Ex: 0, 17, 132")}}, {{LanguageEncoder.getText("Time Zone"), LanguageEncoder.getText("Abbrev. Name"), "z", LanguageEncoder.getText("Ex: EST, PDT")}, {LanguageEncoder.getText("Time Zone"), LanguageEncoder.getText("Full Name"), "zzzz", LanguageEncoder.getText("Ex: Eastern Standard Time, Pacific Daylight Time")}}};

    public BuildDateFormatDialog(JDialog parent, String dateFormat) {
        super(parent, "Date Format Builder", true);
        this.dateFormat = dateFormat;
        this.init(dateFormat);
        this.setPosition();
    }

    private void init(String dateFormat) {
        JScrollPane editPanel = new JScrollPane();
        this.ta = new UndoTextArea(dateFormat, 16, 60);
        editPanel.getViewport().add((Component)this.ta);
        JSplitPane splitPane = new JSplitPane(1, false);
        splitPane.setLeftComponent(editPanel);
        splitPane.setRightComponent(this.getHelperPanel());
        JPanel contentPane = (JPanel)this.getContentPane();
        contentPane.setLayout(new BorderLayout());
        contentPane.add((Component)splitPane, "Center");
        contentPane.add((Component)this.getButtonPanel(), "South");
    }

    public JScrollPane getHelperPanel() {
        DefaultMutableTreeNode[] allTables = new DefaultMutableTreeNode[this.types.length];
        DefaultMutableTreeNode root = new DefaultMutableTreeNode("Elements");
        for (int i = 0; i < this.types.length; ++i) {
            NodeObject folderObj = new NodeObject(this.types[i][0][0], "Contains " + this.types[i].length + " formats");
            DefaultMutableTreeNode node = new DefaultMutableTreeNode(folderObj);
            for (int j = 0; j < this.types[i].length; ++j) {
                NodeObject obj = new NodeObject(this.types[i][j][1], this.types[i][j][3]);
                DefaultMutableTreeNode subnode = new DefaultMutableTreeNode(obj);
                subnode.setAllowsChildren(false);
                node.add(subnode);
            }
            allTables[i] = node;
        }
        for (DefaultMutableTreeNode allTable : allTables) {
            root.add(allTable);
        }
        this.tableTree = new JTree(root, true);
        ToolTipManager.sharedInstance().registerComponent(this.tableTree);
        ToolTipTreeCellRenderer renderer = new ToolTipTreeCellRenderer();
        this.tableTree.setCellRenderer(renderer);
        this.tableTree.setRootVisible(false);
        this.tableTree.setVisibleRowCount(14);
        this.tableTree.addMouseListener(this);
        JScrollPane scroll = new JScrollPane();
        scroll.getViewport().add(this.tableTree);
        Dimension d = scroll.getPreferredSize();
        scroll.setPreferredSize(new Dimension(250, (int)d.getHeight()));
        return scroll;
    }

    public JPanel getButtonPanel() {
        JPanel buttonPanel = new JPanel(new BorderLayout());
        JPanel symbolButtonPanel = new JPanel(new FlowLayout(1));
        this.addSymbolToPanel("/", symbolButtonPanel);
        this.addSymbolToPanel("-", symbolButtonPanel);
        this.addSymbolToPanel("Space", symbolButtonPanel, false);
        this.addSymbolToPanel(",", symbolButtonPanel);
        this.addSymbolToPanel(".", symbolButtonPanel);
        this.addSymbolToPanel(":", symbolButtonPanel);
        this.addSymbolToPanel("_", symbolButtonPanel);
        JPanel actionButtonPanel = new JPanel(new FlowLayout(1));
        this.okBtn = new JButton(LanguageEncoder.getText("OK"));
        actionButtonPanel.add(this.okBtn);
        this.okBtn.addActionListener(this);
        this.cancelBtn = new JButton(LanguageEncoder.getText("Cancel"));
        actionButtonPanel.add(this.cancelBtn);
        this.cancelBtn.addActionListener(this);
        buttonPanel.add((Component)symbolButtonPanel, "North");
        buttonPanel.add((Component)actionButtonPanel, "South");
        return buttonPanel;
    }

    private void addSymbolToPanel(String buttonText, JPanel panel) {
        this.addSymbolToPanel(buttonText, panel, true);
    }

    private void addSymbolToPanel(String buttonText, JPanel panel, boolean changeFont) {
        JButton btn = new JButton(buttonText);
        if (changeFont) {
            btn.setFont(new Font("Dialog", 1, 12));
        }
        panel.add(btn);
        btn.addActionListener(this);
    }

    private void setPosition() {
        this.pack();
        this.setLocationRelativeTo(this.getParent());
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        if (source == this.okBtn) {
            this.dateFormat = this.ta.getText();
            if (QbDateFormat.checkDateFormat(this.dateFormat) != null) {
                new JMessageDialog((Dialog)this, "ERROR", LanguageEncoder.getText(QbDateFormat.checkDateFormat(this.dateFormat)));
                return;
            }
            this.modified = true;
            this.setVisible(false);
            this.dispose();
        } else if (source == this.cancelBtn) {
            this.setVisible(false);
            this.dispose();
        } else if (source instanceof JButton) {
            JButton btn = (JButton)source;
            if (btn.getText().equalsIgnoreCase("Space")) {
                this.insertText(" ");
            } else {
                this.insertText("" + btn.getText().trim());
            }
        }
    }

    public boolean isModified() {
        return this.modified;
    }

    public String getDateFormat() {
        return this.dateFormat;
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (this.tableTree.getSelectionPath() == null) {
            return;
        }
        int selRow = this.tableTree.getRowForLocation(e.getX(), e.getY());
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)this.tableTree.getSelectionPath().getLastPathComponent();
        if (node.isLeaf() && selRow != -1 && e.getClickCount() >= 2) {
            this.insertText(this.getSelectedText());
        }
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    private String getSelectedText() {
        if (this.tableTree.isSelectionEmpty()) {
            return null;
        }
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)this.tableTree.getSelectionPath().getLastPathComponent();
        DefaultMutableTreeNode pNode = (DefaultMutableTreeNode)node.getParent();
        if (pNode.isRoot()) {
            for (String[][] type : this.types) {
                if (!node.getUserObject().toString().equals(type[0][0])) continue;
                return type[0][2];
            }
        } else {
            String[][][] stringArray = this.types;
            int n = stringArray.length;
            for (int i = 0; i < n; ++i) {
                String[][] type;
                for (String[] element : type = stringArray[i]) {
                    if (!pNode.getUserObject().toString().equals(element[0]) || !node.getUserObject().toString().equals(element[1])) continue;
                    return element[2];
                }
            }
        }
        return "";
    }

    private void insertText(String newStr) {
        if (newStr == null) {
            return;
        }
        this.ta.replaceSelection(newStr);
    }

    public String getText() {
        return this.getDateFormat();
    }

    private class ToolTipTreeCellRenderer
    implements TreeCellRenderer {
        DefaultTreeCellRenderer renderer = new DefaultTreeCellRenderer();

        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            Object tipKey;
            this.renderer.getTreeCellRendererComponent(tree, value, selected, expanded, leaf, row, hasFocus);
            if (value != null && value instanceof DefaultMutableTreeNode && (tipKey = ((DefaultMutableTreeNode)value).getUserObject()) instanceof NodeObject) {
                this.renderer.setToolTipText(((NodeObject)tipKey).getTooltip());
            }
            return this.renderer;
        }
    }

    private class NodeObject {
        private String name;
        private String tooltip;

        public NodeObject(String name, String tooltip) {
            this.name = name;
            this.tooltip = tooltip;
        }

        String getTooltip() {
            return this.tooltip;
        }

        public String toString() {
            return this.name;
        }
    }
}

