/*
 * Decompiled with CFR 0.152.
 */
package quadbase.common.paramquery;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import quadbase.common.formula.DateFormulaParser;
import quadbase.common.formula.Formula;
import quadbase.common.formula.ParseException;
import quadbase.common.util.internal.JMessageDialog;
import quadbase.common.util.internal.LanguageEncoder;

public class DateVariableDialog
extends JDialog
implements ActionListener {
    JButton okButton;
    JButton cancelButton;
    JButton currentDateBtn;
    JButton currentTimeBtn;
    JButton currentDateTimeBtn;
    JButton plusBtn;
    JButton minusBtn;
    JButton yearBtn;
    JButton monthBtn;
    JButton weekBtn;
    JButton dayBtn;
    JButton hourBtn;
    JButton minBtn;
    JButton secBtn;
    JButton firstOfYear;
    JButton firstOfQuarter;
    JButton firstOfMonth;
    JButton firstOfWeek;
    JButton lastOfYear;
    JButton lastOfQuarter;
    JButton lastOfMonth;
    JButton lastOfWeek;
    JButton startOfDay;
    JButton endOfDay;
    JTextField tf;
    String text;
    boolean modified = false;

    public DateVariableDialog(Dialog parent, String text) {
        super(parent, "Enter Date Variable", true);
        this.text = text;
        this.init();
        this.setPosition();
    }

    public DateVariableDialog(JDialog parent, String text) {
        super(parent, "Enter Date Variable", true);
        this.text = text;
        this.init();
        this.setPosition();
    }

    private void setPosition() {
        this.pack();
        this.setLocationRelativeTo(this.getParent());
    }

    private void init() {
        JPanel editPanel = new JPanel(new BorderLayout(0, 0));
        editPanel.setBorder(new EmptyBorder(0, 0, 0, 0));
        JPanel setDateFormulaPanel = new JPanel(new FlowLayout(0));
        this.tf = new JTextField(this.text, 40);
        setDateFormulaPanel.add(this.tf);
        JButton clearButton = new JButton(LanguageEncoder.getText("Clear"));
        clearButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DateVariableDialog.this.tf.setText("");
                DateVariableDialog.this.tf.requestFocus();
            }
        });
        setDateFormulaPanel.add(clearButton);
        editPanel.add((Component)setDateFormulaPanel, "North");
        try {
            this.tf.setFont(new Font("Tahoma", 0, 12));
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        JPanel examplePanel = new JPanel(new FlowLayout(0));
        examplePanel.add(new JLabel(LanguageEncoder.getText("ex. FirstOfYear(CurrentDate) - 1 WEEK")));
        editPanel.add((Component)examplePanel, "Center");
        JPanel firstRowPanel = new JPanel();
        firstRowPanel.setLayout(new FlowLayout(1));
        this.currentDateBtn = new JButton(LanguageEncoder.getText("CurrentDate"));
        firstRowPanel.add(this.currentDateBtn);
        this.currentDateBtn.addActionListener(this);
        this.currentTimeBtn = new JButton(LanguageEncoder.getText("CurrentTime"));
        firstRowPanel.add(this.currentTimeBtn);
        this.currentTimeBtn.addActionListener(this);
        this.currentDateTimeBtn = new JButton(LanguageEncoder.getText("CurrentDateTime"));
        firstRowPanel.add(this.currentDateTimeBtn);
        this.currentDateTimeBtn.addActionListener(this);
        this.plusBtn = new JButton(LanguageEncoder.getText("+"));
        firstRowPanel.add(this.plusBtn);
        this.plusBtn.addActionListener(this);
        this.minusBtn = new JButton(LanguageEncoder.getText("-"));
        firstRowPanel.add(this.minusBtn);
        this.minusBtn.addActionListener(this);
        JPanel secondRowPanel = new JPanel();
        secondRowPanel.setLayout(new FlowLayout(1));
        this.yearBtn = new JButton(LanguageEncoder.getText("YEAR"));
        secondRowPanel.add(this.yearBtn);
        this.yearBtn.addActionListener(this);
        this.monthBtn = new JButton(LanguageEncoder.getText("MONTH"));
        secondRowPanel.add(this.monthBtn);
        this.monthBtn.addActionListener(this);
        this.weekBtn = new JButton(LanguageEncoder.getText("WEEK"));
        secondRowPanel.add(this.weekBtn);
        this.weekBtn.addActionListener(this);
        this.dayBtn = new JButton(LanguageEncoder.getText("DAY"));
        secondRowPanel.add(this.dayBtn);
        this.dayBtn.addActionListener(this);
        this.hourBtn = new JButton(LanguageEncoder.getText("HOUR"));
        secondRowPanel.add(this.hourBtn);
        this.hourBtn.addActionListener(this);
        this.minBtn = new JButton(LanguageEncoder.getText("MINUTE"));
        secondRowPanel.add(this.minBtn);
        this.minBtn.addActionListener(this);
        this.secBtn = new JButton(LanguageEncoder.getText("SECOND"));
        secondRowPanel.add(this.secBtn);
        this.secBtn.addActionListener(this);
        JPanel dateFunctionsPanel = new JPanel();
        dateFunctionsPanel.setLayout(new BorderLayout());
        JPanel dateFunctionsFirstRowPanel = new JPanel(new FlowLayout(1));
        this.firstOfYear = new JButton(DateVariableDialog.addBracketsToFunctionName("FirstOfYear"));
        dateFunctionsFirstRowPanel.add(this.firstOfYear);
        this.firstOfYear.addActionListener(this);
        this.firstOfQuarter = new JButton(DateVariableDialog.addBracketsToFunctionName("FirstOfQuarter"));
        dateFunctionsFirstRowPanel.add(this.firstOfQuarter);
        this.firstOfQuarter.addActionListener(this);
        this.firstOfMonth = new JButton(DateVariableDialog.addBracketsToFunctionName("FirstOfMonth"));
        dateFunctionsFirstRowPanel.add(this.firstOfMonth);
        this.firstOfMonth.addActionListener(this);
        this.firstOfWeek = new JButton(DateVariableDialog.addBracketsToFunctionName("FirstOfWeek"));
        dateFunctionsFirstRowPanel.add(this.firstOfWeek);
        this.firstOfWeek.addActionListener(this);
        JPanel dateFunctionsSecondRowPanel = new JPanel(new FlowLayout(1));
        this.lastOfYear = new JButton(DateVariableDialog.addBracketsToFunctionName("LastOfYear"));
        dateFunctionsSecondRowPanel.add(this.lastOfYear);
        this.lastOfYear.addActionListener(this);
        this.lastOfQuarter = new JButton(DateVariableDialog.addBracketsToFunctionName("LastOfQuarter"));
        dateFunctionsSecondRowPanel.add(this.lastOfQuarter);
        this.lastOfQuarter.addActionListener(this);
        this.lastOfMonth = new JButton(DateVariableDialog.addBracketsToFunctionName("LastOfMonth"));
        dateFunctionsSecondRowPanel.add(this.lastOfMonth);
        this.lastOfMonth.addActionListener(this);
        this.lastOfWeek = new JButton(DateVariableDialog.addBracketsToFunctionName("LastOfWeek"));
        dateFunctionsSecondRowPanel.add(this.lastOfWeek);
        this.lastOfWeek.addActionListener(this);
        JPanel dateFunctionsThirdRowPanel = new JPanel(new FlowLayout(1));
        this.startOfDay = new JButton(DateVariableDialog.addBracketsToFunctionName("StartOfDay"));
        dateFunctionsThirdRowPanel.add(this.startOfDay);
        this.startOfDay.addActionListener(this);
        this.endOfDay = new JButton(DateVariableDialog.addBracketsToFunctionName("EndOfDay"));
        dateFunctionsThirdRowPanel.add(this.endOfDay);
        this.endOfDay.addActionListener(this);
        dateFunctionsPanel.add((Component)dateFunctionsFirstRowPanel, "North");
        dateFunctionsPanel.add((Component)dateFunctionsSecondRowPanel, "Center");
        dateFunctionsPanel.add((Component)dateFunctionsThirdRowPanel, "South");
        JPanel helpPanel = new JPanel();
        helpPanel.setLayout(new BorderLayout());
        helpPanel.add((Component)firstRowPanel, "North");
        helpPanel.add((Component)secondRowPanel, "Center");
        helpPanel.add((Component)dateFunctionsPanel, "South");
        JSplitPane splitPane = new JSplitPane(0, false);
        splitPane.setTopComponent(editPanel);
        splitPane.setBottomComponent(helpPanel);
        JPanel bottomPanel = new JPanel();
        this.okButton = new JButton(LanguageEncoder.getText("OK"));
        bottomPanel.add(this.okButton);
        this.okButton.addActionListener(this);
        this.cancelButton = new JButton(LanguageEncoder.getText("CANCEL"));
        bottomPanel.add(this.cancelButton);
        this.cancelButton.addActionListener(this);
        JPanel contentPane = (JPanel)this.getContentPane();
        contentPane.setLayout(new BorderLayout());
        contentPane.add((Component)splitPane, "North");
        contentPane.add((Component)bottomPanel, "South");
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object btn = e.getSource();
        if (btn == this.currentDateBtn) {
            this.insertText("CurrentDate");
        } else if (btn == this.currentTimeBtn) {
            this.insertText("CurrentTime");
        } else if (btn == this.currentDateTimeBtn) {
            this.insertText("CurrentDateTime");
        } else if (btn == this.plusBtn) {
            this.insertText("+");
        } else if (btn == this.minusBtn) {
            this.insertText("-");
        } else if (btn == this.yearBtn) {
            this.insertText("YEAR");
        } else if (btn == this.monthBtn) {
            this.insertText("MONTH");
        } else if (btn == this.weekBtn) {
            this.insertText("WEEK");
        } else if (btn == this.dayBtn) {
            this.insertText("DAY");
        } else if (btn == this.hourBtn) {
            this.insertText("HOUR");
        } else if (btn == this.minBtn) {
            this.insertText("MINUTE");
        } else if (btn == this.secBtn) {
            this.insertText("SECOND");
        } else if (btn == this.firstOfYear) {
            this.insertText(DateVariableDialog.addBracketsToFunctionName("FirstOfYear"), true);
        } else if (btn == this.firstOfQuarter) {
            this.insertText(DateVariableDialog.addBracketsToFunctionName("FirstOfQuarter"), true);
        } else if (btn == this.firstOfMonth) {
            this.insertText(DateVariableDialog.addBracketsToFunctionName("FirstOfMonth"), true);
        } else if (btn == this.firstOfWeek) {
            this.insertText(DateVariableDialog.addBracketsToFunctionName("FirstOfWeek"), true);
        } else if (btn == this.lastOfYear) {
            this.insertText(DateVariableDialog.addBracketsToFunctionName("LastOfYear"), true);
        } else if (btn == this.lastOfQuarter) {
            this.insertText(DateVariableDialog.addBracketsToFunctionName("LastOfQuarter"), true);
        } else if (btn == this.lastOfMonth) {
            this.insertText(DateVariableDialog.addBracketsToFunctionName("LastOfMonth"), true);
        } else if (btn == this.lastOfWeek) {
            this.insertText(DateVariableDialog.addBracketsToFunctionName("LastOfWeek"), true);
        } else if (btn == this.startOfDay) {
            this.insertText(DateVariableDialog.addBracketsToFunctionName("StartOfDay"), true);
        } else if (btn == this.endOfDay) {
            this.insertText(DateVariableDialog.addBracketsToFunctionName("EndOfDay"), true);
        } else if (btn == this.okButton) {
            Formula formula = new Formula();
            formula.setText(this.tf.getText());
            try {
                ByteArrayInputStream inputStream = new ByteArrayInputStream(this.tf.getText().getBytes("UTF-8"));
                InputStreamReader inputStreamReader = new InputStreamReader((InputStream)inputStream, "UTF-8");
                DateFormulaParser parser = new DateFormulaParser(inputStreamReader);
                formula.setFormula(parser.parse());
            }
            catch (ParseException ex) {
                new JMessageDialog((Dialog)this, LanguageEncoder.getText("Error"), LanguageEncoder.getText("Syntax Error:") + ex.getMessage());
                return;
            }
            catch (Exception ex) {
                new JMessageDialog((Dialog)this, LanguageEncoder.getText("Error"), LanguageEncoder.getText("Syntax Error:") + ex.getMessage());
                return;
            }
            catch (Error er) {
                new JMessageDialog((Dialog)this, LanguageEncoder.getText("Error"), LanguageEncoder.getText("Syntax Error:") + er.getMessage());
                return;
            }
            this.text = this.tf.getText();
            this.modified = true;
            this.setVisible(false);
            this.dispose();
        } else if (btn == this.cancelButton) {
            this.setVisible(false);
            this.dispose();
        }
    }

    private static String addBracketsToFunctionName(String functionName) {
        return functionName + "()";
    }

    private void insertText(String newStr) {
        this.insertText(newStr, false);
    }

    private void insertText(String newStr, boolean isFunction) {
        if (newStr == null) {
            return;
        }
        this.tf.replaceSelection(newStr);
        if (isFunction) {
            this.tf.setCaretPosition(this.tf.getCaretPosition() - 1);
        }
        this.tf.requestFocus();
    }

    public String getText() {
        return this.text;
    }

    public boolean isModified() {
        return this.modified;
    }
}

