/*
 * Decompiled with CFR 0.152.
 */
package quadbase.common.paramquery;

import java.awt.AWTEventMulticaster;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.Vector;
import quadbase.common.paramquery.EnterInParamPanel;
import quadbase.common.paramquery.IEnterInParamDialog;
import quadbase.common.paramquery.OurDialog;
import quadbase.common.paramquery.QueryFileInfo;
import quadbase.common.paramquery.QueryInParam;

public class EnterInParamDialog
extends OurDialog
implements ActionListener,
WindowListener,
IEnterInParamDialog {
    private transient ActionListener listener;
    EnterInParamPanel enterPanel;
    boolean showCancelButton;
    Vector<Boolean> isCancelled;
    Frame frame;
    Dialog dialog;
    QueryFileInfo fileInfo;
    int order;
    Vector<QueryInParam> queryInParamVec;
    boolean show = true;
    boolean useDefaultValue = true;

    public EnterInParamDialog(Frame frame, QueryFileInfo fileInfo, boolean showCancelButton) throws Exception {
        super(frame, "Enter Dialog", true);
        this.frame = frame;
        this.order = -1;
        this.queryInParamVec = null;
        this.init(fileInfo, showCancelButton);
    }

    public EnterInParamDialog(Frame frame, QueryFileInfo fileInfo, boolean showCancelButton, int order, Vector<QueryInParam> queryInParamVec, Vector<Boolean> isCancelled) throws Exception {
        super(frame, "Enter Dialog", true);
        this.frame = frame;
        this.order = order;
        this.queryInParamVec = queryInParamVec;
        this.isCancelled = isCancelled;
        this.init(fileInfo, showCancelButton);
    }

    public EnterInParamDialog(Dialog dialog, QueryFileInfo fileInfo, boolean showCancelButton) throws Exception {
        this(dialog, fileInfo, showCancelButton, true);
    }

    public EnterInParamDialog(Dialog dialog, QueryFileInfo fileInfo, boolean showCancelButton, boolean useDefaultValue) throws Exception {
        super(dialog, "Enter Dialog", true);
        this.dialog = dialog;
        this.order = -1;
        this.queryInParamVec = null;
        this.useDefaultValue = useDefaultValue;
        this.init(fileInfo, showCancelButton);
    }

    public EnterInParamDialog(Dialog dialog, QueryFileInfo fileInfo, boolean showCancelButton, int order, Vector<QueryInParam> queryInParamVec, Vector<Boolean> isCancelled) throws Exception {
        super(dialog, "Enter Dialog", true);
        this.dialog = dialog;
        this.order = order;
        this.queryInParamVec = queryInParamVec;
        this.isCancelled = isCancelled;
        this.init(fileInfo, showCancelButton);
    }

    private void init(QueryFileInfo fileInfo, boolean showCancelButton) throws Exception {
        this.fileInfo = fileInfo;
        if (fileInfo.getInParam().length > 1) {
            this.setBorder("Please enter values");
        } else {
            this.setBorder("Please enter value");
        }
        this.showCancelButton = showCancelButton;
        this.addWindowListener(this);
        this.enterPanel = new EnterInParamPanel(fileInfo, true, true, this.order, this.useDefaultValue);
        while (this.enterPanel.getParameterCount() <= 0 && fileInfo.getMaxParameterOrder() > this.order) {
            ++this.order;
            this.enterPanel = new EnterInParamPanel(fileInfo, true, true, this.order, this.useDefaultValue);
        }
        if (this.enterPanel.getParameterCount() <= 0) {
            this.show = false;
        }
        this.enterPanel.addActionListener(this);
        this.add("Center", this.enterPanel);
        this.setPosition();
    }

    private void setPosition() {
        this.pack();
        Dimension screensize = this.getToolkit().getScreenSize();
        Dimension preferredSize = this.getPreferredSize();
        int width = (int)Math.min((double)screensize.width * 0.9, (double)(preferredSize.width + 30));
        int height = (int)Math.min((double)screensize.height * 0.9, (double)(preferredSize.height + 30));
        this.setSize(width, height);
        this.setLocationRelativeTo(this.getParent());
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getActionCommand().equals("OK")) {
            if (this.queryInParamVec == null) {
                this.queryInParamVec = new Vector();
            }
            if (this.isCancelled == null) {
                this.isCancelled = new Vector();
            }
            for (int i = 0; this.enterPanel.getInParamValue() != null && i < this.enterPanel.getInParamValue().length; ++i) {
                this.queryInParamVec.add(this.enterPanel.getInParamValue()[i]);
            }
            if (this.order > -1 && this.fileInfo.getMaxParameterOrder() > this.order) {
                try {
                    EnterInParamDialog newDialog = this.frame != null ? new EnterInParamDialog(this.frame, this.fileInfo, true, this.order + 1, this.queryInParamVec, this.isCancelled) : (this.dialog != null ? new EnterInParamDialog(this.dialog, this.fileInfo, true, this.order + 1, this.queryInParamVec, this.isCancelled) : new EnterInParamDialog(this, this.fileInfo, true, this.order + 1, this.queryInParamVec, this.isCancelled));
                    if (newDialog.show) {
                        newDialog.setVisible(true);
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
            this.setVisible(false);
            this.dispose();
            this.fireEvent(this, 0, e.getActionCommand());
        } else if (e.getActionCommand().equals("Cancel")) {
            if (this.isCancelled == null) {
                this.isCancelled = new Vector();
            }
            this.isCancelled.addElement(Boolean.TRUE);
            this.setVisible(false);
            this.dispose();
        }
    }

    @Override
    public boolean isCancelled() {
        if (this.isCancelled == null) {
            return false;
        }
        for (int i = 0; i < this.isCancelled.size(); ++i) {
            if (!this.isCancelled.elementAt(i).booleanValue()) continue;
            return true;
        }
        return false;
    }

    @Override
    public QueryInParam[] getInParamValue() {
        if (this.queryInParamVec != null) {
            QueryInParam[] inParam = new QueryInParam[this.queryInParamVec.size()];
            for (int i = 0; i < inParam.length; ++i) {
                inParam[i] = this.queryInParamVec.elementAt(i);
            }
            return inParam;
        }
        return this.enterPanel.getInParamValue();
    }

    public synchronized void addActionListener(ActionListener l) {
        this.listener = AWTEventMulticaster.add(this.listener, l);
    }

    public synchronized void removeActionListener(ActionListener l) {
        this.listener = AWTEventMulticaster.remove(this.listener, l);
    }

    protected final void fireEvent(Component c, int id, String cmd) {
        if (this.listener != null) {
            this.listener.actionPerformed(new ActionEvent(c, id, cmd));
        }
    }

    @Override
    public void setVisible(boolean b) {
        if (this.enterPanel != null && b && this.enterPanel.isFailToConnectToDatabase()) {
            if (this.isCancelled == null) {
                this.isCancelled = new Vector();
            }
            this.isCancelled.addElement(Boolean.TRUE);
            if (!this.showCancelButton) {
                throw new IllegalArgumentException("CANCEL");
            }
            return;
        }
        super.setVisible(b);
    }

    @Override
    public void windowActivated(WindowEvent e) {
    }

    @Override
    public void windowClosed(WindowEvent e) {
    }

    @Override
    public void windowClosing(WindowEvent e) {
        if (this.isCancelled == null) {
            this.isCancelled = new Vector();
        }
        this.isCancelled.addElement(Boolean.TRUE);
        this.setVisible(false);
        this.dispose();
    }

    @Override
    public void windowDeactivated(WindowEvent e) {
    }

    @Override
    public void windowDeiconified(WindowEvent e) {
    }

    @Override
    public void windowIconified(WindowEvent e) {
    }

    @Override
    public void windowOpened(WindowEvent e) {
    }
}

