/*
 * Decompiled with CFR 0.152.
 */
package quadbase.common.paramquery;

import java.awt.AWTEventMulticaster;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.List;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Date;
import java.util.EventListener;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.ListSelectionEvent;
import quadbase.common.client.ServerMessage;
import quadbase.common.formula.DateFormulaParser;
import quadbase.common.formula.Formula;
import quadbase.common.paramquery.DateVariableDialog;
import quadbase.common.paramquery.OurButton;
import quadbase.common.paramquery.OurCalendarDialog;
import quadbase.common.paramquery.OurMessageDialog;
import quadbase.common.paramquery.OurPanel;
import quadbase.common.paramquery.OurScrollPane;
import quadbase.common.paramquery.QueryFileInfo;
import quadbase.common.paramquery.QueryInParam;
import quadbase.common.paramquery.QueryMultiValueInParam;
import quadbase.common.paramquery.QueryParser;
import quadbase.common.paramquery.QueryXMLFileInfo;
import quadbase.common.util.IDatabaseInfo;
import quadbase.common.util.internal.DataType;
import quadbase.common.util.internal.IOUtil;
import quadbase.common.util.internal.QbDateFormat;
import quadbase.common.util.internal.QbUtil;
import quadbase.reportdesigner.util.IQueryInParam;
import quadbase.reportdesigner.util.internal.ReportUtil;

public class EnterInParamPanel
extends OurPanel
implements ActionListener,
ItemListener {
    QueryFileInfo fileInfo;
    QueryInParam[] parameter;
    int nParam;
    boolean showOKbutton;
    boolean showCancelButton;
    private transient ActionListener listener;
    OurButton resetButton;
    OurButton okButton;
    OurButton cancelButton;
    JButton[] allButton;
    JButton[] noneButton;
    JComboBox[] choiceArray;
    JTextField[] textArray;
    List[] listArray;
    JButton[] dateButArray;
    JButton[] dateVariableButArray;
    int order = 0;
    int maxOrder = 0;
    boolean useDefaultValue = true;
    boolean failToConnectToDatabase = false;
    GridBagLayout gbl;
    GridBagConstraints gbc;
    OurPanel paramPanel;
    Hashtable distinctTable;
    private boolean[] alreadySelected;

    public EnterInParamPanel(QueryFileInfo fileInfo, boolean showOKbutton, int order) throws Exception {
        this(fileInfo, showOKbutton, false, order, true);
    }

    public EnterInParamPanel(QueryFileInfo fileInfo, boolean showOKbutton, boolean showCancelButton, int order, boolean useDefaultValue) throws Exception {
        QueryInParam currParam;
        this.fileInfo = fileInfo;
        this.useDefaultValue = useDefaultValue;
        this.order = order;
        this.parameter = fileInfo.getInSet().getParameter(order);
        this.maxOrder = fileInfo.getInSet().getMaxParameterOrder();
        this.nParam = this.parameter.length;
        this.showOKbutton = showOKbutton;
        this.showCancelButton = showCancelButton;
        this.gbl = new GridBagLayout();
        this.gbc = new GridBagConstraints();
        this.paramPanel = new OurPanel(this.gbl);
        this.gbc.anchor = 17;
        this.choiceArray = new JComboBox[this.nParam];
        this.textArray = new JTextField[this.nParam];
        this.dateButArray = new JButton[this.nParam];
        this.dateVariableButArray = new JButton[this.nParam];
        this.listArray = new List[this.nParam];
        this.allButton = new JButton[this.nParam];
        this.noneButton = new JButton[this.nParam];
        this.alreadySelected = new boolean[this.nParam];
        for (int j = 0; j < this.nParam; ++j) {
            currParam = this.parameter[j];
            if (currParam.getSelectionChoices() != null || currParam.isMapToColumn() || currParam.getSqlSelect() != null || !DataType.isDateTime(DataType.mapType(currParam.getSqlType()))) continue;
            this.dateButArray[j] = new JButton("Calendar");
            this.dateVariableButArray[j] = new JButton("Variable");
        }
        int gridy = 0;
        for (int i = 0; i < this.nParam; ++i) {
            Component comp;
            currParam = this.parameter[i];
            JLabel labelComp = new JLabel(currParam.getPromptName());
            if (currParam.getSelectionChoices() != null && currParam.getSelectionChoices().size() > 0) {
                boolean isMultiValue = currParam instanceof QueryMultiValueInParam;
                Component[] array = this.choiceArray;
                if (isMultiValue) {
                    array = this.listArray;
                    OurPanel selectionPanel = this.makeSelectionPanel(i);
                    this.gbc.gridx = 2;
                    this.gbc.gridy = gridy++;
                    this.gbc.fill = 2;
                    this.gbc.anchor = 22;
                    this.gbc.insets = i > 0 ? new Insets(12, 0, 0, 0) : new Insets(0, 0, 0, 0);
                    this.gbc.weightx = 0.5;
                    this.gbc.weighty = 0.0;
                    this.gbc.gridwidth = 1;
                    this.gbl.setConstraints(selectionPanel, this.gbc);
                    this.paramPanel.add(selectionPanel);
                }
                comp = this.createComponent(isMultiValue, currParam.getSelectionChoices(), array, i, null, currParam);
            } else if (currParam.getSqlSelect() != null && currParam.getSqlSelect().trim().length() > 0 && !currParam.getSqlSelect().equals("null")) {
                Vector result = new Vector();
                Vector distinctValue = new Vector();
                try {
                    result = QueryParser.executeSQLSelect((IDatabaseInfo)fileInfo, currParam.getSqlSelect(), this.parameter, true);
                    distinctValue = (Vector)result.elementAt(0);
                    if (distinctValue != null && distinctValue.size() > 0) {
                        distinctValue.remove(distinctValue.size() - 1);
                    }
                    if (result.size() > 1) {
                        if (this.distinctTable == null) {
                            this.distinctTable = new Hashtable();
                        }
                        Hashtable table = new Hashtable();
                        for (int j = 0; j < distinctValue.size(); ++j) {
                            String key = distinctValue.elementAt(j).toString();
                            Object object = ((Vector)result.elementAt(1)).elementAt(j);
                            table.put(key, object);
                        }
                        this.distinctTable.put(currParam.getSqlSelect(), table);
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    throw ex;
                }
                boolean isMultiValue = currParam instanceof QueryMultiValueInParam;
                Component[] array = this.choiceArray;
                if (isMultiValue) {
                    array = this.listArray;
                    OurPanel selectionPanel = this.makeSelectionPanel(i);
                    this.gbc.gridx = 2;
                    this.gbc.gridy = gridy++;
                    this.gbc.fill = 2;
                    this.gbc.anchor = 22;
                    this.gbc.insets = i > 0 ? new Insets(12, 0, 0, 0) : new Insets(0, 0, 0, 0);
                    this.gbc.weightx = 0.5;
                    this.gbc.weighty = 0.0;
                    this.gbc.gridwidth = 1;
                    this.gbl.setConstraints(selectionPanel, this.gbc);
                    this.paramPanel.add(selectionPanel);
                }
                comp = this.createComponent(isMultiValue, distinctValue, array, i, null, currParam);
            } else if (currParam.isMapToColumn()) {
                Vector distinctValue = new Vector();
                try {
                    distinctValue = fileInfo instanceof QueryXMLFileInfo ? QueryParser.getDistinctValues(((QueryXMLFileInfo)fileInfo).getXMLFileQueryInfo(), currParam.getColumnName(), order) : QueryParser.getDistinctValues(fileInfo, currParam.getTableName(), currParam.getColumnName(), order);
                    if (distinctValue == null || distinctValue.size() == 0) {
                        this.failToConnectToDatabase = true;
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    throw ex;
                }
                boolean isMultiValue = currParam instanceof QueryMultiValueInParam;
                Component[] array = this.choiceArray;
                if (isMultiValue) {
                    array = this.listArray;
                    OurPanel selectionPanel = this.makeSelectionPanel(i);
                    this.gbc.gridx = 2;
                    this.gbc.gridy = gridy++;
                    this.gbc.fill = 2;
                    this.gbc.anchor = 22;
                    this.gbc.insets = i > 0 ? new Insets(12, 0, 0, 0) : new Insets(0, 0, 0, 0);
                    this.gbc.weightx = 0.5;
                    this.gbc.weighty = 0.0;
                    this.gbc.gridwidth = 1;
                    this.gbl.setConstraints(selectionPanel, this.gbc);
                    this.paramPanel.add(selectionPanel);
                }
                String dateFormat = null;
                if ((currParam.getSqlType() == 91 || currParam.getSqlType() == 92 || currParam.getSqlType() == 93) && currParam.getDateFormat() != null) {
                    dateFormat = currParam.getDateFormat();
                }
                if (this.getOrderIndex(i) == 0 && currParam.isAllOptionEnabled()) {
                    distinctValue.add(0, currParam.getAllOptionLabel());
                }
                comp = this.createComponent(isMultiValue, distinctValue, array, i, dateFormat, currParam);
            } else if (this.dateButArray[i] != null) {
                JPanel panel = new JPanel(new BorderLayout());
                this.textArray[i] = new JTextField("To be filled in", 20);
                this.textArray[i].addActionListener(this);
                panel.add("Center", this.textArray[i]);
                JPanel panel2 = new JPanel(new GridLayout(1, 2, 0, 0));
                panel2.add(this.dateButArray[i]);
                panel2.add(this.dateVariableButArray[i]);
                this.dateButArray[i].addActionListener(this);
                this.dateVariableButArray[i].addActionListener(this);
                panel.add("East", panel2);
                comp = panel;
            } else {
                this.textArray[i] = new JTextField("To be filled in", 20);
                this.textArray[i].addActionListener(this);
                comp = this.textArray[i];
            }
            this.gbc.gridy = gridy++;
            this.gbc.gridx = 0;
            this.gbc.fill = 0;
            this.gbc.insets = new Insets(1, 1, 1, 1);
            this.gbc.weightx = 0.0;
            this.gbc.weighty = 0.0;
            this.gbc.gridwidth = 1;
            this.gbl.setConstraints(labelComp, this.gbc);
            this.paramPanel.add(labelComp);
            this.gbc.gridx = 1;
            this.gbc.fill = 2;
            this.gbc.insets = new Insets(1, 1, 1, 1);
            this.gbc.weightx = 0.0;
            this.gbc.weighty = 0.0;
            this.gbc.gridwidth = 2;
            this.gbl.setConstraints(comp, this.gbc);
            this.paramPanel.add(comp);
        }
        this.resetPanel(0, 0);
        OurScrollPane scrollPane = new OurScrollPane(this.paramPanel, 0);
        scrollPane.setPreferredSize(this.paramPanel.getPreferredSize());
        this.add("Center", scrollPane);
        OurPanel buttonPanel = new OurPanel(new FlowLayout(2));
        this.resetButton = new OurButton("Reset");
        buttonPanel.add(this.resetButton);
        this.resetButton.addActionListener(this);
        if (showOKbutton) {
            this.okButton = new OurButton("OK");
            buttonPanel.add(this.okButton);
            this.okButton.addActionListener(this);
        }
        if (showCancelButton) {
            this.cancelButton = new OurButton("Cancel");
            buttonPanel.add(this.cancelButton);
            this.cancelButton.addActionListener(this);
        }
        this.add("South", buttonPanel);
    }

    boolean isFailToConnectToDatabase() {
        return this.failToConnectToDatabase;
    }

    public synchronized void addActionListener(ActionListener l) {
        this.listener = AWTEventMulticaster.add(this.listener, l);
    }

    public synchronized void removeActionListener(ActionListener l) {
        this.listener = AWTEventMulticaster.remove(this.listener, l);
    }

    public QueryInParam[] getInParamValue() {
        return this.parameter;
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        if (this.maxOrder == 0) {
            return;
        }
        this.onItemChanged(e.getSource());
    }

    private void onItemChanged(Object source) {
        try {
            int i;
            for (i = 0; i < this.choiceArray.length; ++i) {
                if (this.choiceArray[i] == null || source != this.choiceArray[i]) continue;
                this.order = this.getOrderIndex(i);
                if (this.order == this.maxOrder) {
                    return;
                }
                this.alreadySelected[i] = true;
                boolean wholeOrderCompleted = true;
                int index = this.getParamIndex(this.order + 1);
                for (int j = 0; j < index; ++j) {
                    if (!this.alreadySelected[j] && this.order == this.getOrderIndex(j)) {
                        wholeOrderCompleted = false;
                    }
                    this.makeQueryInParam(j);
                }
                if (!wholeOrderCompleted) {
                    return;
                }
                Object[][] paramChoice = this.getNextParamOrderValues(this.order + 1);
                for (int j = 0; j < paramChoice.length && index + j < this.parameter.length; ++j) {
                    QueryInParam param = this.parameter[index + j];
                    if (param.isMapToColumn() || param.isMapToSqlSelect()) {
                        int n;
                        int n2;
                        EventListener element2;
                        EventListener[] il;
                        this.gbc.gridx = 1;
                        this.gbc.gridy = index + j;
                        this.gbc.fill = 2;
                        if (param instanceof QueryMultiValueInParam) {
                            for (EventListener element2 : il = this.listArray[index + j].getItemListeners()) {
                                this.listArray[index + j].removeItemListener((ItemListener)element2);
                            }
                            this.listArray[index + j].setEnabled(true);
                            this.listArray[index + j].removeAll();
                            if (paramChoice[j] != null) {
                                for (int k = 0; k < paramChoice[j].length; ++k) {
                                    if ((param.getSqlType() == 91 || param.getSqlType() == 92 || param.getSqlType() == 93) && param.getDateFormat() != null) {
                                        this.listArray[index + j].add(QbDateFormat.getFormattedDateTime((Date)paramChoice[j][k], param.getDateFormat()));
                                        continue;
                                    }
                                    this.listArray[index + j].add(paramChoice[j][k].toString());
                                }
                            }
                            EventListener[] k = il;
                            n2 = k.length;
                            for (n = 0; n < n2; ++n) {
                                element2 = k[n];
                                this.listArray[index + j].addItemListener((ItemListener)element2);
                            }
                            this.listArray[index + j].setEnabled(true);
                            continue;
                        }
                        for (EventListener element2 : il = this.choiceArray[index + j].getActionListeners()) {
                            this.choiceArray[index + j].removeActionListener((ActionListener)element2);
                        }
                        this.choiceArray[index + j].setEnabled(true);
                        this.choiceArray[index + j].removeAllItems();
                        if (paramChoice[j] != null) {
                            for (int k = 0; k < paramChoice[j].length; ++k) {
                                if ((param.getSqlType() == 91 || param.getSqlType() == 92 || param.getSqlType() == 93) && param.getDateFormat() != null) {
                                    this.choiceArray[index + j].addItem(QbDateFormat.getFormattedDateTime((Date)paramChoice[j][k], param.getDateFormat()));
                                    continue;
                                }
                                this.choiceArray[index + j].addItem(paramChoice[j][k].toString());
                            }
                        }
                        EventListener[] eventListenerArray = il;
                        n2 = eventListenerArray.length;
                        for (n = 0; n < n2; ++n) {
                            element2 = eventListenerArray[n];
                            this.choiceArray[index + j].addActionListener((ActionListener)element2);
                        }
                        this.choiceArray[index + j].setEnabled(true);
                        continue;
                    }
                    if (param.getSelectionChoices() != null) {
                        if (param instanceof QueryMultiValueInParam) {
                            this.listArray[index + j].setEnabled(true);
                            continue;
                        }
                        this.choiceArray[index + j].setEnabled(true);
                        continue;
                    }
                    this.textArray[index + j].setEnabled(true);
                }
                this.resetPanel(index, this.order + 1);
            }
            for (i = 0; i < this.listArray.length; ++i) {
                if (this.listArray[i] == null || source != this.listArray[i]) continue;
                this.order = this.getOrderIndex(i);
                if (this.listArray[i].getSelectedItems() == null || this.listArray[i].getSelectedItems().length == 0) {
                    this.resetPanel(i + 1, this.order);
                    return;
                }
                if (this.order == this.maxOrder) continue;
                this.alreadySelected[i] = true;
                int index = this.getParamIndex(this.order + 1);
                for (int j = 0; j < index; ++j) {
                    this.makeQueryInParam(j);
                }
                Object[][] paramChoice = this.getNextParamOrderValues(this.order + 1);
                for (int j = 0; j < paramChoice.length && index + j < this.parameter.length; ++j) {
                    QueryInParam param = this.parameter[index + j];
                    if (param.isMapToColumn() || param.isMapToSqlSelect()) {
                        EventListener[] il;
                        this.gbc.gridx = 1;
                        this.gbc.gridy = index + j;
                        this.gbc.fill = 2;
                        if (param instanceof QueryMultiValueInParam) {
                            il = this.listArray[index + j].getItemListeners();
                            for (EventListener element : il) {
                                this.listArray[index + j].removeItemListener((ItemListener)element);
                            }
                            this.listArray[index + j].setEnabled(true);
                            this.listArray[index + j].removeAll();
                            if (paramChoice[j] != null) {
                                for (int k = 0; k < paramChoice[j].length; ++k) {
                                    if ((param.getSqlType() == 91 || param.getSqlType() == 92 || param.getSqlType() == 93) && param.getDateFormat() != null) {
                                        this.listArray[index + j].add(QbDateFormat.getFormattedDateTime((Date)paramChoice[j][k], param.getDateFormat()));
                                        continue;
                                    }
                                    this.listArray[index + j].add(paramChoice[j][k].toString());
                                }
                            }
                            for (EventListener element : il) {
                                this.listArray[index + j].addItemListener((ItemListener)element);
                            }
                            this.listArray[index + j].setEnabled(true);
                            continue;
                        }
                        for (EventListener element : il = this.choiceArray[index + j].getActionListeners()) {
                            this.choiceArray[index + j].removeActionListener((ActionListener)element);
                        }
                        this.choiceArray[index + j].setEnabled(true);
                        this.choiceArray[index + j].removeAllItems();
                        if (this.getParamIndex(index + j) == 0 && param.isAllOptionEnabled()) {
                            this.choiceArray[index + j].addItem(param.getAllOptionLabel());
                        }
                        if (paramChoice[j] != null) {
                            for (int k = 0; k < paramChoice[j].length; ++k) {
                                if ((param.getSqlType() == 91 || param.getSqlType() == 92 || param.getSqlType() == 93) && param.getDateFormat() != null) {
                                    this.choiceArray[index + j].addItem(QbDateFormat.getFormattedDateTime((Date)paramChoice[j][k], param.getDateFormat()));
                                    continue;
                                }
                                this.choiceArray[index + j].addItem(paramChoice[j][k].toString());
                            }
                        }
                        for (EventListener element : il) {
                            this.choiceArray[index + j].addActionListener((ActionListener)element);
                        }
                        this.choiceArray[index + j].setEnabled(true);
                        continue;
                    }
                    if (param.getSelectionChoices() != null) {
                        if (param instanceof QueryMultiValueInParam) {
                            this.listArray[index + j].setEnabled(true);
                            continue;
                        }
                        this.choiceArray[index + j].setEnabled(true);
                        continue;
                    }
                    this.textArray[index + j].setEnabled(true);
                }
                this.resetPanel(index, this.order + 1);
            }
            this.paramPanel.validate();
            this.paramPanel.repaint();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        int i;
        Object source = e.getSource();
        if (source == this.resetButton) {
            this.resetPanel(0, 0);
        } else if (source == this.okButton) {
            if (this.areAllValid()) {
                this.fireEvent(this, 0, e.getActionCommand());
            } else {
                this.showError();
            }
        } else if (source == this.cancelButton) {
            this.fireEvent(this, 0, e.getActionCommand());
        } else if (source instanceof JComboBox) {
            this.onItemChanged(e.getSource());
        }
        for (i = 0; i < this.allButton.length; ++i) {
            ItemEvent evt;
            int cnt;
            if (source == this.allButton[i]) {
                cnt = this.listArray[i].getItemCount();
                for (int j = 0; j < cnt; ++j) {
                    this.listArray[i].select(j);
                }
                evt = new ItemEvent(this.listArray[i], 701, null, 1);
                this.itemStateChanged(evt);
                continue;
            }
            if (source != this.noneButton[i]) continue;
            cnt = this.listArray[i].getItemCount();
            for (int j = 0; j < cnt; ++j) {
                this.listArray[i].deselect(j);
            }
            evt = new ItemEvent(this.listArray[i], 701, null, 2);
            this.itemStateChanged(evt);
        }
        for (i = 0; this.maxOrder > 0 && i < this.textArray.length; ++i) {
            if (this.textArray[i] == null || source != this.textArray[i]) continue;
            this.textActionPerformed(i);
        }
        for (i = 0; i < this.dateButArray.length; ++i) {
            if (this.dateButArray[i] == null || source != this.dateButArray[i]) continue;
            OurCalendarDialog calendarDialog = new OurCalendarDialog(null, this.parameter[i].getSqlType());
            Date curTime = null;
            try {
                curTime = (Date)DataType.createObject(this.textArray[i].getText(), DataType.mapType(this.parameter[i].getSqlType()), this.parameter[i].getDateFormat());
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (curTime != null) {
                calendarDialog.setTime(curTime);
            }
            calendarDialog.setVisible(true);
            if (calendarDialog.isCancelled()) {
                return;
            }
            this.textArray[i].setText(DataType.toString(calendarDialog.getTime(), this.parameter[i].getDateFormat()));
            this.textActionPerformed(i);
            return;
        }
        for (i = 0; i < this.dateVariableButArray.length; ++i) {
            if (this.dateVariableButArray[i] == null || source != this.dateVariableButArray[i]) continue;
            String text = "";
            if (this.useDefaultValue) {
                if (this.parameter[i].getDefaultValueVariable() != null) {
                    text = this.parameter[i].getDefaultValueVariable().getText();
                }
            } else if (this.parameter[i].getValueVariable() != null) {
                text = this.parameter[i].getValueVariable().getText();
            }
            DateVariableDialog dialog = new DateVariableDialog(null, text);
            dialog.setVisible(true);
            if (!dialog.isModified() || dialog.getText() == null) continue;
            try {
                text = dialog.getText();
                Formula formula = new Formula(null, text);
                ByteArrayInputStream inputStream = new ByteArrayInputStream(text.getBytes("UTF-8"));
                InputStreamReader inputStreamReader = new InputStreamReader((InputStream)inputStream, "UTF-8");
                DateFormulaParser parser = new DateFormulaParser(inputStreamReader);
                formula.setFormula(parser.parse());
                this.textArray[i].setText(text);
                this.textActionPerformed(i);
                continue;
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    private void textActionPerformed(int i) {
        try {
            this.order = this.getOrderIndex(i);
            if (this.order == this.maxOrder) {
                return;
            }
            int index = this.getParamIndex(this.order + 1);
            for (int j = 0; j < index; ++j) {
                this.makeQueryInParam(j);
            }
            Object[][] paramChoice = this.getNextParamOrderValues(this.order + 1);
            for (int j = 0; j < paramChoice.length && index + j < this.parameter.length; ++j) {
                QueryInParam param = this.parameter[index + j];
                if (param.isMapToColumn() || param.isMapToSqlSelect()) {
                    int k;
                    if (param instanceof QueryMultiValueInParam) {
                        this.listArray[index + j].removeAll();
                        if (paramChoice[j] == null) continue;
                        for (k = 0; k < paramChoice[j].length; ++k) {
                            if ((param.getSqlType() == 91 || param.getSqlType() == 92 || param.getSqlType() == 93) && param.getDateFormat() != null) {
                                this.listArray[index + j].add(QbDateFormat.getFormattedDateTime((Date)paramChoice[j][k], param.getDateFormat()));
                                continue;
                            }
                            this.listArray[index + j].add(paramChoice[j][k].toString());
                        }
                        this.enableDisableList(true, index + j);
                        continue;
                    }
                    this.choiceArray[index + j].removeAllItems();
                    this.choiceArray[index + j].setEnabled(true);
                    if (this.order == 0 && param.isAllOptionEnabled()) {
                        this.choiceArray[index + j].addItem(param.getAllOptionLabel());
                    }
                    if (paramChoice[j] == null) continue;
                    for (k = 0; k < paramChoice[j].length; ++k) {
                        if ((param.getSqlType() == 91 || param.getSqlType() == 92 || param.getSqlType() == 93) && param.getDateFormat() != null) {
                            this.choiceArray[index + j].addItem(QbDateFormat.getFormattedDateTime((Date)paramChoice[j][k], param.getDateFormat()));
                            continue;
                        }
                        this.choiceArray[index + j].addItem(paramChoice[j][k].toString());
                    }
                    continue;
                }
                this.textArray[index + j].setEnabled(true);
            }
            this.resetPanel(index + paramChoice.length, this.order);
            this.paramPanel.validate();
            this.paramPanel.repaint();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void enableDisableList(boolean enable, int index) {
        if (index < this.listArray.length && this.listArray[index] != null) {
            this.listArray[index].setEnabled(enable);
        }
        if (index < this.allButton.length && this.allButton[index] != null) {
            this.allButton[index].setEnabled(enable);
            this.noneButton[index].setEnabled(enable);
        }
    }

    @Override
    public void setEnabled(boolean state) {
        this.resetButton.setEnabled(state);
        if (this.okButton != null) {
            this.okButton.setEnabled(state);
        }
        if (this.cancelButton != null) {
            this.cancelButton.setEnabled(state);
        }
        if (state) {
            this.setCursor(Cursor.getDefaultCursor());
        } else {
            this.setCursor(Cursor.getPredefinedCursor(3));
        }
    }

    public QueryInParam[] getQueryInParam() {
        if (this.areAllValid()) {
            return this.parameter;
        }
        this.showError();
        return null;
    }

    public int getParameterCount() {
        if (this.parameter != null) {
            return this.parameter.length;
        }
        return 0;
    }

    private void resetPanel(int startIndex, int currentOrderLevel) {
        int minOrder = this.getOrderIndex(0);
        if (minOrder > currentOrderLevel) {
            currentOrderLevel = minOrder;
        }
        for (int i = startIndex; i < this.nParam; ++i) {
            QueryInParam currParam = this.parameter[i];
            int orderIndex = this.getOrderIndex(i);
            if (currParam.isMapToColumn() || currParam.getSelectionChoices() != null || currParam.getSqlSelect() != null && currParam.getSqlSelect().trim().length() > 0) {
                Hashtable table = null;
                if (this.distinctTable != null && currParam.getSqlSelect() != null && currParam.getSqlSelect().trim().length() > 0) {
                    table = (Hashtable)this.distinctTable.get(currParam.getSqlSelect());
                }
                if (currParam instanceof QueryMultiValueInParam) {
                    int j;
                    Object vs = this.useDefaultValue ? currParam.getDefaultValue(this.fileInfo) : ((QueryMultiValueInParam)currParam).getValues();
                    Vector defVec = (Vector)vs;
                    String[] defaultString = new String[defVec.size()];
                    for (j = 0; j < defVec.size(); ++j) {
                        defaultString[j] = DataType.toString(defVec.get(j), currParam.getDateFormat());
                    }
                    for (j = 0; j < this.listArray[i].getItemCount(); ++j) {
                        String defaultString2 = this.listArray[i].getItem(j);
                        if (table != null) {
                            defaultString2 = DataType.toString(table.get(this.listArray[i].getItem(j)), currParam.getDateFormat());
                        }
                        this.listArray[i].deselect(j);
                        for (String element : defaultString) {
                            if (!element.equals(defaultString2)) continue;
                            this.listArray[i].select(j);
                            this.listArray[i].makeVisible(j);
                        }
                    }
                    if (orderIndex == currentOrderLevel) {
                        this.enableDisableList(true, i);
                    } else {
                        this.listArray[i].removeAll();
                        this.enableDisableList(false, i);
                    }
                } else {
                    String defaultString = DataType.toString(this.useDefaultValue ? currParam.getDefaultValue(this.fileInfo) : currParam.getValue(), currParam.getDateFormat());
                    for (int j = 0; j < this.choiceArray[i].getItemCount(); ++j) {
                        String defaultString2 = (String)this.choiceArray[i].getItemAt(j);
                        if (table != null) {
                            defaultString2 = DataType.toString(table.get(this.choiceArray[i].getItemAt(j)), currParam.getDateFormat());
                        }
                        if (!defaultString.equals(defaultString2)) continue;
                        this.choiceArray[i].setSelectedIndex(j);
                    }
                    if (orderIndex == currentOrderLevel) {
                        this.choiceArray[i].setEnabled(true);
                    } else {
                        this.choiceArray[i].setEnabled(false);
                    }
                }
            } else {
                Formula defaultValueVariable;
                Object defaultValue = this.useDefaultValue ? currParam.getDefaultValue(this.fileInfo) : currParam.getValue();
                Formula formula = defaultValueVariable = this.useDefaultValue ? currParam.getDefaultValueVariable() : currParam.getValueVariable();
                if (defaultValueVariable != null) {
                    this.textArray[i].setText(defaultValueVariable.getText());
                } else if (defaultValue == null || defaultValue.toString().equals("[null]") || defaultValue.toString().equals("")) {
                    this.textArray[i].setText("To be filled in");
                } else {
                    String defaultString = DataType.toString(defaultValue, currParam.getDateFormat());
                    this.textArray[i].setText(defaultString);
                }
                if (orderIndex == currentOrderLevel) {
                    this.textArray[i].setEnabled(true);
                } else {
                    this.textArray[i].setEnabled(false);
                }
            }
            currParam.setValue(null);
            if (currParam instanceof QueryMultiValueInParam) {
                ((QueryMultiValueInParam)currParam).setValues(null);
            }
            if (this.textArray[i] != null && this.textArray[i].getText().equals("To be filled in")) {
                this.textArray[i].selectAll();
            }
            if (i != 0) continue;
            if (this.textArray[i] != null) {
                this.textArray[i].requestFocusInWindow();
                continue;
            }
            if (this.choiceArray[i] != null) {
                this.choiceArray[i].requestFocusInWindow();
                continue;
            }
            if (this.listArray[i] == null) continue;
            this.listArray[i].requestFocusInWindow();
        }
    }

    private boolean areAllValid() {
        boolean flag = true;
        for (int i = 0; i < this.nParam; ++i) {
            if (this.makeQueryInParam(i)) continue;
            flag = false;
        }
        return flag;
    }

    private boolean makeQueryInParam(int index) {
        QueryInParam currParam = this.parameter[index];
        String[] valueString = new String[1];
        boolean multiValue = false;
        if (currParam.isMapToColumn() || currParam.getSelectionChoices() != null || currParam.getSqlSelect() != null && currParam.getSqlSelect().trim().length() > 0) {
            if (currParam instanceof QueryMultiValueInParam) {
                multiValue = true;
                valueString = this.listArray[index].getSelectedItems();
            } else {
                valueString[0] = this.choiceArray[index].getSelectedIndex() >= 0 ? (String)this.choiceArray[index].getItemAt(this.choiceArray[index].getSelectedIndex()) : null;
            }
        } else {
            if ((currParam.getSqlType() == 91 || currParam.getSqlType() == 92 || currParam.getSqlType() == 93) && this.textArray[index].getText().toLowerCase().indexOf("current") > -1) {
                return this.makeDateParam(currParam, this.textArray[index].getText());
            }
            currParam.setValueVariable(null);
            valueString[0] = this.textArray[index].getText();
            if (currParam instanceof QueryMultiValueInParam) {
                multiValue = true;
                valueString = QbUtil.parseMultiValues(valueString[0]);
            }
        }
        Vector<Object> valueObject = new Vector<Object>();
        try {
            Hashtable table = null;
            if (this.distinctTable != null && currParam.getSqlSelect() != null && currParam.getSqlSelect().trim().length() > 0) {
                table = (Hashtable)this.distinctTable.get(currParam.getSqlSelect());
            }
            if (table != null) {
                for (String element : valueString) {
                    valueObject.addElement(table.get(element));
                }
            } else if (currParam.getAllOptionLabel() != null && valueString[0].equals(currParam.getAllOptionLabel())) {
                valueObject.addElement(valueString[0]);
            } else {
                for (String element : valueString) {
                    valueObject.addElement(DataType.createObject(element, DataType.mapType(currParam.getSqlType()), currParam.getDateFormat()));
                }
            }
        }
        catch (Exception ex) {
            if (multiValue) {
                ((QueryMultiValueInParam)currParam).setValues(null);
            } else {
                currParam.setValue(null);
            }
            return false;
        }
        if (multiValue) {
            if (valueObject.size() == 0) {
                if (multiValue) {
                    ((QueryMultiValueInParam)currParam).setValues(null);
                } else {
                    currParam.setValue(null);
                }
                return false;
            }
            ((QueryMultiValueInParam)currParam).setValues(valueObject);
            if (currParam.isMapToColumn()) {
                if (this.listArray[index] != null && this.listArray[index].getItemCount() == valueObject.size()) {
                    ((QueryMultiValueInParam)currParam).setValue("SELECT_-_ALL_-_MULTIPLE_-_VALUES");
                } else {
                    ((QueryMultiValueInParam)currParam).setValue("NOT_-_SELECT_-_ALL_-_MULTIPLE_-_VALUES");
                }
            }
        } else {
            currParam.setValue(valueObject.elementAt(0));
        }
        return true;
    }

    private void showError() {
        String paramString = "";
        for (int i = 0; i < this.nParam; ++i) {
            QueryInParam currParam = this.parameter[i];
            if (currParam.getValue() != null) continue;
            paramString = paramString + "Please enter values for the " + currParam.getPromptName() + " parameter.\nThe datatype should be " + DataType.getTypeName(currParam.getSqlType()) + ".\n ";
        }
        String message = "Parameter value missing or does not match \nits data type: \n \n" + paramString;
        OurMessageDialog.showError(this, true, message);
    }

    protected final void fireEvent(Component c, int id, String cmd) {
        if (this.listener != null) {
            this.listener.actionPerformed(new ActionEvent(c, id, cmd));
        }
    }

    private Component createComponent(boolean isMultiValue, Vector values, Object[] array, int index, String dateFormat, QueryInParam currParam) {
        Vector vals = values;
        if (dateFormat != null) {
            QbDateFormat df = new QbDateFormat(values);
            try {
                vals = df.getFormattedDate(dateFormat, currParam.getAllOptionLabel());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (isMultiValue) {
            List list = new List(5, true);
            if (vals != null) {
                for (int j = 0; j < vals.size(); ++j) {
                    if (vals.elementAt(j) == null) continue;
                    list.add(vals.elementAt(j).toString());
                }
            }
            array[index] = list;
            list.addItemListener(this);
            list.setPreferredSize(new Dimension(200, 90));
            return list;
        }
        JComboBox<String> choice = new JComboBox<String>();
        choice.setLightWeightPopupEnabled(false);
        if (vals != null) {
            for (int j = 0; j < vals.size(); ++j) {
                if (vals.elementAt(j) == null) continue;
                choice.addItem(vals.elementAt(j).toString());
            }
        }
        array[index] = choice;
        choice.addActionListener(this);
        return choice;
    }

    private boolean makeDateParam(QueryInParam currParam, String value) {
        if (currParam.getSqlType() == 91 && value.toLowerCase().indexOf("currentdate") > -1 || currParam.getSqlType() == 92 && value.toLowerCase().indexOf("currenttime") > -1 || currParam.getSqlType() == 93 && value.toLowerCase().indexOf("currentdatetime") > -1) {
            try {
                Formula formula = new Formula(null, value);
                ByteArrayInputStream inputStream = new ByteArrayInputStream(value.getBytes("UTF-8"));
                InputStreamReader inputStreamReader = new InputStreamReader((InputStream)inputStream, "UTF-8");
                DateFormulaParser parser = new DateFormulaParser(inputStreamReader);
                formula.setFormula(parser.parse());
                currParam.setValueVariable(formula);
                return true;
            }
            catch (Exception ex) {
                ex.printStackTrace();
                return false;
            }
        }
        return false;
    }

    public int getParamIndex(int order) {
        if (this.maxOrder == 0 || order == 0) {
            return 0;
        }
        IQueryInParam[][] paramInSequence = ReportUtil.getParamInSequence(this.fileInfo);
        if (paramInSequence != null) {
            int sum = 0;
            for (int i = 0; i < order; ++i) {
                int ct = 0;
                for (int j = 0; j < paramInSequence[i].length; ++j) {
                    if (paramInSequence[i][j] == null) continue;
                    ct = j + 1;
                }
                sum += ct;
            }
            return sum;
        }
        return 0;
    }

    public int getOrderIndex(int index) {
        if (this.maxOrder == 0) {
            return 0;
        }
        IQueryInParam[][] paramInSequence = ReportUtil.getParamInSequence(this.fileInfo);
        if (paramInSequence != null) {
            int sum = 0;
            for (int i = 0; i < paramInSequence.length; ++i) {
                if (paramInSequence[i] != null) {
                    int ct = 0;
                    for (int j = 0; j < paramInSequence[i].length; ++j) {
                        if (paramInSequence[i][j] == null) continue;
                        ct = j + 1;
                    }
                    sum += ct;
                }
                if (index >= sum) continue;
                return i;
            }
        }
        return 0;
    }

    Object[][] getNextParamOrderValues(int order) {
        QueryInParam[] params = this.fileInfo.getInSet().getParameter(order);
        Object[][] paramChoice = new Object[params.length][];
        for (int i = 0; i < params.length; ++i) {
            Vector distinctValue;
            block13: {
                QueryInParam currParam = params[i];
                distinctValue = new Vector();
                if (currParam.isMapToColumn()) {
                    try {
                        if (this.fileInfo instanceof QueryXMLFileInfo) {
                            distinctValue = QueryParser.getDistinctValues(((QueryXMLFileInfo)this.fileInfo).getXMLFileQueryInfo(), currParam.getColumnName(), order);
                            break block13;
                        }
                        if (ReportUtil.getParamInSequence(this.fileInfo) != null) {
                            distinctValue = QueryParser.getDistinctValues(this.fileInfo, currParam.getTableName(), currParam.getColumnName(), order);
                            break block13;
                        }
                        distinctValue = QueryParser.getDistinctValues(this.fileInfo, currParam.getTableName(), currParam.getColumnName());
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                } else if (currParam.isMapToSqlSelect()) {
                    try {
                        Vector result = new Vector();
                        distinctValue = new Vector();
                        result = QueryParser.executeSQLSelect((IDatabaseInfo)this.fileInfo, currParam.getSqlSelect(), this.parameter, false);
                        distinctValue = (Vector)result.elementAt(0);
                        if (result.size() > 1) {
                            if (this.distinctTable == null) {
                                this.distinctTable = new Hashtable();
                            }
                            Hashtable table = new Hashtable();
                            for (int j = 0; j < distinctValue.size(); ++j) {
                                String key = distinctValue.elementAt(j).toString();
                                Object object = ((Vector)result.elementAt(1)).elementAt(j);
                                table.put(key, object);
                            }
                            this.distinctTable.put(currParam.getSqlSelect(), table);
                        }
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                }
            }
            if (distinctValue == null) continue;
            paramChoice[i] = distinctValue.toArray();
        }
        return paramChoice;
    }

    private OurPanel makeSelectionPanel(int paramIndex) {
        OurPanel selectionPanel = new OurPanel(new FlowLayout(2));
        String allStr = ServerMessage.imagesPath + "selectAll.png";
        String noneStr = ServerMessage.imagesPath + "unselectAll.png";
        this.allButton[paramIndex] = new JButton(IOUtil.getImageIcon(allStr));
        selectionPanel.add(this.allButton[paramIndex]);
        this.noneButton[paramIndex] = new JButton(IOUtil.getImageIcon(noneStr));
        selectionPanel.add(this.noneButton[paramIndex]);
        this.allButton[paramIndex].setBorder(BorderFactory.createEmptyBorder());
        this.allButton[paramIndex].setContentAreaFilled(false);
        this.allButton[paramIndex].addActionListener(this);
        this.noneButton[paramIndex].setBorder(BorderFactory.createEmptyBorder());
        this.noneButton[paramIndex].setContentAreaFilled(false);
        this.noneButton[paramIndex].addActionListener(this);
        selectionPanel.add(this.allButton[paramIndex]);
        selectionPanel.add(this.noneButton[paramIndex]);
        return selectionPanel;
    }

    public void valueChanged(ListSelectionEvent e) {
    }
}

