/*
 * Decompiled with CFR 0.152.
 */
package quadbase.common.paramquery;

import java.awt.AWTEventMulticaster;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.Vector;
import quadbase.chart.Chart;
import quadbase.common.param.ParameterSet;
import quadbase.common.param.Parameters;
import quadbase.common.param.QueryParam;
import quadbase.common.paramquery.EnterParamPanel;
import quadbase.common.paramquery.IEnterInParamDialog;
import quadbase.common.paramquery.OurDialog;
import quadbase.common.paramquery.QueryFileInfo;
import quadbase.common.paramquery.QueryInParam;
import quadbase.reportdesigner.report.Parameter;
import quadbase.reportdesigner.report.Report;

public class EnterParamDialog
extends OurDialog
implements ActionListener,
WindowListener,
IEnterInParamDialog {
    private transient ActionListener listener;
    EnterParamPanel enterPanel;
    boolean showCancelButton;
    Vector<Boolean> isCancelled;
    Report report;
    Chart chart;
    Frame frame;
    Dialog dialog;
    QueryFileInfo fileInfo;
    Vector<Parameter> formulaParams;
    int order;
    ParameterSet parameterSet;
    boolean show = true;
    boolean useDefaultValue = true;

    public EnterParamDialog(Frame frame, Report report, QueryFileInfo fileInfo, Vector<Parameter> formulaParams, boolean showCancelButton) {
        this(frame, report, fileInfo, formulaParams, -1, showCancelButton, null, null);
    }

    public EnterParamDialog(Frame frame, Report report, QueryFileInfo fileInfo, Vector<Parameter> formulaParams, int order, boolean showCancelButton, ParameterSet parameterSet, Vector<Boolean> isCancelled) {
        super(frame, "Enter Dialog", true);
        this.frame = frame;
        this.fileInfo = fileInfo;
        this.formulaParams = formulaParams;
        this.order = order;
        this.parameterSet = parameterSet;
        this.isCancelled = isCancelled;
        this.init(report, fileInfo, formulaParams, showCancelButton);
    }

    public EnterParamDialog(Dialog dialog, Report report, QueryFileInfo fileInfo, Vector<Parameter> formulaParams, boolean showCancelButton) {
        this(dialog, report, fileInfo, formulaParams, -1, showCancelButton, null, null, true);
    }

    public EnterParamDialog(Dialog dialog, Report report, QueryFileInfo fileInfo, Vector<Parameter> formulaParams, int order, boolean showCancelButton, ParameterSet parameterSet, Vector<Boolean> isCancelled, boolean useDefaultValue) {
        super(dialog, "Enter Dialog", true);
        this.dialog = dialog;
        this.fileInfo = fileInfo;
        this.formulaParams = formulaParams;
        this.order = order;
        this.parameterSet = parameterSet;
        this.isCancelled = isCancelled;
        this.useDefaultValue = useDefaultValue;
        this.init(report, fileInfo, formulaParams, showCancelButton);
    }

    public EnterParamDialog(Frame frame, Chart chart, QueryFileInfo fileInfo, boolean showCancelButton) {
        super(frame, "Enter Dialog", true);
        this.frame = frame;
        this.fileInfo = fileInfo;
        this.init(chart, fileInfo, showCancelButton);
    }

    public EnterParamDialog(Dialog dialog, Chart chart, QueryFileInfo fileInfo, boolean showCancelButton) {
        super(dialog, "Enter Dialog", true);
        this.dialog = dialog;
        this.fileInfo = fileInfo;
        this.init(chart, fileInfo, showCancelButton);
    }

    private void init(Report report, QueryFileInfo fileInfo, Vector<Parameter> formulaParams, boolean showCancelButton) {
        this.report = report;
        int number = 0;
        if (fileInfo != null) {
            number = fileInfo.getInParam().length;
        }
        if (formulaParams != null) {
            number += formulaParams.size();
        }
        if (number > 1) {
            this.setBorder("Please enter values");
        } else {
            this.setBorder("Please enter value");
        }
        this.showCancelButton = showCancelButton;
        this.addWindowListener(this);
        this.enterPanel = new EnterParamPanel(this, report, fileInfo, formulaParams, this.order, true, showCancelButton, this.useDefaultValue);
        while (this.enterPanel.getParameterCount() <= 0 && report.getMaxParameterOrder() > this.order) {
            ++this.order;
            this.enterPanel = new EnterParamPanel(this, report, fileInfo, formulaParams, this.order, true, showCancelButton, this.useDefaultValue);
        }
        if (this.enterPanel.getParameterCount() <= 0) {
            this.show = false;
        }
        this.enterPanel.addActionListener(this);
        this.add("Center", this.enterPanel);
        this.setPosition();
    }

    private void init(Chart chart, QueryFileInfo fileInfo, boolean showCancelButton) {
        this.setBackground(Color.lightGray);
        int number = 0;
        if (fileInfo != null) {
            number = fileInfo.getInParam().length;
        }
        if (number > 1) {
            this.setBorder("Please enter values");
        } else {
            this.setBorder("Please enter value");
        }
        this.showCancelButton = showCancelButton;
        this.addWindowListener(this);
        this.enterPanel = new EnterParamPanel(this, chart, fileInfo, true, showCancelButton);
        this.enterPanel.addActionListener(this);
        this.add("Center", this.enterPanel);
        this.setPosition();
    }

    private void setPosition() {
        this.pack();
        Dimension screensize = this.getToolkit().getScreenSize();
        Dimension preferredSize = this.getPreferredSize();
        int width = (int)Math.min((double)screensize.width * 0.9, (double)(preferredSize.width + 30));
        int height = (int)Math.min((double)screensize.height * 0.9, (double)(preferredSize.height + 30));
        this.setSize(width, height);
        this.setLocationRelativeTo(this.getParent());
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getActionCommand().equals("OK")) {
            if (this.parameterSet == null) {
                this.parameterSet = new ParameterSet();
            }
            if (this.isCancelled == null) {
                this.isCancelled = new Vector();
            }
            for (int i = 0; i < this.enterPanel.allPromptParams.size(); ++i) {
                this.parameterSet.add(this.enterPanel.allPromptParams.get(i));
            }
            this.setVisible(false);
            this.dispose();
            this.fireEvent(this, 0, e.getActionCommand());
        } else if (e.getActionCommand().equals("Cancel")) {
            if (this.isCancelled == null) {
                this.isCancelled = new Vector();
            }
            this.isCancelled.addElement(Boolean.TRUE);
            this.setVisible(false);
            this.dispose();
        }
    }

    public boolean hasParameter() {
        return this.enterPanel.nParam > 0 || this.enterPanel.mParam > 0;
    }

    public boolean queryParamHasChanged() {
        return this.enterPanel.queryParamHasChanged;
    }

    @Override
    public boolean isCancelled() {
        if (this.isCancelled == null) {
            return false;
        }
        for (int i = 0; i < this.isCancelled.size(); ++i) {
            if (!this.isCancelled.elementAt(i).booleanValue()) continue;
            return true;
        }
        return false;
    }

    @Override
    public QueryInParam[] getInParamValue() {
        return this.enterPanel.getInParamValue();
    }

    public Parameters getParameterValue() {
        if (this.parameterSet != null) {
            return this.parameterSet;
        }
        return this.enterPanel.allPromptParams;
    }

    public QueryParam[] getParamValue() {
        return this.enterPanel.getParamValue();
    }

    public Vector<Parameter> getFormulaParameters() {
        return this.enterPanel.formulaParams;
    }

    public synchronized void addActionListener(ActionListener l) {
        this.listener = AWTEventMulticaster.add(this.listener, l);
    }

    public synchronized void removeActionListener(ActionListener l) {
        this.listener = AWTEventMulticaster.remove(this.listener, l);
    }

    protected final void fireEvent(Component c, int id, String cmd) {
        if (this.listener != null) {
            this.listener.actionPerformed(new ActionEvent(c, id, cmd));
        }
    }

    @Override
    public void windowActivated(WindowEvent e) {
    }

    @Override
    public void windowClosed(WindowEvent e) {
    }

    @Override
    public void windowClosing(WindowEvent e) {
        this.enterPanel.resetPanel();
        this.enterPanel.areAllValid();
        if (this.isCancelled == null) {
            this.isCancelled = new Vector();
        }
        this.isCancelled.addElement(Boolean.TRUE);
        if (this.showCancelButton) {
            this.setVisible(false);
            this.dispose();
        }
    }

    @Override
    public void windowDeactivated(WindowEvent e) {
    }

    @Override
    public void windowDeiconified(WindowEvent e) {
    }

    @Override
    public void windowIconified(WindowEvent e) {
    }

    @Override
    public void windowOpened(WindowEvent e) {
    }
}

