/*
 * Decompiled with CFR 0.152.
 */
package quadbase.common.paramquery;

import java.awt.AWTEventMulticaster;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Label;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Date;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import quadbase.chart.Chart;
import quadbase.common.client.ServerMessage;
import quadbase.common.formula.DateFormulaParser;
import quadbase.common.formula.Formula;
import quadbase.common.param.FormulaParam;
import quadbase.common.param.OrderedParameterSet;
import quadbase.common.param.Param;
import quadbase.common.param.Parameters;
import quadbase.common.param.QueryParam;
import quadbase.common.paramquery.DateVariableDialog;
import quadbase.common.paramquery.OurButton;
import quadbase.common.paramquery.OurCalendarDialog;
import quadbase.common.paramquery.OurMessageDialog;
import quadbase.common.paramquery.OurPanel;
import quadbase.common.paramquery.OurScrollPane;
import quadbase.common.paramquery.QueryFileInfo;
import quadbase.common.paramquery.QueryInParam;
import quadbase.common.paramquery.QueryMultiValueInParam;
import quadbase.common.paramquery.QueryParser;
import quadbase.common.paramquery.QueryXMLFileInfo;
import quadbase.common.util.IDatabaseInfo;
import quadbase.common.util.internal.DataType;
import quadbase.common.util.internal.IOUtil;
import quadbase.common.util.internal.QbDateFormat;
import quadbase.common.util.internal.QbUtil;
import quadbase.reportdesigner.report.ColData;
import quadbase.reportdesigner.report.ReloadReport;
import quadbase.reportdesigner.report.Report;
import quadbase.reportdesigner.util.internal.FormatUtil;
import quadbase.reportdesigner.util.internal.ReportUtil;

public class EnterParamPanel
extends OurPanel
implements ActionListener,
ItemListener,
ListSelectionListener {
    QueryFileInfo fileInfo;
    Vector formulaParams = new Vector();
    Vector queryParams = new Vector();
    QueryInParam[] parameter;
    OrderedParameterSet allPromptParams;
    int nParam;
    int mParam;
    boolean showOKbutton;
    boolean showCancelButton;
    Report report;
    Report[] subReportArray;
    Chart chart;
    boolean queryParamHasChanged;
    boolean forReport = true;
    Vector originalValues = new Vector();
    int order = 0;
    int maxOrder = 0;
    boolean useDefaultValue = true;
    private transient ActionListener listener;
    OurButton resetButton;
    OurButton okButton;
    OurButton cancelButton;
    JButton[] allButton;
    JButton[] noneButton;
    JComboBox[] choiceArray;
    JScrollPane[] listPane;
    JTextField[] textArray;
    JList[] listArray;
    JPanel paramPanel;
    JButton[] dateButArray;
    JButton[] dateVariableButArray;
    GridBagLayout gbl;
    GridBagConstraints gbc;
    Dialog parentDlg;
    Hashtable distinctTable;
    private boolean[] alreadySelected;

    public EnterParamPanel(Dialog dlg, Report report, QueryFileInfo fileInfo, Vector fParams, int order, boolean showOKbutton) {
        this(dlg, report, fileInfo, fParams, order, showOKbutton, false, true);
    }

    public EnterParamPanel(Dialog dlg, Report report, QueryFileInfo fileInfo, Vector fParams, int order, boolean showOKbutton, boolean showCancelButton, boolean useDefaultValue) {
        Param currParam;
        this.parentDlg = dlg;
        this.report = report;
        this.subReportArray = report.getSubReportArray();
        this.fileInfo = fileInfo;
        this.order = order;
        this.showOKbutton = showOKbutton;
        this.showCancelButton = showCancelButton;
        this.forReport = true;
        this.useDefaultValue = useDefaultValue;
        this.allPromptParams = report.getParametersInSequence(order);
        this.maxOrder = this.allPromptParams.getOrderCount();
        boolean hasSubReport = report.subReports != null && report.subReports.size() > 0;
        this.nParam = this.allPromptParams.size();
        this.gbl = new GridBagLayout();
        this.gbc = new GridBagConstraints();
        this.paramPanel = new JPanel(this.gbl);
        this.gbc.anchor = 17;
        this.choiceArray = new JComboBox[this.nParam];
        this.textArray = new JTextField[this.nParam];
        this.dateButArray = new JButton[this.nParam];
        this.dateVariableButArray = new JButton[this.nParam];
        this.listArray = new JList[this.nParam];
        this.allButton = new JButton[this.nParam];
        this.noneButton = new JButton[this.nParam];
        this.alreadySelected = new boolean[this.nParam];
        for (int j = 0; j < this.nParam; ++j) {
            currParam = this.allPromptParams.get(j);
            if (currParam.getSelectionChoices() != null || currParam.isMapToColumn() || currParam.getSqlSelect() != null || !DataType.isDateTime(DataType.mapType(currParam.getSqlType()))) continue;
            this.dateButArray[j] = new JButton("Calendar");
            this.dateVariableButArray[j] = new JButton("Variable");
        }
        int gridy = 0;
        for (int j = 0; j < this.nParam; ++j) {
            Vector distinctValue;
            Component comp;
            currParam = this.allPromptParams.get(j);
            OrderedParameterSet ops = currParam.getReport().getParametersInSequence(true);
            int reportOrder = 0;
            boolean found = false;
            while (!found && reportOrder < ops.getOrderCount()) {
                Parameters ps = ops.getParamsAt(reportOrder);
                for (int i = 0; i < ps.size(); ++i) {
                    if (!ps.get(i).name().equals(currParam.name())) continue;
                    found = true;
                }
                if (found) continue;
                ++reportOrder;
            }
            String prefix = "";
            if (hasSubReport) {
                prefix = currParam.parent() + " : ";
            }
            JLabel labelComp = new JLabel(prefix + currParam.getPromptName());
            if (!currParam.isFormulaParam()) {
                QueryInParam qip = null;
                if (currParam instanceof QueryParam) {
                    qip = ((QueryParam)currParam).findParam();
                }
                if (currParam.getSelectionChoices() != null) {
                    JComponent[] array = this.choiceArray;
                    if (currParam.multiValue()) {
                        array = this.listArray;
                        OurPanel selectionPanel = this.makeSelectionPanel(j);
                        this.gbc.gridx = 2;
                        this.gbc.gridy = gridy++;
                        this.gbc.fill = 2;
                        this.gbc.anchor = 22;
                        this.gbc.insets = j > 0 ? new Insets(12, 0, 0, 0) : new Insets(0, 0, 0, 0);
                        this.gbc.weightx = 0.5;
                        this.gbc.weighty = 0.0;
                        this.gbc.gridwidth = 1;
                        this.gbl.setConstraints(selectionPanel, this.gbc);
                        this.paramPanel.add(selectionPanel);
                    }
                    comp = this.createComponent(currParam.multiValue(), currParam.getSelectionChoices(), array, j, null, qip);
                } else if (currParam.getSqlSelect() != null && currParam.getSqlSelect().trim().length() > 0) {
                    Vector result = null;
                    Vector distinctValue2 = new Vector();
                    try {
                        result = QueryParser.executeSQLSelect((IDatabaseInfo)currParam.getQueryFileInfo(), currParam.getSqlSelect(), (Parameters)report.getParametersInSequence(), 1);
                        distinctValue2 = (Vector)result.elementAt(0);
                        if (result.size() > 1) {
                            if (this.distinctTable == null) {
                                this.distinctTable = new Hashtable();
                            }
                            Hashtable table = new Hashtable();
                            for (int i = 0; i < distinctValue2.size(); ++i) {
                                String key = distinctValue2.elementAt(i).toString();
                                Object object = ((Vector)result.elementAt(1)).elementAt(i);
                                table.put(key, object);
                            }
                            this.distinctTable.put(currParam.getSqlSelect(), table);
                        }
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                    JComponent[] array = this.choiceArray;
                    if (currParam.multiValue()) {
                        array = this.listArray;
                        OurPanel selectionPanel = this.makeSelectionPanel(j);
                        this.gbc.gridx = 2;
                        this.gbc.gridy = gridy++;
                        this.gbc.fill = 2;
                        this.gbc.anchor = 22;
                        this.gbc.insets = j > 0 ? new Insets(12, 0, 0, 0) : new Insets(0, 0, 0, 0);
                        this.gbc.weightx = 0.5;
                        this.gbc.weighty = 0.0;
                        this.gbc.gridwidth = 1;
                        this.gbl.setConstraints(selectionPanel, this.gbc);
                        this.paramPanel.add(selectionPanel);
                    }
                    comp = this.createComponent(currParam.multiValue(), distinctValue2, array, j, null, qip);
                } else if (currParam.isMapToColumn()) {
                    distinctValue = new Vector();
                    try {
                        distinctValue = currParam.getQueryFileInfo() instanceof QueryXMLFileInfo ? QueryParser.getDistinctValues(((QueryXMLFileInfo)currParam.getQueryFileInfo()).getXMLFileQueryInfo(), currParam.getColumnName(), reportOrder) : QueryParser.getDistinctValues((QueryFileInfo)currParam.getQueryFileInfo(), currParam.getTableName(), currParam.getColumnName(), reportOrder);
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                    JComponent[] array = this.choiceArray;
                    if (currParam.multiValue()) {
                        array = this.listArray;
                        OurPanel selectionPanel = this.makeSelectionPanel(j);
                        this.gbc.gridx = 2;
                        this.gbc.gridy = gridy++;
                        this.gbc.fill = 2;
                        this.gbc.anchor = 22;
                        this.gbc.insets = j > 0 ? new Insets(12, 0, 0, 0) : new Insets(0, 0, 0, 0);
                        this.gbc.weightx = 0.5;
                        this.gbc.weighty = 0.0;
                        this.gbc.gridwidth = 1;
                        this.gbl.setConstraints(selectionPanel, this.gbc);
                        this.paramPanel.add(selectionPanel);
                    }
                    String dateFormat = null;
                    if ((currParam.getSqlType() == 91 || currParam.getSqlType() == 92 || currParam.getSqlType() == 93) && currParam.getDateFormat() != null) {
                        dateFormat = currParam.getDateFormat();
                    }
                    comp = this.createComponent(currParam.multiValue(), distinctValue, array, j, dateFormat, qip);
                } else if (this.dateButArray[j] != null) {
                    JPanel panel = new JPanel(new BorderLayout());
                    this.textArray[j] = new JTextField("To be filled in", 20);
                    this.textArray[j].addActionListener(this);
                    panel.add("Center", this.textArray[j]);
                    JPanel panel2 = new JPanel(new GridLayout(1, 2, 0, 0));
                    panel2.add(this.dateButArray[j]);
                    panel2.add(this.dateVariableButArray[j]);
                    this.dateButArray[j].addActionListener(this);
                    this.dateVariableButArray[j].addActionListener(this);
                    panel.add("East", panel2);
                    comp = panel;
                } else {
                    this.textArray[j] = new JTextField("To be filled in", 20);
                    this.textArray[j].addActionListener(this);
                    comp = this.textArray[j];
                }
            } else if (currParam.isMapToColumn()) {
                ColData[] originalColData = currParam.getReport().colData;
                if (currParam.getReport().sourceData == 0) {
                    currParam.getReport().sourceData = currParam.getReport().getOriginalSourceData();
                    try {
                        originalColData = ReloadReport.getOriginalColData((Report)currParam.getReport(), (boolean)false);
                    }
                    catch (Exception panel) {
                        // empty catch block
                    }
                }
                distinctValue = originalColData[((FormulaParam)currParam).getMapColIdx()].getDistinctValue();
                this.choiceArray[j] = new JComboBox();
                for (int k = 0; k < distinctValue.size(); ++k) {
                    if (distinctValue.elementAt(k) == null) continue;
                    this.choiceArray[j].addItem(FormatUtil.formatValue(distinctValue.elementAt(k)));
                }
                if (useDefaultValue) {
                    this.choiceArray[j].setSelectedItem(((FormulaParam)currParam).formatDefaultValue());
                } else {
                    this.choiceArray[j].setSelectedItem(((FormulaParam)currParam).formatValue());
                }
                this.choiceArray[j].addItemListener(this);
                comp = this.choiceArray[j];
            } else {
                this.textArray[j] = useDefaultValue ? new JTextField(((FormulaParam)currParam).formatDefaultValue(), 20) : new JTextField(((FormulaParam)currParam).formatValue(), 20);
                this.textArray[j].addActionListener(this);
                comp = this.textArray[j];
            }
            this.gbc.gridy = gridy++;
            this.gbc.gridx = 0;
            this.gbc.fill = 0;
            this.gbc.insets = new Insets(1, 1, 1, 1);
            this.gbc.weightx = 0.0;
            this.gbc.weighty = 0.0;
            this.gbc.gridwidth = 1;
            this.gbl.setConstraints(labelComp, this.gbc);
            this.paramPanel.add(labelComp);
            this.gbc.gridx = 1;
            this.gbc.fill = 2;
            this.gbc.insets = new Insets(1, 1, 1, 1);
            this.gbc.weightx = 0.0;
            this.gbc.weighty = 0.0;
            this.gbc.gridwidth = 2;
            this.gbl.setConstraints(comp, this.gbc);
            this.paramPanel.add(comp);
        }
        this.originalValues = new Vector();
        for (int i = 0; i < this.nParam; ++i) {
            if (this.allPromptParams.get(i).isFormulaParam()) continue;
            this.originalValues.addElement(this.allPromptParams.get(i).getValue() == null ? null : this.allPromptParams.get(i).getValue().toString());
        }
        this.resetPanel(0, 0);
        OurScrollPane scrollPane = new OurScrollPane(this.paramPanel, 0);
        scrollPane.setPreferredSize(this.paramPanel.getPreferredSize());
        this.add("Center", scrollPane);
        OurPanel buttonPanel = new OurPanel(new FlowLayout(2));
        this.resetButton = new OurButton("Reset");
        buttonPanel.add(this.resetButton);
        this.resetButton.addActionListener(this);
        if (showOKbutton) {
            this.okButton = new OurButton("OK");
            buttonPanel.add(this.okButton);
            this.okButton.addActionListener(this);
        }
        if (showCancelButton) {
            this.cancelButton = new OurButton("Cancel");
            buttonPanel.add(this.cancelButton);
            this.cancelButton.addActionListener(this);
        }
        this.add("South", buttonPanel);
    }

    private Component getCalendarPanel(Component comp) {
        OurPanel panel = new OurPanel(new BorderLayout());
        panel.add("West", comp);
        Label lbl = new Label("Calendar");
        lbl.setForeground(Color.lightGray);
        panel.add("Center", lbl);
        return panel;
    }

    public EnterParamPanel(Dialog dlg, Chart chart, QueryFileInfo fileInfo, boolean showOKbutton, boolean showCancelButton) {
        int i;
        this.chart = chart;
        this.fileInfo = fileInfo;
        this.showOKbutton = showOKbutton;
        this.showCancelButton = showCancelButton;
        this.forReport = false;
        if (fileInfo != null) {
            this.parameter = fileInfo.getInSet().getParameter();
            this.nParam = this.parameter.length;
        }
        for (int i2 = 0; this.parameter != null && i2 < this.parameter.length; ++i2) {
            this.queryParams.addElement(this.parameter[i2]);
        }
        GridBagLayout gbl = new GridBagLayout();
        GridBagConstraints gbc = new GridBagConstraints();
        OurPanel paramPanel = new OurPanel(gbl);
        gbc.anchor = 17;
        this.choiceArray = new JComboBox[this.nParam];
        this.textArray = new JTextField[this.nParam];
        this.dateButArray = new JButton[this.nParam];
        this.dateVariableButArray = new JButton[this.nParam];
        this.listArray = new JList[this.nParam];
        this.allButton = new JButton[this.nParam];
        this.noneButton = new JButton[this.nParam];
        boolean showCalendarColumn = false;
        for (int j = 0; j < this.nParam; ++j) {
            QueryInParam currParam = (QueryInParam)this.queryParams.elementAt(j);
            if (currParam.getSelectionChoices() != null || currParam.isMapToColumn() || !DataType.isDateTime(DataType.mapType(currParam.getSqlType()))) continue;
            this.dateButArray[j] = new JButton("Calendar");
            this.dateVariableButArray[j] = new JButton("Variable");
            showCalendarColumn = true;
        }
        int gridy = 0;
        for (i = 0; i < this.nParam; ++i) {
            Component comp;
            QueryInParam currParam = this.parameter[i];
            Label labelComp = new Label(currParam.getPromptName());
            if (currParam.getSelectionChoices() != null) {
                boolean isMultiValue = currParam instanceof QueryMultiValueInParam;
                JComponent[] array = this.choiceArray;
                if (isMultiValue) {
                    array = this.listArray;
                    OurPanel selectionPanel = this.makeSelectionPanel(i);
                    gbc.gridx = 2;
                    gbc.gridy = gridy++;
                    gbc.fill = 2;
                    gbc.anchor = 22;
                    gbc.insets = i > 0 ? new Insets(12, 0, 0, 0) : new Insets(0, 0, 0, 0);
                    gbc.weightx = 0.5;
                    gbc.weighty = 0.0;
                    gbc.gridwidth = 1;
                    gbl.setConstraints(selectionPanel, gbc);
                    paramPanel.add(selectionPanel);
                }
                comp = this.createComponent(isMultiValue, currParam.getSelectionChoices(), array, i, null, currParam);
            } else if (currParam.isMapToColumn()) {
                Vector<Object> distinctValue = new Vector();
                try {
                    distinctValue = QueryParser.getDistinctValues(fileInfo, currParam.getTableName(), currParam.getColumnName());
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
                boolean isMultiValue = currParam instanceof QueryMultiValueInParam;
                JComponent[] array = this.choiceArray;
                if (isMultiValue) {
                    array = this.listArray;
                    OurPanel selectionPanel = this.makeSelectionPanel(i);
                    gbc.gridx = 2;
                    gbc.gridy = gridy++;
                    gbc.fill = 2;
                    gbc.anchor = 22;
                    gbc.insets = i > 0 ? new Insets(12, 0, 0, 0) : new Insets(0, 0, 0, 0);
                    gbc.weightx = 0.5;
                    gbc.weighty = 0.0;
                    gbc.gridwidth = 1;
                    gbl.setConstraints(selectionPanel, gbc);
                    paramPanel.add(selectionPanel);
                }
                comp = this.createComponent(isMultiValue, distinctValue, array, i, null, currParam);
                if (showCalendarColumn) {
                    comp = this.getCalendarPanel(comp);
                }
            } else if (this.dateButArray[i] != null) {
                OurPanel panel = new OurPanel(new BorderLayout());
                this.textArray[i] = new JTextField("To be filled in", 20);
                this.textArray[i].addActionListener(this);
                panel.add("West", this.textArray[i]);
                panel.add("Center", this.dateButArray[i]);
                panel.add("East", this.dateVariableButArray[i]);
                this.dateButArray[i].addActionListener(this);
                this.dateVariableButArray[i].addActionListener(this);
                comp = panel;
            } else {
                this.textArray[i] = new JTextField("To be filled in", 20);
                this.textArray[i].addActionListener(this);
                comp = this.textArray[i];
                if (showCalendarColumn) {
                    comp = this.getCalendarPanel(comp);
                }
            }
            gbc.gridy = gridy++;
            gbc.gridx = 0;
            gbc.fill = 0;
            gbc.insets = new Insets(1, 1, 1, 1);
            gbc.weightx = 0.0;
            gbc.weighty = 0.0;
            gbc.gridwidth = 1;
            gbl.setConstraints(labelComp, gbc);
            paramPanel.add(labelComp);
            gbc.gridx = 1;
            gbc.fill = 2;
            gbc.insets = new Insets(1, 1, 1, 1);
            gbc.weightx = 0.0;
            gbc.weighty = 0.0;
            gbc.gridwidth = 2;
            gbl.setConstraints(comp, gbc);
            paramPanel.add(comp);
        }
        this.originalValues = new Vector();
        for (i = 0; this.parameter != null && i < this.parameter.length; ++i) {
            this.originalValues.addElement(this.parameter[i].getValue() == null ? null : this.parameter[i].getValue().toString());
        }
        this.resetPanel(0, 0);
        OurScrollPane scrollPane = new OurScrollPane(paramPanel, 0);
        scrollPane.setPreferredSize(paramPanel.getPreferredSize());
        this.add("Center", scrollPane);
        OurPanel buttonPanel = new OurPanel(new FlowLayout(2));
        this.resetButton = new OurButton("Reset");
        buttonPanel.add(this.resetButton);
        this.resetButton.addActionListener(this);
        if (showOKbutton) {
            this.okButton = new OurButton("OK");
            buttonPanel.add(this.okButton);
            this.okButton.addActionListener(this);
        }
        if (showCancelButton) {
            this.cancelButton = new OurButton("Cancel");
            buttonPanel.add(this.cancelButton);
            this.cancelButton.addActionListener(this);
        }
        this.add("South", buttonPanel);
    }

    public synchronized void addActionListener(ActionListener l) {
        this.listener = AWTEventMulticaster.add(this.listener, l);
    }

    public synchronized void removeActionListener(ActionListener l) {
        this.listener = AWTEventMulticaster.remove(this.listener, l);
    }

    public QueryInParam[] getInParamValue() {
        QueryInParam[] param = new QueryInParam[this.nParam];
        for (int i = 0; i < this.queryParams.size(); ++i) {
            param[i] = (QueryInParam)this.queryParams.elementAt(i);
        }
        return param;
    }

    public QueryParam[] getParamValue() {
        Vector<Param> vec = new Vector<Param>();
        for (int i = 0; i < this.nParam; ++i) {
            Param param = this.allPromptParams.get(i);
            if (param.isFormulaParam()) continue;
            vec.addElement(param);
        }
        QueryParam[] queryParam = new QueryParam[vec.size()];
        for (int i = 0; i < vec.size(); ++i) {
            queryParam[i] = (QueryParam)vec.elementAt(i);
        }
        return queryParam;
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        this.valueChanged(e.getSource());
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        if (e.getStateChange() == 1) {
            this.valueChanged(e.getSource());
        }
    }

    public void valueChanged(Object source) {
        if (this.maxOrder == 0) {
            return;
        }
        try {
            int i;
            for (i = 0; i < this.choiceArray.length; ++i) {
                if (this.choiceArray[i] == null || source != this.choiceArray[i]) continue;
                if (!this.choiceArray[i].isEnabled()) {
                    return;
                }
                Param sourceParam = this.allPromptParams.get(i);
                if (sourceParam instanceof FormulaParam) {
                    return;
                }
                this.order = this.allPromptParams.getOrder(i);
                if (this.order + 1 == this.maxOrder || this.order < 0) {
                    return;
                }
                this.alreadySelected[i] = true;
                boolean wholeOrderCompleted = true;
                int index = this.allPromptParams.getParamIndex(this.order + 1);
                for (int j = 0; j < index; ++j) {
                    if (!this.alreadySelected[j]) {
                        wholeOrderCompleted = false;
                    }
                    this.makeParam(j);
                }
                if (!wholeOrderCompleted) {
                    return;
                }
                Object[][] paramChoice = this.getNextParamOrderValues(this.order + 1);
                for (int j = 0; j < paramChoice.length && index + j < this.allPromptParams.size(); ++j) {
                    Param param = this.allPromptParams.get(index + j);
                    if (param.isMapToColumn() || param.getSqlSelect() != null) {
                        if (param.multiValue()) {
                            Vector<String> data = new Vector<String>();
                            if (paramChoice[j] != null) {
                                for (int k = 0; k < paramChoice[j].length; ++k) {
                                    if ((param.getSqlType() == 91 || param.getSqlType() == 92 || param.getSqlType() == 93) && param.getDateFormat() != null) {
                                        data.add(QbDateFormat.getFormattedDateTime((Date)paramChoice[j][k], param.getDateFormat()));
                                        continue;
                                    }
                                    data.add(paramChoice[j][k].toString());
                                }
                            }
                            this.listArray[index + j].setListData(data);
                            this.enableDisableList(true, index + j);
                            continue;
                        }
                        this.addValuesToSelectBox(index, paramChoice, j, param);
                        continue;
                    }
                    if (param.getSelectionChoices() != null) {
                        if (param instanceof QueryMultiValueInParam) {
                            this.enableDisableList(true, index + j);
                            continue;
                        }
                        this.choiceArray[index + j].setEnabled(true);
                        continue;
                    }
                    this.textArray[index + j].setEnabled(true);
                }
                this.resetPanel(index + paramChoice.length, this.order);
            }
            for (i = 0; i < this.listArray.length; ++i) {
                if (this.listArray[i] == null || (source instanceof ListSelectionModel ? source != this.listArray[i].getSelectionModel() : source != this.listArray[i])) continue;
                this.order = this.allPromptParams.getOrder(i);
                if (this.listArray[i].getSelectedValues() == null || this.listArray[i].getSelectedValues().length == 0) {
                    this.resetPanel(i + 1, this.order);
                    return;
                }
                if (this.order + 1 == this.maxOrder || this.order < 0) continue;
                this.alreadySelected[i] = true;
                int index = this.allPromptParams.getParamIndex(this.order + 1);
                for (int j = 0; j < index; ++j) {
                    this.makeParam(j);
                }
                Object[][] paramChoice = this.getNextParamOrderValues(this.order + 1);
                for (int j = 0; j < paramChoice.length && index + j < this.allPromptParams.size(); ++j) {
                    Param param = this.allPromptParams.get(index + j);
                    if (param.isMapToColumn() || param.getSqlSelect() != null) {
                        if (param.multiValue()) {
                            Vector<String> data = new Vector<String>();
                            if (paramChoice[j] != null) {
                                for (int k = 0; k < paramChoice[j].length; ++k) {
                                    if ((param.getSqlType() == 91 || param.getSqlType() == 92 || param.getSqlType() == 93) && param.getDateFormat() != null) {
                                        data.add(QbDateFormat.getFormattedDateTime((Date)paramChoice[j][k], param.getDateFormat()));
                                        continue;
                                    }
                                    data.add(paramChoice[j][k].toString());
                                }
                            }
                            this.listArray[index + j].setListData(data);
                            this.enableDisableList(true, index + j);
                            continue;
                        }
                        this.addValuesToSelectBox(index, paramChoice, j, param);
                        continue;
                    }
                    if (param.getSelectionChoices() != null) {
                        if (param instanceof QueryMultiValueInParam) {
                            this.enableDisableList(true, index + j);
                            continue;
                        }
                        this.choiceArray[index + j].setEnabled(true);
                        continue;
                    }
                    this.textArray[index + j].setEnabled(true);
                }
                this.resetPanel(index + paramChoice.length, this.order);
            }
            this.paramPanel.validate();
            this.paramPanel.repaint();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void addValuesToSelectBox(int index, Object[][] paramChoice, int j, Param param) {
        ActionListener[] il;
        for (ActionListener element : il = this.choiceArray[index + j].getActionListeners()) {
            this.choiceArray[index + j].removeActionListener(element);
        }
        this.choiceArray[index + j].removeAllItems();
        if (paramChoice[j] != null) {
            for (int k = 0; k < paramChoice[j].length; ++k) {
                if ((param.getSqlType() == 91 || param.getSqlType() == 92 || param.getSqlType() == 93) && param.getDateFormat() != null) {
                    this.choiceArray[index + j].addItem(QbDateFormat.getFormattedDateTime((Date)paramChoice[j][k], param.getDateFormat()));
                    continue;
                }
                this.choiceArray[index + j].addItem(paramChoice[j][k].toString());
            }
        }
        for (ActionListener element : il) {
            this.choiceArray[index + j].addActionListener(element);
        }
        this.choiceArray[index + j].setEnabled(true);
        this.alreadySelected[index + j] = true;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        int i;
        Object source = e.getSource();
        if (source instanceof JComboBox) {
            this.valueChanged(source);
        } else if (source == this.resetButton) {
            this.resetPanel(0, 0);
        } else if (source == this.okButton) {
            if (this.areAllValid()) {
                this.fireEvent(this, 0, e.getActionCommand());
            } else {
                this.showError();
            }
        } else if (source == this.cancelButton) {
            this.resetPanel(0, 0);
            this.areAllValid();
            try {
                int ct = 0;
                for (int i2 = 0; i2 < this.nParam; ++i2) {
                    Param param = this.allPromptParams.get(i2);
                    if (param.isFormulaParam()) continue;
                    param.setValue(DataType.createObject((String)this.originalValues.elementAt(ct), DataType.mapType(param.getSqlType()), param.getDateFormat()));
                    ++ct;
                }
            }
            catch (Exception ct) {
                // empty catch block
            }
            this.fireEvent(this, 0, e.getActionCommand());
        }
        for (i = 0; i < this.allButton.length; ++i) {
            if (source == this.allButton[i]) {
                int start = 0;
                int end = this.listArray[i].getModel().getSize() - 1;
                if (end < 0) continue;
                this.listArray[i].setSelectionInterval(start, end);
                continue;
            }
            if (source != this.noneButton[i]) continue;
            this.listArray[i].clearSelection();
        }
        for (i = 0; this.maxOrder > 0 && i < this.textArray.length; ++i) {
            if (this.textArray[i] == null || source != this.textArray[i]) continue;
            Param sourceParam = this.allPromptParams.get(i);
            if (sourceParam instanceof FormulaParam) {
                return;
            }
            this.textActionPerformed(i);
        }
        for (i = 0; i < this.dateVariableButArray.length; ++i) {
            if (this.dateVariableButArray[i] == null || source != this.dateVariableButArray[i]) continue;
            Param currParam = this.allPromptParams.get(i);
            String text = "";
            if (this.useDefaultValue) {
                if (currParam.getDefaultValueVariable() != null) {
                    text = currParam.getDefaultValueVariable().getText();
                }
            } else if (currParam.getValueVariable() != null) {
                text = currParam.getValueVariable().getText();
            }
            DateVariableDialog dialog = new DateVariableDialog(this.parentDlg, text);
            dialog.setVisible(true);
            if (!dialog.isModified() || dialog.getText() == null) continue;
            try {
                text = dialog.getText();
                Formula formula = new Formula(null, text);
                ByteArrayInputStream inputStream = new ByteArrayInputStream(text.getBytes("UTF-8"));
                InputStreamReader inputStreamReader = new InputStreamReader((InputStream)inputStream, "UTF-8");
                DateFormulaParser parser = new DateFormulaParser(inputStreamReader);
                formula.setFormula(parser.parse());
                this.textArray[i].setText(text);
                this.textActionPerformed(i);
                continue;
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        for (i = 0; i < this.dateButArray.length; ++i) {
            if (this.dateButArray[i] == null || source != this.dateButArray[i]) continue;
            OurCalendarDialog calendarDialog = new OurCalendarDialog(null, this.allPromptParams.get(i).getSqlType());
            Date curTime = null;
            try {
                curTime = (Date)DataType.createObject(this.textArray[i].getText(), DataType.mapType(this.allPromptParams.get(i).getSqlType()), this.allPromptParams.get(i).getDateFormat());
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (curTime != null) {
                calendarDialog.setTime(curTime);
            }
            calendarDialog.setVisible(true);
            if (calendarDialog.isCancelled()) {
                return;
            }
            this.textArray[i].setText(DataType.toString(calendarDialog.getTime(), this.allPromptParams.get(i).getDateFormat()));
            this.textActionPerformed(i);
            return;
        }
    }

    public void textActionPerformed(int i) {
        try {
            this.order = this.allPromptParams.getOrder(i);
            if (this.order + 1 == this.maxOrder || this.order < 0) {
                return;
            }
            int index = this.allPromptParams.getParamIndex(this.order + 1);
            for (int j = 0; j < index; ++j) {
                this.makeParam(j);
            }
            Object[][] paramChoice = this.getNextParamOrderValues(this.order + 1);
            for (int j = 0; j < paramChoice.length && index + j < this.allPromptParams.size(); ++j) {
                Param param = this.allPromptParams.get(index + j);
                if (param.isMapToColumn() || param.getSqlSelect() != null) {
                    if (param.multiValue()) {
                        this.listArray[index + j].removeAll();
                        Vector<String> data = new Vector<String>();
                        if (paramChoice[j] != null) {
                            for (int k = 0; k < paramChoice[j].length; ++k) {
                                if ((param.getSqlType() == 91 || param.getSqlType() == 92 || param.getSqlType() == 93) && param.getDateFormat() != null) {
                                    data.add(QbDateFormat.getFormattedDateTime((Date)paramChoice[j][k], param.getDateFormat()));
                                    continue;
                                }
                                data.add(paramChoice[j][k].toString());
                            }
                        }
                        this.listArray[index + j].setListData(data);
                        this.enableDisableList(true, index + j);
                        continue;
                    }
                    this.paramPanel.remove(this.choiceArray[index + j]);
                    this.choiceArray[index + j] = new JComboBox();
                    if (paramChoice[j] != null) {
                        for (int k = 0; k < paramChoice[j].length; ++k) {
                            if ((param.getSqlType() == 91 || param.getSqlType() == 92 || param.getSqlType() == 93) && param.getDateFormat() != null) {
                                this.choiceArray[index + j].addItem(QbDateFormat.getFormattedDateTime((Date)paramChoice[j][k], param.getDateFormat()));
                                continue;
                            }
                            this.choiceArray[index + j].addItem(paramChoice[j][k].toString());
                        }
                    }
                    this.gbl.setConstraints(this.choiceArray[index + j], this.gbc);
                    this.choiceArray[index + j].addActionListener(this);
                    this.paramPanel.add((Component)this.choiceArray[index + j], (index + j) * 2);
                    continue;
                }
                this.textArray[index + j].setEnabled(true);
            }
            this.paramPanel.validate();
            this.paramPanel.repaint();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void enableDisableList(boolean enable, int index) {
        if (index < this.listArray.length && this.listArray[index] != null) {
            this.listArray[index].setEnabled(enable);
        }
        if (index < this.allButton.length && this.allButton[index] != null) {
            this.allButton[index].setEnabled(enable);
            this.noneButton[index].setEnabled(enable);
        }
    }

    @Override
    public void setEnabled(boolean state) {
        this.resetButton.setEnabled(state);
        if (this.okButton != null) {
            this.okButton.setEnabled(state);
        }
        if (this.cancelButton != null) {
            this.cancelButton.setEnabled(state);
        }
        if (state) {
            this.setCursor(Cursor.getDefaultCursor());
        } else {
            this.setCursor(Cursor.getPredefinedCursor(3));
        }
    }

    public QueryParam[] getQueryParam() {
        if (this.areAllValid()) {
            return this.getParamValue();
        }
        this.showError();
        return null;
    }

    public int getParameterCount() {
        if (this.allPromptParams != null) {
            return this.allPromptParams.size();
        }
        return 0;
    }

    void resetPanel() {
        this.resetPanel(0, 0);
    }

    void resetPanel(int startIndex, int currentOrderLevel) {
        if (currentOrderLevel < 0) {
            currentOrderLevel = 0;
        }
        for (int i = startIndex; i < this.nParam; ++i) {
            Param currParam = this.allPromptParams.get(i);
            if (!currParam.isFormulaParam()) {
                int orderIndex = this.allPromptParams.getOrder(i);
                if (currParam.isMapToColumn() || currParam.getSelectionChoices() != null || currParam.getSqlSelect() != null && currParam.getSqlSelect().trim().length() > 0) {
                    if (currParam.multiValue()) {
                        Vector<Integer> vec;
                        String[] defaultStrings = null;
                        if (this.useDefaultValue) {
                            Vector v = (Vector)currParam.getDefaultValue();
                            defaultStrings = new String[v.size()];
                            for (int j = 0; v != null && j < v.size(); ++j) {
                                defaultStrings[j] = DataType.toString(v.get(j), currParam.getDateFormat());
                            }
                        } else {
                            vec = currParam.getValues();
                            if (vec != null) {
                                defaultStrings = new String[vec.size()];
                                for (int j = 0; j < vec.size(); ++j) {
                                    defaultStrings[j] = DataType.toString(vec.elementAt(j), currParam.getDateFormat());
                                }
                            }
                        }
                        vec = new Vector<Integer>();
                        int ct = 0;
                        try {
                            ct = this.listArray[i].getModel().getSize();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        for (int j = 0; j < ct; ++j) {
                            if (defaultStrings == null) continue;
                            for (String defaultString : defaultStrings) {
                                String listVal;
                                Object tmpVal;
                                Hashtable table;
                                Object val = this.listArray[i].getModel().getElementAt(j);
                                if (this.distinctTable != null && currParam.getSqlSelect() != null && currParam.getSqlSelect().trim().length() > 0 && val != null && (table = (Hashtable)this.distinctTable.get(currParam.getSqlSelect())) != null && (tmpVal = table.get(val.toString())) != null) {
                                    val = tmpVal;
                                }
                                if (!defaultString.equals(listVal = DataType.toString(val, currParam.getDateFormat()))) continue;
                                vec.addElement(j);
                            }
                        }
                        if (vec.size() > 0) {
                            int firstIndex = -1;
                            int[] selectedIdx = new int[vec.size()];
                            for (int t = 0; t < selectedIdx.length; ++t) {
                                selectedIdx[t] = (Integer)vec.elementAt(t);
                                if (firstIndex != -1) continue;
                                firstIndex = selectedIdx[t];
                            }
                            if (selectedIdx.length == this.listArray[i].getModel().getSize()) {
                                this.listArray[i].setSelectionInterval(0, selectedIdx.length - 1);
                            } else {
                                this.listArray[i].setSelectedIndices(selectedIdx);
                            }
                            Point point = this.listArray[i].indexToLocation(firstIndex);
                            if (this.listPane != null && i < this.listPane.length && this.listPane[i] != null) {
                                this.listPane[i].getViewport().setViewPosition(point);
                            }
                        }
                        if (orderIndex <= currentOrderLevel) {
                            this.enableDisableList(true, i);
                        } else {
                            this.enableDisableList(false, i);
                            this.listArray[i].removeAll();
                        }
                    } else {
                        String defaultString = DataType.toString(this.useDefaultValue ? currParam.getDefaultValue() : currParam.getValue(), currParam.getDateFormat());
                        for (int j = 0; j < this.choiceArray[i].getItemCount(); ++j) {
                            if (!defaultString.equals(this.choiceArray[i].getItemAt(j))) continue;
                            this.choiceArray[i].setSelectedIndex(j);
                        }
                        if (orderIndex <= currentOrderLevel) {
                            this.choiceArray[i].setEnabled(true);
                        } else {
                            this.choiceArray[i].setEnabled(false);
                        }
                    }
                } else {
                    Formula defaultValueVariable;
                    Object defaultValue = this.useDefaultValue ? currParam.getDefaultValue() : currParam.getValue();
                    Formula formula = defaultValueVariable = this.useDefaultValue ? currParam.getDefaultValueVariable() : currParam.getValueVariable();
                    if (defaultValueVariable != null) {
                        this.textArray[i].setText(defaultValueVariable.getText());
                    } else if (defaultValue == null || defaultValue.toString().equals("[null]") || defaultValue.toString().equals("")) {
                        this.textArray[i].setText("To be filled in");
                    } else {
                        if (defaultValue instanceof Vector) {
                            defaultValue = defaultValue.toString().substring(1, defaultValue.toString().length() - 1);
                        }
                        String defaultString = DataType.toString(defaultValue, currParam.getDateFormat());
                        this.textArray[i].setText(defaultString);
                    }
                    if (orderIndex <= currentOrderLevel) {
                        this.textArray[i].setEnabled(true);
                    } else {
                        this.textArray[i].setEnabled(false);
                    }
                }
                currParam.setValue(null);
                if (currParam.multiValue()) {
                    currParam.setValues(null);
                }
            } else {
                if (currParam.isMapToColumn()) {
                    String defaultString = ((FormulaParam)currParam).formatDefaultValue();
                    for (int j = 0; j < this.choiceArray[i].getItemCount(); ++j) {
                        if (!defaultString.equals(this.choiceArray[i].getItemAt(j))) continue;
                        this.choiceArray[i].setSelectedIndex(j);
                    }
                    this.choiceArray[i].setEnabled(true);
                } else {
                    if (this.useDefaultValue) {
                        this.textArray[i].setText(((FormulaParam)currParam).formatDefaultValue());
                    } else {
                        this.textArray[i].setText(((FormulaParam)currParam).formatValue());
                    }
                    this.textArray[i].setEnabled(true);
                }
                currParam.setValue(null);
            }
            if (this.textArray[i] != null && this.textArray[i].getText().equals("To be filled in")) {
                this.textArray[i].selectAll();
            }
            if (i != 0) continue;
            if (this.textArray[i] != null) {
                this.textArray[i].requestFocusInWindow();
                continue;
            }
            if (this.choiceArray[i] != null) {
                this.choiceArray[i].requestFocusInWindow();
                continue;
            }
            if (this.listArray[i] == null) continue;
            this.listArray[i].requestFocusInWindow();
        }
    }

    boolean areAllParamOrdersFilled() {
        int i;
        boolean flag = true;
        for (i = 0; i < this.choiceArray.length; ++i) {
            if (this.choiceArray[i] == null || this.choiceArray[i].isEnabled()) continue;
            flag = false;
        }
        if (flag) {
            for (i = 0; i < this.listArray.length; ++i) {
                if (this.listArray[i] == null || this.listArray[i].isEnabled()) continue;
                flag = false;
            }
        }
        if (flag) {
            for (i = 0; i < this.textArray.length; ++i) {
                if (this.textArray[i] == null || this.textArray[i].isEnabled()) continue;
                flag = false;
            }
        }
        return flag;
    }

    boolean areAllValid() {
        boolean flag = true;
        flag = this.areAllParamOrdersFilled();
        if (flag) {
            for (int i = 0; i < this.nParam; ++i) {
                if (this.makeParam(i)) continue;
                flag = false;
            }
        }
        return flag;
    }

    private boolean makeParam(int index) {
        Param currParam = this.allPromptParams.get(index);
        if (!currParam.isFormulaParam()) {
            String[] valueString = new String[1];
            boolean multiValue = currParam.multiValue();
            if (currParam.isMapToColumn() || currParam.getSelectionChoices() != null || currParam.getSqlSelect() != null && currParam.getSqlSelect().trim().length() > 0) {
                if (multiValue) {
                    Object[] valueObj = this.listArray[index].getSelectedValues();
                    valueString = new String[valueObj.length];
                    for (int i = 0; i < valueObj.length; ++i) {
                        valueString[i] = valueObj[i].toString();
                    }
                } else {
                    valueString[0] = this.choiceArray[index].getSelectedIndex() < 0 ? null : (String)this.choiceArray[index].getItemAt(this.choiceArray[index].getSelectedIndex());
                }
            } else {
                if ((currParam.getSqlType() == 91 || currParam.getSqlType() == 92 || currParam.getSqlType() == 93) && this.textArray[index].getText().toLowerCase().indexOf("current") > -1) {
                    return this.makeDateParam(currParam, this.textArray[index].getText());
                }
                currParam.setValueVariable(null);
                valueString[0] = this.textArray[index].getText();
                if (multiValue) {
                    valueString = QbUtil.parseMultiValues(valueString[0]);
                }
            }
            Vector<Object> valueObject = new Vector<Object>();
            try {
                Hashtable table = null;
                if (this.distinctTable != null && currParam.getSqlSelect() != null && currParam.getSqlSelect().trim().length() > 0) {
                    table = (Hashtable)this.distinctTable.get(currParam.getSqlSelect());
                }
                if (table != null) {
                    for (String element : valueString) {
                        valueObject.addElement(table.get(element));
                    }
                } else if (currParam instanceof QueryParam && ((QueryParam)currParam).findParam().isAllOptionEnabled() && ((QueryParam)currParam).findParam().getAllOptionLabel() != null && ((QueryParam)currParam).findParam().getAllOptionLabel().equals(valueString[0])) {
                    QueryInParam qip = ((QueryParam)currParam).findParam();
                    valueObject.addElement(valueString[0]);
                } else {
                    for (String element : valueString) {
                        valueObject.addElement(DataType.createObject(element, DataType.mapType(currParam.getSqlType()), currParam.getDateFormat()));
                    }
                }
            }
            catch (Exception ex) {
                if (multiValue) {
                    currParam.setValues(null);
                } else {
                    currParam.setValue(null);
                }
                return false;
            }
            if (multiValue) {
                if (valueObject.size() == 0) {
                    if (multiValue) {
                        currParam.setValues(null);
                    } else {
                        currParam.setValue(null);
                    }
                    return false;
                }
                if (currParam.getValues() == null || !currParam.getValues().equals(valueObject)) {
                    this.queryParamHasChanged = true;
                    currParam.setValues(valueObject);
                    if (currParam.isMapToColumn() && this.listArray[index] != null) {
                        if (this.listArray[index].getModel().getSize() == valueObject.size()) {
                            currParam.setValue("SELECT_-_ALL_-_MULTIPLE_-_VALUES");
                        } else {
                            currParam.setValue("NOT_-_SELECT_-_ALL_-_MULTIPLE_-_VALUES");
                        }
                    }
                }
            } else if (currParam.getValue() == null || !currParam.getValue().equals(valueObject.elementAt(0))) {
                this.queryParamHasChanged = true;
                currParam.setValue(valueObject.elementAt(0));
            }
            this.report.setSubReportParamValues(currParam);
            return true;
        }
        String valueString = currParam.isMapToColumn() ? (this.choiceArray[index].getSelectedIndex() < 0 ? "" : (String)this.choiceArray[index].getItemAt(this.choiceArray[index].getSelectedIndex())) : this.textArray[index].getText();
        Object value = this.useDefaultValue ? ((FormulaParam)currParam).makeDefaultValueFromText(valueString) : ((FormulaParam)currParam).makeValueFromText(valueString);
        currParam.setValue(value);
        return true;
    }

    private void showError() {
        String paramString = "";
        for (int i = 0; i < this.nParam; ++i) {
            Param currParam = this.allPromptParams.get(i);
            if (currParam.getValue() != null) continue;
            paramString = paramString + "Please enter values for the " + currParam.getPromptName() + " parameter.\nThe datatype should be " + DataType.getTypeName(currParam.getSqlType()) + ".\n ";
        }
        String message = !this.areAllParamOrdersFilled() ? "Not all parameter values have been filled, \nhere are the required data types: \n \n   " + paramString : "Parameter value missing or does not match \nits data type: \n \n" + paramString;
        OurMessageDialog.showError(this, true, message);
    }

    protected final void fireEvent(Component c, int id, String cmd) {
        if (this.listener != null) {
            this.listener.actionPerformed(new ActionEvent(c, id, cmd));
        }
    }

    private Component createComponent(boolean isMultiValue, Vector values, Object[] array, int index, String dateFormat, QueryInParam qip) {
        Vector vals = values;
        if (dateFormat != null) {
            QbDateFormat df = new QbDateFormat(values);
            try {
                vals = df.getFormattedDate(dateFormat, qip.getAllOptionLabel());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (isMultiValue) {
            if (vals == null) {
                vals = new Vector();
            }
            JList list = new JList(vals);
            list.setVisibleRowCount(5);
            list.getSelectionModel().setSelectionMode(2);
            array[index] = list;
            list.getSelectionModel().addListSelectionListener(this);
            JScrollPane scrollPane = new JScrollPane(list);
            if (this.listPane == null) {
                this.listPane = new JScrollPane[array.length];
            }
            this.listPane[index] = scrollPane;
            return scrollPane;
        }
        JComboBox<String> choice = new JComboBox<String>();
        choice.setLightWeightPopupEnabled(false);
        if (qip != null && qip.isAllOptionEnabled()) {
            choice.addItem(qip.getAllOptionLabel());
        }
        if (vals != null) {
            for (int j = 0; j < vals.size(); ++j) {
                if (vals.elementAt(j) == null) continue;
                choice.addItem(vals.elementAt(j).toString());
            }
        }
        array[index] = choice;
        choice.addActionListener(this);
        return choice;
    }

    private boolean makeDateParam(Param currParam, String value) {
        if (currParam.getSqlType() == 91 && value.toLowerCase().indexOf("currentdate") > -1 || currParam.getSqlType() == 92 && value.toLowerCase().indexOf("currenttime") > -1 || currParam.getSqlType() == 93 && value.toLowerCase().indexOf("currentdatetime") > -1) {
            try {
                Formula formula = new Formula(null, value);
                ByteArrayInputStream inputStream = new ByteArrayInputStream(value.getBytes("UTF-8"));
                InputStreamReader inputStreamReader = new InputStreamReader((InputStream)inputStream, "UTF-8");
                DateFormulaParser parser = new DateFormulaParser(inputStreamReader);
                formula.setFormula(parser.parse());
                if (currParam.getValueVariable() == null || !currParam.getValueVariable().equals(formula)) {
                    this.queryParamHasChanged = true;
                }
                currParam.setValueVariable(formula);
                return true;
            }
            catch (Exception ex) {
                ex.printStackTrace();
                return false;
            }
        }
        return false;
    }

    Object[][] getNextParamOrderValues(int order) {
        Parameters params = this.allPromptParams.getParamsAt(order);
        Object[][] paramChoice = new Object[params.size()][];
        for (int i = 0; i < params.size(); ++i) {
            Vector distinctValue;
            block16: {
                Param currParam = params.get(i);
                OrderedParameterSet ops = currParam.getReport().getParametersInSequence(true);
                int reportOrder = 0;
                boolean found = false;
                while (!found && reportOrder < ops.getOrderCount()) {
                    Parameters ps = ops.getParamsAt(reportOrder);
                    for (int j = 0; j < ps.size(); ++j) {
                        if (!ps.get(j).name().equals(currParam.name())) continue;
                        found = true;
                    }
                    if (found) continue;
                    ++reportOrder;
                }
                distinctValue = new Vector();
                if (currParam.isMapToColumn()) {
                    try {
                        if (currParam.getQueryFileInfo() instanceof QueryXMLFileInfo) {
                            distinctValue = QueryParser.getDistinctValues(((QueryXMLFileInfo)currParam.getQueryFileInfo()).getXMLFileQueryInfo(), currParam.getColumnName(), order);
                            break block16;
                        }
                        if (ReportUtil.getParamInSequence(currParam.getQueryFileInfo()) != null) {
                            distinctValue = QueryParser.getDistinctValues((QueryFileInfo)currParam.getQueryFileInfo(), currParam.getTableName(), currParam.getColumnName(), reportOrder);
                            break block16;
                        }
                        distinctValue = QueryParser.getDistinctValues((QueryFileInfo)currParam.getQueryFileInfo(), currParam.getTableName(), currParam.getColumnName());
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                } else if (currParam.getSqlSelect() != null && currParam.getSqlSelect().trim().length() > 0 && !currParam.getSqlSelect().trim().equalsIgnoreCase("null")) {
                    try {
                        Vector result = new Vector();
                        result = QueryParser.executeSQLSelect((IDatabaseInfo)currParam.getQueryFileInfo(), currParam.getSqlSelect(), (Parameters)this.allPromptParams, 0);
                        if (result != null) {
                            distinctValue = (Vector)result.elementAt(0);
                            if (result.size() > 1) {
                                if (this.distinctTable == null) {
                                    this.distinctTable = new Hashtable();
                                }
                                Hashtable table = new Hashtable();
                                for (int j = 0; j < distinctValue.size(); ++j) {
                                    String key = distinctValue.elementAt(j).toString();
                                    Object object = ((Vector)result.elementAt(1)).elementAt(j);
                                    table.put(key, object);
                                }
                                this.distinctTable.put(currParam.getSqlSelect(), table);
                            }
                        }
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                }
            }
            if (distinctValue == null) continue;
            paramChoice[i] = distinctValue.toArray();
        }
        return paramChoice;
    }

    private OurPanel makeSelectionPanel(int paramIndex) {
        OurPanel selectionPanel = new OurPanel(new FlowLayout(2));
        String allStr = ServerMessage.imagesPath + "selectAll.png";
        String noneStr = ServerMessage.imagesPath + "unselectAll.png";
        this.allButton[paramIndex] = new JButton(IOUtil.getImageIcon(allStr));
        selectionPanel.add(this.allButton[paramIndex]);
        this.noneButton[paramIndex] = new JButton(IOUtil.getImageIcon(noneStr));
        selectionPanel.add(this.noneButton[paramIndex]);
        this.allButton[paramIndex].setBorder(BorderFactory.createEmptyBorder());
        this.allButton[paramIndex].setContentAreaFilled(false);
        this.allButton[paramIndex].addActionListener(this);
        this.noneButton[paramIndex].setBorder(BorderFactory.createEmptyBorder());
        this.noneButton[paramIndex].setContentAreaFilled(false);
        this.noneButton[paramIndex].addActionListener(this);
        selectionPanel.add(this.allButton[paramIndex]);
        selectionPanel.add(this.noneButton[paramIndex]);
        return selectionPanel;
    }
}

