/*
 * Decompiled with CFR 0.152.
 */
package quadbase.common.paramquery;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.StringTokenizer;
import java.util.Vector;
import quadbase.common.client.ReadDBparamFunctionMeta;
import quadbase.common.client.ServerMessage;
import quadbase.common.paramquery.QueryInParam;
import quadbase.common.paramquery.QueryParser;
import quadbase.common.util.IDatabaseInfo;
import quadbase.common.util.IJNDIDatabaseInfo;
import quadbase.common.util.internal.DBInfoBasic;
import quadbase.common.util.internal.DataType;

public class MapToFunction {
    public static String getSelectedFunction(String function, Vector availFunctions) {
        if (availFunctions != null) {
            if (function.indexOf(40) == -1) {
                return null;
            }
            String funName = function.substring(0, function.indexOf(40));
            for (int i = 0; i < availFunctions.size(); ++i) {
                for (int j = 0; j < ((Vector)availFunctions.elementAt(i)).size(); ++j) {
                    String tmp;
                    String tmpFull = (String)((Vector)availFunctions.elementAt(i)).elementAt(j);
                    if (tmpFull.indexOf(40) == -1 || !(tmp = tmpFull.substring(0, tmpFull.indexOf(40))).equalsIgnoreCase(funName)) continue;
                    return tmpFull;
                }
            }
        }
        return null;
    }

    public static String getFunctionParam(QueryInParam param, int paramIndex) {
        if (param != null) {
            String funName = param.getColumnName();
            int openParen = funName.indexOf(40);
            int closeParen = funName.lastIndexOf(41);
            if (openParen == -1 || closeParen == -1) {
                return null;
            }
            int numOfParams = 0;
            for (int i = openParen + 1; i < closeParen; ++i) {
                if (funName.charAt(i) == ' ') continue;
                ++numOfParams;
                break;
            }
            if (numOfParams == 0) {
                return null;
            }
            int foundIndex = -1;
            int fromIndex = funName.indexOf(40) + 1;
            Vector<String> paramValue = new Vector<String>();
            do {
                if ((foundIndex = funName.indexOf(",", fromIndex)) < 0) continue;
                ++numOfParams;
                paramValue.add(funName.substring(fromIndex, foundIndex));
                fromIndex = foundIndex + 1;
            } while (foundIndex >= 0);
            if (numOfParams == 1) {
                paramValue.add(funName.substring(openParen + 1, closeParen));
            }
            return (String)paramValue.get(paramIndex);
        }
        return null;
    }

    public static String getFunctionFromQuery(String query, String paramName, Vector functions) throws Exception {
        String functionName = QueryParser.getFunction(query, paramName);
        if (functionName != null && functions != null) {
            return MapToFunction.getSelectedFunction(functionName, functions);
        }
        return null;
    }

    public static Object[] getFunctionParamsFromQuery(String query, String paramName) throws Exception {
        return QueryParser.getFunctionParamsFromQuery(query, paramName);
    }

    public static int getDataType(DBInfoBasic dbInfo, String function, String tableName) throws Exception {
        if (dbInfo.isUseJNDIDataSource()) {
            return MapToFunction.getDataType((IJNDIDatabaseInfo)dbInfo, function, tableName);
        }
        return MapToFunction.getDataType((IDatabaseInfo)dbInfo, function, tableName);
    }

    public static int getDataType(IJNDIDatabaseInfo dbInfo, String function, String tableName) throws Exception {
        if (ServerMessage.useServer) {
            return ReadDBparamFunctionMeta.getMeta(dbInfo, function, tableName);
        }
        return MapToFunction.getFunctionSQLTypeFromLocal(dbInfo, function, tableName);
    }

    public static int getDataType(IDatabaseInfo dbInfo, String function, String tableName) throws Exception {
        if (ServerMessage.useServer) {
            return ReadDBparamFunctionMeta.getMeta(dbInfo, function, tableName);
        }
        return MapToFunction.getFunctionSQLTypeFromLocal(dbInfo, function, tableName);
    }

    public static synchronized int getFunctionSQLTypeFromLocal(DBInfoBasic dbInfo, String function, String tableNames) throws Exception {
        if (dbInfo.isUseJNDIDataSource()) {
            return MapToFunction.getFunctionSQLTypeFromLocal((IJNDIDatabaseInfo)dbInfo, function, tableNames);
        }
        return MapToFunction.getFunctionSQLTypeFromLocal((IDatabaseInfo)dbInfo, function, tableNames);
    }

    public static synchronized int getFunctionSQLTypeFromLocal(IJNDIDatabaseInfo dbInfo, String function, String tableNames) {
        try {
            Connection con = dbInfo.openConnection();
            Object[][] columnInfo = null;
            columnInfo = MapToFunction.getMetaDataForFunction(function, tableNames, con);
            if (columnInfo == null || columnInfo[0][1] == null) {
                return -999;
            }
            return (Integer)columnInfo[0][1];
        }
        catch (Exception ex) {
            return -999;
        }
    }

    public static synchronized int getFunctionSQLTypeFromLocal(IDatabaseInfo dbInfo, String function, String tableNames) {
        try {
            Class.forName(dbInfo.getDriverName());
            Connection con = DriverManager.getConnection(dbInfo.getURLString(), dbInfo.getUserID(), dbInfo.getPassword());
            Object[][] columnInfo = MapToFunction.getMetaDataForFunction(function, tableNames, con);
            if (columnInfo == null || columnInfo[0][1] == null) {
                return -999;
            }
            return (Integer)columnInfo[0][1];
        }
        catch (Exception ex) {
            return -999;
        }
    }

    private static Object[][] getMetaDataForFunction(String function, String tableNames, Connection conn) throws Exception {
        Statement stmt = null;
        ResultSet rs = null;
        PreparedStatement ps = null;
        String tail = "";
        try {
            if (tableNames != null && !tableNames.equals("")) {
                tail = " FROM " + tableNames + " WHERE 1=2";
            }
            String query = "SELECT " + function + tail;
            try {
                if (conn.getMetaData().getDatabaseProductName().toLowerCase().indexOf("mysql") >= 0) {
                    query = "SELECT " + function + tail;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            ResultSetMetaData rsmd = null;
            try {
                ps = conn.prepareStatement(query);
                rsmd = ps.getMetaData();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            if (rsmd == null) {
                stmt = conn.createStatement();
                rs = stmt.executeQuery(query);
                rsmd = rs.getMetaData();
            }
            int nColumn = rsmd.getColumnCount();
            Object[][] tempResult = new Object[nColumn][];
            for (int j = 1; j <= nColumn; ++j) {
                Object[] row = new Object[2];
                int sqlType = rsmd.getColumnType(j);
                if (!rsmd.isSigned(j)) {
                    sqlType = DataType.convertUnsigned(sqlType);
                }
                row[1] = sqlType;
                row[0] = rsmd.getColumnName(j);
                tempResult[j - 1] = row;
            }
            if (ps != null) {
                ps.close();
            }
            if (rs != null) {
                rs.close();
            }
            if (stmt != null) {
                stmt.close();
            }
            Object[][] objectArray = tempResult;
            return objectArray;
        }
        catch (SQLException query) {
        }
        catch (OutOfMemoryError query) {
        }
        catch (Exception ex1) {
            throw ex1;
        }
        catch (Error err1) {
            throw err1;
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (Exception exception) {}
        }
        return null;
    }

    public static String getFullFunction(String function, String[] functionParams) {
        if (function.indexOf(40) < 1) {
            return null;
        }
        StringBuffer functionBuffer = new StringBuffer();
        functionBuffer.append(function.substring(0, function.indexOf(40)));
        functionBuffer.append("(");
        for (int i = 0; i < functionParams.length; ++i) {
            if (functionParams[i].startsWith("Enter Parameter")) {
                return null;
            }
            functionBuffer.append(functionParams[i]);
            if (i == functionParams.length - 1) continue;
            functionBuffer.append(", ");
        }
        functionBuffer.append(")");
        return functionBuffer.toString();
    }

    public static String getFunctionTableNames(String fullFunction) {
        int i;
        StringTokenizer st = new StringTokenizer(fullFunction, ",()");
        Vector<String> tableNamesVec = new Vector<String>();
        StringBuffer tableNames = new StringBuffer();
        while (st.hasMoreTokens()) {
            int dotIndex;
            String tmp = st.nextToken();
            if (tmp.trim().length() <= 0 || (dotIndex = tmp.lastIndexOf(46)) <= -1) continue;
            String tmp2 = tmp.substring(0, dotIndex);
            int spaceIndex = tmp2.lastIndexOf(32);
            boolean match = false;
            for (i = 0; i < tableNamesVec.size(); ++i) {
                if (!((String)tableNamesVec.get(i)).equalsIgnoreCase(tmp.substring(spaceIndex + 1, dotIndex))) continue;
                match = true;
            }
            if (match) continue;
            tableNamesVec.add(tmp.substring(spaceIndex + 1, dotIndex));
        }
        for (i = 0; i < tableNamesVec.size(); ++i) {
            tableNames.append(tableNamesVec.get(i)).append(", ");
        }
        if (tableNames.length() >= 2) {
            tableNames.delete(tableNames.length() - 2, tableNames.length());
        }
        return tableNames.toString();
    }
}

