/*
 * Decompiled with CFR 0.152.
 */
package quadbase.common.paramquery;

import java.awt.Dialog;
import java.awt.Frame;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.sql.Date;
import java.util.Vector;
import javax.swing.JDialog;
import quadbase.common.client.ServerMessage;
import quadbase.common.paramquery.EnterInParamDialog;
import quadbase.common.paramquery.IEnterInParamDialog;
import quadbase.common.paramquery.QueryInParam;
import quadbase.common.paramquery.QueryInParamSet;
import quadbase.common.paramquery.QueryMultiValueInParam;
import quadbase.common.paramquery.QueryParser;
import quadbase.common.util.ICustomParameterDateFormat;
import quadbase.common.util.IQueryFileInfo;
import quadbase.common.util.IQueryInParam;
import quadbase.common.util.IQueryMultiValueInParam;
import quadbase.common.util.IQueryParamValuesProvider;
import quadbase.common.util.internal.Coder;
import quadbase.common.util.internal.DBInfoBasic;
import quadbase.common.util.internal.DataType;
import quadbase.common.util.internal.IOUtil;
import quadbase.common.util.internal.ReadDataFile;
import quadbase.common.util.internal.WriteDataFile;
import quadbase.reportdesigner.util.SimpleQueryInParam;
import quadbase.reportdesigner.util.internal.ReportUtil;
import quadbase.util.IQbQueryFileInfo;
import quadbase.util.SimpleQueryFileInfo;
import quadbase.util.SimpleQueryMultiValueInParam;
import quadbase.util.internal.QbUtil;

public class QueryFileInfo
extends DBInfoBasic
implements IQueryFileInfo {
    public static final String ESPRESSREPORT = "EspressReport";
    public static final String ESPRESSCHART = "EspressChart";
    String productName;
    int version;
    QueryInParamSet inSet;
    private static Frame parentFrame = null;
    private static JDialog parentDialog = null;

    public QueryFileInfo(String productName, int version, DBInfoBasic dbInfo, QueryInParamSet inSet) {
        super(dbInfo);
        this.productName = productName;
        this.version = version;
        this.inSet = inSet;
    }

    public QueryFileInfo(IQueryFileInfo info) {
        this(info, true);
    }

    public QueryFileInfo(IQueryFileInfo info, boolean verify) throws IllegalArgumentException {
        super(info);
        IQueryInParam[] inParam = null;
        if (info instanceof QueryFileInfo) {
            inParam = ((QueryFileInfo)info).getInParam();
        } else if (info instanceof quadbase.util.IQueryFileInfo) {
            inParam = ((quadbase.util.IQueryFileInfo)info).getInParam();
        } else if (info instanceof quadbase.reportdesigner.util.IQueryFileInfo) {
            inParam = ((quadbase.reportdesigner.util.IQueryFileInfo)info).getInParam();
        }
        this.inSet = null;
        if (inParam != null) {
            int nInParam;
            int[][] inParamMap = QueryInParamSet.makeParamMap(this.query);
            if (inParamMap.length < (nInParam = inParam.length)) {
                nInParam = inParamMap.length;
            }
            QueryInParam[] tempIn = new QueryInParam[nInParam];
            for (int i = 0; i < nInParam; ++i) {
                IQueryInParam tmpCurrIn;
                IQueryInParam currIn = inParam[i];
                if (currIn instanceof IQueryMultiValueInParam) {
                    IQueryMultiValueInParam sqmvipCurrIn;
                    tempIn[i] = new QueryMultiValueInParam(inParamMap[i], currIn.getParamName(), currIn.getPromptName(), currIn.isMapToColumn(), currIn.getTableName(), currIn.getColumnName(), currIn.getSqlType(), currIn.getDefaultValue(), currIn.getDefaultSql(), currIn.getValue(), ((IQueryMultiValueInParam)currIn).getValues());
                    tmpCurrIn = currIn;
                    if (currIn instanceof ReportUtil.CQueryMultiValueInParam) {
                        tmpCurrIn = ((ReportUtil.CQueryMultiValueInParam)currIn).getQueryInParam();
                    } else if (currIn instanceof QbUtil.CQueryMultiValueInParam) {
                        tmpCurrIn = ((QbUtil.CQueryMultiValueInParam)currIn).getQueryInParam();
                    }
                    if (tmpCurrIn instanceof QueryMultiValueInParam) {
                        QueryMultiValueInParam qmvipCurrIn = (QueryMultiValueInParam)tmpCurrIn;
                        tempIn[i].setMapToFunction(qmvipCurrIn.isMapToFunctionOnly());
                        tempIn[i].setMapToColumn(qmvipCurrIn.isMapToColumnOnly());
                        tempIn[i].setDefaultValueVariable(qmvipCurrIn.getDefaultValueVariable());
                        tempIn[i].setValueVariable(qmvipCurrIn.getValueVariable());
                        tempIn[i].setSqlSelect(qmvipCurrIn.getSqlSelect());
                        tempIn[i].setDefaultSql(qmvipCurrIn.getDefaultSql());
                        tempIn[i].setAllOptionEnabled(qmvipCurrIn.isAllOptionEnabled());
                        tempIn[i].setAllOptionLabel(qmvipCurrIn.getAllOptionLabel());
                    }
                    if (tmpCurrIn instanceof SimpleQueryMultiValueInParam) {
                        sqmvipCurrIn = (SimpleQueryMultiValueInParam)tmpCurrIn;
                        tempIn[i].setMapToFunction(((quadbase.util.SimpleQueryInParam)((Object)sqmvipCurrIn)).isMapToFunctionOnly());
                        tempIn[i].setMapToColumn(((quadbase.util.SimpleQueryInParam)((Object)sqmvipCurrIn)).isMapToColumnOnly());
                        tempIn[i].setDefaultValueVariable(((quadbase.util.SimpleQueryInParam)((Object)sqmvipCurrIn)).getDefaultValueVariable());
                        tempIn[i].setValueVariable(((quadbase.util.SimpleQueryInParam)((Object)sqmvipCurrIn)).getValueVariable());
                        tempIn[i].setSqlSelect(((quadbase.util.SimpleQueryInParam)((Object)sqmvipCurrIn)).getSqlSelect());
                        tempIn[i].setDefaultSql(((quadbase.util.SimpleQueryInParam)((Object)sqmvipCurrIn)).getDefaultSql());
                        tempIn[i].setAllOptionEnabled(((quadbase.util.SimpleQueryInParam)((Object)sqmvipCurrIn)).isAllOptionEnabled());
                        tempIn[i].setAllOptionLabel(((quadbase.util.SimpleQueryInParam)((Object)sqmvipCurrIn)).getAllOptionLabel());
                    } else if (tmpCurrIn instanceof quadbase.reportdesigner.util.SimpleQueryMultiValueInParam) {
                        sqmvipCurrIn = (quadbase.reportdesigner.util.SimpleQueryMultiValueInParam)tmpCurrIn;
                        tempIn[i].setMapToFunction(((SimpleQueryInParam)((Object)sqmvipCurrIn)).isMapToFunctionOnly());
                        tempIn[i].setMapToColumn(((SimpleQueryInParam)((Object)sqmvipCurrIn)).isMapToColumnOnly());
                        tempIn[i].setDefaultValueVariable(((SimpleQueryInParam)((Object)sqmvipCurrIn)).getDefaultValueVariable());
                        tempIn[i].setValueVariable(((SimpleQueryInParam)((Object)sqmvipCurrIn)).getValueVariable());
                        tempIn[i].setSqlSelect(((SimpleQueryInParam)((Object)sqmvipCurrIn)).getSqlSelect());
                        tempIn[i].setDefaultSql(((SimpleQueryInParam)((Object)sqmvipCurrIn)).getDefaultSql());
                        tempIn[i].setAllOptionEnabled(((SimpleQueryInParam)((Object)sqmvipCurrIn)).isAllOptionEnabled());
                        tempIn[i].setAllOptionLabel(((SimpleQueryInParam)((Object)sqmvipCurrIn)).getAllOptionLabel());
                    }
                } else {
                    IQueryInParam sqipCurrIn;
                    QueryInParam qipCurrIn;
                    tempIn[i] = new QueryInParam(inParamMap[i], currIn.getParamName(), currIn.getPromptName(), currIn.isMapToColumn(), currIn.getTableName(), currIn.getColumnName(), currIn.getSqlType(), currIn.getDefaultValue(), currIn.getValue());
                    tmpCurrIn = currIn;
                    if (currIn instanceof ReportUtil.CQueryInParam) {
                        tmpCurrIn = ((ReportUtil.CQueryInParam)currIn).getQueryInParam();
                    } else if (currIn instanceof QbUtil.CQueryInParam) {
                        tmpCurrIn = ((QbUtil.CQueryInParam)currIn).getQueryInParam();
                    }
                    if (tmpCurrIn instanceof QueryInParam) {
                        qipCurrIn = (QueryInParam)tmpCurrIn;
                        tempIn[i].setMapToFunction(qipCurrIn.isMapToFunctionOnly());
                        tempIn[i].setMapToColumn(qipCurrIn.isMapToColumnOnly());
                        tempIn[i].setDefaultValueVariable(qipCurrIn.getDefaultValueVariable());
                        tempIn[i].setValueVariable(qipCurrIn.getValueVariable());
                        tempIn[i].setSqlSelect(qipCurrIn.getSqlSelect());
                        tempIn[i].setDefaultSql(qipCurrIn.getDefaultSql());
                        tempIn[i].setAllOptionEnabled(qipCurrIn.isAllOptionEnabled());
                        tempIn[i].setAllOptionLabel(qipCurrIn.getAllOptionLabel());
                    }
                    if (tmpCurrIn instanceof quadbase.util.SimpleQueryInParam) {
                        sqipCurrIn = (quadbase.util.SimpleQueryInParam)tmpCurrIn;
                        tempIn[i].setMapToFunction(((quadbase.util.SimpleQueryInParam)sqipCurrIn).isMapToFunctionOnly());
                        tempIn[i].setMapToColumn(((quadbase.util.SimpleQueryInParam)sqipCurrIn).isMapToColumnOnly());
                        tempIn[i].setDefaultValueVariable(((quadbase.util.SimpleQueryInParam)sqipCurrIn).getDefaultValueVariable());
                        tempIn[i].setValueVariable(((quadbase.util.SimpleQueryInParam)sqipCurrIn).getValueVariable());
                        tempIn[i].setSqlSelect(((quadbase.util.SimpleQueryInParam)sqipCurrIn).getSqlSelect());
                        tempIn[i].setDefaultSql(((quadbase.util.SimpleQueryInParam)sqipCurrIn).getDefaultSql());
                        tempIn[i].setAllOptionEnabled(((quadbase.util.SimpleQueryInParam)sqipCurrIn).isAllOptionEnabled());
                        tempIn[i].setAllOptionLabel(((quadbase.util.SimpleQueryInParam)sqipCurrIn).getAllOptionLabel());
                    } else if (tmpCurrIn instanceof SimpleQueryInParam) {
                        sqipCurrIn = (SimpleQueryInParam)tmpCurrIn;
                        tempIn[i].setMapToFunction(((SimpleQueryInParam)sqipCurrIn).isMapToFunctionOnly());
                        tempIn[i].setMapToColumn(((SimpleQueryInParam)sqipCurrIn).isMapToColumnOnly());
                        tempIn[i].setDefaultValueVariable(((SimpleQueryInParam)sqipCurrIn).getDefaultValueVariable());
                        tempIn[i].setValueVariable(((SimpleQueryInParam)sqipCurrIn).getValueVariable());
                        tempIn[i].setSqlSelect(((SimpleQueryInParam)sqipCurrIn).getSqlSelect());
                        tempIn[i].setDefaultSql(((SimpleQueryInParam)sqipCurrIn).getDefaultSql());
                        tempIn[i].setAllOptionEnabled(((SimpleQueryInParam)sqipCurrIn).isAllOptionEnabled());
                        tempIn[i].setAllOptionLabel(((SimpleQueryInParam)sqipCurrIn).getAllOptionLabel());
                    } else if (tmpCurrIn instanceof quadbase.datasource.util.QueryInParam) {
                        qipCurrIn = (quadbase.datasource.util.QueryInParam)tmpCurrIn;
                        tempIn[i].setMapToFunction(qipCurrIn.isMapToFunctionOnly());
                        tempIn[i].setMapToColumn(qipCurrIn.isMapToColumnOnly());
                        tempIn[i].setDefaultValueVariable(qipCurrIn.getDefaultValueVariable());
                        tempIn[i].setValueVariable(qipCurrIn.getValueVariable());
                        tempIn[i].setSqlSelect(qipCurrIn.getSqlSelect());
                        tempIn[i].setDefaultSql(qipCurrIn.getDefaultSql());
                        tempIn[i].setAllOptionEnabled(qipCurrIn.isAllOptionEnabled());
                        tempIn[i].setAllOptionLabel(qipCurrIn.getAllOptionLabel());
                    }
                }
                if (currIn instanceof ICustomParameterDateFormat) {
                    tempIn[i].setDateFormat(((ICustomParameterDateFormat)((Object)currIn)).getDateFormat());
                }
                if (!(currIn instanceof IQueryParamValuesProvider)) continue;
                tempIn[i].setSelectionChoices(((IQueryParamValuesProvider)((Object)currIn)).getSelectionChoices());
            }
            this.inSet = new QueryInParamSet(tempIn);
            IQueryInParam[][] paramInSequence = null;
            if (!(info instanceof SimpleQueryFileInfo)) {
                if (info instanceof QueryFileInfo) {
                    paramInSequence = ((QueryFileInfo)info).getParameterInPromptSequence();
                } else if (info instanceof IQbQueryFileInfo) {
                    paramInSequence = ((IQbQueryFileInfo)info).getParameterInPromptSequence();
                } else if (info instanceof quadbase.reportdesigner.util.IQbQueryFileInfo) {
                    paramInSequence = ((quadbase.reportdesigner.util.IQbQueryFileInfo)info).getParameterInPromptSequence();
                } else if (info instanceof ReportUtil.CQueryFileInfo) {
                    ReportUtil.CQueryFileInfo cInfo = (ReportUtil.CQueryFileInfo)info;
                    paramInSequence = cInfo.getParamInSequence();
                }
            }
            if (paramInSequence != null && paramInSequence.length > 0) {
                QueryInParam[][] newParamInSequence = new QueryInParam[nInParam][nInParam];
                for (int i = 0; i < nInParam; ++i) {
                    for (int j = 0; j < paramInSequence[i].length; ++j) {
                        if (paramInSequence[i][j] == null) continue;
                        newParamInSequence[i][j] = this.inSet.getParameter(paramInSequence[i][j].getParamName());
                    }
                }
                this.inSet.setParameterInPromptSequence(newParamInSequence);
            }
        }
        if (verify) {
            QueryFileInfo.verify(this);
        }
    }

    public static void verify(IQueryFileInfo info) throws IllegalArgumentException {
        QueryFileInfo queryFileInfo = new QueryFileInfo(info);
        QueryFileInfo.verify(queryFileInfo);
    }

    public static void verify(QueryFileInfo info) throws IllegalArgumentException {
        String query = info.getQuery();
        String[] completeList = QueryParser.getCompleteParam(query);
        int nComplete = 0;
        if (completeList != null) {
            nComplete = completeList.length;
        }
        String[] uniqueList = QueryParser.getAllParameters(query);
        int nUnique = 0;
        if (uniqueList != null) {
            nUnique = uniqueList.length;
        }
        int[][] map = QueryInParamSet.makeParamMap(query);
        int matchCount = 0;
        for (int i = 0; i < nUnique; ++i) {
            matchCount += map[i].length;
        }
        if (matchCount != nComplete) {
            throw new IllegalArgumentException("Parameter names do not match the query");
        }
        IQueryInParam[] inParam = info.getInParam();
        int nInParam = inParam.length;
        String tableName = null;
        String columnName = null;
        try {
            for (int i = 0; i < nInParam; ++i) {
                IQueryInParam currParam = inParam[i];
                if (!currParam.isMapToColumn()) continue;
                tableName = currParam.getTableName();
                columnName = currParam.getColumnName();
                QueryParser.getDistinctValues(info, tableName, columnName);
            }
        }
        catch (Exception ex) {
            throw new IllegalArgumentException("Input Parameter: currParam.getParamName()\n\tInvalid table name: " + tableName + "and/or column name: " + columnName + "\tPlease check database information");
        }
    }

    public static Vector<QueryInParamSet> getDBAccessParameter(QueryFileInfo info) throws Exception {
        QueryFileInfo.verify(info);
        return QueryFileInfo.getParameter(info, false, false, true);
    }

    public static Vector<QueryInParamSet> getDBAccessParameter(QueryFileInfo info, boolean isEntpServer) throws Exception {
        QueryFileInfo.verify(info);
        return QueryFileInfo.getParameter(info, false, isEntpServer, true);
    }

    public void write(DataOutputStream dout) throws IOException {
        IOUtil.writeString(dout, Coder.encode(ServerMessage.getProductName()));
        dout.writeInt(ServerMessage.getVersion());
        super.write(dout);
        boolean hasInSet = this.inSet != null;
        dout.writeBoolean(hasInSet);
        if (hasInSet) {
            this.inSet.write(dout);
        }
    }

    private static QueryFileInfo read(DataInputStream din) throws IOException {
        DBInfoBasic dbInfo;
        int version;
        String temp = IOUtil.readString(din, true);
        String productName = Coder.decode(temp, version = din.readInt());
        if (productName.equals(ESPRESSREPORT) || version > 91) {
            dbInfo = DBInfoBasic.read(din, version);
        } else {
            String driver = Coder.decode(IOUtil.readString(din, true), version);
            String url = Coder.decode(IOUtil.readString(din, true), version);
            String username = Coder.decode(IOUtil.readString(din, true), version);
            String password = Coder.decode(IOUtil.readString(din, true), version);
            String query = Coder.decode(IOUtil.readString(din, true), version);
            dbInfo = new DBInfoBasic(url, driver, username, password, query);
        }
        boolean hasInSet = din.readBoolean();
        QueryInParamSet inSet = null;
        if (hasInSet) {
            inSet = QueryInParamSet.read(din, version);
        }
        return new QueryFileInfo(productName, version, dbInfo, inSet);
    }

    public static Vector<QueryInParamSet> getParameter(String query, String queryFilename) throws IOException {
        return QueryFileInfo.getParameter(query, queryFilename, false);
    }

    public static Vector<QueryInParamSet> getParameter(String query, String queryFilename, boolean showCancelButton) throws IOException {
        if (query == null) {
            return null;
        }
        Vector<QueryInParamSet> DBAccessParameter = null;
        if (QueryParser.hasParameters(query)) {
            QueryFileInfo queryFileInfo = QueryFileInfo.readFile(queryFilename);
            DBAccessParameter = QueryFileInfo.getParameter(queryFileInfo, showCancelButton);
        }
        return DBAccessParameter;
    }

    public static Vector<QueryInParamSet> getParameter(QueryFileInfo queryFileInfo) {
        return QueryFileInfo.getParameter(queryFileInfo, false);
    }

    public static Vector<QueryInParamSet> getParameter(QueryFileInfo queryFileInfo, boolean showCancelButton) {
        return QueryFileInfo.getParameter(queryFileInfo, showCancelButton, false);
    }

    public static Vector<QueryInParamSet> getParameter(QueryFileInfo queryFileInfo, boolean showCancelButton, boolean isEntpServer) {
        return QueryFileInfo.getParameter(queryFileInfo, showCancelButton, isEntpServer, false);
    }

    public static Vector<QueryInParamSet> getParameter(QueryFileInfo queryFileInfo, boolean showCancelButton, boolean isEntpServer, boolean fromAPI) {
        return QueryFileInfo.getParameter(queryFileInfo, showCancelButton, isEntpServer, fromAPI, false);
    }

    public static Vector<QueryInParamSet> getParameter(QueryFileInfo queryFileInfo, boolean showCancelButton, boolean isEntpServer, boolean fromAPI, boolean useBackupData) {
        return QueryFileInfo.getParameter(queryFileInfo, showCancelButton, isEntpServer, fromAPI, useBackupData, false);
    }

    public static Vector<QueryInParamSet> getParameter(QueryFileInfo queryFileInfo, boolean showCancelButton, boolean isEntpServer, boolean fromAPI, boolean useBackupData, boolean changeValue) {
        boolean hasNull = false;
        QueryInParamSet inSet = queryFileInfo.getInSet();
        QueryInParam[] inParam = inSet.getParameter();
        for (int i = 0; i < inParam.length; ++i) {
            if (!changeValue && inParam[i].getValue() != null && !inParam[i].getValue().equals("")) continue;
            if (useBackupData) {
                if (inParam[i].getDefaultValue() != null) {
                    inParam[i].setValue(inParam[i].getDefaultValue());
                    continue;
                }
                inParam[i].setValue(QueryFileInfo.getEmptyValue(inParam[i].getSqlType()));
                continue;
            }
            if (!isEntpServer) {
                if (!fromAPI) {
                    inParam[i].setValue(inParam[i].getDefaultValue(queryFileInfo));
                    continue;
                }
                hasNull = true;
                break;
            }
            if (inParam[i].getDefaultValue(queryFileInfo) != null && !inParam[i].getDefaultValue(queryFileInfo).toString().trim().equals("")) {
                inParam[i].setValue(inParam[i].getDefaultValue(queryFileInfo));
                continue;
            }
            Object val = QueryParser.getFirstValue(queryFileInfo, inParam[i].getTableName(), inParam[i].getColumnName());
            if (val != null) {
                inParam[i].setValue(val);
                continue;
            }
            inParam[i].setValue(QueryFileInfo.getEmptyValue(inParam[i].getSqlType()));
        }
        if (hasNull) {
            try {
                IEnterInParamDialog enterDialog = QueryFileInfo.newEnterInParamDialog(queryFileInfo, showCancelButton);
                enterDialog.show();
                while (!showCancelButton) {
                    if (enterDialog.isCancelled()) {
                        return queryFileInfo.makeVector();
                    }
                    if (!enterDialog.isCancelled()) break;
                    enterDialog = QueryFileInfo.newEnterInParamDialog(queryFileInfo, showCancelButton);
                    enterDialog.show();
                    if (!showCancelButton) continue;
                }
                if (!enterDialog.isCancelled()) {
                    inSet.setParameter(enterDialog.getInParamValue());
                    return queryFileInfo.makeVector();
                }
                return null;
            }
            catch (Exception ex) {
                return queryFileInfo.makeVector();
            }
        }
        return queryFileInfo.makeVector();
    }

    public void saveFile(String filename) throws Exception {
        String saveName = filename.trim();
        if (!saveName.endsWith(".qry")) {
            saveName = saveName + ".qry";
        }
        ByteArrayOutputStream fstream = new ByteArrayOutputStream(2048);
        DataOutputStream dout = new DataOutputStream(fstream);
        this.write(dout);
        WriteDataFile wdfile = new WriteDataFile();
        wdfile.output(fstream.toByteArray(), saveName);
        dout.close();
        fstream.close();
    }

    public static QueryFileInfo readFile(String filename) throws IOException {
        QueryFileInfo queryFileInfo = null;
        try {
            ReadDataFile readfile;
            DataInputStream din;
            if (filename == null) {
                throw new IOException("Query file name cannot be null");
            }
            String file = filename.trim();
            if (file.equals("")) {
                throw new IOException("Query file name cannot be empty");
            }
            if (!file.endsWith(".qry")) {
                file = file + ".qry";
            }
            if ((din = (readfile = new ReadDataFile()).getInputStream(file)).available() < 0) {
                readfile.close();
                throw new IOException("Input stream of query file is not available");
            }
            queryFileInfo = QueryFileInfo.read(din);
            readfile.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw new IOException("Cannot read query file " + filename);
        }
        return queryFileInfo;
    }

    public Vector<QueryInParamSet> makeVector() {
        Vector<QueryInParamSet> output = new Vector<QueryInParamSet>();
        if (this.inSet != null) {
            output.addElement(this.inSet);
        }
        return output;
    }

    public void setParameter(Vector parameter) {
        if (parameter == null) {
            return;
        }
        for (int i = 0; i < parameter.size(); ++i) {
            Object target = parameter.elementAt(i);
            if (!(target instanceof QueryInParamSet)) continue;
            this.inSet = (QueryInParamSet)target;
        }
    }

    public void setProductName(String productName) {
        this.productName = productName;
    }

    public String getProductName() {
        return this.productName;
    }

    public void setVersion(int version) {
        this.version = version;
    }

    public int getVersion() {
        return this.version;
    }

    public QueryInParamSet getInSet() {
        return this.inSet;
    }

    public IQueryInParam[] getInParam() {
        if (this.inSet == null) {
            return null;
        }
        return this.inSet.getParameter();
    }

    public void setInSet(QueryInParamSet inSet) {
        this.inSet = inSet;
    }

    public IQueryInParam[][] getParameterInPromptSequence() {
        if (this.inSet == null) {
            return null;
        }
        return this.inSet.getParameterInPromptSequence();
    }

    public static boolean hasParameter(Vector target) {
        if (target == null) {
            return false;
        }
        int size = target.size();
        for (int i = 0; i < size; ++i) {
            if (!(target.elementAt(i) instanceof QueryInParamSet)) continue;
            return true;
        }
        return false;
    }

    @Override
    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("<< QueryFileInfo >>\n");
        sb.append(super.toString());
        sb.append(this.inSet.toString());
        return sb.toString();
    }

    public static void setParentFrame(Frame frame) {
        parentFrame = frame;
        parentDialog = null;
    }

    public static void setParentDialog(JDialog dialog) {
        parentDialog = dialog;
        parentFrame = null;
    }

    public static Frame getParentFrame() {
        return parentFrame;
    }

    public static JDialog getParentDialog() {
        return parentDialog;
    }

    public static IEnterInParamDialog newEnterInParamDialog(Frame parent, QueryFileInfo fileInfo, boolean showCancelButton) throws Exception {
        return new EnterInParamDialog(parent, fileInfo, showCancelButton);
    }

    public static IEnterInParamDialog newEnterInParamDialog(Dialog parent, QueryFileInfo fileInfo, boolean showCancelButton) throws Exception {
        return new EnterInParamDialog(parent, fileInfo, showCancelButton);
    }

    public static IEnterInParamDialog newEnterInParamDialog(QueryFileInfo fileInfo, boolean showCancelButton) throws Exception {
        if (parentDialog != null) {
            return QueryFileInfo.newEnterInParamDialog(parentDialog, fileInfo, showCancelButton);
        }
        return QueryFileInfo.newEnterInParamDialog(parentFrame, fileInfo, showCancelButton);
    }

    public static boolean containsNullValue(QueryInParamSet inSet) {
        boolean hasNull = false;
        QueryInParam[] parameter = inSet.getParameter();
        if (parameter != null && parameter.length > 0) {
            for (int i = 0; !hasNull && i < parameter.length; ++i) {
                hasNull = parameter[i].getDefaultValue() == null && parameter[i].getValue().toString().equals("");
            }
        }
        return hasNull;
    }

    public int getMaxParameterOrder() {
        QueryInParam[][] paramInSequence = this.inSet.getParameterInPromptSequence();
        if (paramInSequence != null) {
            for (int i = paramInSequence.length - 1; i >= 0; --i) {
                for (int j = 0; j < paramInSequence[i].length; ++j) {
                    if (paramInSequence[i][j] == null) continue;
                    return i;
                }
            }
        }
        return 0;
    }

    public static Object getEmptyValue(int type) {
        if ((type = DataType.mapType(type)) == 13) {
            return 0L;
        }
        if (type == 0) {
            return Boolean.FALSE;
        }
        if (type == 11) {
            byte b = 0;
            return b;
        }
        if (type == 12) {
            short s = 0;
            return s;
        }
        if (type == 2) {
            return 0;
        }
        if (type == 1) {
            return 0L;
        }
        if (type == 3) {
            return Float.valueOf(0.0f);
        }
        if (type == 4) {
            return 0.0;
        }
        if (type == 8 || type == 9 || type == 10) {
            return new Date(0L);
        }
        return "";
    }
}

