/*
 * Decompiled with CFR 0.152.
 */
package quadbase.common.paramquery;

import java.io.IOException;
import java.io.Serializable;
import java.io.Writer;
import java.util.Iterator;
import java.util.Vector;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import quadbase.common.paramquery.SOAPParamEnumeration;
import quadbase.common.util.IQueryInParam;
import quadbase.common.util.internal.DataType;
import quadbase.common.util.internal.FixedVersionDataOutput;
import quadbase.common.util.internal.IOUtil;
import quadbase.common.util.internal.VersioningDataInput;
import quadbase.common.util.internal.XMLUtil;

public class SOAPParam
implements IQueryInParam,
Serializable {
    public static final String XMLTAG = "SOAPParam";
    protected Object defaultValue;
    protected Object value;
    protected String paramName;
    protected String paramPrompt;
    protected int sqlType;
    protected boolean alwaysUseDefault;

    public SOAPParam(String paramName, int sqlType) {
        this.paramName = paramName;
        this.sqlType = sqlType;
        this.paramPrompt = paramName;
        this.value = null;
        this.defaultValue = null;
        this.alwaysUseDefault = false;
    }

    public SOAPParam(String paramName, int sqlType, String paramPrompt, Object defaultValue, Object value, boolean alwaysUseDefault) {
        this.defaultValue = defaultValue;
        this.value = value;
        this.paramName = paramName;
        this.paramPrompt = paramPrompt;
        this.sqlType = sqlType;
        this.alwaysUseDefault = alwaysUseDefault;
    }

    public boolean isAlwaysUseDefault() {
        return this.alwaysUseDefault;
    }

    public void setAlwaysUseDefault(boolean alwaysUseDefault) {
        this.alwaysUseDefault = alwaysUseDefault;
    }

    @Override
    public String getColumnName() {
        return null;
    }

    @Override
    public Object getDefaultValue() {
        return this.defaultValue;
    }

    @Override
    public String getParamName() {
        return this.paramName;
    }

    @Override
    public String getPromptName() {
        return this.paramPrompt;
    }

    @Override
    public int getSqlType() {
        return this.sqlType;
    }

    @Override
    public String getTableName() {
        return null;
    }

    @Override
    public Object getValue() {
        if (this.alwaysUseDefault) {
            return this.defaultValue;
        }
        return this.value;
    }

    @Override
    public boolean isMapToColumn() {
        return false;
    }

    @Override
    public void setColumnName(String columnName) {
        throw new UnsupportedOperationException("method not supported");
    }

    @Override
    public void setDefaultValue(Object defaultValue) {
        this.defaultValue = defaultValue;
    }

    @Override
    public void setMapToColumn(boolean mapToColumn) {
        throw new UnsupportedOperationException("method not supported");
    }

    @Override
    public void setPromptName(String promptName) {
        this.paramPrompt = promptName;
    }

    @Override
    public void setSqlType(int sqlType) {
        this.sqlType = sqlType;
    }

    @Override
    public void setTableName(String tableName) {
        throw new UnsupportedOperationException("method not supported");
    }

    @Override
    public void setValue(Object value) {
        this.value = value;
    }

    @Override
    public String getDefaultSql() {
        return null;
    }

    @Override
    public void setDefaultSql(String defaultSql) {
    }

    private void write(FixedVersionDataOutput vout) throws IOException {
        IOUtil.writeStr(vout, this.paramName);
        vout.writeInt(this.sqlType);
        IOUtil.writeStr(vout, this.paramPrompt);
        DataType.write(vout, this.defaultValue);
        DataType.write(vout, this.value);
        vout.writeBoolean(this.alwaysUseDefault);
        Vector choices = null;
        if (this instanceof SOAPParamEnumeration) {
            choices = ((SOAPParamEnumeration)this).getSelectionChoices();
        }
        if (choices == null) {
            vout.writeInt(0);
        } else {
            vout.writeInt(choices.size());
            Iterator iterator = choices.iterator();
            while (iterator.hasNext()) {
                IOUtil.writeStr(vout, (String)iterator.next());
            }
        }
    }

    private static SOAPParam read(VersioningDataInput din) throws IOException {
        String name = IOUtil.readStr(din);
        int type = din.readInt();
        String prompt = IOUtil.readStr(din);
        Object defaultVal = DataType.read(din, type, 6602, true);
        Object val = DataType.read(din, type, 6602, true);
        boolean useDefault = din.readBoolean();
        int choicesCount = din.readInt();
        if (choicesCount == 0) {
            return new SOAPParam(name, type, prompt, defaultVal, val, useDefault);
        }
        Vector<String> choices = new Vector<String>(choicesCount);
        for (int i = 0; i < choicesCount; ++i) {
            choices.add(IOUtil.readStr(din));
        }
        return new SOAPParamEnumeration(name, type, prompt, defaultVal, val, useDefault, choices);
    }

    public static void writeArrayXML(Writer out, SOAPParam[] parameters) throws IOException {
        if (parameters == null || parameters.length == 0) {
            return;
        }
        for (SOAPParam parameter : parameters) {
            Vector choices;
            out.write("<SOAPParam name = \"" + parameter.paramName + "\" sqlType = \"" + parameter.sqlType + "\" prompt = \"" + parameter.paramPrompt + "\" alwaysUseDefault = \"" + parameter.alwaysUseDefault + "\" defaultValue = \"" + DataType.write(parameter.defaultValue) + "\" value = \"" + DataType.write(parameter.value) + "\">\n");
            if (parameter instanceof SOAPParamEnumeration && (choices = ((SOAPParamEnumeration)parameter).getSelectionChoices()) != null) {
                out.write("\n");
                Iterator iterator = choices.iterator();
                while (iterator.hasNext()) {
                    out.write("<choice><![CDATA[" + (String)iterator.next() + "]]></choice>\n");
                }
            }
            out.write("</SOAPParam>\n");
        }
    }

    public static SOAPParam[] readArrayXML(Node node) throws Exception {
        if (!(node instanceof Element)) {
            throw new IllegalArgumentException("Wrong parameter element " + node.getLocalName());
        }
        Element el = (Element)node;
        NodeList list = el.getElementsByTagName(XMLTAG);
        if (list == null || list.getLength() == 0) {
            return null;
        }
        SOAPParam[] result = new SOAPParam[list.getLength()];
        for (int i = 0; i < list.getLength(); ++i) {
            NodeList choicesElements;
            Element paramElement = (Element)list.item(i);
            String name = paramElement.getAttribute("name");
            int sqlType = Integer.parseInt(paramElement.getAttribute("sqlType"));
            String prompt = paramElement.getAttribute("prompt");
            boolean alwaysUseDefault = Boolean.valueOf(paramElement.getAttribute("alwaysUseDefault"));
            Object defaultValue = null;
            String tmpDefault = paramElement.getAttribute("defaultValue");
            if (!tmpDefault.equals("")) {
                defaultValue = DataType.read(tmpDefault);
            }
            Object value = null;
            String tmpValue = paramElement.getAttribute("value");
            if (!tmpValue.equals("")) {
                value = DataType.read(tmpValue);
            }
            if ((choicesElements = paramElement.getElementsByTagName("choice")) == null || choicesElements.getLength() == 0) {
                result[i] = new SOAPParam(name, sqlType, prompt, defaultValue, value, alwaysUseDefault);
                continue;
            }
            Vector<String> choices = new Vector<String>(choicesElements.getLength());
            for (int j = 0; j < choicesElements.getLength(); ++j) {
                choices.add(XMLUtil.readCDATA(choicesElements.item(j)));
            }
            result[i] = new SOAPParamEnumeration(name, sqlType, prompt, defaultValue, value, alwaysUseDefault, choices);
        }
        return result;
    }

    public static void writeArray(FixedVersionDataOutput vout, SOAPParam[] parameters) throws IOException {
        if (parameters == null || parameters.length == 0) {
            vout.writeInt(0);
        } else {
            vout.writeInt(parameters.length);
            for (SOAPParam parameter : parameters) {
                parameter.write(vout);
            }
        }
    }

    public static SOAPParam[] readArray(VersioningDataInput din) throws IOException {
        int count = din.readInt();
        if (count == 0) {
            return null;
        }
        SOAPParam[] result = new SOAPParam[count];
        for (int i = 0; i < count; ++i) {
            result[i] = SOAPParam.read(din);
        }
        return result;
    }
}

