/*
 * Decompiled with CFR 0.152.
 */
package quadbase.common.paramquery;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.Writer;
import java.sql.Connection;
import java.util.Vector;
import javax.xml.namespace.QName;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import quadbase.common.paramquery.QueryFileInfo;
import quadbase.common.paramquery.QueryInParam;
import quadbase.common.paramquery.QueryInParamSet;
import quadbase.common.paramquery.SOAPParam;
import quadbase.common.util.IQueryInParam;
import quadbase.common.util.internal.Coder;
import quadbase.common.util.internal.DBInfoBasic;
import quadbase.common.util.internal.FixedVersionDataOutput;
import quadbase.common.util.internal.IOUtil;
import quadbase.common.util.internal.VersioningDataInput;
import quadbase.common.util.internal.XMLFieldInfo;

public class SOAPQueryFileInfo
extends QueryFileInfo {
    public static final String XMLTAG = "SOAP";
    private String wsdlUri;
    private QName serviceName;
    private String portName;
    private String operationName;
    private XMLFieldInfo[] xmlFieldInfo;
    private SOAPParam[] inParam;

    public SOAPQueryFileInfo(String wsdlUri, QName serviceName, String portName, String operationName, XMLFieldInfo[] xmlFieldInfo, SOAPParam[] parameters) {
        super(null, -1, new DBInfoBasic("", "", "", "", ""), null);
        if (wsdlUri == null || serviceName == null || portName == null || operationName == null) {
            throw new IllegalArgumentException("None of wsdlUri, serviceName, portName and operationName parameters can be null.");
        }
        this.wsdlUri = wsdlUri;
        this.serviceName = serviceName;
        this.portName = portName;
        this.operationName = operationName;
        this.xmlFieldInfo = xmlFieldInfo;
        this.inParam = parameters;
        this.inSet = null;
        if (this.inParam != null) {
            Vector<QueryInParam> queryInParams = new Vector<QueryInParam>();
            for (int i = 0; i < this.inParam.length; ++i) {
                if (this.inParam[i].isAlwaysUseDefault()) continue;
                QueryInParam p = QueryInParam.create(this.inParam[i]);
                QueryInParam.copyValue(p, this.inParam[i]);
                queryInParams.add(p);
            }
            if (!queryInParams.isEmpty()) {
                this.inSet = new QueryInParamSet(queryInParams.toArray(new QueryInParam[0]));
            }
        }
    }

    public XMLFieldInfo[] getXMLFieldInfo() {
        return this.xmlFieldInfo;
    }

    public boolean isParameterized() {
        return this.inSet != null;
    }

    public static SOAPQueryFileInfo readSOAPQueryFileInfo(VersioningDataInput vin) throws IOException {
        String wsdlUri = Coder.decode(IOUtil.readString(vin, true));
        String serviceNameNamespace = Coder.decode(IOUtil.readString(vin, true));
        String serviceNameLocalName = Coder.decode(IOUtil.readString(vin, true));
        QName serviceName = new QName(serviceNameNamespace, serviceNameLocalName);
        String portName = Coder.decode(IOUtil.readString(vin, true));
        String operationName = Coder.decode(IOUtil.readString(vin, true));
        int xmlFieldVersion = vin.readInt();
        XMLFieldInfo[] xmlFieldInfo = new XMLFieldInfo[vin.readInt()];
        for (int i = 0; i < xmlFieldInfo.length; ++i) {
            xmlFieldInfo[i] = XMLFieldInfo.createXMLFieldInfo(vin, xmlFieldVersion, true);
        }
        SOAPParam[] parameters = SOAPParam.readArray(vin);
        SOAPQueryFileInfo result = new SOAPQueryFileInfo(wsdlUri, serviceName, portName, operationName, xmlFieldInfo, parameters);
        return result;
    }

    public void write(DataOutput dout, short ver) throws IOException {
        FixedVersionDataOutput vout = new FixedVersionDataOutput(dout, ver);
        vout.writeUTF(Coder.encode(this.wsdlUri));
        vout.writeUTF(Coder.encode(this.serviceName.getNamespaceURI()));
        vout.writeUTF(Coder.encode(this.serviceName.getLocalPart()));
        vout.writeUTF(Coder.encode(this.portName));
        vout.writeUTF(Coder.encode(this.operationName));
        vout.writeInt(2);
        if (this.xmlFieldInfo == null) {
            vout.writeInt(0);
        } else {
            vout.writeInt(this.xmlFieldInfo.length);
            for (XMLFieldInfo element : this.xmlFieldInfo) {
                element.write(vout, true);
            }
        }
        this.updateSOAPParams();
        SOAPParam.writeArray(vout, this.inParam);
    }

    public static SOAPQueryFileInfo readSOAPQueryFileInfoXML(Node source) throws Exception {
        if (!(source instanceof Element)) {
            throw new Exception("Failed to read SOAP datasource");
        }
        Element el = (Element)source;
        NodeList list = el.getElementsByTagName(XMLTAG);
        if (list == null || list.getLength() == 0) {
            throw new Exception("SOAP element not found in the " + el.getLocalName() + " element.");
        }
        Element soapElement = (Element)list.item(0);
        String wsdUri = soapElement.getAttribute("wsdlUri");
        String serviceNameNamespace = soapElement.getAttribute("serviceNameNamespace");
        String serviceNameLocalName = soapElement.getAttribute("serviceNameLocalName");
        QName serviceName = new QName(serviceNameNamespace, serviceNameLocalName);
        String portName = soapElement.getAttribute("portName");
        String operationName = soapElement.getAttribute("operationName");
        int xmlFieldInfoVersion = Integer.parseInt(soapElement.getAttribute("xmlFieldVersion"));
        NodeList fieldInfos = el.getElementsByTagName("XMLFIELDINFO");
        if (fieldInfos == null || fieldInfos.getLength() == 0) {
            throw new Exception("XMLFIELDINFO element not found in the SOAP element.");
        }
        XMLFieldInfo[] xmlFieldInfo = new XMLFieldInfo[fieldInfos.getLength()];
        for (int i = 0; i < fieldInfos.getLength(); ++i) {
            xmlFieldInfo[i] = XMLFieldInfo.readXML(fieldInfos.item(i), xmlFieldInfoVersion);
        }
        SOAPParam[] inParam = SOAPParam.readArrayXML(soapElement);
        return new SOAPQueryFileInfo(wsdUri, serviceName, portName, operationName, xmlFieldInfo, inParam);
    }

    @Override
    public void writeXML(Writer dout) throws IOException {
        dout.write("<SOAP wsdlUri=\"" + this.wsdlUri + "\" serviceNameNamespace=\"" + this.serviceName.getNamespaceURI() + "\" serviceNameLocalName=\"" + this.serviceName.getLocalPart() + "\" portName=\"" + this.portName + "\" operationName=\"" + this.operationName + "\" xmlFieldVersion=\"" + 2 + "\">\n");
        for (XMLFieldInfo element : this.xmlFieldInfo) {
            element.writeXML(dout);
        }
        this.updateSOAPParams();
        SOAPParam.writeArrayXML(dout, this.inParam);
        dout.write("</SOAP>\n");
    }

    private void updateSOAPParams() {
        if (this.inParam == null || this.inSet == null) {
            return;
        }
        for (SOAPParam element : this.inParam) {
            QueryInParam p = this.inSet.getParameter(element.getParamName());
            if (p == null) continue;
            element.setValue(p.getValue());
        }
    }

    @Override
    @Deprecated
    public Connection getConnection() {
        throw new UnsupportedOperationException("getConnection() is not supported for SOAPQueryFile info.");
    }

    @Deprecated
    public static DBInfoBasic read(DataInput din, int version) {
        throw new UnsupportedOperationException("read(DataInput, int) is not supported for SalesForceQueryFile info. Use readSOAPQueryInfo(DataInput, int) instead.");
    }

    public IQueryInParam getSOAPParameter(String name) {
        QueryInParam param;
        if (this.inSet != null && (param = this.inSet.getParameter(name)) != null) {
            return param;
        }
        if (this.inParam == null) {
            return null;
        }
        for (SOAPParam element : this.inParam) {
            if (!element.getParamName().equals(name)) continue;
            return element;
        }
        return null;
    }

    public SOAPParam[] getSOAPInParam() {
        return this.inParam;
    }

    public String getWsdlUri() {
        return this.wsdlUri;
    }

    public void setWsdlUri(String wsdlUri) {
        this.wsdlUri = wsdlUri;
    }

    public QName getServiceName() {
        return this.serviceName;
    }

    public void setServiceName(QName serviceName) {
        this.serviceName = serviceName;
    }

    public String getPortName() {
        return this.portName;
    }

    public void setPortName(String portName) {
        this.portName = portName;
    }

    public String getOperationName() {
        return this.operationName;
    }

    public void setOperationName(String operationName) {
        this.operationName = operationName;
    }

    @Override
    @Deprecated
    public void write(DataOutputStream dout) throws IOException {
        throw new UnsupportedOperationException("This method is not supported.");
    }

    @Override
    @Deprecated
    public void write(DataOutput dout) throws IOException {
        throw new UnsupportedOperationException("This method is not supported.");
    }
}

