/*
 * Decompiled with CFR 0.152.
 */
package quadbase.common.paramquery.parser;

import java.util.StringTokenizer;
import java.util.Vector;
import quadbase.common.paramquery.parser.ConditionNode;

public class GenericParser {
    private static String SEPARATOR2 = " \t\n\r";
    private static String SEPARATOR3 = "'()";
    public static final int SELECT = 1;
    public static final int FROM = 2;
    public static final int WHERE = 3;
    public static final int GROUPBY_HAVING = 4;
    public static final int ORDERBY = 5;

    public static String getQueryPart(String query, int part) {
        return GenericParser.getQueryPart(query, part, true);
    }

    public static String getQueryPart(String query, int part, boolean addSpaces) {
        String token;
        String token2;
        if (query == null || part != 1 && part != 2 && part != 3 && part != 4 && part != 5) {
            return null;
        }
        String query2 = query;
        if (addSpaces) {
            query2 = GenericParser.addSpaceToQuery(query2);
        }
        StringBuffer sb = null;
        StringTokenizer st0 = null;
        st0 = new StringTokenizer(query2, SEPARATOR2);
        sb = new StringBuffer();
        while (st0.hasMoreTokens() && !st0.nextToken().equalsIgnoreCase("select")) {
        }
        while (st0.hasMoreTokens() && !(token2 = st0.nextToken()).equalsIgnoreCase("from")) {
            sb.append(token2).append(" ");
        }
        if (part == 1) {
            if (sb.length() > 0) {
                return sb.toString();
            }
            return null;
        }
        sb = new StringBuffer();
        boolean wasOrder = false;
        boolean wasGroup = false;
        String prevToken = null;
        int openCT = 0;
        while (st0.hasMoreTokens()) {
            String token3 = st0.nextToken();
            if (token3.equals("(")) {
                ++openCT;
            }
            if (token3.equals(")")) {
                --openCT;
            }
            if (openCT > 0) {
                sb.append(token3).append(" ");
                prevToken = token3;
                continue;
            }
            if (wasOrder || wasGroup) {
                if (token3.equalsIgnoreCase("by")) break;
                sb.append(prevToken).append(" ");
            }
            wasOrder = token3.equalsIgnoreCase("order");
            wasGroup = token3.equalsIgnoreCase("group");
            if (token3.equalsIgnoreCase("where") || token3.equalsIgnoreCase("union")) break;
            if (!st0.hasMoreTokens() || !wasOrder && !wasGroup) {
                sb.append(token3).append(" ");
            }
            prevToken = token3;
        }
        if (part == 2) {
            if (sb.length() > 0) {
                return sb.toString();
            }
            return null;
        }
        boolean hasGroupBy = false;
        boolean hasOrderBy = false;
        sb = new StringBuffer();
        while (st0.hasMoreTokens()) {
            token = st0.nextToken();
            if (token.equalsIgnoreCase("group") || token.equalsIgnoreCase("order") || token.equalsIgnoreCase("union")) {
                if (token.equalsIgnoreCase("group")) {
                    hasGroupBy = true;
                    break;
                }
                if (!token.equalsIgnoreCase("order")) break;
                hasOrderBy = true;
                break;
            }
            sb.append(token).append(" ");
        }
        if (part == 3) {
            if (sb.length() > 0) {
                return sb.toString();
            }
            return null;
        }
        if (hasGroupBy) {
            st0.nextToken();
            sb = new StringBuffer();
            while (st0.hasMoreTokens()) {
                token = st0.nextToken();
                if (token.equalsIgnoreCase("order") || token.equalsIgnoreCase("union")) {
                    if (!token.equalsIgnoreCase("order")) break;
                    hasOrderBy = true;
                    break;
                }
                sb.append(token).append(" ");
            }
            if (part == 4) {
                if (sb.length() > 0) {
                    return sb.toString();
                }
                return null;
            }
        }
        if (hasOrderBy) {
            st0.nextToken();
            sb = new StringBuffer();
            while (st0.hasMoreTokens() && !(token = st0.nextToken()).equalsIgnoreCase("union")) {
                sb.append(token).append(" ");
            }
            if (part == 5) {
                if (sb.length() > 0) {
                    return sb.toString();
                }
                return null;
            }
        }
        return null;
    }

    public static String addSpaceToQuery(String query) {
        query = GenericParser.addSpacesAround(query, ",");
        query = GenericParser.addSpacesAround(query, "(");
        query = GenericParser.addSpacesAround(query, ")");
        return query;
    }

    private static String addSpacesAround(String string, String character) {
        StringBuffer sb = new StringBuffer();
        StringTokenizer st = new StringTokenizer(string, character + "'", true);
        boolean insideQuotes = false;
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            if (token.equals("'")) {
                insideQuotes = !insideQuotes;
                sb.append(token);
                continue;
            }
            if (token.equals(character) && !insideQuotes) {
                sb.append(' ').append(character).append(' ');
                continue;
            }
            sb.append(token);
        }
        return sb.toString();
    }

    public static String getAllFromPart(String query) {
        String query2 = GenericParser.addSpaceToQuery(query);
        StringBuffer sb = null;
        StringTokenizer st0 = null;
        st0 = new StringTokenizer(query2, SEPARATOR2);
        sb = new StringBuffer();
        boolean from = false;
        Vector<String> tables = new Vector<String>();
        while (st0.hasMoreTokens()) {
            String nextToken;
            String token = st0.nextToken();
            if (token.equalsIgnoreCase("from")) {
                from = true;
                continue;
            }
            if (!from) continue;
            if (token.equalsIgnoreCase("select") || token.equalsIgnoreCase("where") || token.equalsIgnoreCase("union")) {
                from = false;
                continue;
            }
            if (token.equalsIgnoreCase("order") || token.equalsIgnoreCase("group")) {
                nextToken = st0.nextToken();
                if (nextToken.equalsIgnoreCase("by")) {
                    from = false;
                    continue;
                }
                if (nextToken.equalsIgnoreCase("select") || nextToken.equalsIgnoreCase("where") || nextToken.equalsIgnoreCase("union")) {
                    if (!tables.contains(token)) {
                        tables.add(token);
                    }
                    from = false;
                    continue;
                }
                if (!nextToken.equalsIgnoreCase("(") && !nextToken.equalsIgnoreCase(")")) {
                    if (!tables.contains(token)) {
                        tables.add(token);
                    }
                    token = nextToken;
                }
            }
            if (token.equalsIgnoreCase("left") || token.equalsIgnoreCase("right") || token.equalsIgnoreCase("inner")) {
                nextToken = st0.nextToken();
                if (nextToken.equalsIgnoreCase("join")) continue;
                if (nextToken.equalsIgnoreCase("select") || nextToken.equalsIgnoreCase("where") || nextToken.equalsIgnoreCase("union")) {
                    if (!tables.contains(token)) {
                        tables.add(token);
                    }
                    from = false;
                    continue;
                }
                if (!nextToken.equalsIgnoreCase("(") && !nextToken.equalsIgnoreCase(")")) {
                    if (!tables.contains(token)) {
                        tables.add(token);
                    }
                    token = nextToken;
                }
            }
            if (token.equalsIgnoreCase(",") || tables.contains(token) || token.equalsIgnoreCase("(") || token.equalsIgnoreCase(")")) continue;
            tables.add(token);
        }
        for (int i = 0; i < tables.size(); ++i) {
            sb.append(tables.get(i)).append(" ");
            if (i >= tables.size() - 1) continue;
            sb.append(", ");
        }
        return sb.toString();
    }

    public static ConditionNode getConditionTree(String query) {
        ConditionNode node;
        String where = GenericParser.getQueryPart(query, 3, true);
        if (where != null && (node = GenericParser.getConditionTreeHelper(where)).isValid()) {
            return node;
        }
        return null;
    }

    private static ConditionNode getConditionTreeHelper(String where) {
        StringTokenizer st0 = new StringTokenizer(where, SEPARATOR3, true);
        ConditionNode topNode = new ConditionNode();
        ConditionNode currentNode = new ConditionNode();
        while (st0.hasMoreTokens()) {
            String token = st0.nextToken();
            if (token.equals("'")) {
                currentNode.setCondition(currentNode.getCondition() + "'");
                boolean discard = true;
                while (discard && st0.hasMoreTokens()) {
                    String intoken = st0.nextToken();
                    if (intoken.equals("'")) {
                        discard = false;
                    }
                    currentNode.setCondition(currentNode.getCondition() + intoken);
                }
                continue;
            }
            if (token.equals("(") && currentNode.getCondition().trim().equals("")) {
                String subcondition = "";
                boolean discard = true;
                int level = 0;
                while (discard && st0.hasMoreTokens()) {
                    String intoken = st0.nextToken();
                    if (intoken.equals(")")) {
                        if (level == 0) {
                            discard = false;
                        } else {
                            --level;
                        }
                    } else if (intoken.equals("(")) {
                        ++level;
                    }
                    if (!discard) continue;
                    subcondition = subcondition + intoken;
                }
                ConditionNode inNode = GenericParser.getConditionTreeHelper(subcondition);
                if (inNode != null) {
                    topNode.addElement(inNode);
                }
                currentNode.setCondition("");
                continue;
            }
            int operator = -1;
            int index = -1;
            if (token.toLowerCase().indexOf(" and ") >= 0) {
                operator = 1;
                index = token.toLowerCase().indexOf(" and ");
            }
            if (token.toLowerCase().indexOf(" or ") >= 0 && token.toLowerCase().indexOf(" or ") < index) {
                operator = 2;
                index = token.toLowerCase().indexOf(" or ");
            }
            int oldIndex = 0;
            while (index != -1) {
                currentNode.setCondition(currentNode.getCondition() + token.substring(oldIndex, index));
                if (currentNode.getCondition().trim().length() > 0) {
                    topNode.addElement(currentNode);
                }
                currentNode = new ConditionNode();
                currentNode.setOperator(operator);
                oldIndex = index + 5;
                if (operator == 2) {
                    oldIndex = index + 4;
                }
                index = -1;
                if (token.toLowerCase().indexOf(" and ", oldIndex) >= 0) {
                    operator = 1;
                    index = token.toLowerCase().indexOf(" and ", oldIndex);
                }
                if (token.toLowerCase().indexOf(" or ", oldIndex) < 0 || token.toLowerCase().indexOf(" or ", oldIndex) >= index) continue;
                operator = 2;
                index = token.toLowerCase().indexOf(" or ", oldIndex);
            }
            currentNode.setCondition(currentNode.getCondition() + token.substring(oldIndex));
        }
        if (currentNode.getCondition().trim().length() > 0) {
            topNode.addElement(currentNode);
        }
        return topNode;
    }

    private static String removeQuote(String query, String quote) {
        String str = query;
        int i = str.indexOf(quote);
        while (i >= 0) {
            int j = str.indexOf(quote, i + 1);
            if (j >= 0) {
                str = str.substring(0, i) + str.substring(j + 1);
                i = str.indexOf(quote);
                continue;
            }
            i = -1;
        }
        return str;
    }

    public static ConditionNode removeCondition(ConditionNode root, String columnName) {
        int i;
        if (root == null || !root.isValid()) {
            return null;
        }
        if (root.isLeaf()) {
            String condition = root.getCondition();
            condition = GenericParser.removeQuote(condition, "\"");
            condition = GenericParser.removeQuote(condition, "'");
            if ((condition = GenericParser.removeQuote(condition, "#")).indexOf(columnName) >= 0) {
                return null;
            }
            return root;
        }
        Vector<ConditionNode> temp = new Vector<ConditionNode>();
        for (i = 0; i < root.size(); ++i) {
            ConditionNode node = (ConditionNode)root.elementAt(i);
            if ((node = GenericParser.removeCondition(node, columnName)) == null) continue;
            temp.addElement(node);
        }
        root.removeAllElements();
        for (i = 0; i < temp.size(); ++i) {
            root.addElement(temp.elementAt(i));
        }
        if (root.isValid()) {
            return root;
        }
        return null;
    }

    public static ConditionNode removeParameterConditions(ConditionNode root) {
        int i;
        if (root == null || !root.isValid()) {
            return null;
        }
        if (root.isLeaf()) {
            String condition = root.getCondition();
            condition = GenericParser.removeQuote(condition, "\"");
            condition = GenericParser.removeQuote(condition, "'");
            if ((condition = GenericParser.removeQuote(condition, "#")).indexOf(58) >= 0) {
                if (condition.length() > condition.indexOf(58) + 3 && condition.charAt(condition.indexOf(58) + 3) == ':') {
                    return root;
                }
                return null;
            }
            return root;
        }
        Vector<ConditionNode> temp = new Vector<ConditionNode>();
        for (i = 0; i < root.size(); ++i) {
            ConditionNode node = (ConditionNode)root.elementAt(i);
            if ((node = GenericParser.removeParameterConditions(node)) == null) continue;
            temp.addElement(node);
        }
        root.removeAllElements();
        for (i = 0; i < temp.size(); ++i) {
            root.addElement(temp.elementAt(i));
        }
        if (root.isValid()) {
            return root;
        }
        return null;
    }

    public static String getPostWhereQuery(String query) {
        String result = "";
        String groupby = GenericParser.getQueryPart(query, 4);
        String orderby = GenericParser.getQueryPart(query, 5);
        if (groupby != null) {
            result = result + "GROUP BY " + groupby;
        }
        if (orderby != null) {
            result = result + "ORDER BY " + orderby;
        }
        return result;
    }
}

