/*
 * Decompiled with CFR 0.152.
 */
package quadbase.common.util;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.naming.InitialContext;
import javax.sql.DataSource;
import quadbase.common.client.ServerMessage;
import quadbase.common.paramquery.QueryFileInfo;
import quadbase.common.paramquery.QueryInParam;
import quadbase.common.paramquery.QueryMultiValueInParam;
import quadbase.common.paramquery.QueryParser;
import quadbase.common.util.internal.QbDebug;
import quadbase.querybuilder.query.QueryBuilder;
import quadbase.reportdesigner.ReportAPI.QbReport;

public class SecParamInfo {
    String paramName;
    boolean isJNDI;
    String driver = "";
    String dbURL = "";
    String JNDIName = "";
    String contextFactory = "";
    String providerURL = "";
    String tableName;
    String colName;
    int sqlType;
    Hashtable valMap;
    Object othersVal;
    boolean isOthersSecOn = false;
    Object grantAllObj = null;
    Object denyAllObj = null;
    boolean isMulti = true;

    public SecParamInfo() {
        this.grantAllObj = new Object();
        this.denyAllObj = new Object();
        this.valMap = new Hashtable();
    }

    public void setParamName(String pName) {
        this.paramName = pName;
    }

    public void setDriver(String driver) {
        this.driver = driver;
    }

    public void setDBUrl(String dbURL) {
        this.dbURL = dbURL;
    }

    public void setJNDIName(String JNDIName) {
        this.JNDIName = JNDIName;
    }

    public void setContextFactory(String contextFactory) {
        this.contextFactory = contextFactory;
    }

    public void setProviderURL(String providerURL) {
        this.providerURL = providerURL;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public void setColName(String colName) {
        this.colName = colName;
    }

    public void setSQLType(int sqlType) {
        this.sqlType = sqlType;
    }

    public void setMulti(boolean isMulti) {
        this.isMulti = isMulti;
    }

    public void setJNDI(boolean isJNDI) {
        this.isJNDI = isJNDI;
    }

    public SecParamInfo(String driver, String dbURL, String tableName, String colName, int sqlType, boolean isMulti) {
        this(tableName + "." + colName, driver, dbURL, tableName, colName, sqlType, isMulti);
    }

    public SecParamInfo(String paramName, String driver, String dbURL, String tableName, String colName, int sqlType, boolean isMulti) {
        this.isJNDI = false;
        this.paramName = paramName;
        this.driver = driver;
        this.dbURL = dbURL;
        this.tableName = tableName;
        this.colName = colName;
        this.sqlType = sqlType;
        this.isMulti = isMulti;
        this.grantAllObj = new Object();
        this.denyAllObj = new Object();
        this.valMap = new Hashtable();
    }

    public SecParamInfo(boolean isJNDI, String JNDIName, String contextFactory, String providerURL, String tableName, String colName, int sqlType, boolean isMulti) {
        this(isJNDI, tableName + "." + colName, JNDIName, contextFactory, providerURL, tableName, colName, sqlType, isMulti);
    }

    public SecParamInfo(boolean isJNDI, String paramName, String JNDIName, String contextFactory, String providerURL, String tableName, String colName, int sqlType, boolean isMulti) {
        this.isJNDI = isJNDI;
        this.paramName = paramName;
        this.JNDIName = JNDIName;
        this.contextFactory = contextFactory;
        this.providerURL = providerURL;
        this.tableName = tableName;
        this.colName = colName;
        this.sqlType = sqlType;
        this.isMulti = isMulti;
        this.grantAllObj = new Object();
        this.denyAllObj = new Object();
        this.valMap = new Hashtable();
    }

    public String getParamName() {
        return this.paramName;
    }

    public String getTableName() {
        return this.tableName;
    }

    public String getColumnName() {
        return this.colName;
    }

    public int getSqlType() {
        return this.sqlType;
    }

    public boolean isMulti() {
        return this.isMulti;
    }

    public String getDriver() {
        return this.driver;
    }

    public String getDBUrl() {
        return this.dbURL;
    }

    public boolean isJNDI() {
        return this.isJNDI;
    }

    public String getJNDIName() {
        return this.JNDIName;
    }

    public String getContextFactory() {
        return this.contextFactory;
    }

    public String getProviderURL() {
        return this.providerURL;
    }

    public String getSecurityLevels() {
        Enumeration e = this.valMap.keys();
        String str = null;
        while (e.hasMoreElements()) {
            if (str != null) {
                str = str + ", " + e.nextElement();
                continue;
            }
            str = "" + e.nextElement();
        }
        return str;
    }

    public void addSecLevel(String secLevel, Object val) {
        if (val == null) {
            this.valMap.put(secLevel, this.denyAllObj);
        } else {
            this.valMap.put(secLevel, val);
        }
    }

    public void grantAll(String secLevel) {
        this.valMap.put(secLevel, this.grantAllObj);
    }

    public void addOthersSecLevel(Object val) {
        this.isOthersSecOn = true;
        this.othersVal = val;
    }

    public boolean isDenied(String secLevel) {
        if (secLevel == "") {
            return true;
        }
        Object obj = this.valMap.get(secLevel);
        if (obj != null && obj.toString().equalsIgnoreCase("[]")) {
            return true;
        }
        if (obj == null && this.isOthersSecOn) {
            return false;
        }
        if (obj == this.grantAllObj) {
            return false;
        }
        return obj == null || obj == this.denyAllObj;
    }

    public boolean isSecured(String secLevel) {
        if (secLevel == null) {
            return false;
        }
        Object obj = this.valMap.get(secLevel);
        if (obj == null && this.isOthersSecOn) {
            return true;
        }
        if (obj == this.grantAllObj) {
            return false;
        }
        return obj != null;
    }

    public Object getObject(String secLevel) {
        if (secLevel == null) {
            return null;
        }
        Object obj = this.valMap.get(secLevel);
        if (obj == this.grantAllObj) {
            return null;
        }
        if (obj == this.denyAllObj) {
            return null;
        }
        if (obj != null) {
            return obj;
        }
        if (this.isOthersSecOn) {
            return this.othersVal;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getCondition(String[][] tableNamesAndAliases, String secLevel) {
        Vector vec;
        if (secLevel == null) {
            return "";
        }
        Object obj = this.getObject(secLevel);
        if (obj instanceof Vector && (vec = (Vector)obj).size() == 0) {
            return null;
        }
        String ftableName = this.getTableNameOrAlias(tableNamesAndAliases);
        int databaseType = -1;
        if (!this.isJNDI) {
            databaseType = QueryBuilder.mapDatabaseType((String)this.driver);
        } else {
            Connection conn = null;
            try {
                Hashtable<String, String> env = new Hashtable<String, String>();
                if (this.providerURL != null && !this.providerURL.trim().equals("") && !this.providerURL.trim().equalsIgnoreCase("null")) {
                    env.put("java.naming.provider.url", this.providerURL);
                }
                if (this.contextFactory != null && !this.contextFactory.trim().equals("") && !this.providerURL.trim().equalsIgnoreCase("null")) {
                    env.put("java.naming.factory.initial", this.contextFactory);
                }
                if (env.size() <= 0) {
                    env = null;
                }
                InitialContext ctx = env == null || env.size() == 0 ? new InitialContext() : new InitialContext(env);
                DataSource ds = (DataSource)ctx.lookup(this.JNDIName);
                conn = ds.getConnection();
                String dbname = conn.getMetaData().getDatabaseProductName();
                databaseType = QueryBuilder.mapDatabaseType((String)dbname);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            finally {
                if (conn != null) {
                    try {
                        conn.close();
                    }
                    catch (SQLException sQLException) {}
                }
            }
        }
        ftableName = QueryBuilder.print((int)databaseType, (Object)ftableName);
        String columnName = QueryBuilder.print((int)databaseType, (Object)this.colName);
        if (this.isMulti) {
            return ftableName + "." + columnName + " In (" + this.printObject(obj) + ")";
        }
        return ftableName + "." + columnName + " = " + this.printObject(obj);
    }

    public String printObject(Object obj) {
        if (obj instanceof Vector) {
            Vector vec = (Vector)obj;
            String res = "";
            for (int i = 0; i < vec.size(); ++i) {
                res = i == 0 ? this.printObject(vec.elementAt(i)) : res + "," + this.printObject(vec.elementAt(i));
            }
            return res;
        }
        if (obj instanceof Number) {
            return obj.toString();
        }
        return "'" + obj + "'";
    }

    public boolean match(String[][] tblNames, String tdriver, String tdbURL) {
        QbDebug.println(4, "DRIVER MATCH = " + tdriver.equalsIgnoreCase(this.driver));
        String fName = this.tableName;
        if (!tdriver.equalsIgnoreCase(this.driver)) {
            return false;
        }
        String dbURL_TMP = null;
        if (this.dbURL != null) {
            dbURL_TMP = this.dbURL.replace('\\', '/');
            dbURL_TMP = this.getAbsolutePathForHSQL(dbURL_TMP);
            QbDebug.println(4, "SEC XML [FULL URL]  = " + dbURL_TMP);
        }
        String tdbURL_TMP = tdbURL.replace('\\', '/');
        tdbURL_TMP = this.getAbsolutePathForHSQL(tdbURL_TMP);
        QbDebug.println(4, "PARAM INFO SQL [FULL URL]  = " + tdbURL_TMP);
        QbDebug.println(4, "URL MATCH = " + tdbURL_TMP.equalsIgnoreCase(dbURL_TMP));
        if (!tdbURL_TMP.equalsIgnoreCase(dbURL_TMP)) {
            return false;
        }
        for (String[] tblName : tblNames) {
            if (!this.compareTableNames(fName, tblName[0]) && !this.compareTableNames(fName, tblName[1])) continue;
            QbDebug.println(4, "FOUND TABLE = " + fName + "=" + tblName[0] + ", " + tblName[1]);
            return true;
        }
        QbDebug.println(4, fName + " DID NOT FIND MATCHING TABLE");
        return false;
    }

    public boolean match(String[][] tblNames, String tjndiname, String tcontextFactory, String tproviderURL) {
        QbDebug.println(4, "JNDI MATCH = " + tjndiname.equalsIgnoreCase(this.JNDIName));
        String fName = this.tableName;
        if (!tjndiname.equalsIgnoreCase(this.JNDIName)) {
            return false;
        }
        if (this.contextFactory != null && tcontextFactory != null && this.contextFactory != "" && tcontextFactory != "" && !tcontextFactory.equalsIgnoreCase(this.contextFactory)) {
            return false;
        }
        if (this.providerURL != null && tproviderURL != null && this.providerURL != "" && tproviderURL != "" && !tproviderURL.equalsIgnoreCase(this.providerURL)) {
            return false;
        }
        for (String[] tblName : tblNames) {
            if (!this.compareTableNames(fName, tblName[0]) && !this.compareTableNames(fName, tblName[1])) continue;
            QbDebug.println(4, "FOUND TABLE = " + fName + "=" + tblName[0] + ", " + tblName[1]);
            return true;
        }
        QbDebug.println(4, fName + " DID NOT FIND MATCHING TABLE");
        return false;
    }

    public void setSecurityQueryParameterMap(Hashtable map, QbReport report) {
        Enumeration keys = this.valMap.keys();
        while (keys.hasMoreElements()) {
            int i;
            String key = (String)keys.nextElement();
            QueryInParam[] mapParam = (QueryInParam[])map.get(key);
            QueryFileInfo fileInfo = report.getReportObj().getQueryFileInfo();
            if (fileInfo == null) {
                return;
            }
            QueryInParam[] oParams = fileInfo.getInSet().getParameter();
            if (mapParam == null) {
                mapParam = QueryParser.verifyAndCopyParameters(oParams, oParams);
                for (i = mapParam.length - 1; i >= 0; --i) {
                    if (mapParam[i] instanceof QueryMultiValueInParam) {
                        ((QueryMultiValueInParam)mapParam[i]).setValues(null);
                        continue;
                    }
                    mapParam[i].setValue(null);
                }
            }
            for (i = mapParam.length - 1; i >= 0; --i) {
                Object obj;
                if (!mapParam[i].getParamName().equals("SECPARAM_" + this.colName) || (obj = this.valMap.get(key)) == this.grantAllObj) continue;
                if (mapParam[i] instanceof QueryMultiValueInParam) {
                    if (obj == this.denyAllObj) {
                        ((QueryMultiValueInParam)mapParam[i]).setValues(new Vector<Object>());
                        continue;
                    }
                    ((QueryMultiValueInParam)mapParam[i]).setValues((Vector)obj);
                    continue;
                }
                if (obj == this.denyAllObj) {
                    mapParam[i].setValue(null);
                    continue;
                }
                mapParam[i].setValue(obj);
            }
            map.put(key, mapParam);
        }
    }

    private String getAbsolutePathForHSQL(String dbURL) {
        return ServerMessage.getDatabaseURL(dbURL);
    }

    private String getTableNameOrAlias(String[][] tableNamesAndAliases) {
        for (String[] tableNamesAndAliase : tableNamesAndAliases) {
            if (this.compareTableNames(tableNamesAndAliase[0], this.tableName) && tableNamesAndAliase[1] != null) {
                return tableNamesAndAliase[1];
            }
            if (!tableNamesAndAliase[0].matches("^\\[.*\\]$|^'.*'$|^`.*$")) continue;
            String string = tableNamesAndAliase[0].substring(1, tableNamesAndAliase[0].length() - 1);
        }
        return this.tableName;
    }

    public boolean isGrantAll(String secLevel) {
        if (secLevel == null) {
            return false;
        }
        Object obj = this.valMap.get(secLevel);
        return obj == this.grantAllObj;
    }

    private boolean compareTableNames(String table1, String table2) {
        if (table1.equalsIgnoreCase(table2)) {
            return true;
        }
        if (table1.matches("^\\[.*\\]$|^'.*'$|^`.*$")) {
            table1 = table1.substring(1, table1.length() - 1);
        }
        if (table2.matches("^\\[.*\\]$|^'.*'$|^`.*$")) {
            table2 = table2.substring(1, table2.length() - 1);
        }
        return table1.equalsIgnoreCase(table2);
    }
}

