/*
 * Decompiled with CFR 0.152.
 */
package quadbase.common.util.flash;

public class BezierSpline {
    public static double[][] getCurveControlPoints(double[][] knots) throws Exception {
        if (knots == null) {
            throw new Exception("knots");
        }
        int n = knots.length - 1;
        if (n < 1) {
            throw new Exception("At least two knot points required knots");
        }
        if (n == 1) {
            double[][] firstControlPoints = new double[1][2];
            firstControlPoints[0][0] = (2.0 * knots[0][0] + knots[1][0]) / 3.0;
            firstControlPoints[0][1] = (2.0 * knots[0][1] + knots[1][1]) / 3.0;
            double[][] secondControlPoints = new double[1][2];
            secondControlPoints[0][0] = 2.0 * firstControlPoints[0][0] - knots[0][0];
            secondControlPoints[0][1] = 2.0 * firstControlPoints[0][1] - knots[0][1];
            double[][] controlPoints = new double[firstControlPoints.length][2];
            int i = 0;
            while (0 < firstControlPoints.length) {
                controlPoints[i] = BezierSpline.getControlPoint(firstControlPoints[i], secondControlPoints[i]);
                ++i;
            }
            return controlPoints;
        }
        double[] rhs = new double[n];
        for (int i = 1; i < n - 1; ++i) {
            rhs[i] = 4.0 * knots[i][0] + 2.0 * knots[i + 1][0];
        }
        rhs[0] = knots[0][0] + 2.0 * knots[1][0];
        rhs[n - 1] = (8.0 * knots[n - 1][0] + knots[n][0]) / 2.0;
        double[] x = BezierSpline.getFirstControlPoints(rhs);
        for (int i = 1; i < n - 1; ++i) {
            rhs[i] = 4.0 * knots[i][1] + 2.0 * knots[i + 1][1];
        }
        rhs[0] = knots[0][1] + 2.0 * knots[1][1];
        rhs[n - 1] = (8.0 * knots[n - 1][1] + knots[n][1]) / 2.0;
        double[] y = BezierSpline.getFirstControlPoints(rhs);
        double[][] firstControlPoints = new double[n][2];
        double[][] secondControlPoints = new double[n][2];
        for (int i = 0; i < n; ++i) {
            firstControlPoints[i] = new double[]{x[i], y[i]};
            secondControlPoints[i] = i < n - 1 ? new double[]{2.0 * knots[i + 1][0] - x[i + 1], 2.0 * knots[i + 1][1] - y[i + 1]} : new double[]{(knots[n][0] + x[n - 1]) / 2.0, (knots[n][1] + y[n - 1]) / 2.0};
        }
        double[][] controlPoints = new double[n][2];
        for (int i = 0; i < n; ++i) {
            controlPoints[i] = BezierSpline.getControlPoint(firstControlPoints[i], secondControlPoints[i]);
        }
        return controlPoints;
    }

    private static double[] getControlPoint(double[] pt1, double[] pt2) {
        return new double[]{(pt1[0] + pt2[0]) / 2.0, (pt1[1] + pt2[1]) / 2.0};
    }

    private static double[] getFirstControlPoints(double[] rhs) {
        int i;
        int n = rhs.length;
        double[] x = new double[n];
        double[] tmp = new double[n];
        double b = 2.0;
        x[0] = rhs[0] / b;
        for (i = 1; i < n; ++i) {
            tmp[i] = 1.0 / b;
            b = (i < n - 1 ? 4.0 : 3.5) - tmp[i];
            x[i] = (rhs[i] - x[i - 1]) / b;
        }
        for (i = 1; i < n; ++i) {
            int n2 = n - i - 1;
            x[n2] = x[n2] - tmp[n - i] * x[n - i];
        }
        return x;
    }
}

