/*
 * Decompiled with CFR 0.152.
 */
package quadbase.common.util.flash;

import com.flagstone.transform.FSAction;
import com.flagstone.transform.FSBitmapFill;
import com.flagstone.transform.FSBounds;
import com.flagstone.transform.FSButton;
import com.flagstone.transform.FSButtonEvent;
import com.flagstone.transform.FSColor;
import com.flagstone.transform.FSColorTable;
import com.flagstone.transform.FSColorTransform;
import com.flagstone.transform.FSCoordTransform;
import com.flagstone.transform.FSCurve;
import com.flagstone.transform.FSDefineButton2;
import com.flagstone.transform.FSDefineImage2;
import com.flagstone.transform.FSDefineJPEGImage2;
import com.flagstone.transform.FSDefineMovieClip;
import com.flagstone.transform.FSDefineObject;
import com.flagstone.transform.FSDefineShape2;
import com.flagstone.transform.FSDefineShape3;
import com.flagstone.transform.FSDefineText2;
import com.flagstone.transform.FSDoAction;
import com.flagstone.transform.FSFillStyle;
import com.flagstone.transform.FSGetUrl;
import com.flagstone.transform.FSGradient;
import com.flagstone.transform.FSGradientFill;
import com.flagstone.transform.FSLine;
import com.flagstone.transform.FSLineStyle;
import com.flagstone.transform.FSMovie;
import com.flagstone.transform.FSMovieObject;
import com.flagstone.transform.FSPlaceObject2;
import com.flagstone.transform.FSPush;
import com.flagstone.transform.FSRemoveObject2;
import com.flagstone.transform.FSSetBackgroundColor;
import com.flagstone.transform.FSShape;
import com.flagstone.transform.FSShapeStyle;
import com.flagstone.transform.FSShowFrame;
import com.flagstone.transform.FSSolidFill;
import com.flagstone.transform.FSSolidLine;
import com.flagstone.transform.FSTransformObject;
import com.flagstone.transform.util.FSImageConstructor;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Toolkit;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;
import java.awt.image.ImageObserver;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.text.AttributedCharacterIterator;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.DataFormatException;
import java.util.zip.Deflater;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;
import javax.imageio.stream.MemoryCacheImageOutputStream;
import quadbase.chart.CGraphics;
import quadbase.chart.CString;
import quadbase.chart.Chart;
import quadbase.chart.IPieChart;
import quadbase.chart.MultiDimData;
import quadbase.chart.ReadDataFile;
import quadbase.chart.chart3d.lib3d.Space;
import quadbase.chart.chart3d.lib3d.Vertex;
import quadbase.common.util.flash.BezierSpline;
import quadbase.common.util.flash.BlockObject;
import quadbase.common.util.flash.FontMapping;
import quadbase.common.util.flash.FrameObject;
import quadbase.common.util.flash.LayerObject;
import quadbase.common.util.flash.Pictures;
import quadbase.common.util.flash.Plane;
import quadbase.common.util.flash.flagstoneex.QbFlashShapeConstructor;
import quadbase.common.util.flash.flagstoneex.QbFlashTextConstructor;
import quadbase.common.util.internal.IFlashGraphics;
import quadbase.common.util.internal.IOUtil;
import quadbase.common.util.internal.LanguageEncoder;
import quadbase.common.util.internal.QbPattern;
import quadbase.common.util.internal.QbUtil;
import quadbase.util.HyperLink;
import quadbase.util.PickData;

public class FlashGraphics
extends Graphics
implements IFlashGraphics {
    private static final Logger LOGGER = Logger.getLogger(FlashGraphics.class.getName());
    private static final float GRADIENT_SQUARE_WIDTH = 32768.0f;
    private static final double CONT_RATIO = 0.92;
    private static final int TOOLTIP_FADE_IN_FRAME_COUNT = 5;
    public static final Pattern IMG_TAG_PATTERN = Pattern.compile("<img\\s+src\\s*=\\s*\"([^\"]*)\"\\s*>", 2);
    private int fontSize = 12;
    private FSColor color;
    private Font awtFont;
    private Color awtColor;
    private Plane p;
    private FSMovie movie;
    private int initLayerCount = 1;
    private int layer = 1;
    private BlockObject currentBlock = null;
    private FSBounds boundingBox;
    private FrameObject[] frames;
    private FrameObject currentFrame;
    private ArrayList<FSButton> recordBuffer = null;
    private ArrayList<LayerObject> shapeBuffer = null;
    private Hashtable<String, QbFlashTextConstructor> fontTable;
    private ArrayList<Object> toolTipsKeys;
    private ArrayList<ArrayList<FSButton>> toolTipsValues;
    private ArrayList<ArrayList<LayerObject>> toolTipsShapes;
    private boolean insertingTopLabel = false;
    private float alphaValue = 1.0f;
    private ArrayList<FSTransformObject> lastArcShape;
    private int lastArcStartX;
    private int lastArcStartY;
    private int lastArcWidth;
    private int lastArcHeight;
    private int lastArcStartAngle;
    private int lastArcAngle;
    private final int TOOLTIP_LAYER_INIT = 50000;
    private final int MAX_LAYER = 65536;
    private int tooltipLayer = 50000;
    private Chart chart;
    private boolean isToolTips = false;
    private BufferedImage pattern = null;
    private GradientPaint gradientPaint;
    private String chartFile;
    private String servletLoc;
    private String optionParam;
    private String prevDrillData;
    private boolean isAddingButtons = false;
    private boolean useDarkerColorForBubble = false;

    public FlashGraphics(int width, int height, Chart chart) {
        this.chart = chart;
        this.p = new Plane(width, height);
        this.fontTable = new Hashtable();
        this.color = new FSColor(0, 0, 0);
        this.awtColor = new Color(0, 0, 0);
        this.movie = new FSMovie();
        this.movie.setFrameRate(chart.flashFrameRate);
        this.movie.setFrameSize(new FSBounds(this.p.getUpperLeftX(), this.p.getUpperLeftY(), this.p.getLowerRightX(), this.p.getLowerRightY()));
        this.movie.add((FSMovieObject)new FSSetBackgroundColor(FSColorTable.white()));
        this.boundingBox = new FSBounds(0, 0, this.p.getWidth(), this.p.getHeight());
        this.layer = 1;
        this.toolTipsKeys = new ArrayList();
        this.toolTipsValues = new ArrayList();
        this.toolTipsShapes = new ArrayList();
    }

    public void setDrillDownInfo(String chartFile, String servletLoc, PickData[] pickData, String[] argv) {
        this.chartFile = chartFile;
        this.servletLoc = servletLoc;
        int level = 1;
        if (pickData != null) {
            level = pickData.length + 1;
        }
        this.prevDrillData = level + "$_$";
        if (pickData != null) {
            for (PickData pickData2 : pickData) {
                this.prevDrillData = this.prevDrillData + CGraphics.getDrillDownLink((PickData)pickData2).link;
            }
        }
        this.optionParam = "";
        if (argv != null) {
            for (String string : argv) {
                this.optionParam = this.optionParam + "&ARGV=" + QbUtil.encodeURIComponent(string);
            }
        }
    }

    public void initFrameSet(int frameCount) {
        this.frames = new FrameObject[frameCount];
        for (int i = 0; i < this.frames.length; ++i) {
            this.frames[i] = new FrameObject(i);
        }
    }

    @Override
    public void setFrameRate(float rate) {
        this.movie.setFrameRate(rate);
    }

    @Override
    public void setFrame(int i) {
        this.resetArcInfo();
        if (i == 0) {
            this.initLayerCount = this.layer;
        }
        if (i == -1) {
            this.alphaValue = 1.0f;
            this.addButtons();
            this.currentFrame = null;
        } else {
            this.currentFrame = this.frames[i];
            if (!this.isLastFrame()) {
                this.layer = this.initLayerCount;
            }
        }
    }

    public void resetArcInfo() {
        this.lastArcShape = null;
        this.lastArcStartX = 0;
        this.lastArcStartY = 0;
        this.lastArcWidth = 0;
        this.lastArcHeight = 0;
        this.lastArcStartAngle = 0;
        this.lastArcAngle = 0;
    }

    @Override
    public void drawRect(int x, int y, int w, int h) {
        if (w == 0 || h == 0) {
            return;
        }
        ArrayList lineStyles = FlashGraphics.getLineStyle(1, this.color);
        ArrayList fillStyles = this.getFillStyle(null);
        int width = this.p.getX(w);
        int height = this.p.getY(h);
        int startX = this.p.getX(x);
        int startY = this.p.getY(y);
        if (!(this.recordBuffer != null && this.isToolTips || startX + width <= this.p.width)) {
            width = this.p.width - startX - 20;
        }
        ArrayList<Object> shapeRecords2 = new ArrayList<Object>();
        shapeRecords2.add(new FSShapeStyle(1, 1, 0, startX, startY));
        shapeRecords2.add(new FSLine(width, 0));
        shapeRecords2.add(new FSLine(0, height));
        shapeRecords2.add(new FSLine(-width, 0));
        shapeRecords2.add(new FSLine(0, -height));
        this.addShape(this.boundingBox, fillStyles, lineStyles, new FSShape(shapeRecords2), 0, 0);
    }

    @Override
    public void draw3DRect(int x, int y, int width, int height, boolean raised) {
        this.drawRect(x, y, width, height);
    }

    @Override
    public void drawRoundRect(int x, int y, int w, int h, int arcWidth, int arcHeight) {
        if (w == 0 || h == 0) {
            return;
        }
        ArrayList lineStyles = FlashGraphics.getLineStyle(1, this.color);
        ArrayList fillStyles = this.getFillStyle(null);
        int width = this.p.getX(w);
        int height = this.p.getY(h);
        int startX = this.p.getX(x);
        int startY = this.p.getY(y);
        if (!(this.recordBuffer != null && this.isToolTips || startX + width <= this.p.width)) {
            width = this.p.width - startX - 20;
        }
        int arcW = this.p.getX((int)Math.round((double)arcWidth / 2.0));
        int arcH = this.p.getY((int)Math.round((double)arcHeight / 2.0));
        ArrayList<Object> shapeRecords2 = new ArrayList<Object>();
        shapeRecords2.add(new FSShapeStyle(1, 1, 0, startX + arcW, startY));
        shapeRecords2.add(new FSLine(width - arcW * 2, 0));
        shapeRecords2.add(new FSCurve(arcW, 0, 0, arcH));
        shapeRecords2.add(new FSLine(0, height - arcH * 2));
        shapeRecords2.add(new FSCurve(0, arcH, -arcW, 0));
        shapeRecords2.add(new FSLine(-width + arcW * 2, 0));
        shapeRecords2.add(new FSCurve(-arcW, 0, 0, -arcH));
        shapeRecords2.add(new FSLine(0, arcH * 2 - height));
        shapeRecords2.add(new FSCurve(0, -arcH, arcW, 0));
        this.addShape(this.boundingBox, fillStyles, lineStyles, new FSShape(shapeRecords2), 0, 0);
    }

    @Override
    public void fillRect(int x, int y, int w, int h) {
        if (w == 0 || h == 0) {
            return;
        }
        ArrayList lineStyles = FlashGraphics.getLineStyle(1, null);
        int width = this.p.getX(w);
        int height = this.p.getY(h);
        int startX = this.p.getX(x);
        int startY = this.p.getY(y);
        if (!(this.recordBuffer != null && this.isToolTips || startX + width <= this.p.width)) {
            width = this.p.width - startX - 20;
        }
        ArrayList fillStyles = this.getFillStyle(this.color);
        ArrayList<Object> shapeRecords2 = new ArrayList<Object>();
        shapeRecords2.add(new FSShapeStyle(1, 1, 0, startX, startY));
        shapeRecords2.add(new FSLine(width, 0));
        shapeRecords2.add(new FSLine(0, height));
        shapeRecords2.add(new FSLine(-width, 0));
        shapeRecords2.add(new FSLine(0, -height));
        this.addShape(this.boundingBox, fillStyles, lineStyles, new FSShape(shapeRecords2), 0, 0);
    }

    @Override
    public void fill3DRect(int x, int y, int width, int height, boolean raised) {
        Color c = this.getColor();
        Color brighter = c.brighter();
        Color darker = c.darker();
        if (!raised) {
            this.setColor(darker);
        }
        this.fillRect(x, y, width, height);
        if (!(this.recordBuffer != null && this.isToolTips || x + width <= this.p.getPixel(this.p.width))) {
            width = this.p.getPixel(this.p.width) - x - 1;
        }
        this.setColor(raised ? brighter : darker);
        this.drawLine(x, y, x + --width, y);
        this.setColor(raised ? darker : brighter);
        this.drawLine(x, y + --height, x + width, y + height);
        this.drawLine(x + width, y, x + width, y + height);
        this.setColor(raised ? brighter : darker);
        this.drawLine(x, y, x, y + height);
        this.setColor(c);
    }

    @Override
    public void fillRoundRect(int x, int y, int w, int h, int arcWidth, int arcHeight) {
        if (w == 0 || h == 0) {
            return;
        }
        ArrayList lineStyles = FlashGraphics.getLineStyle(1, null);
        int width = this.p.getX(w);
        int height = this.p.getY(h);
        int startX = this.p.getX(x);
        int startY = this.p.getY(y);
        ArrayList fillStyles = this.getFillStyle(this.color);
        int arcW = this.p.getX((int)Math.round((double)arcWidth / 2.0));
        int arcH = this.p.getY((int)Math.round((double)arcHeight / 2.0));
        ArrayList<Object> shapeRecords2 = new ArrayList<Object>();
        shapeRecords2.add(new FSShapeStyle(1, 1, 0, startX + arcW, startY));
        shapeRecords2.add(new FSLine(width - arcW * 2, 0));
        shapeRecords2.add(new FSCurve(arcW, 0, 0, arcH));
        shapeRecords2.add(new FSLine(0, height - arcH * 2));
        shapeRecords2.add(new FSCurve(0, arcH, -arcW, 0));
        shapeRecords2.add(new FSLine(-width + arcW * 2, 0));
        shapeRecords2.add(new FSCurve(-arcW, 0, 0, -arcH));
        shapeRecords2.add(new FSLine(0, arcH * 2 - height));
        shapeRecords2.add(new FSCurve(0, -arcH, arcW, 0));
        this.addShape(this.boundingBox, fillStyles, lineStyles, new FSShape(shapeRecords2), 0, 0);
    }

    @Override
    public void fillOval(int x, int y, int w, int h) {
        if (w == h) {
            this.fillArc(x, y, w, h, 0, 360);
            return;
        }
        ArrayList lineStyles = FlashGraphics.getLineStyle(1, null);
        ArrayList fillStyles = this.getFillStyle(this.color);
        int width = this.p.getX(w);
        int height = this.p.getY(h);
        int arcW = this.p.getX((int)Math.round((double)width / 2.0));
        int arcH = this.p.getY((int)Math.round((double)height / 2.0));
        int startX = this.p.getX(x);
        int startY = this.p.getY(y);
        ArrayList<Object> shapeRecords2 = new ArrayList<Object>();
        shapeRecords2.add(new FSShapeStyle(1, 1, 0, startX + arcW, startY));
        shapeRecords2.add(this.drawCurve(startX + arcW, startY, arcW, arcH));
        shapeRecords2.add(this.drawCurve(startX + width, startY + arcH, -arcW, arcH));
        shapeRecords2.add(this.drawCurve(startX + arcW, startY + height, -arcW, -arcH));
        shapeRecords2.add(this.drawCurve(startX, startY + arcH, arcW, -arcH));
        this.addShape(this.boundingBox, fillStyles, lineStyles, new FSShape(shapeRecords2), 0, 0);
    }

    @Override
    public void drawOval(int x, int y, int w, int h) {
        if (w == h) {
            this.drawArc(x, y, w, h, 0, 360);
            return;
        }
        ArrayList lineStyles = FlashGraphics.getLineStyle(1, this.color);
        ArrayList fillStyles = this.getFillStyle(null);
        int width = this.p.getX(w);
        int height = this.p.getY(h);
        int startX = this.p.getX(x);
        int startY = this.p.getY(y);
        int arcW = this.p.getX((int)Math.round((double)width / 2.0));
        int arcH = this.p.getY((int)Math.round((double)height / 2.0));
        ArrayList<Object> shapeRecords2 = new ArrayList<Object>();
        shapeRecords2.add(new FSShapeStyle(1, 1, 0, startX + arcW, startY));
        shapeRecords2.add(this.drawCurve(startX + arcW, startY, arcW, arcH));
        shapeRecords2.add(this.drawCurve(startX + width, startY + arcH, -arcW, arcH));
        shapeRecords2.add(this.drawCurve(startX + arcW, startY + height, -arcW, -arcH));
        shapeRecords2.add(this.drawCurve(startX, startY + arcH, arcW, -arcH));
        this.addShape(this.boundingBox, fillStyles, lineStyles, new FSShape(shapeRecords2), 0, 0);
    }

    @Override
    public void drawPolyline(int[] xPoints, int[] yPoints, int nPoints) {
        ArrayList lineStyles = FlashGraphics.getLineStyle(1, this.color);
        ArrayList fillStyles = this.getFillStyle(null);
        ArrayList<Object> shapeRecords2 = new ArrayList<Object>();
        shapeRecords2.add(new FSShapeStyle(1, 1, 0, this.p.getX(xPoints[0]), this.p.getY(yPoints[0])));
        for (int i = 1; i < xPoints.length; ++i) {
            shapeRecords2.add(new FSLine(this.p.getX(xPoints[i] - xPoints[i - 1]), this.p.getY(yPoints[i] - yPoints[i - 1])));
        }
        this.addShape(this.boundingBox, fillStyles, lineStyles, new FSShape(shapeRecords2), this.p.getX(0), this.p.getY(0));
    }

    @Override
    public void drawPolygon(int[] xPoints, int[] yPoints, int nPoints) {
        for (int i = 0; i < xPoints.length; ++i) {
            if (xPoints[i] > 403220000) {
                return;
            }
            if (yPoints[i] <= 403220000) continue;
            return;
        }
        ArrayList lineStyles = FlashGraphics.getLineStyle(1, this.color);
        ArrayList fillStyles = this.getFillStyle(null);
        ArrayList<Object> shapeRecords2 = new ArrayList<Object>();
        shapeRecords2.add(new FSShapeStyle(1, 1, 0, this.p.getX(xPoints[0]), this.p.getY(yPoints[0])));
        for (int i = 1; i < xPoints.length; ++i) {
            shapeRecords2.add(new FSLine(this.p.getX(xPoints[i] - xPoints[i - 1]), this.p.getY(yPoints[i] - yPoints[i - 1])));
        }
        shapeRecords2.add(new FSLine(this.p.getX(xPoints[0] - xPoints[xPoints.length - 1]), this.p.getY(yPoints[0] - yPoints[yPoints.length - 1])));
        this.addShape(this.boundingBox, fillStyles, lineStyles, new FSShape(shapeRecords2), this.p.getX(0), this.p.getY(0));
    }

    @Override
    public void fillPolygon(int[] xPoints, int[] yPoints, int nPoints) {
        for (int i = 0; i < xPoints.length; ++i) {
            if (xPoints[i] > 403220000) {
                return;
            }
            if (yPoints[i] <= 403220000) continue;
            return;
        }
        ArrayList lineStyles = FlashGraphics.getLineStyle(1, null);
        ArrayList fillStyles = this.getFillStyle(this.color);
        ArrayList<Object> shapeRecords2 = new ArrayList<Object>();
        shapeRecords2.add(new FSShapeStyle(1, 1, 0, this.p.getX(xPoints[0]), this.p.getY(yPoints[0])));
        for (int i = 1; i < xPoints.length; ++i) {
            shapeRecords2.add(new FSLine(this.p.getX(xPoints[i] - xPoints[i - 1]), this.p.getY(yPoints[i] - yPoints[i - 1])));
        }
        shapeRecords2.add(new FSLine(this.p.getX(xPoints[0] - xPoints[xPoints.length - 1]), this.p.getY(yPoints[0] - yPoints[yPoints.length - 1])));
        this.addShape(this.boundingBox, fillStyles, lineStyles, new FSShape(shapeRecords2), this.p.getX(0), this.p.getY(0));
    }

    @Override
    public void drawArc(int startX, int startY, int width, int height, int startAngle, int arcAngle) {
        if (width != height) {
            System.out.println("FLASH GRAPHICS: drawArc(...)");
        }
        int ptUnit = 10;
        if (this.chart.chartType == 6 || this.chart.chartType == 20 || this.chart.chartType == 17) {
            ptUnit = 1;
        }
        if (width >= 100 || height >= 100) {
            ptUnit = 1;
        }
        startAngle = FlashGraphics.absAngle(startAngle);
        arcAngle = FlashGraphics.absAngle(arcAngle);
        ArrayList<Object> shapeRecords = null;
        double radius = (double)width / 2.0;
        int x1 = startX + (int)Math.abs(radius);
        int y1 = startY + (int)Math.abs(radius);
        int maxPt = (int)((double)arcAngle / (double)ptUnit);
        if (maxPt < 4) {
            maxPt = 4;
        }
        double[][] pts = new double[maxPt][2];
        if (arcAngle == 0) {
            arcAngle = 360;
        }
        double tmpAngle = 0.0;
        for (int i = 0; i < maxPt; ++i) {
            tmpAngle = i == maxPt - 1 ? (double)(arcAngle + startAngle) : (double)i * ((double)arcAngle / (double)maxPt) + (double)startAngle;
            pts[i][0] = Math.cos(FlashGraphics.toRadians(tmpAngle)) * radius + (double)x1;
            pts[i][1] = (double)y1 - Math.sin(FlashGraphics.toRadians(tmpAngle)) * radius;
        }
        shapeRecords = new ArrayList<Object>();
        try {
            double[][] controlPt = BezierSpline.getCurveControlPoints(pts);
            shapeRecords.add(new FSShapeStyle(1, 1, 0, this.p.getX(pts[0][0]), this.p.getY(pts[0][1])));
            for (int i = 1; i < pts.length; ++i) {
                double[] currentPoint = pts[i - 1];
                double[] controlPoint = controlPt[i - 1];
                double[] anchorPoint = pts[i];
                shapeRecords.add(new FSCurve(this.p.getX(controlPoint[0]) - this.p.getX(currentPoint[0]), this.p.getY(controlPoint[1]) - this.p.getY(currentPoint[1]), this.p.getX(anchorPoint[0]) - this.p.getX(controlPoint[0]), this.p.getY(anchorPoint[1]) - this.p.getY(controlPoint[1])));
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        this.lastArcShape = shapeRecords;
        this.lastArcStartX = startX;
        this.lastArcStartY = startY;
        this.lastArcWidth = width;
        this.lastArcHeight = height;
        this.lastArcStartAngle = startAngle;
        this.lastArcAngle = arcAngle;
        ArrayList lineStyles = FlashGraphics.getLineStyle(1, this.color);
        ArrayList fillStyles = this.getFillStyle(null);
        this.addShape(this.boundingBox, fillStyles, lineStyles, new FSShape(shapeRecords), 0, 0);
    }

    @Override
    public void drawArc(double[][] pts, int curIdx) {
        ArrayList<Object> shapeRecords = new ArrayList<Object>();
        try {
            double[][] controlPt = BezierSpline.getCurveControlPoints(pts);
            shapeRecords.add(new FSShapeStyle(1, 1, 0, this.p.getX(pts[curIdx][0]), this.p.getY(pts[curIdx][1])));
            double[] currentPoint = pts[curIdx];
            double[] controlPoint = controlPt[curIdx];
            double[] anchorPoint = pts[curIdx + 1];
            shapeRecords.add(new FSCurve(this.p.getX(controlPoint[0]) - this.p.getX(currentPoint[0]), this.p.getY(controlPoint[1]) - this.p.getY(currentPoint[1]), this.p.getX(anchorPoint[0]) - this.p.getX(controlPoint[0]), this.p.getY(anchorPoint[1]) - this.p.getY(controlPoint[1])));
        }
        catch (Exception ex) {
            throw new IllegalArgumentException(ex.toString());
        }
        ArrayList lineStyles = FlashGraphics.getLineStyle(1, this.color);
        ArrayList fillStyles = this.getFillStyle(null);
        this.addShape(this.boundingBox, fillStyles, lineStyles, new FSShape(shapeRecords), 0, 0);
    }

    @Override
    public void fillArc(int startX, int startY, int width, int height, int startAngle, int arcAngle) {
        if (width != height) {
            System.out.println("FLASH GRAPHICS: drawArc(...)");
        }
        int ptUnit = 10;
        if (this.chart.chartType == 6 || this.chart.chartType == 20 || this.chart.chartType == 17) {
            ptUnit = 1;
        }
        if (width >= 100 || height >= 100) {
            ptUnit = 1;
        }
        startAngle = FlashGraphics.absAngle(startAngle);
        arcAngle = FlashGraphics.absAngle(arcAngle);
        ArrayList<Object> shapeRecords = null;
        if (this.lastArcShape != null && startX == this.lastArcStartX && startY == this.lastArcStartY && width == this.lastArcWidth && height == this.lastArcHeight && startAngle == this.lastArcStartAngle && arcAngle == this.lastArcAngle) {
            shapeRecords = this.lastArcShape;
        } else {
            double radius = (double)width / 2.0;
            int x1 = startX + (int)Math.abs(radius);
            int y1 = startY + (int)Math.abs(radius);
            int maxPt = (int)((double)arcAngle / (double)ptUnit);
            if (maxPt < 4) {
                maxPt = 4;
            }
            double[][] pts = new double[maxPt][2];
            if (arcAngle == 0) {
                arcAngle = 360;
            }
            double tmpAngle = 0.0;
            for (int i = 0; i < maxPt; ++i) {
                tmpAngle = i == maxPt - 1 ? (double)(arcAngle + startAngle) : (double)i * ((double)arcAngle / (double)maxPt) + (double)startAngle;
                pts[i][0] = Math.cos(FlashGraphics.toRadians(tmpAngle)) * radius + (double)x1;
                pts[i][1] = (double)y1 - Math.sin(FlashGraphics.toRadians(tmpAngle)) * radius;
            }
            shapeRecords = new ArrayList();
            try {
                double[][] controlPt = BezierSpline.getCurveControlPoints(pts);
                shapeRecords.add((FSTransformObject)new FSShapeStyle(1, 1, 0, this.p.getX(x1), this.p.getY(y1)));
                shapeRecords.add(new FSLine(this.p.getX(pts[0][0] - (double)x1), this.p.getY(pts[0][1] - (double)y1)));
                for (int i = 1; i < pts.length; ++i) {
                    double[] currentPoint = pts[i - 1];
                    double[] controlPoint = controlPt[i - 1];
                    double[] anchorPoint = pts[i];
                    shapeRecords.add(new FSCurve(this.p.getX(controlPoint[0]) - this.p.getX(currentPoint[0]), this.p.getY(controlPoint[1]) - this.p.getY(currentPoint[1]), this.p.getX(anchorPoint[0]) - this.p.getX(controlPoint[0]), this.p.getY(anchorPoint[1]) - this.p.getY(controlPoint[1])));
                }
                shapeRecords.add(new FSLine(this.p.getX((double)x1 - pts[pts.length - 1][0]), this.p.getY((double)y1 - pts[pts.length - 1][1])));
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            this.lastArcShape = shapeRecords;
            this.lastArcStartX = startX;
            this.lastArcStartY = startY;
            this.lastArcWidth = width;
            this.lastArcHeight = height;
            this.lastArcStartAngle = startAngle;
            this.lastArcAngle = arcAngle;
        }
        ArrayList lineStyles = FlashGraphics.getLineStyle(1, null);
        ArrayList fillStyles = this.getFillStyle(this.color);
        this.addShape(this.boundingBox, fillStyles, lineStyles, new FSShape(shapeRecords), 0, 0);
    }

    @Override
    public void drawLine(int x1, int y1, int x2, int y2) {
        if (this.recordBuffer == null || !this.isToolTips) {
            if (x1 > this.p.getPixel(this.p.width)) {
                x1 = this.p.getPixel(this.p.width);
            }
            if (x2 > this.p.getPixel(this.p.width)) {
                x2 = this.p.getPixel(this.p.width);
            }
        }
        ArrayList lineStyles = FlashGraphics.getLineStyle(1, this.color);
        ArrayList fillStyles = this.getFillStyle(null);
        ArrayList<Object> shapeRecords2 = new ArrayList<Object>();
        shapeRecords2.add(new FSShapeStyle(1, 1, 0, this.p.getX(x1), this.p.getY(y1)));
        shapeRecords2.add(new FSLine(this.p.getX(x2 - x1), this.p.getY(y2 - y1)));
        this.addShape(this.boundingBox, fillStyles, lineStyles, new FSShape(shapeRecords2), 0, 0);
    }

    @Override
    public void drawString(String str, int x, int y) {
        this.drawString(str, x, y, 0, this.awtColor);
    }

    public void drawString(String str, int x, int y, int angle, Color newColor) {
        if (!this.isLastFrame() && this.chart.is2DimChart()) {
            return;
        }
        if (this.insertingTopLabel && !this.chart.is2DimChart() && !this.isLastFrame()) {
            return;
        }
        if (this.isAddingButtons) {
            newColor = this.chart.flashHintFontColor;
        }
        if (this.recordBuffer != null && this.isToolTips) {
            this.addTooltipText(str, x, y, newColor);
        } else {
            if (x < 0) {
                FontMetrics fm = this.chart.g.getFontMetrics(QbUtil.resizeViewerFont(this.awtFont, this.chart != null ? this.chart.isAdjustFont() : false));
                int orgW = fm.stringWidth(str);
                int orgX = x;
                while (str.length() > 0 && x < 0) {
                    if ((str = str.substring(1)).length() == 0) {
                        return;
                    }
                    x = orgX + (orgW - fm.stringWidth(str));
                }
            }
            if (str.equals("?") && (x < 0 || y < 0)) {
                return;
            }
            if (x > this.p.getPixel(this.p.getWidth()) || y > this.p.getPixel(this.p.getHeight())) {
                return;
            }
            int fsFontSize = Plane.getPoint(this.awtFont.getSize());
            QbFlashTextConstructor textGenerator = this.getTextConstructor(this.awtFont);
            FSDefineText2 label = textGenerator.defineText(this.movie.newIdentifier(), str, fsFontSize, new FSColor(newColor.getRed(), newColor.getGreen(), newColor.getBlue(), newColor.getAlpha()));
            int xOffset = this.p.getX(x);
            int yOffset = this.p.getY(y);
            this.addText(label, xOffset, yOffset, angle);
        }
    }

    private void addTooltipText(String str, int x, int y, Color newColor) {
        if (!this.chart.flashEnableHintBox) {
            return;
        }
        FontMetrics fm = this.chart.cgraphics.component.getFontMetrics(this.awtFont);
        String[] strArray = this.breakTips(str);
        x += fm.stringWidth(str) / 2;
        int fsFontSize = Plane.getPoint(this.awtFont.getSize());
        QbFlashTextConstructor textGenerator = this.getTextConstructor(this.awtFont);
        FSDefineObject[] rows = new FSDefineObject[strArray.length];
        int[] heights = new int[strArray.length];
        int buttonMargin = Plane.getPoint(5);
        int lineSpace = Plane.getPoint(3);
        int buttonHeight = 2 * buttonMargin + (strArray.length - 1) * lineSpace;
        int buttonWidth = 0;
        for (int i = 0; i < strArray.length; ++i) {
            Matcher matcher = IMG_TAG_PATTERN.matcher(strArray[i]);
            if (matcher.matches()) {
                try {
                    DataInputStream is = new ReadDataFile().getInputStream(matcher.group(1));
                    FSImageConstructor imageConstructor = new FSImageConstructor(IOUtil.streamToByteArray(is));
                    buttonWidth = Math.max(Plane.getPoint(imageConstructor.getWidth()), buttonWidth);
                    heights[i] = Plane.getPoint(imageConstructor.getHeight());
                    buttonHeight += heights[i];
                    int imageId = this.movie.newIdentifier();
                    this.addToMovie((FSMovieObject)imageConstructor.defineImage(imageId));
                    rows[i] = imageConstructor.defineEnclosingShape(this.movie.newIdentifier(), imageId, 0, 0, null);
                    continue;
                }
                catch (Exception e) {
                    LOGGER.log(Level.WARNING, "Failed to read image at: " + matcher.group(1), e);
                }
            }
            FSDefineText2 defineText = textGenerator.defineText(this.movie.newIdentifier(), strArray[i], fsFontSize, new FSColor(newColor.getRed(), newColor.getGreen(), newColor.getBlue(), newColor.getAlpha()));
            buttonWidth = Math.max(defineText.getBounds().getWidth(), buttonWidth);
            heights[i] = defineText.getBounds().getHeight();
            buttonHeight += heights[i];
            rows[i] = defineText;
        }
        int xLocation = this.p.getX(x);
        xLocation = this.chart.isVertical() ? (xLocation += buttonWidth / 2) : (xLocation -= (buttonWidth += 2 * buttonMargin) / 2);
        int yLocation = this.p.getY(y);
        int[] coordShift = this.reCalPosition(xLocation, yLocation, buttonWidth, buttonHeight);
        FSCoordTransform clipCoord = new FSCoordTransform(xLocation += coordShift[0], yLocation += coordShift[1]);
        xLocation += buttonMargin - buttonWidth / 2;
        yLocation += buttonMargin - buttonHeight / 2;
        FSCoordTransform[] rowsCoords = new FSCoordTransform[rows.length];
        for (int i = 0; i < rows.length; ++i) {
            this.addToMovie((FSMovieObject)rows[i]);
            rowsCoords[i] = rows[i] instanceof FSDefineText2 ? new FSCoordTransform(xLocation, yLocation + heights[i]) : new FSCoordTransform(xLocation, yLocation + lineSpace / 2);
            yLocation += heights[i] + lineSpace;
        }
        this.repaintPanel();
        int maxLayer = this.findMaxLayer(this.shapeBuffer);
        if (maxLayer < 0) {
            return;
        }
        FSDefineMovieClip clip = new FSDefineMovieClip(this.movie.newIdentifier());
        FSColorTransform invisibleColorTransform = new FSColorTransform(0, 0, 0, -255);
        FSDefineShape2 tips = this.defineTipBox(buttonWidth, buttonHeight);
        clip.add((FSMovieObject)tips);
        clip.add((FSMovieObject)new FSPlaceObject2(tips.getIdentifier(), 1, clipCoord, invisibleColorTransform));
        for (int i = 0; i < rows.length; ++i) {
            clip.add((FSMovieObject)rows[i]);
            clip.add((FSMovieObject)new FSPlaceObject2(rows[i].getIdentifier(), i + 2, rowsCoords[i], invisibleColorTransform));
        }
        ArrayList<FSAction> stopActions = new ArrayList<FSAction>(1);
        stopActions.add(FSAction.Stop());
        FSDoAction stopAction = new FSDoAction(stopActions);
        clip.add((FSMovieObject)stopAction);
        clip.add((FSMovieObject)FSShowFrame.getInstance());
        int step = 51;
        int delta = 0;
        int i = 1;
        while (i < 5) {
            clip.add((FSMovieObject)new FSPlaceObject2(1, new FSColorTransform(0, 0, 0, delta - 255)));
            for (int j = 0; j < rows.length; ++j) {
                clip.add((FSMovieObject)new FSPlaceObject2(j + 2, new FSColorTransform(0, 0, 0, delta - 255)));
            }
            clip.add((FSMovieObject)FSShowFrame.getInstance());
            ++i;
            delta += step;
        }
        clip.add((FSMovieObject)new FSPlaceObject2(1, new FSColorTransform(0, 0, 0, 0)));
        for (int j = 0; j < rows.length; ++j) {
            clip.add((FSMovieObject)new FSPlaceObject2(j + 2, new FSColorTransform(0, 0, 0, 0)));
        }
        clip.add((FSMovieObject)stopAction);
        clip.add((FSMovieObject)FSShowFrame.getInstance());
        this.movie.add((FSMovieObject)clip);
        FSPlaceObject2 clipPlace = new FSPlaceObject2(clip.getIdentifier(), this.tooltipLayer++, 0, 0);
        clipPlace.setName("mc" + maxLayer);
        this.movie.add((FSMovieObject)clipPlace);
    }

    private QbFlashTextConstructor getTextConstructor(Font font) {
        String key = font.getFontName() + "_" + font.getStyle();
        QbFlashTextConstructor textConstructor = this.fontTable.get(key);
        if (textConstructor == null) {
            textConstructor = new QbFlashTextConstructor(this.movie.newIdentifier(), font);
            this.fontTable.put(key, textConstructor);
        }
        return textConstructor;
    }

    @Override
    public void drawString(AttributedCharacterIterator text, int x, int y) {
        LOGGER.log(Level.FINEST, "drawString(java.text.AttributedCharacterIterator,..) not supported");
    }

    @Override
    public void drawRotateString(String str, Font font, Color c, float angle, int x, int y) {
        this.drawString(str, x, y, (int)angle, c);
    }

    @Override
    public void setColor(Color newColor) {
        this.gradientPaint = null;
        if (newColor == null) {
            return;
        }
        this.awtColor = newColor;
        this.pattern = this.awtColor instanceof QbPattern ? ((QbPattern)this.awtColor).getPatternImage() : null;
        this.color = new FSColor(newColor.getRed(), newColor.getGreen(), newColor.getBlue(), (int)((float)newColor.getAlpha() * this.alphaValue));
    }

    @Override
    public void setGradientPaint(GradientPaint gradientPaint) {
        this.gradientPaint = gradientPaint;
    }

    @Override
    public void setComposite(Composite c) {
        this.alphaValue = c instanceof AlphaComposite ? ((AlphaComposite)c).getAlpha() : 1.0f;
    }

    @Override
    public void setFont(Font newFont) {
        if (this.isAddingButtons) {
            return;
        }
        if (newFont == this.awtFont) {
            return;
        }
        if (newFont == null) {
            return;
        }
        if (this.awtFont != null && newFont.getFontName().equals(this.awtFont.getFontName()) && newFont.getSize() == this.awtFont.getSize() && newFont.getStyle() == this.awtFont.getStyle()) {
            return;
        }
        this.awtFont = FontMapping.mapFont(newFont);
        this.fontSize = newFont.getSize();
        if (this.fontSize > 6) {
            this.fontSize -= 2;
        }
    }

    @Override
    public boolean drawImage(Image img, int x, int y, Color bgcolor, ImageObserver observer) {
        return this.drawImage(img, x, y, img.getWidth(observer), img.getHeight(observer), bgcolor, observer);
    }

    @Override
    public boolean drawImage(Image img, int x, int y, ImageObserver observer) {
        return this.drawImage(img, x, y, img.getWidth(observer), img.getHeight(observer), observer);
    }

    @Override
    public boolean drawImage(Image img, int x, int y, int width, int height, Color bgcolor, ImageObserver observer) {
        return this.drawImage(img, x, y, x + width, y + height, 0, 0, img.getWidth(observer), img.getHeight(observer), bgcolor, observer);
    }

    @Override
    public boolean drawImage(Image img, int x, int y, int width, int height, ImageObserver observer) {
        return this.drawImage(img, x, y, x + width, y + height, 0, 0, img.getWidth(observer), img.getHeight(observer), observer);
    }

    @Override
    public boolean drawImage(Image img, int dx1, int dy1, int dx2, int dy2, int sx1, int sy1, int sx2, int sy2, ImageObserver observer) {
        return this.drawImage(img, dx1, dy1, dx2, dy2, sx1, sy1, sx2, sy2, null, observer);
    }

    @Override
    public boolean drawImage(Image img, int dx1, int dy1, int dx2, int dy2, int sx1, int sy1, int sx2, int sy2, Color bgcolor, ImageObserver observer) {
        FSDefineImage2 image = this.defineImage(img, this.movie.newIdentifier());
        ArrayList lineStyles = new ArrayList();
        ArrayList<FSBitmapFill> fillStyles = new ArrayList<FSBitmapFill>();
        this.addToFrame((FSMovieObject)image);
        int imgWidth = Plane.getPoint(image.getWidth());
        int imgHeight = Plane.getPoint(image.getHeight());
        int width = imgWidth;
        int height = imgHeight;
        double scaleX = 1.0;
        double scaleY = 1.0;
        FSCoordTransform composite = new FSCoordTransform(0, 0, 20.0 * scaleX, 20.0 * scaleY);
        fillStyles.add(new FSBitmapFill(65, image.getIdentifier(), composite));
        ArrayList<Object> shapeRecords2 = new ArrayList<Object>();
        shapeRecords2.add(new FSShapeStyle(1, 1, 0, 0, 0));
        shapeRecords2.add(new FSLine(width, 0));
        shapeRecords2.add(new FSLine(0, height));
        shapeRecords2.add(new FSLine(-width, 0));
        shapeRecords2.add(new FSLine(0, -height));
        this.addShape(this.boundingBox, fillStyles, lineStyles, new FSShape(shapeRecords2), dx1, dy1);
        return true;
    }

    @Override
    public void drawImage(URL fullURL, int display_option, int x, int y, int width, int height) throws DataFormatException {
        ByteArrayOutputStream out;
        try {
            InputStream is = fullURL.openStream();
            out = new ByteArrayOutputStream(is.available());
            IOUtil.copyStream(is, out);
        }
        catch (IOException e) {
            e.printStackTrace();
            return;
        }
        this.drawImage(out.toByteArray(), display_option, x, y, width, height);
    }

    @Override
    public void drawImage(byte[] byteArray, int displayOption, int x, int y, int width, int height) throws DataFormatException {
        int fillStyle;
        FSCoordTransform transform;
        double scaleY;
        double scaleX;
        FSImageConstructor imageConstructor;
        try {
            imageConstructor = new FSImageConstructor(byteArray);
        }
        catch (DataFormatException e) {
            try {
                ByteArrayInputStream is = new ByteArrayInputStream(byteArray);
                ByteArrayOutputStream out = new ByteArrayOutputStream(byteArray.length);
                BufferedImage bu = ImageIO.read(is);
                ImageIO.write((RenderedImage)bu, "png", out);
                imageConstructor = new FSImageConstructor(out.toByteArray());
            }
            catch (Exception e1) {
                throw new DataFormatException("Failed to convert image to PNG.");
            }
        }
        int imageId = this.movie.newIdentifier();
        FSDefineObject image = imageConstructor.defineImage(imageId);
        this.addToFrame((FSMovieObject)image);
        int imageWidth = imageConstructor.getWidth();
        int imageHeight = imageConstructor.getHeight();
        if (displayOption == 1) {
            scaleX = (double)width / (double)imageWidth * 20.0;
            scaleY = (double)height / (double)imageHeight * 20.0;
        } else if (imageWidth > width || imageHeight > height) {
            if (imageWidth <= width || imageWidth >= width && imageHeight >= height && imageHeight * width >= imageWidth * height) {
                scaleX = (double)height * (double)imageWidth / (double)imageHeight / (double)imageWidth * 20.0;
                scaleY = (double)height / (double)imageHeight * 20.0;
            } else {
                scaleX = (double)width / (double)imageWidth * 20.0;
                scaleY = (double)width * (double)imageHeight / (double)imageWidth / (double)imageHeight * 20.0;
            }
            imageWidth = width;
            imageHeight = height;
        } else {
            scaleX = 20.0;
            scaleY = 20.0;
        }
        if (displayOption == 0) {
            transform = new FSCoordTransform(0, 0, scaleX, scaleY);
            fillStyle = 65;
            x += (width - imageWidth) / 2;
            y += (height - imageHeight) / 2;
            width = imageWidth;
            height = imageHeight;
        } else if (displayOption == 2) {
            transform = new FSCoordTransform(0, 0, 20.0, 20.0);
            fillStyle = 64;
        } else {
            transform = new FSCoordTransform(0, 0, scaleX, scaleY);
            fillStyle = 65;
        }
        FSShape shape = new FSShape();
        shape.add((FSTransformObject)new FSShapeStyle(0, 1, 0, 0, 0));
        shape.add((FSTransformObject)new FSLine(width * 20, 0));
        shape.add((FSTransformObject)new FSLine(0, height * 20));
        shape.add((FSTransformObject)new FSLine(-width * 20, 0));
        shape.add((FSTransformObject)new FSLine(0, -height * 20));
        ArrayList lineStyles = new ArrayList();
        ArrayList<FSBitmapFill> fillStyles = new ArrayList<FSBitmapFill>();
        fillStyles.add(new FSBitmapFill(fillStyle, imageId, transform));
        this.addShape(this.boundingBox, fillStyles, lineStyles, shape, x, y);
    }

    @Override
    public void clearRect(int x, int y, int width, int height) {
        Color background = new Color(255, 255, 255);
        FSColor old = this.color;
        this.setColor(background);
        this.fillRect(x, y, width, height);
        this.color = old;
    }

    @Override
    public void clipRect(int x, int y, int width, int height) {
        LOGGER.log(Level.FINEST, "clipRect not supported");
    }

    @Override
    public void copyArea(int x, int y, int width, int height, int dx, int dy) {
        LOGGER.log(Level.FINEST, "copyArea not supported");
    }

    @Override
    public Graphics create() {
        LOGGER.log(Level.FINEST, "create() not supported");
        return null;
    }

    @Override
    public Graphics create(int x, int y, int width, int height) {
        LOGGER.log(Level.FINEST, "create(int x, int y, int width, int height) not supported");
        return null;
    }

    @Override
    public void dispose() {
        this.color = null;
        this.awtColor = null;
        this.awtFont = null;
        this.p = null;
        this.movie = null;
        this.currentBlock = null;
        this.boundingBox = null;
        this.frames = null;
        this.currentFrame = null;
        this.recordBuffer = null;
        this.shapeBuffer = null;
        this.fontTable = null;
        this.toolTipsKeys = null;
        this.toolTipsValues = null;
        this.toolTipsShapes = null;
        this.lastArcShape = null;
        this.pattern = null;
        this.gradientPaint = null;
        this.chartFile = null;
        this.servletLoc = null;
        this.optionParam = null;
        this.prevDrillData = null;
    }

    @Override
    public Shape getClip() {
        LOGGER.log(Level.FINEST, "getClip() not supported");
        return null;
    }

    @Override
    public Rectangle getClipRect() {
        LOGGER.log(Level.FINEST, "getClipRect() not supported");
        return null;
    }

    @Override
    public Rectangle getClipBounds() {
        LOGGER.log(Level.FINEST, "getClipBounds() not supported");
        return null;
    }

    @Override
    public Font getFont() {
        return this.awtFont;
    }

    @Override
    public Color getColor() {
        return this.awtColor;
    }

    @Override
    public FontMetrics getFontMetrics(Font f) {
        return Toolkit.getDefaultToolkit().getFontMetrics(f);
    }

    @Override
    public void setClip(int x, int y, int width, int height) {
        LOGGER.log(Level.FINEST, "setClipBounds(int x, int y, int width, int height) not supported");
    }

    @Override
    public void setClip(Shape clip) {
        LOGGER.log(Level.FINEST, "setClipBounds(java.awt.Shape clip) not supported");
    }

    @Override
    public void setPaintMode() {
        LOGGER.log(Level.FINEST, "setPaintMode not supported");
    }

    @Override
    public void setXORMode(Color c1) {
        LOGGER.log(Level.FINEST, "setXORMode not supported");
    }

    @Override
    public void translate(int x, int y) {
        LOGGER.log(Level.FINEST, "translate not supported");
    }

    private void setBestQuality() {
        ArrayList<Object> actions = new ArrayList<Object>();
        actions.add(new FSPush("this"));
        actions.add(FSAction.GetVariable());
        actions.add(new FSPush("_quality"));
        actions.add(new FSPush("best"));
        actions.add(FSAction.SetAttribute());
        FSDoAction frameAction = new FSDoAction(actions);
        this.addToFrame((FSMovieObject)frameAction);
    }

    private void stopAnimation() {
        ArrayList<FSAction> actions = new ArrayList<FSAction>();
        actions.add(new FSAction(7));
        FSDoAction frameAction = new FSDoAction(actions);
        this.addToFrame((FSMovieObject)frameAction);
        this.addToFrame((FSMovieObject)new FSShowFrame());
    }

    @Override
    public void export(OutputStream out) throws Exception {
        Enumeration<String> keys = this.fontTable.keys();
        while (keys.hasMoreElements()) {
            String key = keys.nextElement();
            this.addToMovie((FSMovieObject)this.fontTable.get(key).defineFont());
        }
        this.setBestQuality();
        for (int i = 0; i < this.frames.length; ++i) {
            int j;
            for (j = 0; j < this.frames[i].size(); ++j) {
                this.movie.add(this.frames[i].get(j));
            }
            this.movie.add((FSMovieObject)new FSShowFrame());
            if (i == this.frames.length - 1) continue;
            for (j = 0; j < this.frames[i].size(); ++j) {
                if (!(this.frames[i].get(j) instanceof FSPlaceObject2)) continue;
                this.movie.add((FSMovieObject)new FSRemoveObject2(((FSPlaceObject2)this.frames[i].get(j)).getLayer()));
            }
        }
        this.stopAnimation();
        if (out == null) {
            return;
        }
        out.write(this.movie.encode());
        out.flush();
        if (this.layer > 50000) {
            throw new Exception(LanguageEncoder.getText("This Flash output has reached the max number of layers in Flash file. Some objects may be missing."));
        }
        if (this.tooltipLayer > 65536) {
            throw new Exception(LanguageEncoder.getText("This flash output can't display more than 15000 data points.  It may causes missing hintbox for some data"));
        }
    }

    @Override
    public void draw(Shape shape) {
        this.traceAwtShape(shape, false, 1);
    }

    public void draw(Shape shape, int thickness) {
        this.traceAwtShape(shape, false, thickness);
    }

    @Override
    public void fill(Shape shape) {
        this.traceAwtShape(shape, true, 1);
    }

    private void traceAwtShape(Shape shape, boolean isFill, int thickness) {
        QbFlashShapeConstructor path = new QbFlashShapeConstructor();
        path.newPath();
        if (isFill) {
            path.setFillStyles(this.getFillStyle(this.color));
            path.selectFillStyle(0);
        } else {
            FSColor noAlphaColor = new FSColor(this.color.getRed(), this.color.getGreen(), this.color.getBlue());
            path.setLineStyles(FlashGraphics.getLineStyle(thickness, noAlphaColor));
            path.selectLineStyle(0);
        }
        PathIterator it = shape.getPathIterator(null);
        float[] af = new float[6];
        while (!it.isDone()) {
            switch (it.currentSegment(af)) {
                case 4: {
                    path.closePath();
                    break;
                }
                case 0: {
                    path.move(this.p.getX(af[0]), this.p.getY(af[1]));
                    break;
                }
                case 1: {
                    path.line(this.p.getX(af[0]), this.p.getY(af[1]));
                    break;
                }
                case 2: {
                    path.curve(this.p.getX(af[0]), this.p.getY(af[1]), this.p.getX(af[2]), this.p.getY(af[3]));
                    break;
                }
                case 3: {
                    path.curve(this.p.getX(af[0]), this.p.getY(af[1]), this.p.getX(af[2]), this.p.getY(af[3]), this.p.getX(af[4]), this.p.getY(af[5]));
                }
            }
            it.next();
        }
        this.addShape(this.boundingBox, path.getFillStyles(), path.getLineStyles(), path.shape(), 0, 0);
    }

    @Override
    public void setToolTipsAndLink(Object data) {
        if (data == null) {
            return;
        }
        if (this.isLastFrame()) {
            this.recordBuffer = this.getToolTipsValue(data);
            this.shapeBuffer = this.getToolTipsShape(data);
            if (this.recordBuffer == null) {
                this.recordBuffer = new ArrayList();
                this.shapeBuffer = new ArrayList();
                this.toolTipsKeys.add(data);
                this.toolTipsValues.add(this.recordBuffer);
                this.toolTipsShapes.add(this.shapeBuffer);
            }
        }
    }

    @Override
    public void setTopLabels() {
        this.insertingTopLabel = true;
        if (this.isLastFrame() && this.recordBuffer == null) {
            this.recordBuffer = new ArrayList();
            this.shapeBuffer = new ArrayList();
            this.toolTipsKeys.add(new Object());
            this.toolTipsValues.add(this.recordBuffer);
            this.toolTipsShapes.add(this.shapeBuffer);
        }
    }

    @Override
    public boolean isDrawingTopLabels() {
        return this.insertingTopLabel;
    }

    @Override
    public void setAxes() {
        if (this.isLastFrame() && this.recordBuffer == null) {
            this.recordBuffer = new ArrayList();
            this.shapeBuffer = new ArrayList();
            this.toolTipsKeys.add(new Object());
            this.toolTipsValues.add(this.recordBuffer);
            this.toolTipsShapes.add(this.shapeBuffer);
        }
    }

    private ArrayList<FSButton> getToolTipsValue(Object data) {
        if (this.chart.getChartType() == 8 && !this.chart.is2DimChart()) {
            if (this.toolTipsKeys.size() > 0 && this.toolTipsKeys.get(this.toolTipsKeys.size() - 1) == data) {
                return this.toolTipsValues.get(this.toolTipsKeys.size() - 1);
            }
        } else {
            for (int i = 0; i < this.toolTipsKeys.size(); ++i) {
                if (this.toolTipsKeys.get(i) != data) continue;
                return this.toolTipsValues.get(i);
            }
        }
        return null;
    }

    private ArrayList<LayerObject> getToolTipsShape(Object data) {
        if (this.chart.getChartType() == 8 && !this.chart.is2DimChart()) {
            if (this.toolTipsKeys.size() > 0 && this.toolTipsKeys.get(this.toolTipsKeys.size() - 1) == data) {
                return this.toolTipsShapes.get(this.toolTipsKeys.size() - 1);
            }
        } else {
            for (int i = 0; i < this.toolTipsKeys.size(); ++i) {
                if (this.toolTipsKeys.get(i) != data) continue;
                return this.toolTipsShapes.get(i);
            }
        }
        return null;
    }

    @Override
    public void resetToolTipsAndLink() {
        this.recordBuffer = null;
        this.shapeBuffer = null;
    }

    @Override
    public void resetAxes() {
        this.recordBuffer = null;
        this.shapeBuffer = null;
    }

    @Override
    public void resetTopLabels() {
        this.insertingTopLabel = false;
        if (!this.isLastFrame()) {
            return;
        }
        this.recordBuffer = null;
        this.shapeBuffer = null;
    }

    @Override
    public void resetBuffer() {
        if (this.frames != null) {
            this.recordBuffer = null;
            this.shapeBuffer = null;
            this.toolTipsKeys = new ArrayList();
            this.toolTipsValues = new ArrayList();
            this.toolTipsShapes = new ArrayList();
            this.initFrameSet(this.frames.length);
        }
    }

    private void addToFrame(FSMovieObject obj) {
        if (this.currentFrame != null) {
            this.currentFrame.add(obj);
        } else {
            this.movie.add(obj);
        }
    }

    private boolean isLastFrame() {
        if (this.frames == null || this.currentFrame == null) {
            return true;
        }
        return this.frames[this.frames.length - 1] == this.currentFrame;
    }

    private void addToMovie(FSMovieObject obj) {
        this.movie.add(obj);
    }

    private FSCurve drawCurve(int startX, int startY, int w, int h) {
        int endX = startX + w;
        int endY = startY + h;
        int contX = 0;
        int contY = 0;
        if (w > 0 && h > 0) {
            contX = (int)Math.round((double)startX + 0.92 * (double)w);
            contY = (int)Math.round((double)(startY + h) - 0.92 * (double)h);
        } else if (w < 0 && h > 0) {
            contX = (int)Math.round((double)(startX + w) - 0.92 * (double)w);
            contY = (int)Math.round((double)startY + 0.92 * (double)h);
        } else if (w < 0 && h < 0) {
            contX = (int)Math.round((double)startX + 0.92 * (double)w);
            contY = (int)Math.round((double)(startY + h) - 0.92 * (double)h);
        } else if (w > 0 && h < 0) {
            contX = (int)Math.round((double)(startX + w) - 0.92 * (double)w);
            contY = (int)Math.round((double)startY + 0.92 * (double)h);
        }
        return new FSCurve(contX, contY, endX -= (contX -= startX), endY -= (contY -= startY));
    }

    private void addText(FSDefineText2 label, int xLocation, int yLocation, int angle) {
        int dx = this.getDxForText(label.getBounds(), angle %= 360);
        int dy = this.getDyForText(label.getBounds(), angle);
        if (this.currentBlock != null) {
            LayerObject layerObj = new LayerObject(label, this.layer++, xLocation + dx, yLocation + dy, angle);
            this.currentBlock.addLayer(layerObj);
        } else {
            LayerObject layerObj = new LayerObject(label, this.layer++, xLocation + dx, yLocation + dy, angle);
            if (this.recordBuffer != null) {
                this.shapeBuffer.add(layerObj);
            }
            if (this.insertingTopLabel && this.isLastFrame()) {
                this.addToFrame((FSMovieObject)label);
                this.addToFrame((FSMovieObject)layerObj.getPlaceObject());
            } else if (!this.insertingTopLabel && !this.chart.is2DimChart()) {
                this.addToFrame((FSMovieObject)label);
                this.addToFrame((FSMovieObject)layerObj.getPlaceObject());
            } else {
                this.addToMovie((FSMovieObject)label);
                this.addToMovie((FSMovieObject)layerObj.getPlaceObject());
            }
            ++this.layer;
        }
    }

    private int getDxForText(FSBounds bounds, int angle) {
        if (angle <= 45) {
            return 0;
        }
        if (angle <= 90) {
            return bounds.getHeight() / 2;
        }
        if (angle <= 225) {
            return bounds.getWidth();
        }
        if (angle <= 270) {
            return bounds.getHeight();
        }
        if (angle <= 300) {
            return 0;
        }
        if (angle <= 315) {
            return bounds.getHeight();
        }
        if (angle <= 320) {
            return bounds.getHeight() + bounds.getHeight() * 2;
        }
        return 0;
    }

    private int getDyForText(FSBounds bounds, int angle) {
        if (angle <= 12) {
            return 0;
        }
        if (angle <= 15) {
            return bounds.getHeight() / 2;
        }
        if (angle <= 180) {
            return 0;
        }
        if (angle <= 270) {
            return bounds.getWidth();
        }
        if (angle <= 300) {
            return bounds.getHeight();
        }
        if (angle <= 315) {
            return bounds.getWidth() / 2 + bounds.getHeight();
        }
        if (angle <= 320) {
            return bounds.getWidth() / 2 + bounds.getHeight() * 2;
        }
        if (angle <= 345) {
            return bounds.getWidth() / 2;
        }
        return 0;
    }

    private int[] reCalPosition(int x, int y, int w, int h) {
        int offsetX = 0;
        int offsetY = 0;
        y -= h / 2;
        if ((x -= w / 2) < 0) {
            offsetX = -x + 60;
        }
        if (x + w > this.p.getWidth()) {
            offsetX = this.p.getWidth() - (x + w) - 60;
        }
        if (y < 0) {
            offsetY = -y + 60;
        }
        if (y + h > this.p.getHeight()) {
            offsetY = this.p.getHeight() - (y + h) - 60;
        }
        return new int[]{offsetX, offsetY};
    }

    private String[] breakTips(String str) {
        int startIndex;
        String[] st = str.split("\u001d\\(|\u001d\\/");
        Vector<String> vec = new Vector<String>();
        for (int i = startIndex = st[0].length() > 0 ? 0 : 1; i < st.length; ++i) {
            Matcher matcher = IMG_TAG_PATTERN.matcher(st[i]);
            int lastEnd = 0;
            while (matcher.find()) {
                vec.add(st[i].substring(lastEnd, matcher.start()));
                vec.add(matcher.group());
                lastEnd = matcher.end();
            }
            vec.add(st[i].substring(lastEnd));
        }
        String[] res = new String[vec.size()];
        for (int i = 0; i < vec.size(); ++i) {
            String temp = (String)vec.elementAt(i);
            res[i] = temp = temp.replaceFirst("\\)\u001d", " : ");
        }
        return res;
    }

    private int findMaxLayer(ArrayList list) {
        if (list == null || list.size() == 0) {
            return -1;
        }
        int maxLayer = 0;
        for (LayerObject element : this.shapeBuffer) {
            LayerObject layerObject = element;
            if (layerObject.getLayer() <= maxLayer) continue;
            maxLayer = layerObject.getLayer();
        }
        return maxLayer;
    }

    private FSDefineShape2 defineTipBox(int buttonWidth, int buttonHeight) {
        int lineWidth = 20;
        QbFlashShapeConstructor path = new QbFlashShapeConstructor();
        path.add((FSLineStyle)new FSSolidLine(lineWidth, new FSColor(this.chart.flashHintBorderColor.getRed(), this.chart.flashHintBorderColor.getGreen(), this.chart.flashHintBorderColor.getBlue())));
        path.add((FSFillStyle)new FSSolidFill(new FSColor(this.chart.flashHintBgColor.getRed(), this.chart.flashHintBgColor.getGreen(), this.chart.flashHintBgColor.getBlue())));
        path.rect(0, 0, buttonWidth, buttonHeight);
        return path.defineShape(this.movie.newIdentifier());
    }

    private void addButtons() {
        if (this.toolTipsKeys == null) {
            return;
        }
        Font backupFont = this.awtFont;
        Color backupFontColor = this.awtColor;
        this.setFont(FontMapping.mapFont(QbUtil.resizeViewerFont(this.chart.flashHintFont, this.chart != null ? this.chart.isAdjustFont() : false)));
        this.setColor(this.chart.flashHintFontColor);
        this.isAddingButtons = true;
        int cutOffThreshold = this.chart.getCutOffThresholdForText();
        if (cutOffThreshold >= 0) {
            this.chart.setCutOffThresholdForText(-1);
        }
        for (int i = 0; i < this.toolTipsKeys.size(); ++i) {
            this.addButton(this.toolTipsKeys.get(i), this.toolTipsValues.get(i), this.toolTipsShapes.get(i));
        }
        if (cutOffThreshold >= 0) {
            this.chart.setCutOffThresholdForText(cutOffThreshold);
        }
        this.setFont(backupFont);
        this.setColor(backupFontColor);
        this.isAddingButtons = false;
    }

    private void repaintPanel() {
        if (this.toolTipsValues == null) {
            return;
        }
        boolean repaintWholeChart = false;
        if (!this.chart.is2DimChart() && this.chart.getDataDimension() > 1 && this.chart.getChartType() != 6 && this.chart.getChartType() != 20) {
            repaintWholeChart = true;
        }
        if (!repaintWholeChart) {
            return;
        }
        int index = 0;
        for (int i = 0; i < this.toolTipsValues.size(); ++i) {
            if (this.toolTipsValues.get(i) == this.recordBuffer) {
                while (index < this.recordBuffer.size()) {
                    FSButton button = this.recordBuffer.get(index);
                    button.setLayer(index);
                    ++index;
                }
                continue;
            }
            ArrayList<LayerObject> list = this.toolTipsShapes.get(i);
            for (int j = 0; j < list.size(); ++j) {
                LayerObject layerObject = list.get(j);
                if (layerObject.getShape() != null) {
                    FSDefineShape3 shape = layerObject.getShape();
                    this.recordBuffer.add(index, new FSButton(2, shape.getIdentifier(), index));
                    ++index;
                    continue;
                }
                FSDefineText2 text = layerObject.getText();
                this.recordBuffer.add(index, new FSButton(2, text.getIdentifier(), index, layerObject.getCoordTransform()));
                ++index;
            }
        }
    }

    private HyperLink getLink(MultiDimData data) {
        HyperLink link = CGraphics.getLink(data, false);
        if (!CGraphics.drillDownMap && !CGraphics.fieldDrillDownMap) {
            return link;
        }
        if (this.servletLoc == null) {
            return link;
        }
        String nodeLink = link.link;
        if (CGraphics.drillDownMap) {
            nodeLink = this.prevDrillData + link.link;
            nodeLink = "&PARAM=" + QbUtil.encodeURIComponent(nodeLink);
        }
        if (this.servletLoc.indexOf(63) < 0) {
            this.servletLoc = this.servletLoc + "?";
        }
        if (!this.servletLoc.endsWith("?")) {
            this.servletLoc = this.servletLoc + "&";
        }
        link.link = nodeLink = this.servletLoc + "FILENAME=" + this.chartFile + nodeLink + this.optionParam;
        return link;
    }

    private void addButton(Object key, ArrayList<FSButton> rec, ArrayList<LayerObject> rec2) {
        if (!(key instanceof MultiDimData)) {
            return;
        }
        HyperLink link = this.getLink((MultiDimData)key);
        this.shapeBuffer = rec2;
        if (this.chart.isCircularChart()) {
            this.recordBuffer = rec;
            this.isToolTips = true;
            boolean showLabel = ((IPieChart)((Object)this.chart)).getPieChart().showLabel;
            boolean showValue = ((IPieChart)((Object)this.chart)).getPieChart().showValue;
            boolean showPercent = ((IPieChart)((Object)this.chart)).getPieChart().showPercent;
            boolean labelAtTheSide = ((IPieChart)((Object)this.chart)).getPieChart().labelAtTheSide;
            boolean pieExtendLine = ((IPieChart)((Object)this.chart)).getPieChart().pieExtendLine;
            boolean pieLabelWithDirection = ((IPieChart)((Object)this.chart)).getPieChart().pieLabelWithDirection;
            ((IPieChart)((Object)this.chart)).getPieChart().showLabel = true;
            ((IPieChart)((Object)this.chart)).getPieChart().showValue = false;
            ((IPieChart)((Object)this.chart)).getPieChart().showPercent = false;
            ((IPieChart)((Object)this.chart)).getPieChart().labelAtTheSide = false;
            ((IPieChart)((Object)this.chart)).getPieChart().pieExtendLine = false;
            ((IPieChart)((Object)this.chart)).getPieChart().pieLabelWithDirection = false;
            Font backupFont = this.awtFont;
            Color backupFontColor = this.awtColor;
            this.setFont(FontMapping.mapFont(QbUtil.resizeViewerFont(this.chart.flashHintFont, this.chart != null ? this.chart.isAdjustFont() : false)));
            this.setColor(this.chart.flashHintFontColor);
            ((IPieChart)((Object)this.chart)).getPieChart().drawLabel(this.chart.cgraphics, (MultiDimData)key, link.hint);
            this.setFont(backupFont);
            this.setColor(backupFontColor);
            rec = this.recordBuffer;
            this.recordBuffer = null;
            this.isToolTips = false;
            ((IPieChart)((Object)this.chart)).getPieChart().showLabel = showLabel;
            ((IPieChart)((Object)this.chart)).getPieChart().showValue = showValue;
            ((IPieChart)((Object)this.chart)).getPieChart().showPercent = showPercent;
            ((IPieChart)((Object)this.chart)).getPieChart().labelAtTheSide = labelAtTheSide;
            ((IPieChart)((Object)this.chart)).getPieChart().pieExtendLine = pieExtendLine;
            ((IPieChart)((Object)this.chart)).getPieChart().pieLabelWithDirection = pieLabelWithDirection;
        } else {
            CString label = ((MultiDimData)key).flashLabel;
            if (label == null || this.chart.chartType == 7) {
                label = ((MultiDimData)key).topLabel;
            }
            if (label != null) {
                String orgLabelStr = label.str;
                if (link != null && link.hint != null) {
                    label.str = link.hint;
                }
                Font backupFont = label.font;
                Color backupFontColor = label.color;
                label.setFont(FontMapping.mapFont(QbUtil.resizeViewerFont(this.chart.flashHintFont, this.chart != null ? this.chart.isAdjustFont() : false)));
                label.color = this.chart.flashHintFontColor;
                boolean state = label.bshow;
                int labelAlignment = this.chart.topLabel_Alignment;
                label.bshow = true;
                this.recordBuffer = rec;
                this.isToolTips = true;
                if (this.chart.isHiLow()) {
                    this.chart.topLabel_Alignment = 0;
                } else if (this.chart.chartType == 11 && !state && this.chart.topLabel_Alignment != 1) {
                    this.chart.topLabel_Alignment = 1;
                    this.chart.computeCoord(this.chart.cgraphics, this.chart.chartxorigin, this.chart.chartxorigin + this.chart.chartwidth, this.chart.chartyorigin, this.chart.chartheight + this.chart.chartyorigin);
                }
                if (this.chart.is2DimChart()) {
                    label.draw(this.chart.cgraphics);
                } else {
                    Vertex v = new Vertex();
                    int oldx = label.pos.x;
                    v.x = oldx;
                    int oldy = label.pos.y;
                    v.y = oldy;
                    int oldz = label.pos.z;
                    v.z = oldz;
                    ((Space)this.chart.getSpace()).transform(v);
                    label.pos.x = v.screen_x;
                    label.pos.y = this.chart.cgraphics.height - v.screen_y;
                    label.draw(this.chart.cgraphics);
                    label.pos.x = oldx;
                    label.pos.y = oldy;
                    label.pos.z = oldz;
                }
                rec = this.recordBuffer;
                this.recordBuffer = null;
                this.isToolTips = false;
                label.bshow = state;
                label.str = orgLabelStr;
                this.chart.topLabel_Alignment = labelAlignment;
                label.setFont(backupFont);
                label.color = backupFontColor;
            }
        }
        int maxLayer = this.findMaxLayer(rec2);
        if (maxLayer < 0) {
            return;
        }
        String clipName = "mc" + maxLayer;
        ArrayList<Object> overActions = new ArrayList<Object>();
        overActions.add(new FSPush(2));
        overActions.add(new FSPush(1));
        overActions.add(new FSPush(clipName));
        overActions.add(FSAction.GetVariable());
        overActions.add(new FSPush("gotoAndPlay"));
        overActions.add(FSAction.ExecuteMethod());
        ArrayList<Object> outActions = new ArrayList<Object>();
        outActions.add(new FSPush(1));
        outActions.add(new FSPush(1));
        outActions.add(new FSPush(clipName));
        outActions.add(FSAction.GetVariable());
        outActions.add(new FSPush("gotoAndStop"));
        outActions.add(FSAction.ExecuteMethod());
        ArrayList<Object> clickActions = new ArrayList<Object>();
        if (link != null && link.link != null && !link.link.equals("")) {
            clickActions.add(new FSGetUrl(link.link, link.target));
            clickActions.addAll(outActions);
        }
        ArrayList<FSButtonEvent> events = new ArrayList<FSButtonEvent>();
        events.add(new FSButtonEvent(1, overActions));
        events.add(new FSButtonEvent(2, outActions));
        events.add(new FSButtonEvent(4, clickActions));
        FSDefineButton2 button = new FSDefineButton2(this.movie.newIdentifier(), 0, rec, events);
        this.addToFrame((FSMovieObject)button);
        this.addToFrame((FSMovieObject)new FSPlaceObject2(button.getIdentifier(), maxLayer + 1, this.p.getX(0), this.p.getY(0)));
    }

    private void addShape(FSBounds bounds2, ArrayList fillStyles, ArrayList lineStyles, FSShape shapeRecords2, int x, int y) {
        FSDefineShape3 shape = new FSDefineShape3(this.movie.newIdentifier(), bounds2, fillStyles, lineStyles, shapeRecords2);
        LayerObject layerObj = new LayerObject(shape, this.layer++, this.p.getX(x), this.p.getY(y));
        if (this.recordBuffer != null && this.isLastFrame()) {
            FSDefineShape3 shape_OVER = new FSDefineShape3(this.movie.newIdentifier(), bounds2, this.getSelectedFillStyles(fillStyles), this.getSelectedLineStyles(lineStyles), shapeRecords2);
            this.shapeBuffer.add(layerObj);
            this.recordBuffer.add(new FSButton(8, shape.getIdentifier(), this.recordBuffer.size()));
            this.recordBuffer.add(new FSButton(2, shape_OVER.getIdentifier(), this.recordBuffer.size()));
            this.recordBuffer.add(new FSButton(4, shape_OVER.getIdentifier(), this.recordBuffer.size()));
            this.addToFrame((FSMovieObject)shape_OVER);
            this.addToFrame((FSMovieObject)layerObj.getShape());
            this.addToFrame((FSMovieObject)layerObj.getPlaceObject());
            ++this.layer;
        } else if (this.currentBlock != null) {
            this.currentBlock.addLayer(layerObj);
        } else {
            this.addToFrame((FSMovieObject)layerObj.getShape());
            this.addToFrame((FSMovieObject)layerObj.getPlaceObject());
            ++this.layer;
        }
    }

    private static int absAngle(int angle) {
        while (angle < 0) {
            angle += 360;
        }
        while (angle > 360) {
            angle -= 360;
        }
        return angle;
    }

    private static double toRadians(double degree) {
        return degree * Math.PI / 180.0;
    }

    private byte[] zip(byte[] image) {
        Deflater deflater = new Deflater();
        deflater.setInput(image);
        deflater.finish();
        byte[] compressedData = new byte[image.length];
        int bytesCompressed = deflater.deflate(compressedData);
        byte[] newData = new byte[bytesCompressed];
        for (int i = 0; i < bytesCompressed; ++i) {
            newData[i] = compressedData[i];
        }
        return newData;
    }

    private byte[] imageToByte(Image img, int width, int height) {
        BufferedImage bu = Pictures.toBufferedImage(img);
        int[] rgb = new int[width * height];
        rgb = bu.getRGB(0, 0, width, height, rgb, 0, width);
        byte[] imgBytes = new byte[rgb.length * 4];
        int ct = 0;
        for (int element : rgb) {
            Color c = new Color(element, true);
            imgBytes[ct] = (byte)c.getAlpha();
            imgBytes[++ct] = (byte)c.getRed();
            imgBytes[++ct] = (byte)c.getGreen();
            imgBytes[++ct] = (byte)c.getBlue();
            ++ct;
        }
        return imgBytes;
    }

    private FSDefineImage2 defineImage(Image image, int identifier) {
        try {
            int width = image.getWidth(null);
            int height = image.getHeight(null);
            byte[] img = this.imageToByte(image, width, height);
            img = this.zip(img);
            FSDefineImage2 defIm = new FSDefineImage2(identifier, width, height, img);
            return defIm;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    private static ArrayList getLineStyle(int thickness, FSColor borderColor) {
        ArrayList<FSSolidLine> lineStyles = new ArrayList<FSSolidLine>();
        if (borderColor != null) {
            lineStyles.add(new FSSolidLine(Plane.getPoint(thickness), borderColor));
        }
        return lineStyles;
    }

    private FSColor toFSColor(Color c) {
        return new FSColor(c.getRed(), c.getGreen(), c.getBlue(), (int)((float)c.getAlpha() * this.alphaValue));
    }

    private ArrayList getFillStyle(FSColor fillColor) {
        ArrayList<Object> fillStyles = new ArrayList<Object>();
        if (fillColor == null) {
            return fillStyles;
        }
        try {
            if (this.pattern != null) {
                ByteArrayOutputStream out = new ByteArrayOutputStream(1024);
                ImageWriter writer = ImageIO.getImageWritersByFormatName("jpeg").next();
                ImageWriteParam iwp = writer.getDefaultWriteParam();
                iwp.setCompressionMode(2);
                iwp.setCompressionQuality(1.0f);
                writer.setOutput(new MemoryCacheImageOutputStream(out));
                IIOImage ioimage = new IIOImage(this.pattern, null, null);
                writer.write(null, ioimage, iwp);
                writer.dispose();
                int imageId = this.movie.newIdentifier();
                this.movie.add((FSMovieObject)new FSDefineJPEGImage2(imageId, out.toByteArray()));
                FSCoordTransform composite = new FSCoordTransform(Plane.getPoint(-this.pattern.getWidth()) / 2, Plane.getPoint(-this.pattern.getHeight()) / 2, 20.0, 20.0);
                fillStyles.add(new FSBitmapFill(64, imageId, composite));
                return fillStyles;
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        if (this.gradientPaint != null) {
            int cycles = this.gradientPaint.isCyclic() ? 5 : 1;
            Point2D p1 = this.gradientPaint.getPoint1();
            Point2D p2 = this.gradientPaint.getPoint2();
            int x1 = this.p.getX(p1.getX());
            int x2 = this.p.getX(p2.getX());
            int y1 = this.p.getY(p1.getY());
            int y2 = this.p.getY(p2.getY());
            double angle = Math.toDegrees(Math.atan2(y2 - y1, x2 - x1));
            double l = Math.sqrt(Math.pow(x2 - x1, 2.0) + Math.pow(y2 - y1, 2.0));
            FSCoordTransform transform = new FSCoordTransform();
            transform.translate((x1 + x2) / 2, (y1 + y2) / 2);
            transform.rotate(angle);
            transform.scale((double)cycles * l / 32768.0, 1.0);
            ArrayList<FSGradient> gradientRecord = new ArrayList<FSGradient>();
            FSColor fsColor1 = this.toFSColor(this.gradientPaint.getColor1());
            FSColor fsColor2 = this.toFSColor(this.gradientPaint.getColor2());
            for (int i = 0; i <= cycles; ++i) {
                gradientRecord.add(new FSGradient(i * 255 / cycles, i % 2 == 0 ? fsColor1 : fsColor2));
            }
            fillStyles.add(new FSGradientFill(16, transform, gradientRecord));
        } else {
            fillStyles.add(new FSSolidFill(fillColor));
        }
        return fillStyles;
    }

    private ArrayList getSelectedLineStyles(ArrayList lineStyles) {
        if (lineStyles != null) {
            ArrayList<Object> newLineStyles = new ArrayList<Object>();
            for (int i = 0; i < lineStyles.size(); ++i) {
                Object obj = lineStyles.get(i);
                if (obj instanceof FSSolidLine) {
                    FSSolidLine newLine = new FSSolidLine(((FSSolidLine)obj).getWidth(), this.getHighlightColor(((FSSolidLine)obj).getColor()));
                    newLineStyles.add(newLine);
                    continue;
                }
                newLineStyles.add(obj);
            }
            return newLineStyles;
        }
        return lineStyles;
    }

    private ArrayList getSelectedFillStyles(ArrayList fillStyles) {
        if (fillStyles != null) {
            ArrayList<Object> newFillStyles = new ArrayList<Object>();
            for (int i = 0; i < fillStyles.size(); ++i) {
                Object obj = fillStyles.get(i);
                if (obj instanceof FSGradientFill) {
                    FSGradientFill orgFill = (FSGradientFill)obj;
                    ArrayList orgGradients = orgFill.getGradients();
                    ArrayList<FSGradient> newGradients = new ArrayList<FSGradient>();
                    for (int j = 0; j < orgGradients.size(); ++j) {
                        FSGradient orgGradient = (FSGradient)orgGradients.get(j);
                        newGradients.add(new FSGradient(orgGradient.getRatio(), this.getHighlightColor(orgGradient.getColor())));
                    }
                    FSGradientFill newFill = new FSGradientFill(16, orgFill.getTransform(), newGradients);
                    newFillStyles.add(newFill);
                    continue;
                }
                if (obj instanceof FSSolidFill) {
                    FSSolidFill newFill = new FSSolidFill(this.getHighlightColor(((FSSolidFill)obj).getColor()));
                    newFillStyles.add(newFill);
                    continue;
                }
                newFillStyles.add(obj);
            }
            return newFillStyles;
        }
        return fillStyles;
    }

    private FSColor getHighlightColor(FSColor fsColor) {
        if (this.chart.getChartType() == 13) {
            if (this.recordBuffer != null && this.recordBuffer.size() == 0) {
                boolean bl = this.useDarkerColorForBubble = fsColor.getRed() + fsColor.getGreen() + fsColor.getBlue() < 382;
            }
            if (this.useDarkerColorForBubble) {
                return this.getDarker(fsColor, 1);
            }
            return this.getBrighter(fsColor, 1);
        }
        if (fsColor.getRed() + fsColor.getGreen() + fsColor.getBlue() < 382) {
            return this.getDarker(fsColor, 1);
        }
        return this.getBrighter(fsColor, 1);
    }

    private FSColor getBrighter(FSColor fsColor, int level) {
        boolean useMinGreen;
        Color newColor = new Color(fsColor.getRed(), fsColor.getGreen(), fsColor.getBlue(), fsColor.getAlpha());
        for (int i = 0; i < level; ++i) {
            newColor = newColor.brighter();
        }
        boolean useMinRed = newColor.getRed() > 200;
        boolean bl = useMinGreen = newColor.getGreen() > 200;
        if (newColor.getRed() > 200 || newColor.getGreen() > 200 || newColor.getBlue() > 200) {
            newColor = new Color(Math.min(newColor.getRed(), 200), Math.min(newColor.getGreen(), 200), useMinRed && useMinGreen ? newColor.getBlue() : Math.min(newColor.getBlue(), 200));
        }
        return new FSColor(newColor.getRed(), newColor.getGreen(), newColor.getBlue(), newColor.getAlpha());
    }

    private FSColor getDarker(FSColor fsColor, int level) {
        Color newColor = new Color(fsColor.getRed(), fsColor.getGreen(), fsColor.getBlue(), fsColor.getAlpha());
        for (int i = 0; i < level; ++i) {
            newColor = newColor.darker();
        }
        return new FSColor(newColor.getRed(), newColor.getGreen(), newColor.getBlue(), newColor.getAlpha());
    }
}

