/*
 * Decompiled with CFR 0.152.
 */
package quadbase.common.util.flash.flagstoneex;

import com.flagstone.transform.FSBounds;
import com.flagstone.transform.FSShape;
import com.flagstone.transform.FSShapeStyle;
import java.awt.Font;
import java.awt.Shape;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphVector;
import java.awt.geom.PathIterator;
import java.util.ArrayList;
import quadbase.common.util.flash.flagstoneex.QbFlashShapeConstructor;

public class FlashGlyph {
    private FSShape shape;
    private FSBounds bounds;
    private float advance;

    public FlashGlyph(Font font, FontRenderContext fontContext, char character) {
        GlyphVector glyphVector = font.createGlyphVector(fontContext, new char[]{character});
        Shape outline = glyphVector.getGlyphOutline(0);
        this.shape = this.convertShape(outline);
        this.advance = glyphVector.getGlyphMetrics(0).getAdvance();
        this.bounds = new FSBounds(0, 0, 0, 0);
    }

    private FSShape convertShape(Shape glyph) {
        PathIterator pathIter = glyph.getPathIterator(null);
        QbFlashShapeConstructor path = new QbFlashShapeConstructor();
        double[] coords = new double[6];
        while (!pathIter.isDone()) {
            int segmentType = pathIter.currentSegment(coords);
            int p1 = (int)coords[0];
            int p2 = (int)coords[1];
            int p3 = (int)coords[2];
            int p4 = (int)coords[3];
            int p5 = (int)coords[4];
            int p6 = (int)coords[5];
            switch (segmentType) {
                case 0: {
                    path.closePath();
                    path.move(p1, p2);
                    break;
                }
                case 1: {
                    path.line(p1, p2);
                    break;
                }
                case 2: {
                    path.curve(p1, p2, p3, p4);
                    break;
                }
                case 3: {
                    path.curve(p1, p2, p3, p4, p5, p6);
                    break;
                }
                case 4: {
                    path.closePath();
                }
            }
            pathIter.next();
        }
        FSShape fsShape = path.shape();
        ArrayList objects = fsShape.getObjects();
        if (objects.size() > 0) {
            FSShapeStyle style = (FSShapeStyle)objects.get(0);
            style.setLineStyle(0);
            style.setAltFillStyle(1);
        }
        return fsShape;
    }

    public FSShape getFSShape() {
        return this.shape;
    }

    public float getAdvance() {
        return this.advance;
    }

    public FSBounds getBounds() {
        return this.bounds;
    }
}

