/*
 * Decompiled with CFR 0.152.
 */
package quadbase.common.util.internal;

import java.util.logging.Level;
import java.util.logging.Logger;

public class Coder {
    private static final Logger LOGGER = Logger.getLogger(Coder.class.getName());
    static final String errorStr = "ERROR";
    static final String defaultCodeStr = "U&*W8&^%^#T9vf,d.gm:<<P:lsa[ls[ws,anKJSjdksjfdsfjioKJ73280(**(&(*9>:KM:Lmdsl;dm;}{}7u05HB90-Ay_((7^*sU90iam989x203-9&*7*^a9832";

    public static String getDefaultCodeStr() {
        return defaultCodeStr;
    }

    public static String encode(String str) {
        if (str == null) {
            return null;
        }
        LOGGER.log(Level.FINEST, "[DEBUG] str before encode: " + str);
        return Coder.encode(str, Coder.getDefaultCodeStr());
    }

    public static String encode(String str, String code) {
        char g_Offset;
        int i;
        StringBuffer buf = new StringBuffer("");
        int sum = Coder.computeSum(str);
        int[] groups = new int[]{0, 0, 0, 0, 0, 0};
        for (i = 0; i < str.length(); ++i) {
            int n = (0xFF & str.charAt(i) ^ code.charAt(i % code.length())) / 43;
            groups[n] = groups[n] + 1;
        }
        int maxGroup = 0;
        int maxSoFar = groups[0];
        for (i = 1; i < 6; ++i) {
            if (groups[i] <= maxSoFar) continue;
            maxSoFar = groups[i];
            maxGroup = (byte)i;
        }
        switch (maxGroup) {
            case 1: {
                g_Offset = '*';
                break;
            }
            case 2: {
                g_Offset = 'T';
                break;
            }
            case 3: {
                g_Offset = '~';
                break;
            }
            case 4: {
                g_Offset = '\u00a8';
                break;
            }
            case 5: {
                g_Offset = '\u00d2';
                break;
            }
            default: {
                g_Offset = '\u0000';
            }
        }
        char A_Offset = (char)(g_Offset + 20);
        char Z_Offset = (char)(A_Offset + 25);
        for (i = 0; i < str.length(); ++i) {
            char c = (char)(str.charAt(i) ^ code.charAt(i % code.length()));
            if (c >= g_Offset && c < A_Offset) {
                buf.append((char)(c + 103 - g_Offset));
                continue;
            }
            if (c >= A_Offset && c <= Z_Offset) {
                buf.append((char)(c + 65 - A_Offset));
                continue;
            }
            if (c <= '\u00ff') {
                buf.append('-');
                buf.append(Coder.charToHex(c, '\u00f0'));
                buf.append(Coder.charToHex(c, '\u000f'));
                continue;
            }
            buf.append(Coder.charToHex(c, '\uf000'));
            buf.append(Coder.charToHex(c, '\u0f00'));
            buf.append(Coder.charToHex(c, '\u00f0'));
            buf.append(Coder.charToHex(c, '\u000f'));
        }
        if (sum <= 255) {
            char shortSum = (char)sum;
            shortSum = (char)(shortSum ^ code.charAt(0));
            buf.append(Coder.charToHex(shortSum, '\u00f0'));
            buf.append(Coder.charToHex(shortSum, '\u000f'));
            buf.append((char)(97 + maxGroup));
        } else if (sum <= 65535) {
            char[] shortSum = new char[2];
            shortSum[1] = (char)(sum >> 8);
            shortSum[0] = (char)(sum & 0xFF);
            for (i = 0; i < shortSum.length; ++i) {
                int n = i;
                shortSum[n] = (char)(shortSum[n] ^ code.charAt(i % code.length()));
                buf.append(Coder.charToHex(shortSum[i], '\u00f0'));
                buf.append(Coder.charToHex(shortSum[i], '\u000f'));
            }
            buf.append((char)(103 + maxGroup));
        } else {
            char[] shortSum = new char[4];
            shortSum[3] = (char)(sum >> 24);
            shortSum[2] = (char)(sum >> 16);
            shortSum[1] = (char)(sum >> 8);
            shortSum[0] = (char)(sum & 0xFF);
            for (i = 0; i < shortSum.length; ++i) {
                int n = i;
                shortSum[n] = (char)(shortSum[n] ^ code.charAt(i % code.length()));
                buf.append(Coder.charToHex(shortSum[i], '\u00f0'));
                buf.append(Coder.charToHex(shortSum[i], '\u000f'));
            }
            buf.append((char)(109 + maxGroup));
        }
        return buf.toString();
    }

    public static String decode(String str, int version) {
        return Coder.decode(str, Coder.getDefaultCodeStr());
    }

    public static String decode(String str) {
        return Coder.decode(str, Coder.getDefaultCodeStr());
    }

    public static String decode(String str, String code) {
        if (str == null || str.length() == 0) {
            return str;
        }
        switch (str.charAt(str.length() - 1)) {
            case 'a': 
            case 'b': 
            case 'c': 
            case 'd': 
            case 'e': 
            case 'f': {
                if (str.length() < 3) {
                    return errorStr;
                }
                return Coder.decode(str.substring(0, str.length() - 3), code, (char)(str.charAt(str.length() - 1) - 97));
            }
            case 'g': 
            case 'h': 
            case 'i': 
            case 'j': 
            case 'k': 
            case 'l': {
                if (str.length() < 5) {
                    return errorStr;
                }
                return Coder.decode(str.substring(0, str.length() - 5), code, (char)(str.charAt(str.length() - 1) - 103));
            }
            case 'm': 
            case 'n': 
            case 'o': 
            case 'p': 
            case 'q': 
            case 'r': {
                if (str.length() < 9) {
                    return errorStr;
                }
                return Coder.decode(str.substring(0, str.length() - 9), code, (char)(str.charAt(str.length() - 1) - 109));
            }
        }
        return errorStr;
    }

    public static int computeSum(String str) {
        int sum = 0;
        for (int i = 0; i < str.length(); ++i) {
            sum += str.charAt(i);
        }
        return sum;
    }

    private static String decode(String str, String code, char group) {
        int g_Offset;
        StringBuffer buf = new StringBuffer("");
        switch (group) {
            case '\u0001': {
                g_Offset = 42;
                break;
            }
            case '\u0002': {
                g_Offset = 84;
                break;
            }
            case '\u0003': {
                g_Offset = 126;
                break;
            }
            case '\u0004': {
                g_Offset = 168;
                break;
            }
            case '\u0005': {
                g_Offset = 210;
                break;
            }
            default: {
                g_Offset = 0;
            }
        }
        char A_Offset = (char)(g_Offset + 20);
        int i = 0;
        while (i < str.length()) {
            if (str.charAt(i) >= 'g' && str.charAt(i) <= 'z') {
                buf.append((char)(str.charAt(i) - 103 + g_Offset));
                ++i;
                continue;
            }
            if (str.charAt(i) >= 'A' && str.charAt(i) <= 'Z') {
                buf.append((char)(str.charAt(i) - 65 + A_Offset));
                ++i;
                continue;
            }
            if (str.charAt(i) == '-') {
                buf.append(Coder.hexToChar(str.charAt(i), '\u0000', str.charAt(i + 1), str.charAt(i + 2)));
                i += 3;
                continue;
            }
            buf.append(Coder.hexToChar(str.charAt(i), str.charAt(i + 1), str.charAt(i + 2), str.charAt(i + 3)));
            i += 4;
        }
        for (i = 0; i < buf.length(); ++i) {
            buf.setCharAt(i, (char)(buf.charAt(i) ^ code.charAt(i % code.length())));
        }
        return buf.toString();
    }

    private static char hexToChar(char h1, char h2, char h3, char h4) {
        char rc;
        if (h1 != '-') {
            h1 = h1 >= 'a' && h1 <= 'f' ? (char)(h1 - 87) : (char)(h1 - 48);
            h2 = h2 >= 'a' && h2 <= 'f' ? (char)(h2 - 87) : (char)(h2 - 48);
            rc = (char)((h1 << 12) + (h2 << 8));
        } else {
            rc = '\u0000';
        }
        h3 = h3 >= 'a' && h3 <= 'f' ? (char)(h3 - 87) : (char)(h3 - 48);
        h4 = h4 >= 'a' && h4 <= 'f' ? (char)(h4 - 87) : (char)(h4 - 48);
        rc = (char)(rc + (char)((h3 << 4) + h4));
        return rc;
    }

    private static char charToHex(char c, char mask) {
        char rc = (char)(c & mask);
        if (mask == '\uf000') {
            rc = (char)(rc >> 12);
        } else if (mask == '\u0f00') {
            rc = (char)(rc >> 8);
        } else if (mask == '\u00f0') {
            rc = (char)(rc >> 4);
        }
        rc = rc <= '\t' ? (char)(rc + 48) : (char)(rc + 87);
        return rc;
    }
}

