/*
 * Decompiled with CFR 0.152.
 */
package quadbase.common.util.internal;

import java.io.IOException;
import java.io.InputStream;
import java.util.Hashtable;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;
import quadbase.common.util.internal.CustomizeNode;
import quadbase.common.util.internal.DTDEntityResolver;
import quadbase.common.util.internal.LCKey;
import quadbase.common.util.internal.QbUtil;
import quadbase.common.util.internal.ReadDataFile;
import quadbase.reportdesigner.ReportAPI.QbReport;

public class CustomizeElement {
    public static final String CUSTOMIZEXML = "Customization.xml";
    public static final String CUSTOMIZEDTD = "Customization.dtd";
    public static final String EDABMAINPAGE = "[EDAB Main Page]";
    public static final String EDABLOGINPAGE = "[EDAB Login Page]";
    public static final String ERESMAINPAGE = "[ERES Main Page]";
    public static final String ERESLOGINPAGE = "[ERES Login Page]";
    public static final String ERESORGANIZER = "[ERES Organizer]";
    public static final String ORGANIZER = "[Organizer]";
    public static final String QUICKDESIGNER = "[QuickDesigner]";
    public static final String MENUPAGE = "[Menu Page]";
    public static final String QUICKSTARTEXAMPLES = "[Quick Start Examples]";
    public static final String GENERAL = "[General]";
    public static final String IMAGES = "[Images]";
    public static final String TEXT = "[Text]";
    public static final String CSS = "[CSS]";
    public static final String MAPS = "[Maps]";
    public static final String DASHBOARD = "[Dashboard]";
    private static Hashtable<String, CustomizeNode> customizeTable = null;
    private static String[] tmpKey;

    public static void main(String[] args) {
        QbReport.useServlet((boolean)true);
        QbReport.setServletRunner((String)"http://localhost:8080");
        QbReport.setServletContext((String)"ERES/servlet");
        CustomizeElement.load();
        customizeTable.get("[ERES Main Page].[Images].[Login Background]");
        System.out.println(CustomizeElement.getCustomData("[ERES Organizer][Images][Launch Page Logo]", "def"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isERES() {
        boolean eres = false;
        try {
            eres = LCKey.isERES();
        }
        catch (Exception e) {
            ReadDataFile rdf = null;
            try {
                rdf = new ReadDataFile();
                rdf.getInputStream(CustomizeElement.getXMLFileName());
                rdf.close();
                boolean bl = true;
                return bl;
            }
            catch (Exception e2) {
                boolean bl = false;
                return bl;
            }
            finally {
                try {
                    if (rdf != null) {
                        rdf.close();
                    }
                }
                catch (Exception exception) {}
            }
        }
        return eres;
    }

    public static String getXMLFileName() {
        return CUSTOMIZEXML;
    }

    public static String getCustomDataForHTML(String key, String defaultVal, int imNavUp, String linkPrefix, String parameters) {
        String data = CustomizeElement.getCustomData(key, defaultVal);
        if (key.indexOf(IMAGES) > -1) {
            StringBuffer buf = new StringBuffer();
            if (customizeTable == null || customizeTable.size() == 0) {
                if (data.startsWith("http://") || data.startsWith("https://")) {
                    imNavUp = 0;
                }
                buf.append("<img src=\"");
                for (int i = 0; i < imNavUp; ++i) {
                    buf.append("../");
                }
                buf.append(data + "\" " + parameters + ">");
                return buf.toString();
            }
            CustomizeNode node = customizeTable.get(key);
            if (node != null && node.getCustomizedLink() != null && node.getCustomizedLink() != "") {
                if (node.getCustomizedLink().startsWith("http://") || node.getCustomizedLink().startsWith("https://")) {
                    linkPrefix = "";
                }
                buf.append("<a href=\"" + linkPrefix + node.getCustomizedLink() + "\">");
            }
            buf.append("<img src=\"");
            if (data.startsWith("http://") || data.startsWith("https://")) {
                imNavUp = 0;
            }
            for (int i = 0; i < imNavUp; ++i) {
                buf.append("../");
            }
            buf.append(data + "\" " + parameters + ">");
            if (node != null && node.getCustomizedLink() != null && node.getCustomizedLink() != "") {
                buf.append("</a>");
            }
            return buf.toString();
        }
        if (key.indexOf(TEXT) > -1) {
            data = data.replaceAll("&apos;", "'");
            data = data.replaceAll("&quot;", "\"");
            data = data.replaceAll("\\*_&apos;_\\*", "&apos;");
            data = data.replaceAll("\\*_&quot;_\\*", "&quot;");
            data = data.replaceAll("&gt;", ">");
            data = data.replaceAll("&lt;", "<");
            data = data.replaceAll("\\*_&gt;_\\*", "&gt;");
            data = data.replaceAll("\\*_&lt;_\\*", "&lt;");
            data = data.replaceAll("&amp;", "&");
            data = data.replaceAll("\\*_&amp;_\\*", "&amp;");
        }
        return data;
    }

    public static String getCustomDataForHTML(String key, String defaultVal) {
        String data = CustomizeElement.getCustomData(key, defaultVal);
        if (key.indexOf(IMAGES) > -1) {
            StringBuffer buf = new StringBuffer();
            if (customizeTable == null || customizeTable.size() == 0) {
                return "<img src=\"" + data + "\">";
            }
            CustomizeNode node = customizeTable.get(key);
            if (node != null && node.getCustomizedLink() != null && node.getCustomizedLink() != "") {
                String target = node.getCustomizedLink().trim();
                if (!target.toLowerCase().startsWith("http://") && !target.toLowerCase().startsWith("https://")) {
                    target = "http://" + target;
                }
                buf.append("<a href=\"" + target + "\">");
                buf.append("<img src=\"" + data + "\" border=0>");
                buf.append("</a>");
            } else {
                buf.append("<img src=\"" + data + "\">");
            }
            return buf.toString();
        }
        if (key.indexOf(TEXT) > -1) {
            data = data.replaceAll("&apos;", "'");
            data = data.replaceAll("&quot;", "\"");
            data = data.replaceAll("\\*_&apos;_\\*", "&apos;");
            data = data.replaceAll("\\*_&quot;_\\*", "&quot;");
            data = data.replaceAll("&gt;", ">");
            data = data.replaceAll("&lt;", "<");
            data = data.replaceAll("\\*_&gt;_\\*", "&gt;");
            data = data.replaceAll("\\*_&lt;_\\*", "&lt;");
            data = data.replaceAll("&amp;", "&");
            data = data.replaceAll("\\*_&amp;_\\*", "&amp;");
        }
        return data;
    }

    public static String getCustomData(String key, String defaultVal) {
        if (key == null || key.equals("") || customizeTable == null || customizeTable.size() == 0) {
            return defaultVal;
        }
        CustomizeNode node = customizeTable.get(key);
        if (node == null) {
            return defaultVal;
        }
        if (node.getCustomizedValue().equals(node.getDefaultValue()) && (node.getDefaultLink() == null && node.getCustomizedLink() == null || node.getDefaultLink() != null && node.getDefaultLink().equals(node.getCustomizedLink()))) {
            return node.getDefaultValue();
        }
        String custVal = node.getCustomizedValue();
        if (custVal.contains("http") && !QbUtil.isThisMyIpAddress(custVal)) {
            custVal = "";
        }
        return custVal;
    }

    public static String getCustomData(String key, String defaultVal, int navUp) {
        String data = CustomizeElement.getCustomData(key, defaultVal);
        StringBuffer buf = new StringBuffer();
        if (data.startsWith("http://") || data.startsWith("https://")) {
            navUp = 0;
        }
        for (int i = 0; i < navUp; ++i) {
            buf.append("../");
        }
        buf.append(data);
        return buf.toString();
    }

    public static String getCustomLink(String key, String defaultVal, int imNavUp) {
        String link = CustomizeElement.getCustomLink(key, defaultVal);
        if (link.startsWith("http://") || link.startsWith("https://")) {
            imNavUp = 0;
        }
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < imNavUp; ++i) {
            buf.append("../");
        }
        buf.append(link);
        return buf.toString();
    }

    public static String getCustomLink(String key, String defaultVal) {
        if (key == null || key.equals("") || customizeTable == null || customizeTable.size() == 0) {
            return defaultVal;
        }
        CustomizeNode node = customizeTable.get(key);
        if (node == null) {
            return defaultVal;
        }
        if (node.getCustomizedValue().equals(node.getDefaultValue()) && (node.getDefaultLink() == null && node.getCustomizedLink() == null || node.getDefaultLink() != null && node.getDefaultLink().equals(node.getCustomizedLink()))) {
            return defaultVal;
        }
        return node.getCustomizedLink();
    }

    public static void reload() {
        CustomizeElement.reload(CustomizeElement.getXMLFileName());
    }

    public static void reload(String filename) {
        customizeTable = null;
        CustomizeElement.load(filename);
    }

    public static void clean() {
        customizeTable = null;
    }

    public static void load() {
        CustomizeElement.load(CustomizeElement.getXMLFileName());
    }

    public static void load(String filename) {
        if (!LCKey.isERES() && !LCKey.isDashboard()) {
            return;
        }
        if (customizeTable != null && customizeTable.size() > 0) {
            return;
        }
        if (filename.endsWith(".xml")) {
            InputStream inputStream = null;
            try {
                customizeTable = new Hashtable();
                ReadDataFile rdf = new ReadDataFile();
                inputStream = rdf.getInputStream(filename, false, true);
                Document xmlDoc = CustomizeElement.createXmlTree(inputStream);
                CustomizeElement.createHashtable(xmlDoc);
                inputStream.close();
            }
            catch (IOException rdf) {
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            try {
                if (inputStream != null) {
                    inputStream.close();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private static void addToHash(CustomizeNode node) {
        String key = "[" + tmpKey[0] + "][" + tmpKey[1] + "][" + tmpKey[2] + "]";
        customizeTable.put(key, node);
    }

    private static void buildTree(Node domNode) {
        if (domNode.getNodeType() == 1 && domNode.getNodeName().equalsIgnoreCase("Item")) {
            NodeList nodeList = domNode.getChildNodes();
            CustomizeNode custNode = new CustomizeNode();
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Node node = nodeList.item(i);
                if (node.getNodeName().equalsIgnoreCase("Name")) {
                    CustomizeElement.tmpKey[2] = CustomizeElement.getData(node);
                    custNode.setName(tmpKey[2]);
                    continue;
                }
                if (node.getNodeName().equalsIgnoreCase("Description")) {
                    custNode.setDescription(CustomizeElement.getData(node));
                    continue;
                }
                if (node.getNodeName().equalsIgnoreCase("DefaultValue")) {
                    custNode.setDefaultValue(CustomizeElement.getData(node));
                    continue;
                }
                if (node.getNodeName().equalsIgnoreCase("CustomizedValue")) {
                    custNode.setCustomizedValue(CustomizeElement.getData(node));
                    continue;
                }
                if (node.getNodeName().equalsIgnoreCase("DefaultLink")) {
                    custNode.setDefaultLink(CustomizeElement.getData(node));
                    continue;
                }
                if (node.getNodeName().equalsIgnoreCase("CustomizedLink")) {
                    custNode.setCustomizedLink(CustomizeElement.getData(node));
                    continue;
                }
                if (node.getNodeName().equalsIgnoreCase("isCustomized")) {
                    custNode.setCustomized(Boolean.valueOf(CustomizeElement.getData(node)));
                    continue;
                }
                if (!node.getNodeName().equalsIgnoreCase("DefaultCheckSum")) continue;
                custNode.setChecksum(Long.parseLong(CustomizeElement.getData(node)));
            }
            CustomizeElement.addToHash(custNode);
        } else if (domNode.getNodeType() == 1 && domNode.getAttributes() != null && domNode.getAttributes().item(0) != null && domNode.getAttributes().item(0).getNodeName() != null && domNode.getAttributes().item(0).getNodeName().equalsIgnoreCase("ComponentName")) {
            CustomizeElement.tmpKey[0] = domNode.getAttributes().item(0).getNodeValue();
            NodeList nodeList = domNode.getChildNodes();
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Node node = nodeList.item(i);
                CustomizeElement.buildTree(node);
            }
        } else if (domNode.getNodeType() == 1 && domNode.getAttributes() != null && domNode.getAttributes().item(0) != null && domNode.getAttributes().item(0).getNodeName() != null && domNode.getAttributes().item(0).getNodeName().equalsIgnoreCase("CategoryName")) {
            CustomizeElement.tmpKey[1] = domNode.getAttributes().item(0).getNodeValue();
            NodeList nodeList = domNode.getChildNodes();
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Node node = nodeList.item(i);
                CustomizeElement.buildTree(node);
            }
        } else {
            NodeList nodeList = domNode.getChildNodes();
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Node node = nodeList.item(i);
                CustomizeElement.buildTree(node);
            }
        }
    }

    public static void createHashtable(Node domNode) {
        NodeList nodeList = domNode.getChildNodes();
        customizeTable = new Hashtable();
        tmpKey = new String[3];
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            CustomizeElement.buildTree(node);
        }
    }

    private static String getData(Node domNode) {
        if (domNode == null) {
            return "";
        }
        NodeList nodeList = domNode.getChildNodes();
        String s = "";
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            short type = node.getNodeType();
            if (type == 1) {
                s = s + CustomizeElement.getData(node);
                continue;
            }
            if (type == 3) {
                s = s + node.getNodeValue();
                continue;
            }
            if (type == 5) {
                s = s + CustomizeElement.getData(node);
                continue;
            }
            if (type != 4) continue;
            s = s + node.getNodeValue();
        }
        return s;
    }

    public static Document createXmlTree(InputStream customizeXmlFileName) {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        try {
            DocumentBuilder builder = factory.newDocumentBuilder();
            DTDEntityResolver dtder = new DTDEntityResolver();
            builder.setEntityResolver(dtder);
            Document document = builder.parse(customizeXmlFileName, "");
            return document;
        }
        catch (SAXException sxe) {
            Exception x = sxe;
            if (sxe.getException() != null) {
                x = sxe.getException();
            }
            x.printStackTrace();
        }
        catch (ParserConfigurationException pce) {
            pce.printStackTrace();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        return null;
    }
}

