/*
 * Decompiled with CFR 0.152.
 */
package quadbase.common.util.internal;

import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.tree.DefaultMutableTreeNode;
import org.apache.xerces.xs.XSAttributeDeclaration;
import quadbase.common.util.dtd.elements.DTD;
import quadbase.common.util.dtd.elements.DTDAny;
import quadbase.common.util.dtd.elements.DTDAttribute;
import quadbase.common.util.dtd.elements.DTDChoice;
import quadbase.common.util.dtd.elements.DTDDataType;
import quadbase.common.util.dtd.elements.DTDElement;
import quadbase.common.util.dtd.elements.DTDEmpty;
import quadbase.common.util.dtd.elements.DTDItem;
import quadbase.common.util.dtd.elements.DTDMixed;
import quadbase.common.util.dtd.elements.DTDName;
import quadbase.common.util.dtd.elements.DTDPCData;
import quadbase.common.util.dtd.elements.DTDSequence;
import quadbase.common.util.dtd.elements.XSObjectWrapper;
import quadbase.common.util.dtd.parser.DTDParser;
import quadbase.common.util.dtd.parser.ParseException;
import quadbase.common.util.internal.ReadDataFile;
import quadbase.common.util.internal.WriteDataFile;
import quadbase.common.util.internal.XMLFieldInfo;

public class DTDUtil {
    public static DefaultMutableTreeNode buildTree(DTDElement root, Hashtable elements, DefaultMutableTreeNode node, boolean expand) {
        DTDElement nodeElt = (DTDElement)node.getUserObject();
        if (elements != null && elements.containsKey(nodeElt.getName())) {
            DTDUtil.addContent(root, nodeElt, elements, node, expand);
            DTDUtil.addAttribute(nodeElt, node, expand);
        }
        return node;
    }

    private static void addContent(DTDElement root, DTDElement nodeElt, Hashtable elements, DefaultMutableTreeNode node, boolean expand) {
        block11: {
            DTDItem[] choices;
            DTDItem content;
            block12: {
                DTDItem[] items;
                block10: {
                    DTDItem[] items2;
                    if (!expand) {
                        return;
                    }
                    content = nodeElt.getContent();
                    if (!(content instanceof DTDMixed)) break block10;
                    for (DTDItem item : items2 = ((DTDMixed)content).getItems()) {
                        if (item instanceof DTDName) {
                            String name = ((DTDName)item).getValue();
                            if (elements.containsKey(name)) {
                                DTDElement elt = (DTDElement)elements.get(name);
                                elt.setCardinal(((DTDName)item).getCardinal());
                                elt.setExpand(DTDUtil.isExpand(name, nodeElt));
                                node.add(DTDUtil.buildTree(root, elements, new DefaultMutableTreeNode(elt), DTDUtil.isExpand(name, nodeElt)));
                                continue;
                            }
                            System.out.println("Dialog, cann't find this DTDName");
                            continue;
                        }
                        if (item instanceof DTDPCData) {
                            if (nodeElt.getDataType() == null || nodeElt.getDataType().trim().equals("")) {
                                nodeElt.setDataType("string");
                            }
                            if (!nodeElt.getDataType().equals("date") || nodeElt.getDateFormat() != null && !nodeElt.getDateFormat().trim().equals("")) continue;
                            nodeElt.setDateFormat("MM-DD-YYYY");
                            continue;
                        }
                        System.out.println("Dialog, not DTDName or DTDPCData.");
                    }
                    break block11;
                }
                if (!(content instanceof DTDSequence)) break block12;
                DTDSequence children = (DTDSequence)content;
                for (DTDItem item : items = children.getItems()) {
                    DTDItem[] choices2;
                    if (item instanceof DTDName) {
                        String name = ((DTDName)item).getValue();
                        if (!elements.containsKey(name)) continue;
                        DTDElement elt = (DTDElement)elements.get(name);
                        elt.setCardinal(((DTDName)item).getCardinal());
                        elt.setExpand(DTDUtil.isExpand(name, nodeElt));
                        node.add(DTDUtil.buildTree(root, elements, new DefaultMutableTreeNode(elt), DTDUtil.isExpand(name, nodeElt)));
                        continue;
                    }
                    if (!(item instanceof DTDChoice)) continue;
                    DTDChoice choice = (DTDChoice)item;
                    for (DTDItem choice2 : choices2 = choice.getItems()) {
                        String choiceName;
                        if (!(choice2 instanceof DTDName) || !elements.containsKey(choiceName = ((DTDName)choice2).getValue())) continue;
                        DTDElement elt = (DTDElement)elements.get(choiceName);
                        elt.setCardinal(((DTDName)choice2).getCardinal());
                        elt.setExpand(DTDUtil.isExpand(choiceName, nodeElt));
                        node.add(DTDUtil.buildTree(root, elements, new DefaultMutableTreeNode(elt), DTDUtil.isExpand(choiceName, nodeElt)));
                    }
                }
                break block11;
            }
            if (!(content instanceof DTDChoice)) break block11;
            DTDChoice choice = (DTDChoice)content;
            for (DTDItem choice2 : choices = choice.getItems()) {
                String choiceName;
                if (!(choice2 instanceof DTDName) || !elements.containsKey(choiceName = ((DTDName)choice2).getValue())) continue;
                DTDElement elt = (DTDElement)elements.get(choiceName);
                elt.setCardinal(((DTDName)choice2).getCardinal());
                elt.setExpand(DTDUtil.isExpand(choiceName, nodeElt));
                node.add(DTDUtil.buildTree(root, elements, new DefaultMutableTreeNode(elt), DTDUtil.isExpand(choiceName, nodeElt)));
            }
        }
    }

    private static boolean isExpand(String name, DTDElement parent) {
        boolean expand = true;
        if (name.equals(parent.getName())) {
            expand = false;
        }
        return expand;
    }

    private static void addAttribute(DTDElement nodeElt, DefaultMutableTreeNode node, boolean expand) {
        if (!expand) {
            return;
        }
        DTDAttribute[] atts = nodeElt.getAttributes();
        if (atts == null) {
            return;
        }
        for (DTDAttribute att : atts) {
            if (att.isCDATAType()) {
                if (att.getDataType() == null || att.getDataType().equals("")) {
                    att.setDataType("string");
                }
                if (att.getDataType().equals("date") && (att.getDateFormat() == null || att.getDateFormat().trim().equals(""))) {
                    att.setDateFormat("MM-DD-YYYY");
                }
            }
            node.add(new DefaultMutableTreeNode(att));
        }
    }

    public static void writeItem(DataOutputStream out, DTDItem item) {
        try {
            if (item instanceof DTDPCData) {
                out.writeInt(10);
            } else if (item instanceof DTDName) {
                out.writeInt(8);
            } else if (item instanceof DTDEmpty) {
                out.writeInt(5);
            } else if (item instanceof DTDAny) {
                out.writeInt(3);
            } else if (item instanceof DTDChoice) {
                out.writeInt(4);
            } else if (item instanceof DTDMixed) {
                out.writeInt(7);
            } else if (item instanceof DTDSequence) {
                out.writeInt(11);
            }
            item.write(out);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static DTDItem readItem(DataInputStream in, int version) {
        try {
            int type = in.readInt();
            DTDPCData item = null;
            if (type == 10) {
                item = (DTDPCData)new DTDPCData().read(in, version);
            } else if (type == 8) {
                item = (DTDName)new DTDName().read(in, version);
            } else if (type == 5) {
                item = (DTDEmpty)new DTDEmpty().read(in, version);
            } else if (type == 3) {
                item = (DTDAny)new DTDAny().read(in, version);
            } else if (type == 4) {
                item = (DTDChoice)new DTDChoice().read(in, version);
            } else if (type == 7) {
                item = (DTDMixed)new DTDMixed().read(in, version);
            } else if (type == 11) {
                item = (DTDSequence)new DTDSequence().read(in, version);
            }
            return item;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static DTD getDTDFromParser(String filename) throws ParseException, Exception {
        DTD dtd = null;
        DataInputStream in = new ReadDataFile().getInputStream(filename);
        dtd = DTDParser.parse((InputStream)in);
        return dtd;
    }

    public static DTD getDTDFromParser(InputStream in) throws ParseException, Exception {
        DTD dtd = null;
        dtd = DTDParser.parse((InputStream)in);
        return dtd;
    }

    public static DTD readDTD(String ddtFileName) {
        try {
            DataInputStream in = new ReadDataFile().getInputStream(ddtFileName);
            int version = in.readInt();
            DTD dtd = (DTD)new DTD().read(in, version);
            in.close();
            return dtd;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return null;
    }

    public static void writeDTDTreeFile(DTD dtdTree, String filename, int version) {
        try {
            ByteArrayOutputStream bstream = new ByteArrayOutputStream(1024);
            DataOutputStream dout = new DataOutputStream(bstream);
            dout.writeInt(version);
            dtdTree.write(dout);
            byte[] barray = bstream.toByteArray();
            new WriteDataFile().output(barray, filename);
            dout.flush();
            dout.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static XMLFieldInfo[] getXMLAllFields(DefaultMutableTreeNode root) {
        Vector<XMLFieldInfo> vec = new Vector<XMLFieldInfo>();
        int leafCt = root.getLeafCount();
        DefaultMutableTreeNode node = root.getFirstLeaf();
        XMLFieldInfo field = DTDUtil.getXMLFieldInfo(node);
        if (field != null) {
            vec.addElement(field);
        }
        for (int i = 1; i < leafCt; ++i) {
            field = DTDUtil.getXMLFieldInfo(node = node.getNextLeaf());
            if (field == null) continue;
            vec.addElement(field);
        }
        Object[] temp = vec.toArray();
        XMLFieldInfo[] fields = new XMLFieldInfo[temp.length];
        for (int i = 0; i < temp.length; ++i) {
            fields[i] = (XMLFieldInfo)temp[i];
        }
        return fields;
    }

    public static XMLFieldInfo getXMLFieldInfo(DefaultMutableTreeNode node) {
        Object userObj = node.getUserObject();
        XMLFieldInfo field = null;
        if (userObj instanceof XSObjectWrapper) {
            XSObjectWrapper wrapper = (XSObjectWrapper)userObj;
            if (wrapper.isLeaf() || wrapper.isSelectable()) {
                if (wrapper.getObject() instanceof XSAttributeDeclaration) {
                    Object[] userObjects = node.getUserObjectPath();
                    String[] path = new String[userObjects.length - 2];
                    for (int i = 0; i < path.length; ++i) {
                        path[i] = ((XSObjectWrapper)userObjects[i + 1]).toString();
                    }
                    field = new XMLFieldInfo(path, wrapper.toString());
                    field.setXMLType(2);
                    String dataType = DTDDataType.mapXMLSchemaDataType(wrapper.getDataType());
                    field.setAttributeDataType(dataType);
                    if (dataType.equals("date") || dataType.equals("time") || dataType.equals("timestamp")) {
                        field.setDateFormat(wrapper.getDateFormatString());
                    }
                } else {
                    Object[] userObjects = node.getUserObjectPath();
                    String[] path = new String[userObjects.length - 1];
                    for (int i = 0; i < path.length; ++i) {
                        path[i] = ((XSObjectWrapper)userObjects[i + 1]).toString();
                    }
                    field = new XMLFieldInfo(path);
                    field.setXMLType(1);
                    String dataType = DTDDataType.mapXMLSchemaDataType(wrapper.getDataType());
                    field.setElementDataType(dataType);
                    if (dataType.equals("date") || dataType.equals("time") || dataType.equals("timestamp")) {
                        field.setDateFormat(wrapper.getDateFormatString());
                    }
                }
            }
        } else if (node.isLeaf() || userObj instanceof DTDElement && ((DTDElement)userObj).isMixedLeaf()) {
            Object[] userObjects = node.getUserObjectPath();
            Object selectedObj = userObjects[userObjects.length - 1];
            String[] path = null;
            if (selectedObj instanceof DTDElement) {
                path = new String[userObjects.length];
                for (int i = 0; i < path.length; ++i) {
                    if (!(userObjects[i] instanceof DTDElement)) continue;
                    path[i] = ((DTDElement)userObjects[i]).getName();
                }
                field = new XMLFieldInfo(path);
                DTDElement elt = (DTDElement)selectedObj;
                field.setXMLType(1);
                if (elt.getDataType() == null) {
                    field.setElementDataType("string");
                } else {
                    field.setElementDataType(elt.getDataType());
                }
                if (field.getElementDataType().equals("date")) {
                    field.setDateFormat(elt.getDateFormat());
                }
                if (!elt.isExpand()) {
                    field.setRecursive(true);
                }
            } else if (selectedObj instanceof DTDAttribute) {
                path = new String[userObjects.length - 1];
                for (int i = 0; i < path.length; ++i) {
                    if (!(userObjects[i] instanceof DTDElement)) continue;
                    path[i] = ((DTDElement)userObjects[i]).getName();
                }
                DTDAttribute attr = (DTDAttribute)selectedObj;
                field = new XMLFieldInfo(path, attr.getName());
                field.setXMLType(2);
                if (attr.getDataType() == null) {
                    field.setAttributeDataType("string");
                } else {
                    field.setAttributeDataType(attr.getDataType());
                }
                if (field.getAttributeDataType().equals("date")) {
                    field.setDateFormat(attr.getDateFormat());
                }
            }
        }
        return field;
    }

    public static String getXMLFieldFullName(String[] path, String attrName) {
        return XMLFieldInfo.getDisplayName(path, attrName);
    }
}

