/*
 * Decompiled with CFR 0.152.
 */
package quadbase.common.util.internal;

import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Properties;
import quadbase.common.client.ServerMessage;
import quadbase.common.util.internal.DataSetARRAY;
import quadbase.common.util.internal.DataSetARRAYIndexed;
import quadbase.common.util.internal.DataSetColumn;
import quadbase.common.util.internal.DataSetDISK;
import quadbase.common.util.internal.DataSetDISKIndexed;
import quadbase.common.util.internal.DataSetMEM;
import quadbase.common.util.internal.DataSetREF;
import quadbase.common.util.internal.IDataSet;
import quadbase.common.util.internal.IOUtil;
import quadbase.common.util.internal.QbDebug;

public class DataSet
implements IDataSet {
    private IDataSet data;
    private boolean useMemory = true;
    private boolean useMemoryOnly = false;
    protected String address;
    protected int maxChar;
    protected int noOfCol = -1;
    private static int maxInfoChar = 1;
    private int dataType = -1;
    private long currentSize = 0L;
    static final int BOOLEAN_BLOCK_SIZE = 1;
    static final int BYTE_BLOCK_SIZE = 1;
    static final int SHORT_BLOCK_SIZE = 2;
    static final int INT_BLOCK_SIZE = 4;
    static final int LONG_BLOCK_SIZE = 8;
    static final int FLOAT_BLOCK_SIZE = 4;
    static final int DOUBLE_BLOCK_SIZE = 8;
    static final int DATE_BLOCK_SIZE = 8;
    static final int TIME_BLOCK_SIZE = 8;
    static final int TIMESTAMP_BLOCK_SIZE = 8;
    static final int BOOLEAN_OBJECT_SIZE = 16;
    static final int SHORT_OBJECT_SIZE = 16;
    static final int INT_OBJECT_SIZE = 16;
    static final int LONG_OBJECT_SIZE = 16;
    static final int FLOAT_OBJECT_SIZE = 16;
    static final int DOUBLE_OBJECT_SIZE = 16;
    static final int DATE_OBJECT_SIZE = 24;
    static final int TIME_OBJECT_SIZE = 24;
    static final int TIMESTAMP_OBJECT_SIZE = 32;

    public DataSet(int initialCapacity, String address, int maxChar, int noOfCol, int dataType) {
        this.address = address;
        this.maxChar = maxChar;
        this.noOfCol = noOfCol;
        this.dataType = dataType;
        this.useMemoryOnly = ServerMessage.getPagingThreshold() < 0;
        this.data = new DataSetMEM(initialCapacity);
    }

    public DataSet(String address, int maxChar, int noOfCol, boolean isTreeReport, Properties treeProperties) {
        this(address, maxChar, noOfCol, -1);
    }

    public DataSet(int colDataType, IDataSet dataSetROOT) {
        this.data = dataSetROOT instanceof DataSetColumn ? new DataSetREF(((DataSetColumn)dataSetROOT).getColumnData(colDataType)) : new DataSetREF(dataSetROOT);
    }

    public DataSet(String address, int maxChar, int noOfCol, int dataType) {
        this.address = address;
        this.maxChar = maxChar;
        this.noOfCol = noOfCol;
        this.dataType = dataType;
        this.useMemoryOnly = ServerMessage.getPagingThreshold() < 0;
        this.data = new DataSetMEM();
    }

    public DataSet(DataSet _data) {
        this(_data, true);
    }

    public DataSet(DataSet _data, boolean copyData) {
        if (_data == null) {
            return;
        }
        this.useMemory = _data.useMemory;
        this.useMemoryOnly = _data.useMemoryOnly;
        this.address = _data.address;
        this.maxChar = _data.maxChar;
        this.noOfCol = _data.noOfCol;
        this.data = _data.data instanceof DataSetMEM ? new DataSetMEM((DataSetMEM)_data.data) : new DataSetDISK((DataSetDISK)_data.data, this.address);
    }

    @Override
    public void addElement(Object obj) {
        this.checkSize(obj);
        this.data.addElement(obj);
    }

    @Override
    public void removeAllElements() {
        this.data.removeAllElements();
    }

    @Override
    public int size() {
        return this.data.size();
    }

    @Override
    public Object elementAt(int i) {
        return this.data.elementAt(i);
    }

    @Override
    public void setElementAt(Object obj, int index) {
        if (!this.useMemory) {
            this.convertToMEM();
        }
        this.data.setElementAt(obj, index);
    }

    @Override
    public void insertElementAt(Object obj, int index) {
        if (index == this.size()) {
            this.addElement(obj);
            return;
        }
        if (!this.useMemory) {
            this.convertToMEM();
        }
        this.data.insertElementAt(obj, index);
    }

    @Override
    public void removeElementAt(int index) {
        if (!this.useMemory) {
            this.convertToMEM();
        }
        this.data.removeElementAt(index);
    }

    @Override
    public Object clone() {
        return new DataSet(this);
    }

    @Override
    public Object cloneStructure() {
        return new DataSet(this, false);
    }

    @Override
    public boolean isValid() {
        return this.data.isValid();
    }

    @Override
    public void cleanup() {
        try {
            this.finalize();
        }
        catch (Throwable ex) {
            throw new IllegalArgumentException(IOUtil.getStackTrace(ex));
        }
    }

    protected void finalize() throws Throwable {
        try {
            this.data.cleanup();
        }
        finally {
            super.finalize();
        }
    }

    @Override
    public void releaseDiskBuffer() {
        if (this.data instanceof DataSetDISKIndexed) {
            ((DataSetDISKIndexed)this.data).releaseDiskBuffer();
        }
        if (this.data instanceof DataSetDISK) {
            ((DataSetDISK)this.data).releaseDiskBuffer();
        }
    }

    private void checkSize(Object obj) {
        if (this.useMemoryOnly) {
            return;
        }
        if (this.data instanceof DataSetDISK) {
            return;
        }
        if (this.data instanceof DataSetREF) {
            return;
        }
        int maxMem = ServerMessage.getPagingThreshold() * 1024 * 1024 / 2 / this.noOfCol;
        int objectSize = this.calculateObjectSize(obj);
        if (this.data instanceof DataSetMEM && (long)objectSize + this.currentSize >= (long)maxMem) {
            int blockSize = this.calculateBlockSize(obj);
            int maxBuffer = ServerMessage.getPageBufferSize() * 1024 * 1024 / 10;
            int maxRowInBuffer = maxBuffer / blockSize / this.noOfCol;
            this.convertToARRAY(blockSize, maxRowInBuffer);
        } else if (this.data instanceof DataSetARRAY && !((DataSetARRAY)this.data).willFit(obj)) {
            int blockSize = this.calculateBlockSize(obj);
            int maxBuffer = ServerMessage.getPageBufferSize() * 1024 * 1024 / 10;
            int maxRowInBuffer = maxBuffer / blockSize / this.noOfCol;
            this.convertToDISK(blockSize, maxRowInBuffer);
        }
        if ((long)objectSize + this.currentSize < (long)maxMem) {
            this.currentSize += (long)objectSize;
        }
    }

    private void convertToARRAY(int blockSize, int maxRowInBuffer) {
        DataSetARRAY newData = this.dataType == 7 || this.dataType == 13 ? new DataSetARRAYIndexed(blockSize, this.dataType, maxRowInBuffer) : new DataSetARRAY(blockSize, this.dataType, maxRowInBuffer);
        if (!((DataSetARRAY)newData).willFit(this.data)) {
            this.convertToDISK(blockSize, maxRowInBuffer);
        } else {
            int mSize = this.data.size();
            for (int i = 0; i < mSize; ++i) {
                newData.addElement(this.data.elementAt(i));
            }
            this.useMemory = false;
            this.data.cleanup();
            this.data = newData;
        }
    }

    private void convertToDISK(int blockSize, int maxRowInBuffer) {
        DataSetDISK newData = this.dataType == 7 || this.dataType == 13 ? new DataSetDISKIndexed(this.address, blockSize, this.dataType, maxRowInBuffer) : new DataSetDISK(this.address, blockSize, this.dataType, maxRowInBuffer);
        if (this.data instanceof DataSetARRAY) {
            ((DataSetDISK)newData).copy((DataSetARRAY)this.data);
        } else {
            int mSize = this.data.size();
            for (int i = 0; i < mSize; ++i) {
                newData.addElement(this.data.elementAt(i));
            }
        }
        this.useMemory = false;
        this.data.cleanup();
        this.data = newData;
    }

    private void convertToMEM() {
        DataSetMEM newData = new DataSetMEM();
        int mSize = this.data.size();
        for (int i = 0; i < mSize; ++i) {
            newData.addElement(this.data.elementAt(i));
        }
        this.useMemory = true;
        this.data.cleanup();
        this.data = newData;
    }

    private int calculateBlockSize(Object objectSample) {
        return this.calculateMaxChar(objectSample) + maxInfoChar;
    }

    private int calculateMaxChar(Object objectSample) {
        if (objectSample == null && this.dataType == -1) {
            QbDebug.println(6, "RETURN DATATYPE = " + this.dataType);
            return ServerMessage.getMaxFieldSize();
        }
        if (this.dataType == 7 || objectSample instanceof String) {
            this.dataType = 7;
            return this.maxChar;
        }
        if (this.dataType == 0 || objectSample instanceof Boolean) {
            this.dataType = 0;
            return 1;
        }
        if (this.dataType == 11 || objectSample instanceof Byte) {
            this.dataType = 11;
            return 1;
        }
        if (this.dataType == 12 || objectSample instanceof Short) {
            this.dataType = 12;
            return 2;
        }
        if (this.dataType == 2 || objectSample instanceof Integer) {
            this.dataType = 2;
            return 4;
        }
        if (this.dataType == 1 || objectSample instanceof Long) {
            this.dataType = 1;
            return 8;
        }
        if (this.dataType == 3 || objectSample instanceof Float) {
            this.dataType = 3;
            return 4;
        }
        if (this.dataType == 4 || objectSample instanceof Double) {
            this.dataType = 4;
            return 8;
        }
        if (this.dataType == 13 || objectSample instanceof BigDecimal) {
            this.dataType = 13;
            return this.maxChar;
        }
        if (this.dataType == 8 || objectSample instanceof Date) {
            this.dataType = 8;
            return 8;
        }
        if (this.dataType == 9 || objectSample instanceof Time) {
            this.dataType = 9;
            return 8;
        }
        if (this.dataType == 10 || objectSample instanceof Timestamp) {
            this.dataType = 10;
            return 8;
        }
        return ServerMessage.getMaxFieldSize();
    }

    private int calculateObjectSize(Object objectSample) {
        if (objectSample == null && this.dataType == -1) {
            return 1;
        }
        if (objectSample instanceof Integer) {
            return 16;
        }
        if (objectSample instanceof Long) {
            return 16;
        }
        if (objectSample instanceof Double) {
            return 16;
        }
        if (objectSample instanceof Float) {
            return 16;
        }
        if (objectSample instanceof Date) {
            return 24;
        }
        if (objectSample instanceof Time) {
            return 24;
        }
        if (objectSample instanceof Timestamp) {
            return 32;
        }
        if (objectSample instanceof Boolean) {
            return 16;
        }
        if (objectSample instanceof Short) {
            return 16;
        }
        if (this.dataType == 7 || objectSample instanceof String || this.dataType == 13 || objectSample instanceof BigDecimal) {
            if (objectSample == null) {
                return 42;
            }
            return 42 + 2 * objectSample.toString().length();
        }
        if (objectSample != null) {
            System.err.println("Unrecognized data type: " + objectSample.getClass().getName() + ", use default max size");
        }
        return ServerMessage.getMaxFieldSize();
    }

    protected String getFileName() {
        if (this.data instanceof DataSetDISK) {
            return ((DataSetDISK)this.data).fileName;
        }
        return null;
    }

    @Override
    public long getMemSizeUsed() {
        return this.currentSize;
    }

    public IDataSet getData() {
        return this.data;
    }
}

