/*
 * Decompiled with CFR 0.152.
 */
package quadbase.common.util.internal;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import quadbase.common.util.internal.IDataSet;
import quadbase.common.util.internal.IOUtil;
import quadbase.common.util.internal.QbDebug;

public class DataSetARRAY
implements IDataSet {
    protected int size = 0;
    protected int blockSize = -1;
    protected int dataType = -1;
    protected int maxBuffer = -1;
    protected int wBufferPtr = 0;
    protected byte[] buffer;
    protected ByteArrayOutputStream bos;
    protected DataOutputStream dos;
    protected ObjectOutputStream oos;
    protected ByteArrayInputStream bis;
    protected ObjectInputStream ois;
    protected boolean isFinalized = false;
    private int WRITE_OBJECT = 0;
    private int REMOVE_ALL_OBJECTS = 2;
    private int RELEASE_READ_BUFFER = 3;

    public DataSetARRAY(int blockSize, int dataType, int maxBuffer) {
        this.dataType = dataType;
        this.checkDataType();
        this.blockSize = blockSize;
        this.maxBuffer = maxBuffer;
    }

    protected void initialBuffer() {
        this.buffer = new byte[this.blockSize * this.maxBuffer];
        this.wBufferPtr = 0;
    }

    protected void releaseBuffer() {
        this.wBufferPtr = 0;
        this.buffer = null;
    }

    @Override
    public void addElement(Object obj) {
        if (this.isFinalized) {
            return;
        }
        try {
            this.processData(this.WRITE_OBJECT, obj);
            ++this.size;
        }
        catch (Exception ex) {
            if (this.isFinalized) {
                return;
            }
            throw new IllegalArgumentException(IOUtil.getStackTrace(ex));
        }
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public long getMemSizeUsed() {
        return 0L;
    }

    @Override
    public Object elementAt(int i) {
        Object res;
        if (this.isFinalized) {
            return null;
        }
        if (this.buffer == null) {
            return null;
        }
        try {
            res = this.readObject(this.buffer, i * this.blockSize);
        }
        catch (Exception ex) {
            if (this.isFinalized) {
                return null;
            }
            throw new IllegalArgumentException(IOUtil.getStackTrace(ex));
        }
        return res;
    }

    @Override
    public void setElementAt(Object obj, int index) {
        System.out.println("DATASETDISK - setElementAt");
    }

    @Override
    public Object clone() {
        return null;
    }

    @Override
    public Object cloneStructure() {
        return null;
    }

    @Override
    public void insertElementAt(Object obj, int index) {
        System.out.println("DATASETDISK - insertElementAt");
    }

    @Override
    public void removeElementAt(int index) {
        System.out.println("DATASETDISK - removeElementAt");
    }

    @Override
    public void removeAllElements() {
        try {
            this.processData(this.REMOVE_ALL_OBJECTS, null);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void removeAllObjects() {
        if (this.size != 0) {
            this.reset();
        }
    }

    @Override
    public boolean isValid() {
        return true;
    }

    public boolean willFit(IDataSet data) {
        return data.size() < this.maxBuffer;
    }

    public boolean willFit(Object obj) {
        return this.wBufferPtr < this.blockSize * this.maxBuffer - this.blockSize;
    }

    @Override
    public void cleanup() {
        try {
            this.finalize();
        }
        catch (Throwable ex) {
            throw new IllegalArgumentException(IOUtil.getStackTrace(ex));
        }
    }

    protected void finalize() throws Throwable {
        try {
            if (this.isFinalized) {
                return;
            }
            this.isFinalized = true;
            this.releaseBuffer();
        }
        finally {
            super.finalize();
        }
    }

    @Override
    public void releaseDiskBuffer() {
    }

    private void reset() {
        this.releaseBuffer();
        this.bos = null;
        this.oos = null;
        this.dos = null;
        this.bis = null;
        this.ois = null;
        this.size = 0;
    }

    protected void writeObject(Object obj) throws Exception {
        if (this.buffer == null) {
            this.initialBuffer();
        }
        if (!this.willFit(obj)) {
            throw new Exception("Object " + obj + " will not fit in the DataSetARRAY!");
        }
        if (obj == null) {
            this.buffer[this.wBufferPtr] = 0;
        } else if (obj.equals("")) {
            this.buffer[this.wBufferPtr] = 2;
        } else {
            switch (this.dataType) {
                case 0: {
                    this.getDataOutputStream().writeBoolean((Boolean)obj);
                    break;
                }
                case 11: {
                    this.getDataOutputStream().writeByte(((Byte)obj).byteValue());
                    break;
                }
                case 12: {
                    this.getDataOutputStream().writeShort(((Short)obj).shortValue());
                    break;
                }
                case 2: {
                    this.getDataOutputStream().writeInt((Integer)obj);
                    break;
                }
                case 1: {
                    this.getDataOutputStream().writeLong((Long)obj);
                    break;
                }
                case 3: {
                    this.getDataOutputStream().writeFloat(((Float)obj).floatValue());
                    break;
                }
                case 4: {
                    this.getDataOutputStream().writeDouble((Double)obj);
                    break;
                }
                case 8: 
                case 9: 
                case 10: {
                    this.getDataOutputStream().writeLong(((java.util.Date)obj).getTime());
                    break;
                }
                default: {
                    if (this.bos == null) {
                        this.bos = new ByteArrayOutputStream();
                    }
                    this.bos.reset();
                    this.oos = new ObjectOutputStream(this.bos);
                    this.oos.writeObject(obj);
                    this.oos.flush();
                    this.oos.close();
                }
            }
            if (this.bos.size() > this.blockSize) {
                System.out.println("EXCEED SIZE LIMIT, size [" + this.bos.size() + "] max [" + this.blockSize + "]");
                QbDebug.println(6, "EXCEED SIZE LIMIT - OBJ CLASS = " + obj.getClass().toString() + " VAL = " + obj.toString());
                this.buffer[this.wBufferPtr] = 0;
            } else {
                this.buffer[this.wBufferPtr] = 1;
                byte[] data = this.bos.toByteArray();
                System.arraycopy(data, 0, this.buffer, this.wBufferPtr + 1, data.length);
            }
        }
        this.wBufferPtr += this.blockSize;
    }

    private synchronized Object processData(int flag, Object obj) throws Exception {
        if (flag == this.WRITE_OBJECT) {
            this.writeObject(obj);
            return null;
        }
        if (flag == this.REMOVE_ALL_OBJECTS) {
            this.removeAllObjects();
            return null;
        }
        if (flag == this.RELEASE_READ_BUFFER) {
            this.releaseBuffer();
            return null;
        }
        return null;
    }

    private Object readObject(byte[] data, int offset) throws Exception {
        if (this.isFinalized) {
            return null;
        }
        if (data[offset] == 0) {
            return null;
        }
        if (data[offset] == 2) {
            return "";
        }
        this.bis = new ByteArrayInputStream(data, offset + 1, this.blockSize - 1);
        DataInputStream dis = new DataInputStream(this.bis);
        switch (this.dataType) {
            case 0: {
                return dis.readBoolean();
            }
            case 11: {
                return dis.readByte();
            }
            case 12: {
                return dis.readShort();
            }
            case 2: {
                return dis.readInt();
            }
            case 1: {
                return dis.readLong();
            }
            case 3: {
                return Float.valueOf(dis.readFloat());
            }
            case 4: {
                return dis.readDouble();
            }
            case 8: {
                return new Date(dis.readLong());
            }
            case 9: {
                return new Time(dis.readLong());
            }
            case 10: {
                return new Timestamp(dis.readLong());
            }
        }
        this.ois = new ObjectInputStream(this.bis);
        Object result = this.ois.readObject();
        return result;
    }

    protected DataOutputStream getDataOutputStream() {
        if (this.bos == null) {
            this.bos = new ByteArrayOutputStream();
        }
        this.bos.reset();
        if (this.dos == null) {
            this.dos = new DataOutputStream(this.bos);
        }
        return this.dos;
    }

    protected void checkDataType() throws IllegalArgumentException {
        if (this.dataType == 7 || this.dataType == 13) {
            throw new IllegalArgumentException("DataSetARRAYIndexed should be used instead of DataSetARRAY for STRING and BIGDECIMAL data type");
        }
    }
}

