/*
 * Decompiled with CFR 0.152.
 */
package quadbase.common.util.internal;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.math.BigDecimal;
import quadbase.common.util.internal.DataSetARRAY;
import quadbase.common.util.internal.DataSetARRAYIndexed;
import quadbase.common.util.internal.DataSetDISK;
import quadbase.common.util.internal.IOUtil;

public class DataSetDISKIndexed
extends DataSetDISK {
    private DataSetDISK index;
    private int filePosition = 0;
    private int currentBlock = -1;

    public DataSetDISKIndexed(String name, int blockSize, int dataType, int maxBuffer) {
        super(name, blockSize, dataType, maxBuffer);
        this.index = new DataSetDISK("I_" + name, 5, 2, maxBuffer / 4);
    }

    public DataSetDISKIndexed(DataSetDISKIndexed _disk, String name) {
        super(_disk, name);
        this.index = new DataSetDISK(this.index, "I_" + name);
    }

    @Override
    protected void copy(DataSetARRAY dataARRAY) {
        if (!(dataARRAY instanceof DataSetARRAYIndexed)) {
            throw new IllegalArgumentException("Argument of DataSetDISKIndexed.copy must be DataSetARRAYIndexed");
        }
        super.copy(dataARRAY);
        this.filePosition = this.wBufferPtr;
        DataSetARRAYIndexed dai = (DataSetARRAYIndexed)dataARRAY;
        for (int i = 0; i < dai.index.size(); ++i) {
            this.index.addElement(dai.index.elementAt(i));
        }
    }

    @Override
    protected void initialWriteBuffer() {
        super.initialWriteBuffer();
        this.filePosition = 0;
        this.index.addElement(this.filePosition);
    }

    @Override
    protected void releaseWriteBuffer() {
        super.releaseWriteBuffer();
        this.filePosition = 0;
    }

    @Override
    protected void releaseReadBuffer() {
        super.releaseReadBuffer();
        this.currentBlock = -1;
    }

    @Override
    public void releaseDiskBuffer() {
        this.index.releaseDiskBuffer();
        super.releaseDiskBuffer();
    }

    @Override
    public Object elementAt(int i) {
        if (this.isFinalized) {
            return null;
        }
        if (this.index == null || this.index.isFinalized) {
            return null;
        }
        try {
            Object res;
            Integer tmp = (Integer)this.index.elementAt(i);
            if (tmp == null) {
                return null;
            }
            int startPosition = tmp;
            tmp = (Integer)this.index.elementAt(i + 1);
            if (tmp == null) {
                return null;
            }
            int startBlockNumber = startPosition / (this.maxBuffer * this.blockSize);
            int endPosition = tmp;
            int endBlockNumber = endPosition / (this.maxBuffer * this.blockSize);
            if (startBlockNumber != endBlockNumber || startBlockNumber != this.currentBlock) {
                try {
                    res = this.processData(1, i, null);
                }
                catch (Exception ex) {
                    if (this.isFinalized) {
                        return null;
                    }
                    throw new IllegalArgumentException(IOUtil.getStackTrace(ex));
                }
            }
            startPosition -= startBlockNumber * this.maxBuffer * this.blockSize;
            endPosition -= endBlockNumber * this.maxBuffer * this.blockSize;
            try {
                res = this.readObject(this.readBuffer, startPosition, endPosition - startPosition);
            }
            catch (Exception ex) {
                if (this.isFinalized) {
                    return null;
                }
                throw new IllegalArgumentException(IOUtil.getStackTrace(ex));
            }
            if (i == this.size - 1) {
                try {
                    this.processData(3, -1, null);
                }
                catch (Exception ex) {
                    if (this.isFinalized) {
                        return null;
                    }
                    throw new IllegalArgumentException(IOUtil.getStackTrace(ex));
                }
            }
            return res;
        }
        catch (Exception ex) {
            if (this.isFinalized || this.index.isFinalized) {
                return null;
            }
            throw new IllegalArgumentException(IOUtil.getStackTrace(ex));
        }
    }

    @Override
    public void removeAllObjects() {
        super.removeAllObjects();
        this.index.removeAllElements();
    }

    @Override
    protected void finalize() throws Throwable {
        this.index.finalize();
        super.finalize();
    }

    @Override
    protected void reset() {
        super.reset();
        this.index.reset();
    }

    @Override
    protected void writeObject(Object obj) throws Exception {
        if (this.writeBuffer == null) {
            this.initialWriteBuffer();
        }
        if (this.index == null || this.index.isFinalized) {
            return;
        }
        try {
            if (obj == null) {
                if (this.wBufferPtr + 1 >= this.writeBuffer.length) {
                    this.writeToFile();
                }
                this.writeBuffer[this.wBufferPtr] = 0;
                ++this.wBufferPtr;
                ++this.filePosition;
                this.index.addElement(this.filePosition);
            } else if (obj.equals("")) {
                if (this.wBufferPtr + 1 >= this.writeBuffer.length) {
                    this.writeToFile();
                }
                this.writeBuffer[this.wBufferPtr] = 2;
                ++this.wBufferPtr;
                ++this.filePosition;
                this.index.addElement(this.filePosition);
            } else {
                byte[] barray = obj.toString().getBytes();
                if (barray.length > this.writeBuffer.length) {
                    System.err.println("String is too long to fit the buffer, it will be truncated.");
                    byte[] newArray = new byte[this.writeBuffer.length];
                    System.arraycopy(barray, 0, newArray, 0, newArray.length);
                    barray = newArray;
                }
                this.filePosition += barray.length;
                this.index.addElement(this.filePosition);
                if (barray.length + this.wBufferPtr >= this.writeBuffer.length) {
                    int splitIndex = this.writeBuffer.length - this.wBufferPtr;
                    System.arraycopy(barray, 0, this.writeBuffer, this.wBufferPtr, splitIndex);
                    this.wBufferPtr += splitIndex;
                    this.writeToFile();
                    System.arraycopy(barray, splitIndex, this.writeBuffer, this.wBufferPtr, barray.length - splitIndex);
                    this.wBufferPtr += barray.length - splitIndex;
                } else {
                    System.arraycopy(barray, 0, this.writeBuffer, this.wBufferPtr, barray.length);
                    this.wBufferPtr += barray.length;
                }
            }
        }
        catch (Exception ex) {
            if (this.isFinalized || this.index.isFinalized) {
                return;
            }
            throw new IllegalArgumentException(IOUtil.getStackTrace(ex));
        }
    }

    @Override
    protected Object readObject(int startIndex) throws Exception {
        if (this.writeBuffer != null && this.wBufferPtr > 0) {
            this.writeToFile();
            this.currentBlock = -1;
        }
        if (this.isFinalized) {
            return null;
        }
        int startPosition = (Integer)this.index.elementAt(startIndex);
        int endPosition = (Integer)this.index.elementAt(startIndex + 1);
        int startBlockNumber = startPosition / (this.maxBuffer * this.blockSize);
        int endBlockNumber = endPosition / (this.maxBuffer * this.blockSize);
        int length = endPosition - startPosition;
        startPosition -= startBlockNumber * this.maxBuffer * this.blockSize;
        endPosition -= endBlockNumber * this.maxBuffer * this.blockSize;
        if (this.currentBlock != startBlockNumber) {
            this.readBlock(startBlockNumber);
        }
        if (startBlockNumber == endBlockNumber) {
            return this.readObject(this.readBuffer, startPosition, length);
        }
        byte[] barray = new byte[length];
        int splitIndex = this.readBuffer.length - startPosition;
        System.arraycopy(this.readBuffer, startPosition, barray, 0, splitIndex);
        this.readBlock(endBlockNumber);
        System.arraycopy(this.readBuffer, 0, barray, splitIndex, barray.length - splitIndex);
        return this.readObject(barray, 0, barray.length);
    }

    private void readBlock(int blockNumber) throws IOException {
        int start = blockNumber * this.maxBuffer * this.blockSize;
        if (this.rf == null) {
            this.openIO();
        }
        this.rf.seek(start);
        if (this.readBuffer == null) {
            this.initialReadBuffer(this.maxBuffer);
        }
        this.rf.read(this.readBuffer);
        this.currentBlock = blockNumber;
    }

    private Object readObject(byte[] data, int offset, int length) throws Exception {
        if (length == 1 && data[offset] == 0) {
            return null;
        }
        if (length == 1 && data[offset] == 2) {
            return "";
        }
        if (this.isFinalized) {
            return null;
        }
        this.bis = new ByteArrayInputStream(data, offset, length);
        byte[] barray = new byte[length];
        this.bis.read(barray, 0, length);
        String tmpStr = new String(barray);
        if (this.dataType == 13) {
            return new BigDecimal(tmpStr);
        }
        return tmpStr;
    }

    @Override
    protected void checkDataType() throws IllegalArgumentException {
        if (this.dataType != 7 && this.dataType != 13) {
            throw new IllegalArgumentException("DataSetDISKIndexed works only with STRING or BIGDECIMAL data type");
        }
    }
}

