/*
 * Decompiled with CFR 0.152.
 */
package quadbase.common.util.internal;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URL;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Vector;
import quadbase.common.client.ServerMessage;
import quadbase.common.util.internal.CloseUtils;
import quadbase.common.util.internal.IOUtil;
import quadbase.common.util.internal.IReportDocument;
import quadbase.common.util.internal.IReportImage;

public final class DataType {
    public static final int BOOLEAN = 0;
    public static final int LONG = 1;
    public static final int INT = 2;
    public static final int FLOAT = 3;
    public static final int DOUBLE = 4;
    public static final int NUMERIC = 5;
    public static final int CHAR = 6;
    public static final int STRING = 7;
    public static final int DATE = 8;
    public static final int TIME = 9;
    public static final int TIMESTAMP = 10;
    public static final int BYTE = 11;
    public static final int SHORT = 12;
    public static final int BIGDECIMAL = 13;
    public static final int UNKNOWN = 14;
    public static final int BINARY = 15;
    public static final int CLOB = 16;
    public static final int VALUE = 99;
    public static final int JDBC_4_NCHAR = -15;
    public static final int JDBC_4_NVARCHAR = -9;
    public static final int JDBC_4_LONGNVARCHAR = -16;
    public static final int JDBC_4_NCLOB = 2011;
    public static final String EMPTY_STRING = "^QB_EMPTY_STRING";

    public static final boolean isNumeric(int datatype) {
        return datatype < 6 || datatype == 11 || datatype == 12 || datatype == 13;
    }

    public static final boolean isSuitableForTranspose(int datatype) {
        return datatype < 6 && datatype > 0 || datatype == 11 || datatype == 12 || datatype == 13 || datatype == 9;
    }

    public static final boolean isReal(int datatype) {
        return datatype == 4 || datatype == 3 || datatype == 5 || datatype == 13;
    }

    public static final boolean isInt(int datatype) {
        return datatype == 0 || datatype == 2 || datatype == 1 || datatype == 11 || datatype == 12;
    }

    public static final boolean isDate(int datatype) {
        return datatype == 8;
    }

    public static final boolean isTimestamp(int datatype) {
        return datatype == 10;
    }

    public static final boolean isTime(int datatype) {
        return datatype == 9;
    }

    public static final boolean isDateTime(int datatype) {
        return datatype == 9 || datatype == 10 || datatype == 8;
    }

    public static int mapType(int t) {
        if (t == 1 || t == 12 || t == -15 || t == -9 || t == -1 || t == -16) {
            return 7;
        }
        if (t == 2 || t == 3) {
            return 13;
        }
        if (t == -7) {
            return 0;
        }
        if (t == 16) {
            return 0;
        }
        if (t == -6) {
            return 11;
        }
        if (t == 5) {
            return 12;
        }
        if (t == 4) {
            return 2;
        }
        if (t == -5) {
            return 1;
        }
        if (t == 7) {
            return 3;
        }
        if (t == 8 || t == 6) {
            return 4;
        }
        if (t == 91) {
            return 8;
        }
        if (t == 92) {
            return 9;
        }
        if (t == 93) {
            return 10;
        }
        if (t == 2004 || t == -2 || t == -3 || t == -4) {
            return 15;
        }
        if (t == 2005 || t == 2011) {
            return 16;
        }
        return 7;
    }

    public static final void write(DataOutput out, Object obj) throws IOException {
        if (obj == null || obj.equals("")) {
            out.writeBoolean(true);
            return;
        }
        out.writeBoolean(false);
        if (obj instanceof String) {
            IOUtil.writeString(out, obj.toString());
        } else if (obj instanceof BigDecimal) {
            IOUtil.writeString(out, ((BigDecimal)obj).toString());
        } else if (obj instanceof BigInteger) {
            out.writeLong(((BigInteger)obj).longValue());
        } else if (obj instanceof Boolean) {
            out.writeBoolean((Boolean)obj);
        } else if (obj instanceof Character) {
            out.writeChar(((Character)obj).charValue());
        } else if (obj instanceof Double) {
            out.writeDouble((Double)obj);
        } else if (obj instanceof Float) {
            out.writeFloat(((Float)obj).floatValue());
        } else if (obj instanceof Integer) {
            out.writeInt((Integer)obj);
        } else if (obj instanceof Long) {
            out.writeLong((Long)obj);
        } else if (obj instanceof Date) {
            out.writeLong(((Date)obj).getTime());
        } else if (obj instanceof Time) {
            out.writeLong(((Time)obj).getTime());
        } else if (obj instanceof Timestamp) {
            out.writeLong(((Timestamp)obj).getTime());
            out.writeInt(((Timestamp)obj).getNanos());
        } else if (obj instanceof Byte) {
            out.writeByte(((Byte)obj).byteValue());
        } else if (obj instanceof Short) {
            out.writeShort(((Short)obj).shortValue());
        } else if (obj instanceof IReportDocument) {
            IOUtil.writeStr(out, ((IReportDocument)obj).getTextString());
            IOUtil.writeStr(out, ((IReportDocument)obj).getRelativePath());
        } else if (obj instanceof IReportImage) {
            IOUtil.writeString(out, ((IReportImage)obj).getRelativePath());
        } else {
            IOUtil.writeString(out, obj == null ? null : obj.toString());
        }
    }

    public static final void write(DataOutput out, int sqlType, Object obj) throws IOException {
        if (obj != null && !obj.equals("")) {
            if (sqlType == 1) {
                DataType.write(out, obj.toString());
                return;
            }
            if (sqlType == 4 && !(obj instanceof Integer)) {
                DataType.write(out, Integer.valueOf(obj.toString()));
                return;
            }
            if (sqlType == 5 && !(obj instanceof Short)) {
                DataType.write(out, Short.valueOf(obj.toString()));
                return;
            }
            if (sqlType == -6 && !(obj instanceof Byte)) {
                DataType.write(out, Byte.valueOf(obj.toString()));
                return;
            }
            if (sqlType == -5 && !(obj instanceof Long)) {
                DataType.write(out, Long.valueOf(obj.toString()));
                return;
            }
            if (!(sqlType != 6 && sqlType != 8 || obj instanceof Short)) {
                DataType.write(out, Double.valueOf(obj.toString()));
                return;
            }
            if (sqlType == 7 && !(obj instanceof Float)) {
                DataType.write(out, Float.valueOf(obj.toString()));
                return;
            }
            if (!(sqlType != 2 && sqlType != 3 || obj instanceof BigDecimal)) {
                DataType.write(out, new BigDecimal(obj.toString()));
                return;
            }
            if (sqlType == 91 && !(obj instanceof Date)) {
                if (obj instanceof java.util.Date) {
                    DataType.write(out, new Date(((java.util.Date)obj).getTime()));
                } else if (obj instanceof String) {
                    try {
                        DataType.write(out, DataType.createObject((String)obj, 8, null));
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                }
                return;
            }
            if (sqlType == 92 && !(obj instanceof Time)) {
                if (obj instanceof java.util.Date) {
                    DataType.write(out, new Time(((java.util.Date)obj).getTime()));
                } else if (obj instanceof String) {
                    try {
                        DataType.write(out, DataType.createObject((String)obj, 9, null));
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                }
                return;
            }
            if (sqlType == 93 && !(obj instanceof Timestamp)) {
                if (obj instanceof java.util.Date) {
                    DataType.write(out, new Timestamp(((java.util.Date)obj).getTime()));
                } else if (obj instanceof String) {
                    try {
                        DataType.write(out, DataType.createObject((String)obj, 10, null));
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                }
                return;
            }
        } else if (obj != null && obj.equals("") && (sqlType == -16 || sqlType == -1 || sqlType == 12 || sqlType == 1 || sqlType == -15 || sqlType == -9 || sqlType == 1111 || sqlType == -9)) {
            DataType.write(out, EMPTY_STRING);
            return;
        }
        DataType.write(out, obj);
    }

    public static final String write(Object obj) {
        if (obj == null) {
            return "0";
        }
        String ret = "1";
        if (obj instanceof String) {
            return ret + 12 + " " + obj.toString();
        }
        if (obj instanceof BigDecimal) {
            return ret + 3 + " " + obj.toString();
        }
        if (obj instanceof BigInteger) {
            return ret + -5 + " " + obj.toString();
        }
        if (obj instanceof Boolean) {
            return ret + -7 + " " + obj.toString();
        }
        if (obj instanceof Character) {
            return ret + 1 + " " + obj.toString();
        }
        if (obj instanceof Double) {
            return ret + 8 + " " + obj.toString();
        }
        if (obj instanceof Float) {
            return ret + 6 + " " + obj.toString();
        }
        if (obj instanceof Integer) {
            return ret + 4 + " " + obj.toString();
        }
        if (obj instanceof Long) {
            return ret + -5 + " " + obj.toString();
        }
        if (obj instanceof Date) {
            return ret + 91 + " " + ((Date)obj).getTime();
        }
        if (obj instanceof Time) {
            return ret + 92 + " " + ((Time)obj).getTime();
        }
        if (obj instanceof Timestamp) {
            return ret + 93 + " " + ((Timestamp)obj).getTime() + " " + ((Timestamp)obj).getNanos();
        }
        if (obj instanceof Byte) {
            return ret + -6 + " " + obj.toString();
        }
        if (obj instanceof Short) {
            return ret + 5 + " " + obj.toString();
        }
        if (obj instanceof IReportImage) {
            return ret + 2004 + " " + ((IReportImage)obj).getRelativePath();
        }
        if (obj instanceof IReportDocument) {
            IReportDocument doc = (IReportDocument)obj;
            if (doc.getTextString() != null) {
                return ret + 2005 + " 0" + doc.getTextString();
            }
            return ret + 2005 + " 1" + doc.getRelativePath();
        }
        return "0";
    }

    /*
     * Exception decompiling
     */
    public static final Object read(String in) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static final Object read(DataInput in, int type, int version, boolean isUTF) throws IOException {
        if (in.readBoolean()) {
            return null;
        }
        switch (type) {
            case -16: 
            case -15: 
            case -9: 
            case -1: 
            case 1: 
            case 12: 
            case 1111: {
                return DataType.checkEmptyString(IOUtil.readString(in, isUTF));
            }
            case 4: {
                return in.readInt();
            }
            case 5: {
                return in.readShort();
            }
            case -6: {
                return in.readByte();
            }
            case -5: {
                return in.readLong();
            }
            case 6: 
            case 8: {
                return in.readDouble();
            }
            case 7: {
                return Float.valueOf(in.readFloat());
            }
            case 2: 
            case 3: {
                return new BigDecimal(IOUtil.readString(in, isUTF));
            }
            case -7: 
            case 16: {
                return in.readBoolean();
            }
            case 91: {
                return new Date(in.readLong());
            }
            case 92: {
                return new Time(in.readLong());
            }
            case 93: {
                Timestamp ts = new Timestamp(in.readLong());
                ts.setNanos(in.readInt());
                return ts;
            }
            case -4: 
            case -3: 
            case -2: 
            case 2004: {
                String relPath = IOUtil.readString(in, isUTF);
                if (type == -3 && relPath.indexOf("DBImages") < 0) {
                    return DataType.checkEmptyString(relPath);
                }
                try {
                    Class<?> ri_Class = Class.forName("quadbase.reportdesigner.ReportElements.ReportImage");
                    Constructor<?> constructor = ri_Class.getConstructor(Class.forName("java.lang.String"));
                    IReportImage imagecell = (IReportImage)constructor.newInstance("<BINARY DATA>");
                    imagecell.setRelativePath(relPath);
                    imagecell.setDBImage(true);
                    return imagecell;
                }
                catch (Exception ex) {
                    return null;
                }
            }
            case 2005: 
            case 2011: {
                try {
                    Class<?> ri_Class = Class.forName("quadbase.reportdesigner.ReportElements.ReportDocument");
                    Constructor<?> constructor = ri_Class.getConstructor(Class.forName("java.lang.String"));
                    IReportDocument doccell = (IReportDocument)constructor.newInstance("<DOCUMENT DATA>");
                    String textString = IOUtil.readStr(in);
                    doccell.setTextString(textString);
                    String relativePath = IOUtil.readStr(in);
                    doccell.setRelativePath(relativePath);
                    return doccell;
                }
                catch (Exception ex) {
                    return null;
                }
            }
        }
        in.readByte();
        return null;
    }

    public static int findType(Object s) throws IllegalArgumentException {
        if (s instanceof Integer) {
            return 4;
        }
        if (s instanceof Long) {
            return -5;
        }
        if (s instanceof Double) {
            return 8;
        }
        if (s instanceof Float) {
            return 6;
        }
        if (s instanceof String) {
            return 12;
        }
        if (s instanceof Date) {
            return 91;
        }
        if (s instanceof Time) {
            return 92;
        }
        if (s instanceof Timestamp) {
            return 93;
        }
        if (s instanceof Boolean) {
            return -7;
        }
        if (s instanceof BigInteger) {
            return -5;
        }
        if (s instanceof BigDecimal) {
            return 3;
        }
        if (s instanceof Byte) {
            return -6;
        }
        if (s instanceof Short) {
            return 5;
        }
        if (s instanceof IReportImage) {
            return -4;
        }
        if (s instanceof IReportDocument) {
            return 2005;
        }
        throw new IllegalArgumentException("Unsupported type " + s);
    }

    public static int findType(String s) throws IllegalArgumentException {
        if (s.equalsIgnoreCase("int") || s.equalsIgnoreCase("integer")) {
            return 4;
        }
        if (s.equalsIgnoreCase("smallint") || s.equalsIgnoreCase("short")) {
            return 5;
        }
        if (s.equalsIgnoreCase("tinyint") || s.equalsIgnoreCase("byte")) {
            return -6;
        }
        if (s.equalsIgnoreCase("long") || s.equalsIgnoreCase("bigint")) {
            return -5;
        }
        if (s.equalsIgnoreCase("numeric")) {
            return 2;
        }
        if (s.equalsIgnoreCase("decimal")) {
            return 3;
        }
        if (s.equalsIgnoreCase("real")) {
            return 6;
        }
        if (s.equalsIgnoreCase("float") || s.equalsIgnoreCase("double")) {
            return 8;
        }
        if (s.equalsIgnoreCase("time")) {
            return 92;
        }
        if (s.equalsIgnoreCase("date")) {
            return 91;
        }
        if (s.equalsIgnoreCase("timestamp")) {
            return 93;
        }
        if (s.equalsIgnoreCase("string") || s.equalsIgnoreCase("varchar")) {
            return 12;
        }
        if (s.equalsIgnoreCase("longvarchar") || s.equalsIgnoreCase("longnvarchar")) {
            return -1;
        }
        if (s.equalsIgnoreCase("boolean") || s.equalsIgnoreCase("logical") || s.equalsIgnoreCase("bit")) {
            return -7;
        }
        if (s.equalsIgnoreCase("blob") || s.equalsIgnoreCase("binary") || s.equalsIgnoreCase("varbinary") || s.equalsIgnoreCase("longvarbinary")) {
            return -4;
        }
        if (s.equalsIgnoreCase("clob")) {
            return 2005;
        }
        throw new IllegalArgumentException("Invalid data type " + s);
    }

    public static String toString(Object obj, String dateFormat) {
        if (obj == null) {
            return "";
        }
        if (obj instanceof Vector) {
            StringBuilder builder = new StringBuilder();
            Vector vec = (Vector)obj;
            for (int i = 0; i < vec.size(); ++i) {
                Object o = vec.get(i);
                builder.append(DataType.toString(o, dateFormat));
                if (i >= vec.size() - 1) continue;
                builder.append(", ");
            }
            return builder.toString();
        }
        if (dateFormat == null) {
            return obj.toString();
        }
        if (obj instanceof java.util.Date) {
            SimpleDateFormat format = new SimpleDateFormat(dateFormat);
            return format.format((java.util.Date)obj);
        }
        return obj.toString();
    }

    public static final Object createObject(String value, int dtype) throws IllegalArgumentException, NumberFormatException {
        try {
            return DataType.createObject(value, dtype, null);
        }
        catch (ParseException ex) {
            return null;
        }
    }

    public static final Object createObject(String value, int dtype, String dateFormat) throws IllegalArgumentException, NumberFormatException, ParseException {
        if (value == null) {
            return null;
        }
        if (value.length() == 0 && dtype != 7) {
            return null;
        }
        switch (dtype) {
            case 11: {
                return Byte.valueOf(value);
            }
            case 12: {
                return DataType.parseShort(value);
            }
            case 2: {
                return DataType.parseInt(value);
            }
            case 1: {
                return DataType.parseLong(value);
            }
            case 3: {
                return Float.valueOf(value);
            }
            case 4: {
                return Double.valueOf(value);
            }
            case 5: 
            case 13: {
                return new BigDecimal(value);
            }
            case 6: 
            case 7: {
                return value;
            }
            case 9: {
                if (dateFormat == null) {
                    return Time.valueOf(value);
                }
                SimpleDateFormat format = new SimpleDateFormat(dateFormat);
                return new Time(format.parse(value).getTime());
            }
            case 8: {
                if (dateFormat == null) {
                    return Date.valueOf(value);
                }
                SimpleDateFormat format = new SimpleDateFormat(dateFormat);
                try {
                    return new Date(format.parse(value).getTime());
                }
                catch (ParseException e) {
                    return Date.valueOf(value);
                }
            }
            case 10: {
                if (dateFormat == null) {
                    return Timestamp.valueOf(value);
                }
                SimpleDateFormat format = new SimpleDateFormat(dateFormat);
                return new Timestamp(format.parse(value).getTime());
            }
            case 0: {
                if (value.startsWith("1")) {
                    return Boolean.TRUE;
                }
                if (value.startsWith("0")) {
                    return Boolean.FALSE;
                }
                if (value.equalsIgnoreCase("true") || value.equalsIgnoreCase("t")) {
                    return Boolean.TRUE;
                }
                if (value.equalsIgnoreCase("false") || value.equalsIgnoreCase("f")) {
                    return Boolean.FALSE;
                }
                throw new IllegalArgumentException("Invalid boolean value " + value);
            }
            case 15: {
                try {
                    Class<?> ri_Class = Class.forName("quadbase.reportdesigner.ReportElements.ReportImage");
                    Constructor<?> constructor = ri_Class.getConstructor(Class.forName("java.lang.String"));
                    IReportImage imagecell = (IReportImage)constructor.newInstance("<BINARY DATA>");
                    URL imageurl = new URL(value);
                    imagecell.setImageURL(imageurl, false);
                    return imagecell;
                }
                catch (Exception ri_Class) {
                    // empty catch block
                }
            }
            case 16: {
                try {
                    Class<?> ri_Class = Class.forName("quadbase.reportdesigner.ReportElements.ReportDocument");
                    Constructor<?> constructor = ri_Class.getConstructor(Class.forName("java.lang.String"));
                    IReportDocument doccell = (IReportDocument)constructor.newInstance("<DOCUMENT DATA>");
                    if (value.length() < 10000) {
                        doccell.setTextString(value);
                    } else {
                        doccell.setRelativePath(value);
                    }
                    return doccell;
                }
                catch (Exception e) {
                    return null;
                }
            }
        }
        throw new IllegalArgumentException("Invalid data type " + dtype + " value = " + value);
    }

    private static Object parseInt(String value) throws NumberFormatException {
        try {
            return Integer.valueOf(value);
        }
        catch (Exception ex) {
            return (int)Double.valueOf(value).doubleValue();
        }
    }

    private static Object parseLong(String value) throws NumberFormatException {
        try {
            return Long.valueOf(value);
        }
        catch (Exception ex) {
            return (long)((int)Double.valueOf(value).doubleValue());
        }
    }

    private static Object parseShort(String value) throws NumberFormatException {
        try {
            return Short.valueOf(value);
        }
        catch (Exception ex) {
            return (short)Double.valueOf(value).doubleValue();
        }
    }

    public static String getTypeName2(int t) {
        if (t == 1 || t == 12 || t == -15 || t == -9 || t == -1 || t == -16) {
            return "String";
        }
        if (t == 2 || t == 3) {
            return "Decimal";
        }
        if (t == 8 || t == 6) {
            return "Double";
        }
        return DataType.getTypeName(t);
    }

    public static String getTypeName(int t) {
        switch (t) {
            case 1: 
            case 1111: {
                return "String";
            }
            case -15: {
                return "String";
            }
            case 12: {
                return "Varchar";
            }
            case -9: {
                return "Varchar";
            }
            case -1: {
                return "Longvarchar";
            }
            case -16: {
                return "Longnvarchar";
            }
            case 16: {
                return "Boolean";
            }
            case -7: {
                return "Bit";
            }
            case 6: {
                return "Float";
            }
            case 8: {
                return "Double";
            }
            case 2: {
                return "Numeric";
            }
            case 3: {
                return "Decimal";
            }
            case 7: {
                return "Real";
            }
            case 91: {
                return "Date";
            }
            case -6: {
                return "Tinyint";
            }
            case 5: {
                return "Smallint";
            }
            case 4: {
                return "Integer";
            }
            case -5: {
                return "Bigint";
            }
            case 92: {
                return "Time";
            }
            case 93: {
                return "Timestamp";
            }
            case -4: 
            case -3: 
            case -2: 
            case 2004: {
                return "Binary";
            }
            case 2005: {
                return "Clob";
            }
            case 2011: {
                return "Clob";
            }
        }
        return "Unsupport Type";
    }

    public static final boolean match(int dtype, Object obj) {
        if (obj == null) {
            return true;
        }
        switch (dtype) {
            case -16: 
            case -15: 
            case -9: 
            case -1: 
            case 1: 
            case 12: 
            case 1111: {
                return obj instanceof String;
            }
            case 4: {
                return obj instanceof Integer;
            }
            case 5: {
                return obj instanceof Short;
            }
            case -6: {
                return obj instanceof Byte;
            }
            case -5: {
                return obj instanceof Long;
            }
            case 6: 
            case 8: {
                return obj instanceof Double;
            }
            case 7: {
                return obj instanceof Float;
            }
            case 2: 
            case 3: {
                return obj instanceof BigDecimal;
            }
            case -7: 
            case 16: {
                return obj instanceof Boolean;
            }
            case 91: {
                return obj instanceof Date;
            }
            case 92: {
                return obj instanceof Time;
            }
            case 93: {
                return obj instanceof Timestamp;
            }
            case -3: {
                return obj instanceof IReportImage || obj instanceof String;
            }
            case -4: 
            case -2: 
            case 2004: {
                return obj instanceof IReportImage;
            }
            case 2005: 
            case 2011: {
                return obj instanceof IReportDocument;
            }
        }
        return false;
    }

    /*
     * Unable to fully structure code
     */
    public static Object getDefaultObject(ResultSet rs, int colNo, int sqlType) throws SQLException {
        res = null;
        switch (sqlType) {
            case -7: 
            case 16: {
                res = rs.getBoolean(colNo);
                return rs.wasNull() != false ? null : res;
            }
            case -6: {
                res = rs.getByte(colNo);
                return rs.wasNull() != false ? null : res;
            }
            case 5: {
                res = rs.getShort(colNo);
                return rs.wasNull() != false ? null : res;
            }
            case 4: {
                res = rs.getInt(colNo);
                return rs.wasNull() != false ? null : res;
            }
            case -5: {
                res = rs.getLong(colNo);
                return rs.wasNull() != false ? null : res;
            }
            case 7: {
                res = Float.valueOf(rs.getFloat(colNo));
                return rs.wasNull() != false ? null : res;
            }
            case 6: 
            case 8: {
                res = rs.getDouble(colNo);
                return rs.wasNull() != false ? null : res;
            }
            case 2: 
            case 3: {
                res = rs.getBigDecimal(colNo);
                return rs.wasNull() != false ? null : res;
            }
            case -16: 
            case -15: 
            case -9: 
            case -1: 
            case 1: 
            case 12: 
            case 1111: {
                res = rs.getString(colNo);
                return rs.wasNull() != false ? null : res;
            }
            case 91: {
                res = rs.getDate(colNo);
                return rs.wasNull() != false ? null : res;
            }
            case 92: {
                res = rs.getTime(colNo);
                return rs.wasNull() != false ? null : res;
            }
            case 93: {
                res = rs.getTimestamp(colNo);
                return rs.wasNull() != false ? null : res;
            }
            case -4: 
            case -3: 
            case -2: 
            case 2004: {
                if (sqlType == -3) {
                    res = rs.getObject(colNo);
                    if (res instanceof String) {
                        return rs.wasNull() != false ? null : res;
                    }
                    res = null;
                }
                data = rs.getBinaryStream(colNo);
                urlStr = "";
                imagefile = null;
                if (data == null) {
                    return null;
                }
                output = null;
                urlStr = IOUtil.nameToURL(null, ServerMessage.getWorkingDirectory(), "DBImages");
                tempdir = new File(ServerMessage.getWorkingDirectory(), "DBImages");
                if (!tempdir.exists()) {
                    tempdir.mkdir();
                } else if (!tempdir.isDirectory()) {
                    tempdir.delete();
                    tempdir.mkdir();
                }
                imagefile = File.createTempFile("img", null, tempdir);
                imagefile.deleteOnExit();
                output = new FileOutputStream(imagefile);
                finished = false;
                count = -1;
                while (!finished) {
                    ++count;
                    b = data.read();
                    if (b != -1) {
                        output.write(b);
                        continue;
                    }
                    finished = true;
                }
                if (count > 0) ** GOTO lbl82
                imagefile.delete();
                b = null;
                CloseUtils.close(output);
                return b;
lbl82:
                // 1 sources

                try {
                    ri_Class = Class.forName("quadbase.reportdesigner.ReportElements.ReportImage");
                    constructor = ri_Class.getConstructor(new Class[]{Class.forName("java.lang.String")});
                    imagecell = (IReportImage)constructor.newInstance(new Object[]{"<BINARY DATA>"});
                    imageurl = new URL(urlStr + File.separatorChar + imagefile.getName());
                    imagecell.setImageURL(imageurl, false);
                    imagecell.setRelativePath("DBImages" + File.separatorChar + imagefile.getName());
                    imagecell.setDBImage(true);
                    var15_28 = imagecell;
                }
                catch (Exception e) {
                    try {
                        throw new SQLException(e.toString());
                    }
                    catch (Throwable var16_29) {
                        CloseUtils.close(output);
                        throw var16_29;
                    }
                }
                CloseUtils.close(output);
                return var15_28;
            }
            case 2005: 
            case 2011: {
                try {
                    clobData = rs.getClob(colNo);
                    if (clobData == null) {
                        return null;
                    }
                    string = clobData.getSubString(1L, (int)clobData.length());
                }
                catch (Exception e) {
                    string = rs.getString(colNo);
                }
                try {
                    ri_Class = Class.forName("quadbase.reportdesigner.ReportElements.ReportDocument");
                    constructor = ri_Class.getConstructor(new Class[]{Class.forName("java.lang.String")});
                    doccell = (IReportDocument)constructor.newInstance(new Object[]{"<DOCUMENT DATA>"});
                    if (string.length() < 10000) {
                        doccell.setTextString(string);
                    } else {
                        fwOut = null;
                        docFile = null;
                        tempdir = new File("docs");
                        if (!tempdir.exists()) {
                            tempdir.mkdir();
                        } else if (!tempdir.isDirectory()) {
                            tempdir.delete();
                            tempdir.mkdir();
                        }
                        docFile = File.createTempFile("doc", ".txt", tempdir);
                        docFile.deleteOnExit();
                        fwOut = new FileWriter(docFile);
                        fwOut.write(string);
                        doccell.setRelativePath("docs" + File.separatorChar + docFile.getName());
                        CloseUtils.close(fwOut);
                    }
                    ** GOTO lbl141
                    catch (Exception e) {
                        try {
                            throw new SQLException(e.toString());
                        }
                        catch (Throwable var17_30) {
                            CloseUtils.close(fwOut);
                            throw var17_30;
                        }
                    }
lbl141:
                    // 2 sources

                    return doccell;
                }
                catch (Exception e) {
                    return null;
                }
            }
        }
        return null;
    }

    public static Object makeDefaultObject(Object obj) {
        if (obj instanceof Number) {
            return obj;
        }
        try {
            return Time.valueOf((String)obj);
        }
        catch (Exception ex1) {
            try {
                return Date.valueOf((String)obj);
            }
            catch (Exception ex2) {
                try {
                    return Timestamp.valueOf((String)obj);
                }
                catch (Exception ex3) {
                    return obj;
                }
            }
        }
    }

    public static int convertUnsigned(int sqlType) {
        if (sqlType == -6) {
            return 5;
        }
        if (sqlType == 5) {
            return 4;
        }
        if (sqlType == 4) {
            return -5;
        }
        return sqlType;
    }

    public static String checkEmptyString(String str) {
        if (str.equals(EMPTY_STRING)) {
            return "";
        }
        return str;
    }

    public static boolean isSuperSet(int type1, int type2) {
        int t2;
        int t1 = DataType.mapType(type1);
        if (t1 == (t2 = DataType.mapType(type2))) {
            return true;
        }
        switch (t1) {
            case 11: {
                return t2 == 0;
            }
            case 12: {
                return t2 == 0 || t2 == 11;
            }
            case 2: {
                return t2 == 0 || t2 == 11 || t2 == 12;
            }
            case 1: {
                return t2 == 0 || t2 == 11 || t2 == 12 || t2 == 2;
            }
            case 3: {
                return t2 == 0 || t2 == 11 || t2 == 12 || t2 == 2 || t2 == 1;
            }
            case 4: {
                return t2 == 0 || t2 == 11 || t2 == 12 || t2 == 2 || t2 == 1 || t2 == 3;
            }
            case 13: {
                return t2 == 0 || t2 == 11 || t2 == 12 || t2 == 2 || t2 == 1 || t2 == 3 || t2 == 4;
            }
            case 10: {
                return t2 == 8 || t2 == 9;
            }
            case 7: {
                return t2 != 15 && t2 != 16 && t2 != 14;
            }
        }
        return false;
    }

    public static boolean isCompatibleSQLTypes(int masterType, int slaveType) {
        switch (masterType) {
            case -1: 
            case 1: 
            case 12: {
                return slaveType == 1 || slaveType == 12 || slaveType == -1;
            }
            case 91: {
                return slaveType == 91;
            }
            case 92: {
                return slaveType == 92;
            }
            case 93: {
                return slaveType == 93;
            }
            case 2: 
            case 3: {
                return slaveType == 2 || slaveType == 3 || slaveType == 6 || slaveType == 8 || slaveType == 7 || slaveType == -5 || slaveType == 4 || slaveType == 5 || slaveType == -6;
            }
            case 8: {
                return slaveType == 6 || slaveType == 8 || slaveType == 7 || slaveType == -5 || slaveType == 4 || slaveType == 5 || slaveType == -6;
            }
            case 6: {
                return slaveType == 7 || slaveType == -5 || slaveType == 4 || slaveType == 5 || slaveType == -6;
            }
            case -5: {
                return slaveType == -5 || slaveType == 4 || slaveType == 5 || slaveType == -6;
            }
            case 4: {
                return slaveType == 4 || slaveType == 5 || slaveType == -6;
            }
            case 5: {
                return slaveType == 5 || slaveType == -6;
            }
            case -6: {
                return slaveType == -6;
            }
            case -7: {
                return slaveType == -7 || slaveType == 16;
            }
        }
        return false;
    }
}

