/*
 * Decompiled with CFR 0.152.
 */
package quadbase.common.util.internal;

public class EJBUtil {
    public static final String[] PROP_KEYS = new String[]{"APPLET", "AUTHORITATIVE", "BATCHSIZE", "DNS_URL", "INITIAL_CONTEXT_FACTORY", "LANGUAGE", "OBJECT_FACTORIES", "PROVIDER_URL", "REFERRAL", "SECURITY_AUTHENTICATION", "SECURITY_CREDENTIALS", "SECURITY_PRINCIPAL", "SECURITY_PROTOCOL", "STATE_FACTORIES", "URL_PKG_PREFIXES"};
    public static final String[] PROP_STRINGS = new String[]{"java.naming.applet", "java.naming.authoritative", "java.naming.batchsize", "java.naming.dns.url", "java.naming.factory.initial", "java.naming.language", "java.naming.factory.object", "java.naming.provider.url", "java.naming.referral", "java.naming.security.authentication", "java.naming.security.credentials", "java.naming.security.principal", "java.naming.security.protocol", "java.naming.factory.state", "java.naming.factory.url.pkgs"};

    public static int mapFieldType(String type) {
        if (type.equals("int")) {
            return 4;
        }
        if (type.equals("double")) {
            return 8;
        }
        if (type.equals("long")) {
            return -5;
        }
        if (type.equals("short")) {
            return 5;
        }
        if (type.equals("float")) {
            return 7;
        }
        if (type.equals("byte")) {
            return -6;
        }
        return 12;
    }

    public static Object getInputValue(String type, String value) {
        if (type.equals("int")) {
            if (value == null) {
                return 0;
            }
            return Integer.valueOf(value);
        }
        if (type.equals("double")) {
            if (value == null) {
                return 0.0;
            }
            return Double.valueOf(value);
        }
        if (type.equals("long")) {
            if (value == null) {
                return 0L;
            }
            return Long.valueOf(value);
        }
        if (type.equals("short")) {
            if (value == null) {
                return (short)0;
            }
            return Short.valueOf(value);
        }
        if (type.equals("float")) {
            if (value == null) {
                return Float.valueOf(0.0f);
            }
            return Float.valueOf(value);
        }
        if (type.equals("byte")) {
            if (value == null) {
                return Byte.valueOf("null");
            }
            return Byte.valueOf(value);
        }
        if (value == null) {
            return "null";
        }
        return value;
    }

    public static Object getRuntimeInputValue(String type, String value) {
        if (type.equals("java.lang.Integer")) {
            if (value == null) {
                return 0;
            }
            return Integer.valueOf(value);
        }
        if (type.equals("java.lang.Double")) {
            if (value == null) {
                return 0.0;
            }
            return Double.valueOf(value);
        }
        if (type.equals("java.lang.Long")) {
            if (value == null) {
                return 0L;
            }
            return Long.valueOf(value);
        }
        if (type.equals("java.lang.Short")) {
            if (value == null) {
                return (short)0;
            }
            return Short.valueOf(value);
        }
        if (type.equals("java.lang.Float")) {
            if (value == null) {
                return Float.valueOf(0.0f);
            }
            return Float.valueOf(value);
        }
        if (type.equals("java.lang.Byte")) {
            if (value == null) {
                return Byte.valueOf("null");
            }
            return Byte.valueOf(value);
        }
        if (value == null) {
            return "null";
        }
        return value;
    }

    public static Class mapTypeToClass(String paramType) {
        try {
            if (paramType.equals("int")) {
                return Integer.TYPE;
            }
            if (paramType.equals("double")) {
                return Double.TYPE;
            }
            if (paramType.equals("long")) {
                return Long.TYPE;
            }
            if (paramType.equals("short")) {
                return Short.TYPE;
            }
            if (paramType.equals("float")) {
                return Float.TYPE;
            }
            if (paramType.equals("byte")) {
                return Byte.TYPE;
            }
            return Class.forName(paramType);
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
            return null;
        }
    }
}

