/*
 * Decompiled with CFR 0.152.
 */
package quadbase.common.util.internal;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.Vector;
import quadbase.common.util.internal.CloseUtils;
import quadbase.reportorganizer.data.DataTreeDatabase;
import quadbase.reportorganizer.data.OrganizerDataImpl;

public class ERESLog {
    public static final String AUTO = "AUTO";
    public static final String ERESLOGREPORT = "ERESLog/ERESLog.pak";
    public static final String ERESSCHEDLOGREPORT = "ERESLog/Schedlog.pak";
    public static final String ERESMONITORINGLOGREPORT = "ERESLog/Monlog.pak";
    public static final String ERESLOGDBURL = "jdbc:hsqldb:data/quadbasedb";
    public static final String ERESLOGDBDRIVER = "org.hsqldb.jdbcDriver";
    public static final String ERESLOGDBUSER = "sa";
    public static final String ERESLOGDBPWD = "";
    public static final int LOGINPAGE = 0;
    public static final int ADMINPAGE = 1;
    public static final int MENUPAGE = 2;
    public static final int DASHBOARD = 3;
    public static final int QUICKDESIGNER = 4;
    public static final int ORGANIZER = 5;
    public static final int REPORT = 6;
    public static final int CHART = 7;
    public static final int SCHEDULER = 8;
    public static final int LOOKUPSERVLET = 9;
    public static final int DHTMLVIEWER = 10;
    public static final int DASHVIEWER = 11;
    public static final int SOAP = 12;
    public static final int DESIGNER = 13;
    public static final int ERESSERVER = 14;
    public static String[] prodType = new String[]{"LOGINPAGE", "ADMINPAGE", "MENUPAGE", "DASHBOARD", "QUICKDESIGNER", "ORGANIZER", "REPORT", "CHART", "SCHEDULER", "LOOKUPSERVLET", "DHTMLVIEWER", "DASHVIEWER", "SOAP", "DESIGNER", "ERESSERVER"};
    public static final String UNKNOWN = "UNKNOWN";
    public static final int LOGIN = 0;
    public static final int TIMEOUT = 1;
    public static final int LOGOUT = 2;
    public static final int SETWEBROOT = 3;
    public static final int SETSERVERNAME = 4;
    public static final int SETPROTOCOL = 5;
    public static final int SETPORTNUMBER = 6;
    public static final int SETWEBSERVERPORT = 7;
    public static final int SETJSPDEFAULTDIRECTORY = 8;
    public static final int SETSERVLETCONTEXT = 9;
    public static final int SETSMTPHOSTNAME = 10;
    public static final int REPAIRBROKENLINKS = 11;
    public static final int REPLACEDIRECTORY = 12;
    public static final int ADDNEWNODE = 13;
    public static final int REMOVENODE = 14;
    public static final int COPYNODE = 15;
    public static final int MOVENODE = 16;
    public static final int SETNODENAME = 17;
    public static final int SETNODEDESCRIPTION = 18;
    public static final int SETNODEFILENAME = 19;
    public static final int UPDATENODEOWNERID = 20;
    public static final int ADDSCHEDULETASK = 21;
    public static final int ADDREPORTSCHEDULETASK = 22;
    public static final int ADDCHARTSCHEDULETASK = 23;
    public static final int REMOVESCHEDULETASK = 24;
    public static final int MODIFYSCHEDULETASK = 25;
    public static final int RUNSCHEDULETASK = 26;
    public static final int ADDDATAREGISTRY = 27;
    public static final int REMOVEDATAREGISTRY = 28;
    public static final int SETDATAREGISTRYPERMISSION = 29;
    public static final int DELETEDATAREGISTRYFILE = 30;
    public static final int SETUSERDATAFILE = 31;
    public static final int SETUSERPERMISSION = 32;
    public static final int SETGROUPPERMISSION = 33;
    public static final int INSERTSECURITYLEVEL = 34;
    public static final int REMOVESECURITYLEVEL = 35;
    public static final int SETSECURITYLEVELS = 36;
    public static final int SETNODEPERMISSION = 37;
    public static final int SETFILEPERMISSION = 38;
    public static final int SETDATAREGISTRYINVISIBLENODE = 39;
    public static final int PATH_SETVALUE = 40;
    public static final int PATH_ADDROW = 41;
    public static final int PATH_REMOVEROW = 42;
    public static final int PATH_CREATEROW = 43;
    public static final int URLMAP_SETVALUE = 44;
    public static final int URLMAP_ADDROW = 45;
    public static final int URLMAP_INSERTROW = 46;
    public static final int URLMAP_MOVEROW = 47;
    public static final int URLMAP_REMOVEROW = 48;
    public static final int URLMAP_CREATEROW = 49;
    public static final int SCHEDULE_EXPORT = 50;
    public static final int WRITE_DATAVIEW = 51;
    public static final int WRITE_QUERYFILE = 52;
    public static final int MENU_VIEWPAGE = 53;
    public static final int MENU_LOGIN = 54;
    public static final int OPEN_REPORT = 55;
    public static final int OPEN_CHART = 56;
    public static final int EXPORT = 57;
    public static final int SETCLEANUPLOGINTERVAL = 58;
    public static final int GETCLEANUPLOGINTERVAL = 59;
    public static final int START_SERVER = 60;
    public static final int STOP_SERVER = 61;
    public static final int GETCHARTDATA = 62;
    public static final int ADDCHARTDATA = 63;
    public static final int MODIFYCHARTDATA = 64;
    public static final int REMOVECHARTDATA = 65;
    public static final int GETNEWCHARTDATAID = 66;
    public static final int GETREPORTDATA = 67;
    public static final int ADDREPORTDATA = 68;
    public static final int MODIFYREPORTDATA = 69;
    public static final int REMOVEREPORTDATA = 70;
    public static final int GETNEWREPORTDATAID = 71;
    public static final int GETDASHBOARDDATA = 72;
    public static final int ADDDASHBOARDDATA = 73;
    public static final int MODIFYDASHBOARDDATA = 74;
    public static final int REMOVEDASHBOARDDATA = 75;
    public static final int GETNEWDASHBOARDDATAID = 76;
    public static final int ADDPACKAGETASK = 77;
    public static final int MODIFYPACKAGETASK = 78;
    public static final int ISSCHEDULENAMEEXISTED = 79;
    public static final int GETMAPDATA = 80;
    public static final int ADDMAPDATA = 81;
    public static final int MODIFYMAPDATA = 82;
    public static final int REMOVEMAPDATA = 83;
    public static final int GETNEWMAPDATAID = 84;
    public static String[] process = new String[]{"LOGIN", "TIMEOUT", "LOGOUT", "SET_WEBROOT", "SET_SERVER_NAME", "SET_PROTOCOL", "SET_PORT_NUMBER", "SET_WEB_SERVER_PORT", "SET_JSP_DEFAULT_DIRECTORY", "SET_SERVLET_CONTEXT", "SET_SMTP_HOSTNAME", "REPAIR_BROKEN_LINKS", "REPLACE_DIRECTORY", "ADD_NEW_NODE", "REMOVE_NODE", "COPY_NODE", "MOVE_NODE", "SET_NAME", "SET_NODE_DESCRIPTION", "SET_NODE_FILENAME", "UPDATE_NODE_OWNER_ID", "ADD_SCHEDULE_TASK", "ADD_REPORT_SCHEDULE_TASK", "ADD_CHART_SCHEDULE_TASK", "REMOVE_SCHEDULE_TASK", "MODIFY_SCHEDULE_TASK", "RUN_SCHEDULE_TASK", "ADD_DATA_REGISTRY", "REMOVE_DATA_REGISTRY", "SET_DATA_REGISTRY_PERMISSION", "DELETE_DATA_REGISTRY_FILE", "SET_USER_DATA_FILE", "SET_USER_PERMISSION", "SET_GROUP_PERMISSION", "INSERT_SECURITY_LEVEL", "REMOVE_SECURITY_LEVEL", "SET_SECURITY_LEVELS", "SET_NODE_PERMISSION", "SET_FILE_PERMISSION", "SET_DATA_REGISTRY_INVISIBLE_NODE", "TABLE_SETVALUE", "TABLE_ADD_ITEM", "TABLE_REMOVE_ITEM", "TABLE_CREATE_ITEM", "URLMAP_SETVALUE", "URLMAP_ADD_ITEM", "URLMAP_INSERT_ITEM", "URLMAP_MOVE_ITEM", "URLMAP_REMOVE_ITEM", "URLMAP_CREATE_ITEM", "SCHEDULE_EXPORT", "WRITE_DATAVIEW", "WRITE_QUERYFILE", "MENU_VIEWPAGE", "MENU_LOGIN", "OPEN_REPORT", "OPEN_CHART", "EXPORT", "SET_CLEANUP_LOG_INTERVAL", "GET_CLEANUP_LOG_INTERVAL", "START_SERVER", "STOP_SERVER", "GETCHARTDATA", "ADDCHARTDATA", "MODIFYCHARTDATA", "REMOVECHARTDATA", "GETNEWCHARTDATAID", "GETREPORTDATA", "ADDREPORTDATA", "MODIFYREPORTDATA", "REMOVEREPORTDATA", "GETNEWREPORTDATAID", "GETDASHBOARDDATA", "ADDDASHBOARDDATA", "MODIFYDASHBOARDDATA", "REMOVEDASHBOARDDATA", "GETNEWDASHBOARDDATAID", "ADDPACKAGETASK", "MODIFYPACKAGETASK", "ISSCHEDULENAMEEXISTED", "GETMAPDATA", "ADDMAPDATA", "MODIFYMAPDATA", "REMOVEMAPDATA", "GETNEWMAPDATAID"};

    public static String printObjectArray(Object[] obj) {
        if (obj == null) {
            return null;
        }
        String str = ERESLOGDBPWD;
        for (int i = 0; i < obj.length; ++i) {
            if (i == 0) {
                if (obj[0] != null) {
                    str = obj[0].toString();
                    continue;
                }
                str = "NULL";
                continue;
            }
            str = obj[i] != null ? str + ", " + obj[i].toString() : str + ", NULL";
        }
        return str;
    }

    public static String printIntArray(int[] obj) {
        if (obj == null) {
            return "NULL";
        }
        String str = ERESLOGDBPWD;
        for (int i = 0; i < obj.length; ++i) {
            str = i == 0 ? obj[0] + ERESLOGDBPWD : str + ", " + obj[i];
        }
        return str;
    }

    public static void writeLog(String user, int process, String incomingIP, int productType, String details) throws Exception {
        if (user == null || user.equals(ERESLOGDBPWD)) {
            return;
        }
        try {
            Class<?> objClass = Class.forName("quadbase.reportorganizer.data.ERESLogDatabase");
            Constructor<?> objCons = objClass.getConstructor(new Class[0]);
            Object eresLog = objCons.newInstance(new Object[0]);
            Method objMethod1 = objClass.getMethod("write", String.class, Integer.class, String.class, Integer.class, String.class);
            objMethod1.invoke(eresLog, user, process, incomingIP, productType, details);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static String getProcessName(int processType) {
        if (processType < process.length) {
            return process[processType];
        }
        switch (processType) {
            case 10004: {
                return "DEFAULT_FILES";
            }
            case 1076: {
                return "EXPORT";
            }
            case 20088: {
                return "PAGEVIEWERHTML";
            }
            case 20876: {
                return "STREAM";
            }
            case 28931: {
                return "STREAM READ ONLY";
            }
            case 20877: {
                return "PAGEVIEWER STREAM";
            }
            case 20880: {
                return "LOAD VIEW PAGE SLAVE";
            }
            case 20881: {
                return "LOAD VIEW PAGE EXPORT";
            }
            case 29370: {
                return "FILE INFO";
            }
            case 31010: {
                return "LICENSE INFO";
            }
            case 29371: {
                return "PAGEVIEWER FILE INFO";
            }
            case 29399: {
                return "FILEINFO ROOT";
            }
            case 25578: {
                return "XML REPORT";
            }
            case 25993: {
                return "XML REPORT DATA";
            }
            case 24327: {
                return "XML DATA PARSER";
            }
            case 32420: {
                return "XML DATA SHEET";
            }
            case 25579: {
                return "XML GLOBAL FORMAT";
            }
            case 25588: {
                return "XML FONT MAPPING";
            }
            case 32415: {
                return "DATA FILE";
            }
            case 32416: {
                return "EJB ACCESS";
            }
            case 32417: {
                return "EJB METADATA";
            }
            case 32418: {
                return "EJB HOME METHOD ACCESS";
            }
            case 32419: {
                return "XML VERIFY";
            }
            case 24097: {
                return "SQL";
            }
            case 32000: {
                return "TEST DB CONNECTION";
            }
            case 30158: {
                return "URL";
            }
            case 23868: {
                return "RENAME";
            }
            case 23866: {
                return "REPLACE";
            }
            case 28929: {
                return "EXPORT BARCODE";
            }
            case 30500: {
                return "SERVER DIRECTORY";
            }
            case 16789: {
                return "DB DISTINCT";
            }
            case 15765: {
                return "DB FIRST VALUE";
            }
            case 18657: {
                return "DB PARAM META";
            }
            case 18658: {
                return "DB PARAM FUNCTION META";
            }
            case 25679: {
                return "DB PARAM TYPE";
            }
            case 23612: {
                return "DB QUERY META";
            }
            case 25367: {
                return "DATA FILE META";
            }
            case 28321: {
                return "QB PRODUCT NAME";
            }
            case 28762: {
                return "QB NUMERIC FUNCTION";
            }
            case 28648: {
                return "QB SYSTEM FUNCTION";
            }
            case 28356: {
                return "QB STRING FUNCTION";
            }
            case 28963: {
                return "QB TIME DATE FUNCTION";
            }
            case 28771: {
                return "QB TABLE LIST";
            }
            case 28232: {
                return "QB TABLE INFO";
            }
            case 28928: {
                return "QB SQL";
            }
            case 31005: {
                return "SCHEDULE SAVE";
            }
            case 31001: {
                return "GET SCHEDULE LIST";
            }
            case 31002: {
                return "MOD SCHEDULE";
            }
            case 31003: {
                return "ADD SCHEDULE";
            }
            case 31004: {
                return "DEL SCHEDULE";
            }
            case 25332: {
                return "USER LANGUAGE";
            }
            case 25335: {
                return "GET OS NAME";
            }
            case 23801: {
                return "DATA REGISTRY";
            }
            case 22071: {
                return "CHART EXPORT";
            }
            case 28816: {
                return "FILTER DATA FILE";
            }
            case 24578: {
                return "XML CHART";
            }
            case 27678: {
                return "XML TEMPLATE";
            }
            case 22111: {
                return "CREAT CHART";
            }
            case 27587: {
                return "FILTER PPSQL";
            }
            case 29203: {
                return "IMG EXPORT";
            }
            case 29302: {
                return "CHT EXPORT";
            }
            case 25330: {
                return "DELETE";
            }
            case 25331: {
                return "DELETE TEMP FILE";
            }
            case 26000: {
                return "RELEASE FILE";
            }
            case 26001: {
                return "COPY FILE";
            }
            case 26002: {
                return "WORKING DIRECTORY";
            }
            case 28930: {
                return "SHUT DOWN SERVER";
            }
            case 10001: {
                return "OUTPUTSTREAM INITIALIZE";
            }
            case 10002: {
                return "OUTPUTSTREAM WRITE";
            }
            case 10003: {
                return "OUTPUTSTREAM CLOSE";
            }
            case 25333: {
                return "CLASSFILE";
            }
        }
        return "DESIGNER";
    }

    private static String getPathName(String url) {
        if (url == null) {
            return url;
        }
        int index = url.lastIndexOf(47);
        if (index == -1) {
            return url;
        }
        return url.substring(index, url.length());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getPathInOrgainzer(String url) throws Exception {
        Vector<Integer> nodeIds = new Vector<Integer>();
        Vector<String> fileNames = new Vector<String>();
        Connection conn = null;
        ResultSet rs = null;
        PreparedStatement pStat = null;
        try {
            conn = OrganizerDataImpl.getConnection();
            pStat = conn.prepareStatement("Select nodeid, name, url From pathtable where url LIKE ?");
            String pathName = ERESLog.getPathName(url);
            pStat.setString(1, "%" + pathName);
            rs = pStat.executeQuery();
            while (rs.next()) {
                String urlInDb = rs.getString(3);
                if (!urlInDb.equals(url)) continue;
                nodeIds.addElement(rs.getInt(1));
                fileNames.addElement(rs.getString(2));
            }
            try {
                conn.commit();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        catch (Throwable throwable) {
            CloseUtils.close(rs);
            CloseUtils.close(pStat);
            CloseUtils.close(conn);
            throw throwable;
        }
        CloseUtils.close(rs);
        CloseUtils.close(pStat);
        CloseUtils.close(conn);
        int i = 0;
        if (i < nodeIds.size()) {
            int nodeId = (Integer)nodeIds.elementAt(i);
            String fileName = (String)fileNames.elementAt(i);
            String nodePath = DataTreeDatabase.getPath((int)nodeId, (boolean)true);
            return nodePath + "/" + fileName;
        }
        return null;
    }
}

