/*
 * Decompiled with CFR 0.152.
 */
package quadbase.common.util.internal;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.Writer;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import quadbase.common.util.internal.IOUtil;
import quadbase.common.util.internal.XMLUtil;

public class ExcelFileInfo {
    private static final String XMLTAG = "EXCEL";
    private static final String DATATYPE_TAG = "DATATYPE";
    private String filename;
    private String sheetName = null;
    private int minRow = 0;
    private int minColumn = 0;
    private int maxRow = -1;
    private int maxColumn = -1;
    private boolean includeNewData = false;
    private boolean hasHeader = false;
    private boolean dataAreRows = false;
    private int[] dataTypes = null;

    public ExcelFileInfo(String filename) {
        this.filename = filename;
    }

    public ExcelFileInfo(String filename, String sheetName, int minRow, int minColumn, int maxRow, int maxColumn, boolean includeNewData, boolean hasHeader, boolean dataAreRows) {
        this.filename = filename;
        this.sheetName = sheetName;
        this.minRow = minRow;
        this.minColumn = minColumn;
        this.maxRow = maxRow;
        this.maxColumn = maxColumn;
        this.includeNewData = includeNewData;
        this.hasHeader = hasHeader;
        this.dataAreRows = dataAreRows;
    }

    public static ExcelFileInfo read(DataInput in, int version) throws IOException {
        String filename = IOUtil.readString(in, true);
        String sheetName = IOUtil.readString(in, true);
        int minRow = in.readInt();
        int minColumn = in.readInt();
        int maxRow = in.readInt();
        int maxColumn = in.readInt();
        boolean includeNewData = in.readBoolean();
        boolean hasHeader = in.readBoolean();
        boolean dataAreRows = in.readBoolean();
        ExcelFileInfo ifo = new ExcelFileInfo(filename, sheetName, minRow, minColumn, maxRow, maxColumn, includeNewData, hasHeader, dataAreRows);
        int size = in.readInt();
        if (size > 0) {
            ifo.setDataTypes(IOUtil.readInts(in, size));
        }
        return ifo;
    }

    public void write(DataOutput out) throws IOException {
        IOUtil.writeString(out, this.filename);
        IOUtil.writeString(out, this.sheetName);
        out.writeInt(this.minRow);
        out.writeInt(this.minColumn);
        out.writeInt(this.maxRow);
        out.writeInt(this.maxColumn);
        out.writeBoolean(this.includeNewData);
        out.writeBoolean(this.hasHeader);
        out.writeBoolean(this.dataAreRows);
        if (this.dataTypes == null) {
            out.writeInt(0);
        } else {
            out.writeInt(this.dataTypes.length);
            IOUtil.writeInts(out, this.dataTypes, this.dataTypes.length);
        }
    }

    public static ExcelFileInfo readXML(Node source) throws Exception {
        if (!(source instanceof Element)) {
            throw new Exception("Failed to read Excel datasource");
        }
        Element el = (Element)source;
        NodeList list = el.getElementsByTagName(XMLTAG);
        if (list == null || list.getLength() == 0) {
            throw new Exception("EXCEL element not found in the " + el.getLocalName() + " element.");
        }
        Element excelElement = (Element)list.item(0);
        String filename = excelElement.getAttribute("filename");
        String sheetName = excelElement.getAttribute("sheetName");
        int minRow = Integer.parseInt(excelElement.getAttribute("minRow"));
        int minColumn = Integer.parseInt(excelElement.getAttribute("minColumn"));
        int maxRow = Integer.parseInt(excelElement.getAttribute("maxRow"));
        int maxColumn = Integer.parseInt(excelElement.getAttribute("maxColumn"));
        boolean includeNewData = Boolean.valueOf(excelElement.getAttribute("includeNewData"));
        boolean hasHeader = Boolean.valueOf(excelElement.getAttribute("hasHeader"));
        boolean dataAreRows = Boolean.valueOf(excelElement.getAttribute("dataAreRows"));
        ExcelFileInfo ifo = new ExcelFileInfo(filename, sheetName, minRow, minColumn, maxRow, maxColumn, includeNewData, hasHeader, dataAreRows);
        NodeList typeList = excelElement.getElementsByTagName(DATATYPE_TAG);
        if (typeList != null && typeList.getLength() > 0) {
            int[] dataTypes = new int[typeList.getLength()];
            for (int i = 0; i < typeList.getLength(); ++i) {
                dataTypes[i] = Integer.parseInt(XMLUtil.readText(typeList.item(i)));
            }
            ifo.setDataTypes(dataTypes);
        }
        return ifo;
    }

    public void writeXML(Writer out) throws IOException {
        out.write("<EXCEL filename=\"" + this.filename + "\" sheetName=\"" + this.sheetName + "\" minRow=\"" + this.minRow + "\" minColumn=\"" + this.minColumn + "\" maxRow=\"" + this.maxRow + "\" maxColumn=\"" + this.maxColumn + "\" includeNewData=\"" + this.includeNewData + "\" hasHeader=\"" + this.hasHeader + "\" dataAreRows=\"" + this.dataAreRows + "\">\n");
        if (this.dataTypes != null) {
            for (int dataType : this.dataTypes) {
                out.write("  <DATATYPE>" + dataType + "</" + DATATYPE_TAG + ">\n");
            }
        }
        out.write("</EXCEL>\n");
        out.flush();
    }

    public String getFilename() {
        return this.filename;
    }

    public void setFilename(String filename) {
        this.filename = filename;
    }

    public String getSheetName() {
        return this.sheetName;
    }

    public void setSheetName(String sheetName) {
        this.sheetName = sheetName;
    }

    public boolean hasHeader() {
        return this.hasHeader;
    }

    public void setHasHeader(boolean hasHeader) {
        this.hasHeader = hasHeader;
    }

    public int getMinRow() {
        return this.minRow;
    }

    public void setMinRow(int minRow) {
        this.minRow = minRow;
    }

    public int getMaxRow() {
        return this.maxRow;
    }

    public void setMaxRow(int maxRow) {
        this.maxRow = maxRow;
    }

    public int getMinColumn() {
        return this.minColumn;
    }

    public void setMinColumn(int minColumn) {
        this.minColumn = minColumn;
    }

    public int getMaxColumn() {
        return this.maxColumn;
    }

    public void setMaxColumn(int maxColumn) {
        this.maxColumn = maxColumn;
    }

    public boolean isIncludeNewData() {
        return this.includeNewData;
    }

    public void setIncludeNewData(boolean includeNewData) {
        this.includeNewData = includeNewData;
    }

    public boolean dataAreRows() {
        return this.dataAreRows;
    }

    public void setDataAreRows(boolean dataAreRows) {
        this.dataAreRows = dataAreRows;
    }

    public int[] getDataTypes() {
        return this.dataTypes;
    }

    public void setDataTypes(int[] dataTypes) {
        this.dataTypes = dataTypes;
    }
}

