/*
 * Decompiled with CFR 0.152.
 */
package quadbase.common.util.internal;

import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Iterator;
import java.util.Vector;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.CellValue;
import org.apache.poi.ss.usermodel.DateUtil;
import org.apache.poi.ss.usermodel.FormulaEvaluator;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.usermodel.WorkbookFactory;
import org.apache.poi.ss.util.CellReference;
import quadbase.common.util.internal.DataType;
import quadbase.common.util.internal.ExcelFileInfo;
import quadbase.common.util.internal.LanguageEncoder;
import quadbase.common.util.internal.ReadDataFile;

public class ExcelReader {
    private static final int ZERO_YEAR = 1899;
    private static final int ZERO_MONTH = 11;
    private static final int ZERO_DAY = 31;
    private Workbook workBook = null;
    private Sheet sheet = null;
    private FormulaEvaluator formulaEvaluator = null;
    private int[] dataTypes = null;
    private int lastColumn = -1;
    private int realLastColumn = -1;
    private int lastRow = -1;
    private int realLastRow = -1;
    private ExcelFileInfo excelInfo;
    private int startIndex;
    private int count;

    public ExcelReader(ExcelFileInfo excelInfo, int startIndex, int count) throws Exception {
        this.excelInfo = excelInfo;
        this.startIndex = startIndex;
        this.count = count;
        DataInputStream is = new ReadDataFile().getInputStream(excelInfo.getFilename(), false, true);
        this.workBook = WorkbookFactory.create((InputStream)is);
        this.formulaEvaluator = this.workBook.getCreationHelper().createFormulaEvaluator();
        if (excelInfo.getSheetName() != null) {
            this.sheet = this.workBook.getSheet(excelInfo.getSheetName());
            if (this.sheet.getPhysicalNumberOfRows() > 0) {
                this.realLastRow = this.sheet.getLastRowNum();
                this.lastRow = excelInfo.getMaxRow();
                if (this.lastRow == -1 || !excelInfo.dataAreRows() && excelInfo.isIncludeNewData()) {
                    this.lastRow = this.realLastRow;
                }
                this.realLastColumn = -1;
                for (int i = 0; i <= this.sheet.getLastRowNum(); ++i) {
                    Row row = this.sheet.getRow(i);
                    if (row == null || row.getLastCellNum() <= this.realLastColumn) continue;
                    this.realLastColumn = row.getLastCellNum();
                }
                this.lastColumn = excelInfo.getMaxColumn();
                if (this.lastColumn == -1 || excelInfo.dataAreRows() && excelInfo.isIncludeNewData()) {
                    this.lastColumn = this.realLastColumn;
                }
            }
        }
        this.dataTypes = excelInfo.getDataTypes();
    }

    public String[] getSheetNames() throws IOException {
        String[] result = new String[this.workBook.getNumberOfSheets()];
        for (int i = 0; i < result.length; ++i) {
            result[i] = this.workBook.getSheetName(i);
        }
        return result;
    }

    public String[] getColumnNames() throws IOException {
        Vector row = this.readRow(0, true);
        if (row == null) {
            return new String[0];
        }
        String[] result = new String[row.size()];
        for (int i = 0; i < row.size(); ++i) {
            result[i] = this.excelInfo.hasHeader() ? (row.get(i) != null ? row.get(i).toString() : "") : (this.excelInfo.dataAreRows() ? i + "" : ExcelReader.getExcelColumnNameForIndex(i));
        }
        return result;
    }

    public synchronized int[] getDataTypes() throws IOException {
        if (this.dataTypes != null) {
            return this.dataTypes;
        }
        if (this.excelInfo.getDataTypes() != null) {
            this.dataTypes = this.excelInfo.getDataTypes();
        } else {
            Vector data = this.readData();
            if (data == null || data.size() == 0) {
                this.dataTypes = new int[0];
                return this.dataTypes;
            }
            Vector firstRow = (Vector)data.get(0);
            this.dataTypes = new int[firstRow.size()];
            Arrays.fill(this.dataTypes, -1);
            for (Vector row : data) {
                for (int i = 0; i < row.size() && i < this.dataTypes.length; ++i) {
                    int actualDataType;
                    int colDataType = this.dataTypes[i];
                    Object o = row.get(i);
                    int n = actualDataType = o == null ? -1 : DataType.findType(row.get(i));
                    if (colDataType == actualDataType) continue;
                    this.dataTypes[i] = this.getSuperDataType(colDataType, actualDataType);
                }
            }
            for (int i = 0; i < this.dataTypes.length; ++i) {
                if (this.dataTypes[i] != -1) continue;
                this.dataTypes[i] = 12;
            }
        }
        return this.dataTypes;
    }

    public Vector getData() throws IOException {
        if (this.dataTypes == null) {
            this.getDataTypes();
        }
        return this.readData();
    }

    private int getSuperDataType(int t1, int t2) {
        if (t1 == -1) {
            return t2;
        }
        if (t2 == -1) {
            return t1;
        }
        if (t1 == 12 || t2 == 12) {
            return 12;
        }
        if (t1 == 8 || t2 == 8) {
            return 8;
        }
        if (t1 == 4 || t2 == 4) {
            return 8;
        }
        return 93;
    }

    private Vector readData() {
        Vector row;
        Vector<Vector> result = new Vector<Vector>();
        int i = this.excelInfo.hasHeader() ? 1 : 0;
        i += this.startIndex;
        while ((row = this.readRow(i, false)) != null && (this.count < 0 || i < this.startIndex + this.count)) {
            result.add(row);
            ++i;
        }
        while (result.size() > 0) {
            row = (Vector)result.get(result.size() - 1);
            boolean found = false;
            Iterator it = row.iterator();
            while (it.hasNext()) {
                if (it.next() == null) continue;
                found = true;
                break;
            }
            if (found) break;
            result.remove(result.size() - 1);
        }
        return result;
    }

    private Vector readRow(int index, boolean forceString) {
        if (this.sheet.getPhysicalNumberOfRows() == 0) {
            return null;
        }
        if (this.excelInfo.dataAreRows()) {
            if ((index += this.excelInfo.getMinColumn()) > this.lastColumn || index > this.realLastColumn) {
                return null;
            }
            Vector<Object> result = new Vector<Object>(this.lastRow - this.excelInfo.getMinRow() + 1);
            for (int i = 0; i <= this.lastRow - this.excelInfo.getMinRow(); ++i) {
                Row row = this.sheet.getRow(i + this.excelInfo.getMinRow());
                if (row == null) {
                    result.add(null);
                    continue;
                }
                int dataType = !forceString && this.dataTypes != null ? this.dataTypes[i] : -1;
                result.add(this.readCell(row.getCell(index), dataType));
            }
            return result;
        }
        if ((index += this.excelInfo.getMinRow()) > this.lastRow || index > this.realLastRow) {
            return null;
        }
        Row row = this.sheet.getRow(index);
        Vector<Object> result = new Vector<Object>(this.lastColumn - this.excelInfo.getMinColumn() + 1);
        for (int i = 0; i <= this.lastColumn - this.excelInfo.getMinColumn(); ++i) {
            if (row == null) {
                result.add(null);
                continue;
            }
            int dataType = !forceString && this.dataTypes != null ? this.dataTypes[i] : -1;
            result.add(this.readCell(row.getCell(i + this.excelInfo.getMinColumn()), dataType));
        }
        return result;
    }

    private Object readCell(Cell cell, int dataType) {
        Object o;
        if (cell == null) {
            return null;
        }
        if (cell.getCellType() == CellType.FORMULA) {
            String error;
            block18: {
                error = null;
                try {
                    CellValue cv = this.formulaEvaluator.evaluate(cell);
                    if (cv.getCellType() != CellType.ERROR) {
                        this.formulaEvaluator.evaluateInCell(cell);
                    } else {
                        error = "Error: " + cv.formatAsString();
                    }
                }
                catch (RuntimeException e) {
                    error = LanguageEncoder.getText("Error");
                    if (e.getMessage() == null) break block18;
                    error = error + ": " + e.getMessage();
                }
            }
            if (error != null) {
                return error;
            }
        }
        switch (cell.getCellType()) {
            case STRING: {
                o = cell.getRichStringCellValue().getString();
                break;
            }
            case FORMULA: {
                o = cell.getCellFormula();
                break;
            }
            case BOOLEAN: {
                o = cell.getBooleanCellValue() ? Integer.valueOf(1) : Integer.valueOf(0);
                break;
            }
            case NUMERIC: {
                if (DateUtil.isCellDateFormatted((Cell)cell)) {
                    o = this.readDateTimeCell(cell);
                    break;
                }
                o = this.readNumericCell(cell);
                break;
            }
            default: {
                o = null;
            }
        }
        if (o != null && dataType != -1 && (dataType == 12 && !(o instanceof String) || dataType == 8 && !(o instanceof Double) || dataType == 4 && !(o instanceof Integer) || dataType == 91 && !(o instanceof Date) || dataType == 92 && !(o instanceof Time) || dataType == 93 && !(o instanceof Timestamp))) {
            try {
                if (dataType == 8 || dataType == 4) {
                    o = this.readNumericCell(cell);
                }
                o = DataType.createObject(o.toString(), DataType.mapType(dataType));
            }
            catch (Exception ex) {
                String msg = "Failed to parse value '" + o.toString() + "' in cell " + ExcelReader.getExcelColumnNameForIndex(cell.getColumnIndex()) + (cell.getRowIndex() + 1) + " as " + DataType.getTypeName(dataType) + ".";
                throw new IllegalArgumentException(msg);
            }
        }
        return o;
    }

    private Object readDateTimeCell(Cell cell) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(cell.getDateCellValue());
        if (cal.get(10) == 0 && cal.get(12) == 0 && cal.get(13) == 0 && cal.get(14) == 0) {
            return new Date(cal.getTimeInMillis());
        }
        if (cal.get(1) == 1899 && cal.get(2) == 11 && cal.get(5) == 31) {
            return new Time(cal.getTimeInMillis());
        }
        return new Timestamp(cal.getTimeInMillis());
    }

    private Object readNumericCell(Cell cell) {
        double d = cell.getNumericCellValue();
        if (Math.floor(d) == d) {
            return (int)d;
        }
        return cell.getNumericCellValue();
    }

    public static String getExcelColumnNameForIndex(int index) {
        CellReference cr = new CellReference(0, index);
        String[] parts = cr.getCellRefParts();
        return parts[2];
    }
}

