/*
 * Decompiled with CFR 0.152.
 */
package quadbase.common.util.internal;

import java.awt.Color;
import java.awt.Font;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import quadbase.common.client.ServerMessage;
import quadbase.common.network.IConnection;
import quadbase.common.util.internal.IOUtil;
import quadbase.reportdesigner.util.internal.BarcodeUtil;

public class ExportBarcode {
    String filename = null;
    String codeText = null;
    int barType = 0;
    int width;
    int height;
    int leftMargin;
    Font font;
    Color bgColor;
    Color fColor;

    public ExportBarcode(String fileName, String codeText, int barType, int width, int height, int leftMargin, Font font, Color bgColor, Color fColor) {
        this.filename = fileName.replace('\\', '/');
        this.codeText = codeText;
        this.barType = barType;
        this.width = width;
        this.height = height;
        this.leftMargin = leftMargin;
        this.font = font;
        this.bgColor = bgColor;
        this.fColor = fColor;
    }

    public boolean export() {
        int code;
        if (!ServerMessage.useServer && ServerMessage.isLoadBalancer) {
            try {
                BarcodeUtil.getBarCodeImage((String)this.codeText, (int)this.barType, (int)this.width, (int)this.height, (String)this.filename, (Font)this.font, (Color)this.bgColor, (Color)this.fColor);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            return true;
        }
        IConnection socket = null;
        try {
            socket = ServerMessage.createConnection();
            ByteArrayOutputStream bstream = new ByteArrayOutputStream(1024);
            DataOutputStream out = new DataOutputStream(bstream);
            out.writeShort(28929);
            out.writeBoolean(false);
            IOUtil.writeString(out, this.filename);
            IOUtil.writeString(out, this.codeText);
            out.writeInt(this.barType);
            out.writeInt(this.width);
            out.writeInt(this.height);
            out.writeInt(this.leftMargin);
            IOUtil.writeFont(out, this.font);
            IOUtil.writeColor(out, this.bgColor);
            IOUtil.writeColor(out, this.fColor);
            byte[] array = bstream.toByteArray();
            socket.setContentLength(array.length);
            socket.getOutputStream().write(array);
            socket.getOutputStream().flush();
            DataInputStream din = new DataInputStream(socket.getInputStream());
            code = din.readInt();
            socket.close();
        }
        catch (Exception ex) {
            try {
                socket.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            return false;
        }
        switch (code) {
            case 0: {
                return true;
            }
        }
        return false;
    }
}

