/*
 * Decompiled with CFR 0.152.
 */
package quadbase.common.util.internal;

import java.util.Enumeration;
import java.util.Hashtable;
import quadbase.common.util.internal.FileTypeUtil;

public class FileInMemTable
extends Hashtable<String, byte[]> {
    private boolean isModified = false;
    private static int count = 0;
    private String name = this.name + count++;
    private String topName = null;
    private boolean isEnabled = false;

    public void setFileInMemEnabled(boolean b) {
        this.isEnabled = b;
    }

    public boolean isFileInMemEnabled() {
        return this.isEnabled;
    }

    public void setTopName(String topName) {
        if (topName == null) {
            this.topName = null;
            return;
        }
        this.topName = topName;
    }

    public String getTopName() {
        return this.topName;
    }

    @Override
    public synchronized byte[] put(String key, byte[] value) {
        this.isModified = true;
        return super.put(key, value);
    }

    @Override
    public synchronized byte[] get(Object key) {
        if (!this.containsKey(key) && key instanceof String) {
            String skey = (String)key;
            if (FileTypeUtil.isPAKFile(skey) && this.containsKey(FileTypeUtil.getRptFileName(skey))) {
                return (byte[])super.get(FileTypeUtil.getRptFileName(skey));
            }
            if (FileTypeUtil.isRPTFile(skey) && this.containsKey(FileTypeUtil.getPakFileName(skey))) {
                return (byte[])super.get(FileTypeUtil.getPakFileName(skey));
            }
        }
        return (byte[])super.get(key);
    }

    @Override
    public synchronized byte[] remove(Object key) {
        this.isModified = true;
        return (byte[])super.remove(key);
    }

    public boolean isModified() {
        return this.isModified;
    }

    public void resetModify() {
        this.isModified = false;
    }

    @Override
    public synchronized String toString() {
        if (!this.isFileInMemEnabled()) {
            return "";
        }
        StringBuffer result = new StringBuffer();
        Enumeration keys = this.keys();
        int i = 0;
        while (keys.hasMoreElements()) {
            String key = (String)keys.nextElement();
            byte[] value = (byte[])super.get(key);
            result.append("KEY[" + i + "] = " + key + " Size = " + value.length);
            ++i;
        }
        return result.toString();
    }
}

