/*
 * Decompiled with CFR 0.152.
 */
package quadbase.common.util.internal;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLConnection;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import quadbase.common.util.internal.HttpsIOCom;

public class HttpsIO {
    protected static SSLSocketFactory trustAllFactory;
    protected static HostnameVerifier verifyAllVerifier;

    public HttpsIO() throws NoSuchAlgorithmException, KeyManagementException {
        HttpsIO.init();
    }

    private static void init() throws NoSuchAlgorithmException, KeyManagementException {
        TrustManager[] trustAllCerts = new TrustManager[]{new X509TrustManager(){

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                return null;
            }

            @Override
            public void checkClientTrusted(X509Certificate[] certs, String authType) {
            }

            @Override
            public void checkServerTrusted(X509Certificate[] certs, String authType) {
            }
        }};
        SSLContext sc = SSLContext.getInstance("SSL");
        sc.init(null, trustAllCerts, new SecureRandom());
        trustAllFactory = sc.getSocketFactory();
        verifyAllVerifier = HttpsIO.getVerifyAllVerifier();
    }

    public static URLConnection openHttpsConnection(URL url) throws NoSuchAlgorithmException, KeyManagementException, IOException {
        String version = System.getProperty("java.version").trim();
        if (version.startsWith("1.0") || version.startsWith("1.1") || version.startsWith("1.2") || version.startsWith("1.3")) {
            return HttpsIOCom.openHttpsConnection(url);
        }
        HttpsIO.trustAll();
        URLConnection conn = url.openConnection();
        ((HttpsURLConnection)conn).setHostnameVerifier(HttpsIO.getVerifyAllVerifier());
        return conn;
    }

    public static OutputStream getOutputStream(HttpsURLConnection conn) throws NoSuchAlgorithmException, KeyManagementException, IOException {
        HttpsIO.trustAll();
        conn.setHostnameVerifier(HttpsIO.getVerifyAllVerifier());
        return conn.getOutputStream();
    }

    public static InputStream getInputStream(HttpsURLConnection conn) throws NoSuchAlgorithmException, KeyManagementException, IOException {
        HttpsIO.trustAll();
        conn.setHostnameVerifier(HttpsIO.getVerifyAllVerifier());
        return conn.getInputStream();
    }

    public static byte[] getBytes(String url) throws NoSuchAlgorithmException, KeyManagementException, IOException {
        URL myUrl = new URL(url);
        return HttpsIO.getBytes(myUrl);
    }

    public static byte[] getBytes(URL url) throws NoSuchAlgorithmException, KeyManagementException, IOException {
        int bytesRead;
        BufferedInputStream in = new BufferedInputStream(HttpsIO.getHttpsInputStream(url));
        byte[] data = new byte[1024];
        byte[] buf = new byte[4];
        int freeData = 0;
        while ((bytesRead = in.read(buf, 0, buf.length)) != -1) {
            if (freeData + bytesRead >= data.length) {
                byte[] temp = new byte[data.length * 2];
                System.arraycopy(data, 0, temp, 0, freeData);
                data = temp;
            }
            System.arraycopy(buf, 0, data, freeData, bytesRead);
            freeData += bytesRead;
        }
        if (freeData < data.length) {
            byte[] result = new byte[freeData];
            System.arraycopy(data, 0, result, 0, freeData);
            return result;
        }
        return data;
    }

    public static InputStream getHttpsInputStream(String url) throws NoSuchAlgorithmException, KeyManagementException, IOException {
        URL myUrl = new URL(url);
        return HttpsIO.getHttpsInputStream(myUrl);
    }

    public static InputStream getHttpsInputStream(URL url) throws NoSuchAlgorithmException, KeyManagementException, IOException {
        String version = System.getProperty("java.version").trim();
        if (version.startsWith("1.0") || version.startsWith("1.1") || version.startsWith("1.2") || version.startsWith("1.3")) {
            return HttpsIOCom.getHttpsInputStream(url);
        }
        HttpsIO.trustAll();
        URLConnection conn = url.openConnection();
        ((HttpsURLConnection)conn).setHostnameVerifier(HttpsIO.getVerifyAllVerifier());
        return conn.getInputStream();
    }

    protected static void trustAll() throws NoSuchAlgorithmException, KeyManagementException {
        if (trustAllFactory == null) {
            HttpsIO.init();
        }
        try {
            HttpsURLConnection.setDefaultSSLSocketFactory(trustAllFactory);
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
    }

    public static HostnameVerifier getVerifyAllVerifier() {
        if (verifyAllVerifier == null) {
            verifyAllVerifier = new HostnameVerifier(){

                @Override
                public boolean verify(String urlHost, SSLSession hostSession) {
                    return true;
                }
            };
        }
        return verifyAllVerifier;
    }
}

