/*
 * Decompiled with CFR 0.152.
 */
package quadbase.common.util.internal;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JTextPane;
import javax.swing.KeyStroke;
import javax.swing.text.View;
import quadbase.common.util.internal.IOUtil;
import quadbase.common.util.internal.LanguageEncoder;

public class JMessageDialog
extends JDialog
implements ActionListener {
    public static final int YES_NO_CANCEL_OPTION = 1;
    public static final int YES_NO_OPTION = 2;
    public static final int OK_CANCEL_OPTION = 3;
    public static final int YES_OPTION = 4;
    public static final int NO_OPTION = 5;
    public static final int OK_OPTION = 6;
    public static final int CANCEL_OPTION = 7;
    public static final int IGNORE_CANCEL_OPTION = 8;
    public static final int IGNORE_OPTION = 9;
    public static final int COPY_OPTION = 10;
    private String message;
    private int optionType = 0;
    private JButton yesButton;
    private JButton noButton;
    private JButton cancelButton;
    private JButton okButton;
    private JButton ignoreButton;
    private JButton copyButton;
    private int response;
    private JComponent component;
    private JCheckBox check;
    private String checkBoxMessage;

    public JMessageDialog(Dialog parentDialog, String title, String msg) {
        super(parentDialog, title, true);
        this.message = msg;
        this.init();
        this.setVisible(true);
    }

    public JMessageDialog(Dialog parentComponent, String title, String msg, int i) {
        super(parentComponent, title, true);
        this.message = msg;
        this.optionType = i;
        this.init();
        this.setVisible(true);
    }

    public JMessageDialog(Dialog parentComponent, String title, JComponent component) {
        super(parentComponent, title, true);
        this.component = component;
        this.init();
        this.setVisible(true);
    }

    public JMessageDialog(Frame parentComponent, String title, String msg) {
        super(parentComponent, title, true);
        this.message = msg;
        this.init();
        this.setVisible(true);
    }

    public JMessageDialog(Frame parentComponent, String title, String msg, int i) {
        super(parentComponent, title, true);
        this.message = msg;
        this.optionType = i;
        this.init();
        this.setVisible(true);
    }

    public JMessageDialog(Frame parentComponent, String title, String msg, int i, String checkBoxMessage) {
        super(parentComponent, title, true);
        this.message = msg;
        this.optionType = i;
        this.checkBoxMessage = checkBoxMessage;
        this.init();
        this.setVisible(true);
    }

    public JMessageDialog(Frame parentComponent, String title, JComponent component) {
        super(parentComponent, title, true);
        this.component = component;
        this.init();
        this.setVisible(true);
    }

    public static void errorDialog(Component parentComponent, String message) {
        while (parentComponent != null) {
            if (parentComponent.isVisible()) {
                if (parentComponent instanceof JDialog) {
                    new JMessageDialog((Dialog)((JDialog)parentComponent), LanguageEncoder.getText("Error"), message);
                    return;
                }
                if (parentComponent instanceof Frame) {
                    new JMessageDialog((Frame)parentComponent, LanguageEncoder.getText("Error"), message);
                    return;
                }
            }
            parentComponent = parentComponent.getParent();
        }
        new JMessageDialog((Frame)null, LanguageEncoder.getText("Error"), message);
    }

    public JMessageDialog(Dialog parentComponent, String title, JComponent component, int option) {
        super(parentComponent, title, true);
        this.component = component;
        this.optionType = option;
        this.init();
    }

    public static JMessageDialog optionDialog(Component parentComponent, String title, String message, int option) {
        while (parentComponent != null) {
            if (parentComponent.isVisible()) {
                if (parentComponent instanceof JDialog) {
                    return new JMessageDialog((Dialog)((JDialog)parentComponent), title, message, option);
                }
                if (parentComponent instanceof Frame) {
                    return new JMessageDialog((Frame)parentComponent, title, message, option);
                }
            }
            parentComponent = parentComponent.getParent();
        }
        return new JMessageDialog((Frame)null, title, message, option);
    }

    private void setDefaultButtonFocus() {
        switch (this.optionType) {
            case 1: 
            case 2: {
                this.yesButton.requestFocusInWindow();
                break;
            }
            case 8: {
                this.ignoreButton.requestFocusInWindow();
                break;
            }
            default: {
                this.okButton.requestFocusInWindow();
            }
        }
    }

    private void addEscapeKeyListener(final JDialog dialog) {
        ActionListener escListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                dialog.setVisible(false);
            }
        };
        dialog.getRootPane().registerKeyboardAction(escListener, KeyStroke.getKeyStroke(27, 0), 2);
    }

    private void init() {
        this.setDefaultCloseOperation(2);
        this.setBackground(Color.lightGray);
        if (this.message == null) {
            this.message = "Error.";
        }
        if (this.component == null) {
            JTextPane textPane = new JTextPane();
            textPane.setText(this.message);
            textPane.setEditable(false);
            textPane.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
            textPane.setBackground(null);
            View v = textPane.getUI().getRootView(textPane);
            Dimension screenSize = this.getToolkit().getScreenSize();
            int width = (int)((double)screenSize.width * 0.75);
            v.setSize(width, 2.1474836E9f);
            int height = (int)v.getPreferredSpan(1);
            width = Math.min((int)v.getPreferredSpan(0), width);
            textPane.setPreferredSize(new Dimension(width + 50, height + 20));
            this.component = textPane;
        }
        JPanel checkPanel = null;
        if (this.checkBoxMessage != null) {
            checkPanel = new JPanel();
            checkPanel.setLayout(new FlowLayout(0));
            this.check = new JCheckBox(this.checkBoxMessage, false);
            checkPanel.add(this.check);
        }
        JPanel btPanel = new JPanel();
        btPanel.setLayout(new FlowLayout());
        JPanel lowerPanel = new JPanel();
        lowerPanel.setLayout(new BorderLayout());
        if (checkPanel != null) {
            lowerPanel.add((Component)checkPanel, "Center");
        }
        lowerPanel.add((Component)btPanel, "South");
        switch (this.optionType) {
            case 1: {
                this.yesButton = new JButton(LanguageEncoder.getText("Yes"));
                this.yesButton.addActionListener(this);
                this.noButton = new JButton(LanguageEncoder.getText("No"));
                this.noButton.addActionListener(this);
                this.cancelButton = new JButton(LanguageEncoder.getText("Cancel"));
                this.cancelButton.addActionListener(this);
                btPanel.add(this.yesButton);
                btPanel.add(this.noButton);
                btPanel.add(this.cancelButton);
                break;
            }
            case 2: {
                this.yesButton = new JButton(LanguageEncoder.getText("Yes"));
                this.yesButton.addActionListener(this);
                this.noButton = new JButton(LanguageEncoder.getText("No"));
                this.noButton.addActionListener(this);
                btPanel.add(this.yesButton);
                btPanel.add(this.noButton);
                break;
            }
            case 3: {
                this.okButton = new JButton(LanguageEncoder.getText("OK"));
                this.okButton.addActionListener(this);
                this.cancelButton = new JButton(LanguageEncoder.getText("Cancel"));
                this.cancelButton.addActionListener(this);
                btPanel.add(this.okButton);
                btPanel.add(this.cancelButton);
                break;
            }
            case 8: {
                this.ignoreButton = new JButton(LanguageEncoder.getText("Ignore"));
                this.ignoreButton.addActionListener(this);
                this.cancelButton = new JButton(LanguageEncoder.getText("Quit"));
                this.cancelButton.addActionListener(this);
                btPanel.add(this.ignoreButton);
                btPanel.add(this.cancelButton);
                break;
            }
            case 10: {
                String copyImg = "orgimages/toolsIcon_Copy.png";
                String closeImg = "orgimages/closeImage.png";
                this.copyButton = new JButton(IOUtil.getImageIcon(copyImg));
                this.okButton = new JButton(IOUtil.getImageIcon(closeImg));
                this.copyButton.setToolTipText(LanguageEncoder.getText("Copy to clipboard"));
                this.okButton.setToolTipText(LanguageEncoder.getText("Close the dialog"));
                this.okButton.addActionListener(this);
                btPanel.add(this.copyButton);
                btPanel.add(this.okButton);
                break;
            }
            default: {
                this.okButton = new JButton(LanguageEncoder.getText("OK"));
                this.okButton.addActionListener(this);
                btPanel.add(this.okButton);
            }
        }
        JPanel contentPane = (JPanel)this.getContentPane();
        contentPane.setLayout(new BorderLayout());
        contentPane.add("Center", this.component);
        contentPane.add("South", lowerPanel);
        this.pack();
        this.setDefaultButtonFocus();
        this.addEscapeKeyListener(this);
        this.setLocationRelativeTo(this.getParent());
    }

    public int getResponse() {
        return this.response;
    }

    public boolean isCheckBoxSelected() {
        return this.check.isSelected();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        if (source != this.copyButton) {
            if (source == this.okButton) {
                this.response = 6;
            } else if (source == this.cancelButton) {
                this.response = 7;
            } else if (source == this.yesButton) {
                this.response = 4;
            } else if (source == this.noButton) {
                this.response = 5;
            } else if (source == this.ignoreButton) {
                this.response = 9;
            }
            this.setVisible(false);
            this.dispose();
        }
    }

    public void addCopyListener(ActionListener listener) {
        this.copyButton.addActionListener(listener);
    }
}

