/*
 * Decompiled with CFR 0.152.
 */
package quadbase.common.util.internal;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.awt.geom.GeneralPath;
import java.awt.image.BufferedImage;
import java.util.logging.Logger;
import quadbase.common.util.internal.ZoomGraphics;

public class Java2DUtil {
    private static final Logger LOGGER = Logger.getLogger(Java2DUtil.class.getName());
    public static final int SOLID = 1;
    public static final int DOUBLE = 2;
    public static final int DASH = 3;

    public static Graphics getBufferedGraphics(int width, int height) {
        try {
            BufferedImage image = new BufferedImage(width, height, 1);
            return image.getGraphics();
        }
        catch (Exception ex) {
            return null;
        }
    }

    public static void drawCellWithRoundCornersBySegments(Graphics2D g2d, float rX, float rY, int roundCornerRadius, boolean[] roundCornersArray, float rW, float rH, Color borderColor, Color bgColor, int gridStyle, boolean drawRoundCorners, boolean drawTop, boolean drawBottom, float[] borderThickness) throws Exception {
        boolean drawBorder;
        if (g2d.getRenderingHint(RenderingHints.KEY_ANTIALIASING) != RenderingHints.VALUE_ANTIALIAS_ON) {
            g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        }
        Stroke origStroke = g2d.getStroke();
        if (bgColor != null) {
            GeneralPath roundRect = Java2DUtil.getRoundRectangleGeneralPath(rX, rY, drawRoundCorners ? roundCornerRadius : 0, roundCornersArray, rW, rH, drawTop, drawBottom, false);
            g2d.setPaint(bgColor);
            g2d.fill(roundRect);
        }
        boolean bl = drawBorder = borderThickness[0] != 0.0f || borderThickness[1] != 0.0f || borderThickness[2] != 0.0f || borderThickness[3] != 0.0f;
        if (borderColor != null && drawBorder) {
            if (gridStyle != -1 && gridStyle != 1 && gridStyle == 2) {
                g2d.setPaint(borderColor);
                Java2DUtil.drawRoundRectangleBySegments(g2d, Math.round(rX + 2.0f * borderThickness[0]), Math.round(rY + 2.0f * borderThickness[3]), roundCornerRadius, roundCornersArray, Math.round(rW - 4.0f * borderThickness[1]), Math.round(rH - 4.0f * borderThickness[2]), drawTop, drawBottom, true, borderThickness, gridStyle);
            }
            g2d.setPaint(borderColor);
            Java2DUtil.drawRoundRectangleBySegments(g2d, Math.round(rX), Math.round(rY), roundCornerRadius, roundCornersArray, Math.round(rW), Math.round(rH), drawTop, drawBottom, true, borderThickness, gridStyle);
        }
        g2d.setStroke(origStroke);
    }

    public static GeneralPath getRoundRectangleGeneralPath(float x, float y, int roundCornerRadius, boolean[] roundCornersArray, float w, float h, boolean drawTop, boolean drawBottom, boolean drawingBorder) {
        boolean topLeft = roundCornersArray[0];
        boolean topRight = roundCornersArray[1];
        boolean bottomRight = roundCornersArray[2];
        boolean bottomLeft = roundCornersArray[3];
        int r = roundCornerRadius;
        float minR = r;
        if (minR > w / 2.0f) {
            minR = w / 2.0f;
        }
        if (minR > h / 2.0f) {
            minR = h / 2.0f;
        }
        r = Math.round(minR);
        GeneralPath roundRect = new GeneralPath();
        if (drawTop || !drawingBorder && !topLeft) {
            roundRect.moveTo(x, topLeft ? y + (float)r : y);
            if (topLeft && r != 0) {
                roundRect.quadTo(x, y, x + (float)r, y);
            }
            roundRect.lineTo(x + w - (float)(topRight ? r : 0), y);
        } else {
            roundRect.moveTo(x + w, y);
        }
        if (topRight && r != 0) {
            roundRect.quadTo(x + w, y, x + w, y + (float)r);
        }
        roundRect.lineTo(x + w, y + h - (float)(bottomRight && drawBottom ? r : 0));
        if (drawBottom || !drawingBorder) {
            if (bottomRight && r != 0) {
                roundRect.quadTo(x + w, y + h, x + w - (float)r, y + h);
            }
            roundRect.lineTo(x + (float)(drawBottom && bottomLeft ? r : 0), y + h);
        } else {
            roundRect.moveTo(x, y + h);
        }
        if (bottomLeft && r != 0) {
            roundRect.quadTo(x, y + h, x, y + h - (float)r);
        }
        roundRect.lineTo(x, y + (float)(drawTop && topLeft ? r : 0));
        if (drawTop && drawBottom) {
            roundRect.closePath();
        }
        return roundRect;
    }

    public static void drawRoundRectangleBySegments(Graphics2D g2d, int x, int y, int roundCornerRadius, boolean[] roundCornersArray, float w, float h, boolean drawTop, boolean drawBottom, boolean drawingBorder, float[] borderThickness, int gridStyle) {
        boolean topLeft = roundCornersArray[0];
        boolean topRight = roundCornersArray[1];
        boolean bottomRight = roundCornersArray[2];
        boolean bottomLeft = roundCornersArray[3];
        float topBorder = borderThickness[0];
        float rightBorder = borderThickness[1];
        float bottomBorder = borderThickness[2];
        float leftBorder = borderThickness[3];
        int r = roundCornerRadius;
        w -= Math.abs(-rightBorder / 2.0f + leftBorder / 2.0f);
        h -= Math.abs(-bottomBorder / 2.0f + topBorder / 2.0f);
        float minR = r;
        if (minR > w / 2.0f) {
            minR = w / 2.0f;
        }
        if (minR > h / 2.0f) {
            minR = h / 2.0f;
        }
        r = Math.round(minR);
        Stroke origStroke = g2d.getStroke();
        GeneralPath roundRect = new GeneralPath();
        g2d.setStroke(Java2DUtil.getStroke(gridStyle, topBorder));
        if (topBorder > 0.0f && (drawTop || !drawingBorder && !topLeft)) {
            roundRect.moveTo((float)x + Math.abs((leftBorder - topBorder) / 2.0f), topLeft ? (float)(y + r) : (float)y);
            if (topLeft && r != 0) {
                roundRect.quadTo((float)x + Math.abs((leftBorder - topBorder) / 2.0f), y, x + r, y);
            }
            roundRect.lineTo((float)x + w - (float)(topRight ? r : 0) - Math.abs((rightBorder - topBorder) / 2.0f), y);
        } else {
            roundRect.moveTo((float)x + w, y);
        }
        if (topRight && r != 0) {
            roundRect.quadTo((float)x + w - Math.abs((rightBorder - topBorder) / 2.0f), y, (float)x + w - Math.abs((rightBorder - topBorder) / 2.0f), y + r);
        }
        if (rightBorder != topBorder) {
            g2d.draw(roundRect);
            roundRect = new GeneralPath();
            g2d.setStroke(Java2DUtil.getStroke(gridStyle, rightBorder));
            roundRect.moveTo((float)x + w, (float)(y + (topRight && r != 0 ? r : 0)) + Math.abs((rightBorder - topBorder) / 2.0f));
        }
        if (rightBorder > 0.0f) {
            roundRect.lineTo((float)x + w, (float)y + h - (float)(bottomRight && drawBottom ? r : 0) - Math.abs((rightBorder - bottomBorder) / 2.0f));
        } else {
            roundRect.moveTo((float)x + w, (float)y + h - (float)(bottomRight && drawBottom ? r : 0));
        }
        if (rightBorder != bottomBorder) {
            g2d.draw(roundRect);
            roundRect = new GeneralPath();
            g2d.setStroke(Java2DUtil.getStroke(gridStyle, bottomBorder));
            roundRect.moveTo((float)x + w - Math.abs((rightBorder - bottomBorder) / 2.0f), (float)y + h - (float)(bottomRight && drawBottom ? r : 0));
        }
        if (bottomBorder > 0.0f && (drawBottom || !drawingBorder)) {
            if (bottomRight && r != 0) {
                roundRect.quadTo((float)x + w - Math.abs((rightBorder - bottomBorder) / 2.0f), (float)y + h, (float)x + w - (float)r - Math.abs((rightBorder - bottomBorder) / 2.0f), (float)y + h);
            }
            roundRect.lineTo((float)(x + (drawBottom && bottomLeft ? r : 0)) + Math.abs((leftBorder - bottomBorder) / 2.0f), (float)y + h);
        } else {
            roundRect.moveTo(x, (float)y + h);
        }
        if (bottomBorder > 0.0f && bottomLeft && r != 0) {
            roundRect.quadTo((float)x + Math.abs((leftBorder - bottomBorder) / 2.0f), (float)y + h, (float)x + Math.abs((leftBorder - bottomBorder) / 2.0f), (float)y + h - (float)r);
        }
        if (bottomBorder != leftBorder) {
            g2d.draw(roundRect);
            roundRect = new GeneralPath();
            g2d.setStroke(Java2DUtil.getStroke(gridStyle, leftBorder));
            roundRect.moveTo(x, (float)y + h - (float)(bottomLeft && drawBottom ? r : 0) - Math.abs((bottomBorder - leftBorder) / 2.0f));
        }
        if (leftBorder > 0.0f) {
            roundRect.lineTo(x, (float)(y + (drawTop && topLeft ? r : 0)) + Math.abs((topBorder - leftBorder) / 2.0f));
            if (leftBorder == rightBorder && topBorder == bottomBorder && topBorder == leftBorder && drawTop && drawBottom) {
                roundRect.closePath();
            }
            g2d.draw(roundRect);
        }
        g2d.setStroke(origStroke);
    }

    private static Stroke getStroke(int gridStyle, float borderThickness) {
        BasicStroke stroke;
        if (gridStyle == 3) {
            float[] dashPattern = new float[]{10.0f, 5.0f};
            stroke = new BasicStroke(borderThickness, 0, 0, 1.0f, dashPattern, 0.0f);
        } else {
            stroke = new BasicStroke(borderThickness, 1, 2);
        }
        return stroke;
    }

    public static void drawRotateString(Graphics g, int x, int y, int w, int h, short align, short valign, boolean isUnderline, double rotation, Font font, String str, int length, int index) {
        Graphics2D g2d;
        double angle;
        FontMetrics fm = g.getFontMetrics(font);
        int charH = fm.getMaxAscent() + fm.getMaxDescent();
        int strWidth = fm.stringWidth(str);
        int strBaseX = Java2DUtil.getStringX(strWidth, x, w, align);
        int strBaseY = Java2DUtil.getStringY(length, y, h, index, charH, valign, fm.getMaxDescent());
        if (rotation != 0.0) {
            strBaseY = Java2DUtil.getRotateStringY(length, x, w, index, charH, valign, fm.getMaxDescent(), rotation);
            strBaseX = Java2DUtil.getRotateStringX(strWidth, y, h, align, rotation);
            LOGGER.finest("rotate x: " + x + " y: " + y + " rotation: " + rotation + " h: " + h);
            angle = Math.PI * (rotation - 360.0) / 180.0;
            if (g instanceof Graphics2D) {
                ((Graphics2D)g).translate((double)(-x), (double)(-y));
                ((Graphics2D)g).rotate(angle);
                if (rotation < 0.0 && rotation > -180.0 || rotation > 180.0) {
                    ((Graphics2D)g).translate((double)(-y), (double)x);
                } else {
                    ((Graphics2D)g).translate((double)y, (double)(-x));
                }
            } else if (g instanceof ZoomGraphics && ((ZoomGraphics)g).g instanceof Graphics2D) {
                g2d = (Graphics2D)((ZoomGraphics)g).g;
                g2d.translate(-x, -y);
                g2d.rotate(angle);
                if (rotation < 0.0 && rotation > -180.0 || rotation > 180.0) {
                    g2d.translate(-y, x);
                } else {
                    g2d.translate(y, -x);
                }
            }
        }
        g.drawString(str, strBaseX, strBaseY);
        LOGGER.finest("strBaseX: " + strBaseX + " strBaseY: " + strBaseY);
        if (isUnderline && !str.trim().equals("")) {
            int underLineY = strBaseY + fm.getDescent();
            g.drawLine(strBaseX, underLineY, strBaseX + strWidth, underLineY);
        }
        if (rotation != 0.0) {
            if (g instanceof Graphics2D) {
                angle = Math.PI * (rotation - 360.0) / 180.0;
                g2d = (Graphics2D)g;
                if (rotation < 0.0 && rotation > -180.0 || rotation > 180.0) {
                    g2d.translate((double)y, (double)(-x));
                } else {
                    g2d.translate((double)(-y), (double)x);
                }
                g2d.rotate(-angle);
                g2d.translate((double)x, (double)y);
            } else if (g instanceof ZoomGraphics && ((ZoomGraphics)g).g instanceof Graphics2D) {
                angle = Math.PI * (rotation - 360.0) / 180.0;
                g2d = (Graphics2D)((ZoomGraphics)g).g;
                if (rotation < 0.0 && rotation > -180.0 || rotation > 180.0) {
                    g2d.translate((double)y, (double)(-x));
                } else {
                    g2d.translate((double)(-y), (double)x);
                }
                g2d.rotate(-angle);
                g2d.translate((double)x, (double)y);
            }
        }
    }

    private static int getStringX(int strLen, int x, int w, short align) {
        switch (align) {
            case 2: {
                return x + w - strLen;
            }
            case 0: {
                return x + (int)Math.rint((double)(w - strLen) / 2.0);
            }
        }
        return x;
    }

    private static int getStringY(int numberOfLines, int y, int h, int i, int charH, short valign, int descent) {
        int r = 0;
        switch (valign) {
            case 1: {
                return y + (i + 1) * charH - 2 * descent + 3;
            }
            case 2: {
                r = h - numberOfLines * charH;
                if (r < 0) {
                    r = 0;
                }
                return y + r + (i + 1) * charH - 3;
            }
            case 0: {
                r = (int)Math.rint((double)(h - numberOfLines * charH) / 2.0);
                if (r < 0) {
                    r = 0;
                }
                return y + r + (i + 1) * charH - descent;
            }
        }
        return y + (i + 1) * charH - descent;
    }

    private static int getRotateStringX(int strLen, int x, int w, short align, double rotation) {
        int padding = 3;
        if (rotation < 0.0 && rotation > -180.0 || rotation > 180.0) {
            switch (align) {
                case 1: {
                    return -x - w + padding;
                }
                case 2: {
                    return -x - strLen;
                }
                case 0: {
                    return -x - w + (int)Math.rint((double)(w - 2 * padding - strLen) / 2.0) + padding;
                }
            }
            return x;
        }
        switch (align) {
            case 1: {
                return x + padding;
            }
            case 2: {
                return x + w - strLen;
            }
            case 0: {
                return x + (int)Math.rint((double)(w - 2 * padding - strLen) / 2.0) + padding;
            }
        }
        return x;
    }

    private static int getRotateStringY(int numberOfLines, int y, int h, int i, int charH, short valign, int descent, double rotation) {
        int r = 0;
        switch (valign) {
            case 1: {
                if (rotation > 0.0 && rotation < 180.0 || rotation < -180.0) {
                    return -y - h + (i + 1) * charH - 2 * descent + 3;
                }
                if (rotation < 0.0 && rotation > -180.0 || rotation > 180.0) {
                    return y + (i + 1) * charH - 2 * descent + 3;
                }
                return y + (i + 1) * charH - 2 * descent + 3;
            }
            case 2: {
                if (rotation > 0.0 && rotation < 180.0) {
                    r = numberOfLines * charH;
                    if (r < 0) {
                        r = 0;
                    }
                    return -y - r + (i + 1) * charH - 2 * descent;
                }
                r = h - numberOfLines * charH;
                if (r < 0) {
                    r = 0;
                }
                return y + r + (i + 1) * charH - 3;
            }
            case 0: {
                if (rotation > 0.0 && rotation < 180.0) {
                    r = (int)Math.rint((double)(h - numberOfLines * charH) / 2.0);
                    if (r < 0) {
                        r = 0;
                    }
                    return -y - h + r + (i + 1) * charH - descent;
                }
                r = (int)Math.rint((double)(h - numberOfLines * charH) / 2.0);
                if (r < 0) {
                    r = 0;
                }
                return y + r + (i + 1) * charH - descent;
            }
        }
        return y + (i + 1) * charH - descent;
    }
}

