/*
 * Decompiled with CFR 0.152.
 */
package quadbase.common.util.internal;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.InetAddress;
import java.sql.Date;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import quadbase.common.client.ServerMessage;
import quadbase.common.network.IConnection;
import quadbase.common.util.internal.CloseUtils;
import quadbase.common.util.internal.Coder;
import quadbase.common.util.internal.IOUtil;
import quadbase.common.util.internal.QbDebug;

public class LCKey {
    public static final String FREE_VERSION_TOOLTIP = "This feature is only included in full version, please contact sales@quadbase.com for more information.";
    public static final String FREE_VERSION_MSG = "This report contains charts/subreports/drilldowns,\nand only can be opened in full version,\nplease contact sales@quadbase.com for more information.";
    public static final String FREE_VERSION_ABOUT_MSG = "<html> This is a free trial version of EspressReport, with limited functionality.<br> If you want advanced functionality, such as Insert Charts, Sub-Reports,<br> and Drill-Down reports in your report design, please contact sales@quadbase.com.</html>";
    public static final String FREE_VERSION_SCHEDULER_MSG = "Report Scheduler is only included in full version.\nWith Report Scheduler, you can export reports at a specific time or specific interval.\nFor more information, please contact sales@quadbase.com.";
    public static final String FREE = "FREE";
    public static final String ERES = "ERES";
    public static final String ER = "ER";
    public static final String EC = "EC";
    public static final String DASH = "DASH";
    private static final String SKIPHOST = "QUADBASE-I";
    private static final String SKIPHOST_WITH_TIMEBOMB = "QUADBASE-E";
    private static final String RELEASE_VERSION = "R-V([0-9]+)X";
    private static final String DOWNLOAD_VERSION = "D-V([0-9]+)X";
    private static final String RELEASE_VERSION_4X = "R-V4X";
    private static final String DOWNLOAD_VERSION_4X = "D-V4X";
    private static boolean isFree = false;
    private static boolean isChart = false;
    private static boolean isReport = false;
    private static boolean isERES = false;
    private static boolean isDashboard = false;
    private static boolean isDownload = true;
    private static long expirationDate = 0L;
    private static int maxNoOfUser = 1;
    private static int maxNoOfCPU = 2;
    private static String licenseHostName = null;
    private static boolean isValidMachine = false;
    private static boolean init = false;
    private static boolean wasServerUsed = false;
    private static final String KEY_VERSION = "VERSION";
    private static final String USER = "USER";
    private static final String CPU = "CPU";
    private static final String VIEWER = "VIEWER";
    private static final String TYPE = "TYPE";
    private static final String HOST = "HOST";
    private static final String EXPIRE = "EXPIRE";
    private static int maxNoOfViewer = 0;
    private static String lcProdVersion = null;
    private static String error = null;

    public static boolean isFree() {
        return isFree;
    }

    public static boolean isChart() {
        return isChart;
    }

    public static boolean isReport() {
        return isReport;
    }

    public static boolean isERES() {
        return isERES;
    }

    public static boolean isDashboard() {
        return isDashboard;
    }

    public static boolean isDashboardOnly() {
        return isDashboard && !isERES;
    }

    public static boolean isDownload() {
        return isDownload;
    }

    public static int getMaxNoOfUser() {
        return maxNoOfUser;
    }

    public static int getMaxNoOfCPU() {
        return maxNoOfCPU;
    }

    public static String getLicenseHostName() {
        if (licenseHostName == null) {
            return "";
        }
        return licenseHostName;
    }

    public static int getMaxNoOfViewer() {
        if (maxNoOfViewer == 0) {
            return Integer.MAX_VALUE;
        }
        return maxNoOfViewer;
    }

    public static void resetLicense() {
        try {
            if (init && ServerMessage.useServer == wasServerUsed) {
                return;
            }
            QbDebug.println(3, "RESET LCKEY.....");
            isChart = false;
            isReport = false;
            isERES = false;
            isDashboard = false;
            isDownload = true;
            maxNoOfUser = 1;
            maxNoOfCPU = 2;
            licenseHostName = null;
            isValidMachine = false;
            LCKey.readLicense();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw new IllegalArgumentException(ex.toString());
        }
    }

    public static void readLicense() throws Exception {
        if (init && ServerMessage.useServer == wasServerUsed) {
            return;
        }
        init = false;
        BufferedReader reader = null;
        try {
            InputStream in = LCKey.class.getResourceAsStream("/QbKey.dat");
            if (in == null && ServerMessage.useServer) {
                QbDebug.println(3, "CHECK LICENSE -- CLIENT...");
                LCKey.getFromServer();
            } else {
                QbDebug.println(3, "CHECK LICENSE -- SERVER...");
                if (in == null) {
                    throw new IOException("Please include qblicense.jar into your classpath");
                }
                reader = new BufferedReader(new InputStreamReader(in));
                String code = reader.readLine();
                QbDebug.println(3, "READ CODE: " + code);
                String s = Coder.decode(code);
                QbDebug.println(3, "DECODE: " + s);
                boolean isKey4X = false;
                Element root = null;
                if (s.endsWith(FREE)) {
                    isFree = true;
                    s = s.replace(FREE, "");
                }
                if (s.startsWith(RELEASE_VERSION_4X)) {
                    QbDebug.println(3, "Release 4X Key");
                    isDownload = false;
                    isKey4X = true;
                } else if (s.startsWith(DOWNLOAD_VERSION_4X)) {
                    QbDebug.println(3, "Download 4X Key");
                    isDownload = true;
                    isKey4X = true;
                } else {
                    root = LCKey.isValidLicense(s);
                    if (root != null) {
                        if (LCKey.isReleaseVersion(root)) {
                            QbDebug.println(3, "Release 6X Key");
                            isDownload = false;
                        } else {
                            QbDebug.println(3, "Download 6X Key");
                            isDownload = true;
                        }
                    } else {
                        throw new IOException("Cannot Read License Key!");
                    }
                }
                if (!isDownload) {
                    if (isKey4X) {
                        LCKey.process4XReleaseLicense(s);
                    } else {
                        LCKey.processReleaseLicense(root);
                    }
                } else if (isKey4X) {
                    LCKey.process4XDownloadLicense(s);
                } else {
                    LCKey.processDownloadLicense(root);
                }
            }
        }
        catch (IOException ex) {
            LCKey.setType("");
            isDownload = true;
            throw ex;
        }
        finally {
            CloseUtils.close(reader);
        }
        wasServerUsed = ServerMessage.useServer;
        init = true;
        QbDebug.println(3, "isRelease = " + !isDownload);
        QbDebug.println(3, "maxNoOfUser = " + maxNoOfUser);
        if (maxNoOfViewer > 0) {
            QbDebug.println(3, "maxNoOfViewer = " + maxNoOfViewer);
        } else {
            QbDebug.println(3, "maxNoOfViewer = Unlimited");
        }
        QbDebug.println(3, "maxNoOfCPU = " + maxNoOfCPU);
        QbDebug.println(3, "licenseHostName = " + licenseHostName);
        QbDebug.println(3, "ORGANIZER = " + isERES);
        QbDebug.println(3, "REPORT = " + isReport);
        QbDebug.println(3, "CHART = " + isChart);
        QbDebug.println(3, "DASH = " + isDashboard);
        ServerMessage.product = isReport ? 1 : 0;
    }

    private static void processDownloadLicense(Element root) throws Exception {
        String tmp = root.getAttribute(EXPIRE);
        if (tmp != null && !tmp.equals("0") && !tmp.equals("")) {
            long expire;
            expirationDate = expire = Long.parseLong(tmp) - 247809L;
            if (System.currentTimeMillis() >= expire) {
                throw new IOException("Your evaluation copy has expired!  Please contact sales@quadbase.com for purchasing information.");
            }
        }
        tmp = root.getAttribute(TYPE);
        LCKey.setType(tmp);
    }

    private static void process4XDownloadLicense(String s) throws IOException {
        long ext;
        s = s.substring(DOWNLOAD_VERSION_4X.length());
        int k = s.indexOf(TYPE);
        expirationDate = ext = Long.parseLong(s.substring(0, k)) - 247809L;
        if (System.currentTimeMillis() >= ext) {
            throw new IOException("Your evaluation copy has expired!  Please contact sales@quadbase.com for purchasing information.");
        }
        String type = s.substring(k + TYPE.length());
        LCKey.setType(type);
    }

    private static Element isValidLicense(String s) {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        try {
            DocumentBuilder builder = factory.newDocumentBuilder();
            byte[] currentXMLBytes = s.getBytes();
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(currentXMLBytes);
            Document document = builder.parse(byteArrayInputStream);
            return document.getDocumentElement();
        }
        catch (Exception ex) {
            QbDebug.println(3, "Error checking is valid license: " + ex.getMessage());
            return null;
        }
    }

    private static boolean isTimeBombVersion() {
        return expirationDate > 0L;
    }

    public static boolean isRewriteNewKey(String lastAccessKey) throws Exception {
        if (!LCKey.isTimeBombVersion()) {
            return false;
        }
        long lastAccessTime = Long.parseLong(Coder.decode(lastAccessKey)) - 153287L;
        if (lastAccessTime > expirationDate) {
            throw new IOException("Your evaluation copy has expired!  Please contact sales@quadbase.com for purchasing information.");
        }
        return !LCKey.isLatestTime(lastAccessTime);
    }

    public static String getCurrentKey() {
        if (!LCKey.isTimeBombVersion()) {
            return null;
        }
        return Coder.encode(System.currentTimeMillis() + 153287L + "");
    }

    public static boolean isLatestKey(String lastAccessKey) {
        long lastAccessTime = Long.parseLong(Coder.decode(lastAccessKey)) - 153287L;
        return LCKey.isLatestTime(lastAccessTime);
    }

    private static boolean isLatestTime(long lastAccessTime) {
        return lastAccessTime > System.currentTimeMillis();
    }

    private static void processReleaseLicense(Element root) throws Exception {
        String version = root.getAttribute(KEY_VERSION);
        Pattern releasePattern = Pattern.compile(RELEASE_VERSION);
        Matcher matcher = releasePattern.matcher(version);
        matcher.matches();
        lcProdVersion = matcher.group(1);
        if (!lcProdVersion.equals("0")) {
            String curProdVersion = "7.0";
            int periodInd = curProdVersion.indexOf(46);
            String curMajorVersion = "";
            curMajorVersion = periodInd == -1 ? curProdVersion : curProdVersion.substring(0, periodInd);
            if (!curMajorVersion.equals(lcProdVersion)) {
                throw new IOException("The license key is for major version " + lcProdVersion + " and does not match the current release version.");
            }
        }
        String tmp = root.getAttribute(USER);
        maxNoOfUser = (int)(Long.parseLong(tmp) - 101076L);
        tmp = root.getAttribute(CPU);
        maxNoOfCPU = (int)(Long.parseLong(tmp) - 42666L);
        tmp = root.getAttribute(HOST);
        licenseHostName = tmp;
        if (licenseHostName.startsWith(SKIPHOST_WITH_TIMEBOMB)) {
            long ext;
            expirationDate = ext = Long.parseLong(licenseHostName.substring(SKIPHOST_WITH_TIMEBOMB.length())) - 247809L;
            if (System.currentTimeMillis() >= ext) {
                throw new IOException("Your copy has expired!  Please contact sales@quadbase.com for purchasing information");
            }
        }
        if ((tmp = root.getAttribute(EXPIRE)) != null && !tmp.equals("0") && !tmp.equals("")) {
            long ext = Long.parseLong(tmp) - 247809L;
            System.out.println(new Date(ext).toLocaleString());
            expirationDate = ext;
            if (System.currentTimeMillis() >= ext) {
                throw new IOException("Your copy has expired!  Please contact sales@quadbase.com for purchasing information.");
            }
        }
        tmp = root.getAttribute(TYPE);
        LCKey.setType(tmp);
        tmp = root.getAttribute(VIEWER);
        maxNoOfViewer = (int)(Long.parseLong(tmp) - 902565L);
    }

    private static void process4XReleaseLicense(String s) throws IOException {
        s = s.substring(RELEASE_VERSION_4X.length());
        int k = s.indexOf(CPU);
        maxNoOfUser = (int)(Long.parseLong(s.substring(0, k)) - 101076L);
        int l = s.indexOf(TYPE);
        String cpuStr = s.substring(k + CPU.length(), l);
        maxNoOfCPU = (int)(Long.parseLong(cpuStr) - 42666L);
        String type = null;
        int m = s.indexOf(HOST);
        type = s.substring(l + TYPE.length(), m);
        licenseHostName = s.substring(m + HOST.length());
        if (licenseHostName.startsWith(SKIPHOST_WITH_TIMEBOMB)) {
            long ext;
            expirationDate = ext = Long.parseLong(licenseHostName.substring(SKIPHOST_WITH_TIMEBOMB.length())) - 247809L;
            if (System.currentTimeMillis() >= ext) {
                throw new IOException("Your copy has expired!  Please contact sales@quadbase.com for purchasing information.");
            }
        }
        LCKey.setType(type);
    }

    private static boolean isReleaseVersion(Element root) throws Exception {
        String version = root.getAttribute(KEY_VERSION);
        Pattern releasePattern = Pattern.compile(RELEASE_VERSION);
        Matcher matcher = releasePattern.matcher(version);
        return matcher.matches();
    }

    private static void getFromServer() throws Exception {
        if (!ServerMessage.useServer && ServerMessage.isLoadBalancer) {
            return;
        }
        IConnection socket = ServerMessage.createConnection();
        ByteArrayOutputStream bstream = new ByteArrayOutputStream(50);
        DataOutputStream dout = new DataOutputStream(bstream);
        int slaveType = 31010;
        dout.writeShort(slaveType);
        try {
            byte[] array = bstream.toByteArray();
            socket.setContentLength(array.length);
            socket.getOutputStream().write(array);
            socket.getOutputStream().flush();
        }
        catch (Exception ex) {
            socket.close();
            throw ex;
        }
        try {
            DataInputStream dstream = new DataInputStream(socket.getInputStream());
            int code = dstream.readInt();
            if (code != 0) {
                throw new IOException(IOUtil.getErrorString(code) + IOUtil.readString(dstream, true));
            }
            isDownload = dstream.readBoolean();
            isERES = dstream.readBoolean();
            isDashboard = dstream.readBoolean();
            isReport = dstream.readBoolean();
            isChart = dstream.readBoolean();
            maxNoOfUser = dstream.readInt();
            maxNoOfCPU = dstream.readInt();
            licenseHostName = IOUtil.readString(dstream, true);
        }
        catch (Exception ex) {
            try {
                socket.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw ex;
        }
        catch (Error err) {
            try {
                socket.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw new Exception(err.getMessage());
        }
    }

    public static final void isValidEC() {
        if (!isChart) {
            String err = "Invalid license key for chart:  Please contact sales@quadbase.com!";
            System.out.println(err);
            throw new IllegalArgumentException(err);
        }
        if (!ServerMessage.useServer && ServerMessage.isCheckMachineName()) {
            LCKey.isValidMachine();
        }
    }

    public static final void isValidER() {
        if (!isReport) {
            String err = "Invalid license key for report:  Please contact sales@quadbase.com!";
            System.out.println(err);
            throw new IllegalArgumentException(err);
        }
        if (!ServerMessage.useServer && ServerMessage.isCheckMachineName()) {
            LCKey.isValidMachine();
        }
    }

    public static final void isValidERES() {
        if (!isERES) {
            String err = "Invalid license key for ERES:  Please contact sales@quadbase.com!";
            System.out.println(err);
            throw new IllegalArgumentException(err);
        }
        LCKey.isValidMachine();
    }

    public static final void isValidDASH() {
        if (!isDashboard) {
            String err = "Invalid license key for Dashboard:  Please contact sales@quadbase.com!";
            System.out.println(err);
            throw new IllegalArgumentException(err);
        }
        LCKey.isValidMachine();
    }

    public static final void isValidServer() {
        if (!isReport && !isChart) {
            String err = "Invalid license key for server:  Please contact sales@quadbase.com!";
            System.out.println(err);
            throw new IllegalArgumentException(err);
        }
        LCKey.isValidMachine();
    }

    private static final void isValidMachine() {
        if (isValidMachine || isDownload) {
            return;
        }
        if (ServerMessage.useServer) {
            return;
        }
        QbDebug.println(3, "CHECK IS VALID MACHINE...");
        String err = null;
        if (!IOUtil.checkCPU(maxNoOfCPU)) {
            err = "Your machine has more than " + maxNoOfCPU + " CPU!";
            System.out.println(err);
            throw new IllegalArgumentException(err);
        }
        String curHostName = LCKey.getHostName();
        String curHostAddress = LCKey.getHostAddress();
        QbDebug.println(3, "curHostName = " + curHostName);
        QbDebug.println(3, "curHostAddress = " + curHostAddress);
        if (licenseHostName != null && (licenseHostName.equals(SKIPHOST) || licenseHostName.startsWith(SKIPHOST_WITH_TIMEBOMB) || licenseHostName.equalsIgnoreCase(curHostName) || licenseHostName.equalsIgnoreCase(curHostAddress))) {
            isValidMachine = true;
            return;
        }
        String partialName = "";
        if (curHostName != null && licenseHostName != null) {
            if (licenseHostName.length() > curHostName.length()) {
                partialName = licenseHostName.substring(0, curHostName.length() + 1);
                String tempCurHostName = curHostName + ".";
                if (tempCurHostName.equalsIgnoreCase(partialName)) {
                    isValidMachine = true;
                    return;
                }
            } else if (curHostName.length() > licenseHostName.length() && licenseHostName.equalsIgnoreCase(partialName = curHostName.substring(0, licenseHostName.length()))) {
                isValidMachine = true;
                return;
            }
        }
        err = "This program can only run in host " + licenseHostName + " but not host " + curHostName + "!";
        System.out.println(err);
        throw new IllegalArgumentException(err);
    }

    public static final String getHostName() {
        String hostName = null;
        try {
            String ipaddress = InetAddress.getLocalHost().getHostAddress();
            hostName = InetAddress.getByName(ipaddress).getHostName();
            if (hostName != null) {
                return hostName;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            hostName = InetAddress.getLocalHost().getHostName();
            if (hostName != null) {
                return hostName;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            hostName = InetAddress.getLocalHost().getHostAddress();
            if (hostName != null) {
                return hostName;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public static final String getHostAddress() {
        String ipaddress = null;
        try {
            ipaddress = InetAddress.getLocalHost().getHostAddress();
            if (ipaddress != null) {
                return ipaddress;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            ipaddress = InetAddress.getLocalHost().getHostAddress();
            if (ipaddress != null) {
                return ipaddress;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    private static void setType(String type) {
        try {
            isChart = true;
            isReport = true;
            isERES = true;
            isDashboard = true;
            if (type.equals(ERES)) {
                return;
            }
            isERES = false;
            if (type.equals(DASH)) {
                return;
            }
            isDashboard = false;
            if (type.equals(ER)) {
                if (!isFree) {
                    return;
                }
                isChart = false;
                return;
            }
            isReport = false;
            if (type.equals(EC)) {
                return;
            }
            isChart = false;
        }
        catch (Exception ex) {
            isChart = false;
            isReport = false;
            isERES = false;
            isDashboard = false;
        }
    }

    public static String getError() {
        return error;
    }

    static {
        try {
            QbDebug.println(3, "INIT LCKEY...");
            LCKey.readLicense();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            error = ex.toString();
        }
    }
}

