/*
 * Decompiled with CFR 0.152.
 */
package quadbase.common.util.internal;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;

public class PatternImage {
    public static final int BLANK = 0;
    public static final int FORWARD_DIAGONAL = 1;
    public static final int BACKWARD_DIAGONAL = 2;
    public static final int MID_CROSS = 3;
    public static final int DIAGONAL_CROSS = 4;
    public static final int HORIZONTAL_LINE = 5;
    public static final int VERTICAL_LINE = 6;
    public static final int THICK_FORWARD_DIAGONAL = 7;
    public static final int THICK_BACKWARD_DIAGONAL = 8;
    public static final int THICK_HORIZONTAL = 9;
    public static final int THICK_VERTICAL = 10;
    public static final int BIG_TRIANGLE = 11;
    public static final int SMALL_TRIANGLE = 12;
    public static final int UPPER_TRIANGLE = 13;
    public static final int LOWER_TRIANGLE = 14;
    public static final int BIG_REV_TRIANGLE = 15;
    public static final int SMALL_REV_TRIANGLE = 16;
    public static final int HOLLOW_TRIANGLE = 17;
    public static final int BIG_CIRCLE = 18;
    public static final int SMALL_CIRCLE = 19;
    public static final int CROSS_ECLIPSE = 20;
    public static final int HOLLOW_CIRCLE = 21;
    public static final int CHESSBOX = 22;
    public static final int SMALL_BLOCK = 23;
    public static final int DIAMOND = 24;
    public static final int HOLLOW_SQUARE = 25;
    public static final int HOLLOW_DIAMOND = 26;
    public static final int HEART = 27;
    public static final int STAR = 28;
    public static final int CLUB = 29;
    public static final int MAX_PATTERN_ID = 30;
    public static final int WIDTH = 16;
    public static final int HEIGHT = 16;

    public static BufferedImage generatePatternImage(Color color, int type) {
        BufferedImage bImage = new BufferedImage(16, 16, 1);
        Graphics g = bImage.getGraphics();
        g.setColor(Color.white);
        g.fillRect(0, 0, 16, 16);
        g.setColor(color);
        switch (type) {
            case 0: {
                g.fillRect(0, 0, 16, 16);
                break;
            }
            case 1: {
                PatternImage.makeForwardDiagonal(g);
                break;
            }
            case 2: {
                PatternImage.makeBackwardDiagonal(g);
                break;
            }
            case 4: {
                PatternImage.makeDiagonalCross(g);
                break;
            }
            case 3: {
                PatternImage.makeMidCross(g);
                break;
            }
            case 6: {
                PatternImage.makeVerticalLine(g);
                break;
            }
            case 5: {
                PatternImage.makeHorizontalLine(g);
                break;
            }
            case 11: {
                PatternImage.makeBigTriangle(g);
                break;
            }
            case 12: {
                PatternImage.makeSmallTriangle(g);
                break;
            }
            case 18: {
                PatternImage.makeBigCircle(g);
                break;
            }
            case 19: {
                PatternImage.makeSmallCircle(g);
                break;
            }
            case 20: {
                PatternImage.makeCrossEclipse(g);
                break;
            }
            case 27: {
                PatternImage.makeHeart(g);
                break;
            }
            case 28: {
                PatternImage.makeStar(g);
                break;
            }
            case 29: {
                PatternImage.makeClub(g);
                break;
            }
            case 24: {
                PatternImage.makeDiamond(g);
                break;
            }
            case 21: {
                PatternImage.makeHollowCircle(g);
                break;
            }
            case 22: {
                PatternImage.makeChessBox(g);
                break;
            }
            case 23: {
                PatternImage.makeSmallBlock(g);
                break;
            }
            case 25: {
                PatternImage.makeHollowSquare(g);
                break;
            }
            case 26: {
                PatternImage.makeHollowDiamond(g);
                break;
            }
            case 15: {
                PatternImage.makeBigRevTriangle(g);
                break;
            }
            case 16: {
                PatternImage.makeSmallRevTriangle(g);
                break;
            }
            case 17: {
                PatternImage.makeHollowTriangle(g);
                break;
            }
            case 7: {
                PatternImage.makeThickForwardDiagonal(g);
                break;
            }
            case 8: {
                PatternImage.makeThickBackwardDiagonal(g);
                break;
            }
            case 9: {
                PatternImage.makeThickHorizontalLine(g);
                break;
            }
            case 10: {
                PatternImage.makeThickVerticalLine(g);
                break;
            }
            case 13: {
                PatternImage.makeUpperTriangle(g);
                break;
            }
            case 14: {
                PatternImage.makeLowerTriangle(g);
            }
        }
        return bImage;
    }

    private static void makeForwardDiagonal(Graphics g) {
        int[] x = new int[]{15, 16, 16, 1, 0, 0};
        int[] y = new int[]{0, 0, 1, 16, 16, 15};
        g.fillPolygon(x, y, 6);
        g.drawLine(0, 0, 0, 0);
        g.drawLine(16, 16, 16, 16);
    }

    private static void makeBackwardDiagonal(Graphics g) {
        int[] x = new int[]{0, 1, 16, 16, 15, 0};
        int[] y = new int[]{0, 0, 15, 16, 16, 1};
        g.fillPolygon(x, y, 6);
        g.drawLine(15, 0, 15, 0);
        g.drawLine(0, 16, 0, 16);
    }

    private static void makeDiagonalCross(Graphics g) {
        PatternImage.makeForwardDiagonal(g);
        PatternImage.makeBackwardDiagonal(g);
    }

    private static void makeHorizontalLine(Graphics g) {
        g.drawLine(0, 7, 16, 7);
        g.drawLine(0, 8, 16, 8);
        g.drawLine(0, 0, 16, 0);
        g.drawLine(0, 15, 16, 15);
    }

    private static void makeVerticalLine(Graphics g) {
        g.drawLine(7, 0, 7, 16);
        g.drawLine(8, 0, 8, 16);
        g.drawLine(0, 0, 0, 16);
        g.drawLine(15, 0, 15, 16);
    }

    private static void makeMidCross(Graphics g) {
        PatternImage.makeHorizontalLine(g);
        PatternImage.makeVerticalLine(g);
    }

    private static void makeBigTriangle(Graphics g) {
        int[] x = new int[]{8, 0, 16};
        int[] y = new int[]{0, 16, 16};
        g.fillPolygon(x, y, 3);
    }

    private static void makeSmallTriangle(Graphics g) {
        int[] x = new int[]{8, 4, 12};
        int[] y = new int[]{4, 12, 12};
        g.fillPolygon(x, y, 3);
    }

    private static void makeBigCircle(Graphics g) {
        g.fillOval(1, 1, 15, 15);
    }

    private static void makeSmallCircle(Graphics g) {
        g.fillOval(4, 4, 8, 8);
    }

    private static void makeCrossEclipse(Graphics g) {
        g.fillOval(0, 4, 16, 8);
        g.fillOval(4, 0, 8, 16);
        ((Graphics2D)g).rotate(0.5235987755982988);
    }

    private static void makeHeart(Graphics g) {
        g.fillArc(0, 4, 8, 8, 0, 180);
        g.fillArc(8, 4, 8, 8, 0, 180);
        int[] x = new int[]{0, 8, 16};
        int[] y = new int[]{8, 16, 8};
        g.fillPolygon(x, y, 3);
    }

    private static void makeClub(Graphics g) {
        g.fillOval(4, 0, 8, 8);
        g.fillOval(0, 4, 8, 8);
        g.fillOval(8, 4, 8, 8);
        int[] x = new int[]{8, 12, 4};
        int[] y = new int[]{8, 16, 16};
        g.fillPolygon(x, y, 3);
    }

    private static void makeStar(Graphics g) {
        int[] x = new int[]{8, 10, 16, 11, 12, 8, 3, 4, 0, 6};
        int[] y = new int[]{0, 6, 6, 9, 16, 11, 16, 9, 6, 6};
        g.fillPolygon(x, y, 10);
    }

    private static void makeDiamond(Graphics g) {
        int[] x = new int[]{0, 8, 16, 8};
        int[] y = new int[]{8, 0, 8, 16};
        g.fillPolygon(x, y, 4);
    }

    private static void makeHollowCircle(Graphics g) {
        g.fillOval(0, 0, 16, 16);
        g.setColor(Color.white);
        g.fillOval(4, 4, 8, 8);
    }

    private static void makeChessBox(Graphics g) {
        g.fillRect(0, 0, 8, 8);
        g.fillRect(8, 8, 16, 16);
    }

    private static void makeSmallBlock(Graphics g) {
        g.fillRect(4, 4, 8, 8);
    }

    private static void makeHollowSquare(Graphics g) {
        g.fillRect(0, 0, 16, 16);
        g.setColor(Color.white);
        g.fillRect(4, 4, 8, 8);
    }

    private static void makeHollowDiamond(Graphics g) {
        int[] x = new int[]{8, 16, 8, 0};
        int[] y = new int[]{0, 8, 16, 8};
        g.fillPolygon(x, y, 4);
        g.setColor(Color.white);
        x = new int[]{8, 12, 8, 4};
        y = new int[]{4, 8, 12, 8};
        g.fillPolygon(x, y, 4);
    }

    private static void makeBigRevTriangle(Graphics g) {
        int[] x = new int[]{0, 16, 8};
        int[] y = new int[]{0, 0, 16};
        g.fillPolygon(x, y, 3);
    }

    private static void makeSmallRevTriangle(Graphics g) {
        int[] x = new int[]{4, 12, 8};
        int[] y = new int[]{4, 4, 12};
        g.fillPolygon(x, y, 3);
    }

    private static void makeHollowTriangle(Graphics g) {
        PatternImage.makeBigTriangle(g);
        g.setColor(Color.white);
        PatternImage.makeSmallTriangle(g);
    }

    private static void makeThickForwardDiagonal(Graphics g) {
        int[] x = new int[]{12, 16, 16, 4, 0, 0};
        int[] y = new int[]{0, 0, 4, 16, 16, 12};
        g.fillPolygon(x, y, 6);
        x = new int[]{0, 4, 0};
        y = new int[]{0, 0, 4};
        g.fillPolygon(x, y, 3);
        x = new int[]{16, 16, 12};
        y = new int[]{12, 16, 16};
        g.fillPolygon(x, y, 3);
    }

    private static void makeThickBackwardDiagonal(Graphics g) {
        int[] x = new int[]{0, 4, 16, 16, 12, 0};
        int[] y = new int[]{0, 0, 12, 16, 16, 4};
        g.fillPolygon(x, y, 6);
        x = new int[]{12, 16, 16};
        y = new int[]{0, 0, 4};
        g.fillPolygon(x, y, 3);
        x = new int[]{0, 4, 0};
        y = new int[]{12, 16, 16};
        g.fillPolygon(x, y, 3);
    }

    private static void makeThickVerticalLine(Graphics g) {
        g.fillRect(4, 0, 8, 16);
    }

    private static void makeThickHorizontalLine(Graphics g) {
        g.fillRect(0, 4, 16, 8);
    }

    private static void makeUpperTriangle(Graphics g) {
        int[] x = new int[]{0, 16, 0};
        int[] y = new int[]{0, 0, 16};
        g.fillPolygon(x, y, 3);
    }

    private static void makeLowerTriangle(Graphics g) {
        int[] x = new int[]{16, 16, 0};
        int[] y = new int[]{0, 16, 16};
        g.fillPolygon(x, y, 3);
    }
}

