/*
 * Decompiled with CFR 0.152.
 */
package quadbase.common.util.internal;

import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.Date;
import java.sql.NClob;
import java.sql.ParameterMetaData;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Map;

public class QbCallableStatement
implements CallableStatement {
    private boolean isOracleStoredProcedure = false;
    CallableStatement cStmt;
    Connection conn;

    public QbCallableStatement(Connection conn, String query) throws SQLException {
        this.conn = conn;
        this.cStmt = conn.prepareCall(query);
        this.setOracleStoredProcedure(conn, query);
    }

    public QbCallableStatement(Connection conn, String query, int resultSetType, int resultSetConcurrency) throws SQLException {
        this.conn = conn;
        this.cStmt = conn.prepareCall(query, resultSetType, resultSetConcurrency);
        this.setOracleStoredProcedure(conn, query);
    }

    public QbCallableStatement(Connection conn, String query, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        this.conn = conn;
        this.cStmt = conn.prepareCall(query, resultSetType, resultSetConcurrency, resultSetHoldability);
        this.setOracleStoredProcedure(conn, query);
    }

    private void setOracleStoredProcedure(Connection conn, String query) throws SQLException {
        if (conn.getMetaData().getDatabaseProductName().toLowerCase().indexOf("oracle") > -1 && query.toLowerCase().startsWith("begin") && query.toLowerCase().trim().endsWith("end;")) {
            this.isOracleStoredProcedure = true;
            this.cStmt.registerOutParameter(1, -10);
        }
    }

    @Override
    public Array getArray(int i) throws SQLException {
        return this.cStmt.getArray(i);
    }

    @Override
    public Array getArray(String parameterName) throws SQLException {
        return this.cStmt.getArray(parameterName);
    }

    @Override
    public BigDecimal getBigDecimal(int parameterIndex) throws SQLException {
        return this.cStmt.getBigDecimal(parameterIndex);
    }

    @Override
    public BigDecimal getBigDecimal(String parameterName) throws SQLException {
        return this.cStmt.getBigDecimal(parameterName);
    }

    @Override
    public BigDecimal getBigDecimal(int parameterIndex, int scale) throws SQLException {
        return this.cStmt.getBigDecimal(parameterIndex, scale);
    }

    @Override
    public Blob getBlob(int i) throws SQLException {
        return this.cStmt.getBlob(i);
    }

    @Override
    public Blob getBlob(String parameterName) throws SQLException {
        return this.cStmt.getBlob(parameterName);
    }

    @Override
    public boolean getBoolean(int parameterIndex) throws SQLException {
        return this.cStmt.getBoolean(parameterIndex);
    }

    @Override
    public boolean getBoolean(String parameterName) throws SQLException {
        return this.cStmt.getBoolean(parameterName);
    }

    @Override
    public byte getByte(int parameterIndex) throws SQLException {
        return this.cStmt.getByte(parameterIndex);
    }

    @Override
    public byte getByte(String parameterName) throws SQLException {
        return this.cStmt.getByte(parameterName);
    }

    @Override
    public byte[] getBytes(int parameterIndex) throws SQLException {
        return this.cStmt.getBytes(parameterIndex);
    }

    @Override
    public byte[] getBytes(String parameterName) throws SQLException {
        return this.cStmt.getBytes(parameterName);
    }

    @Override
    public Clob getClob(int i) throws SQLException {
        return this.cStmt.getClob(i);
    }

    @Override
    public Clob getClob(String parameterName) throws SQLException {
        return this.cStmt.getClob(parameterName);
    }

    @Override
    public Date getDate(int parameterIndex) throws SQLException {
        return this.cStmt.getDate(parameterIndex);
    }

    @Override
    public Date getDate(String parameterName) throws SQLException {
        return this.cStmt.getDate(parameterName);
    }

    @Override
    public Date getDate(int parameterIndex, Calendar cal) throws SQLException {
        return this.cStmt.getDate(parameterIndex, cal);
    }

    @Override
    public Date getDate(String parameterName, Calendar cal) throws SQLException {
        return this.cStmt.getDate(parameterName, cal);
    }

    @Override
    public double getDouble(int parameterIndex) throws SQLException {
        return this.cStmt.getDouble(parameterIndex);
    }

    @Override
    public double getDouble(String parameterName) throws SQLException {
        return this.cStmt.getDouble(parameterName);
    }

    @Override
    public float getFloat(int parameterIndex) throws SQLException {
        return this.cStmt.getFloat(parameterIndex);
    }

    @Override
    public float getFloat(String parameterName) throws SQLException {
        return this.cStmt.getFloat(parameterName);
    }

    @Override
    public int getInt(int parameterIndex) throws SQLException {
        return this.cStmt.getInt(parameterIndex);
    }

    @Override
    public int getInt(String parameterName) throws SQLException {
        return this.cStmt.getInt(parameterName);
    }

    @Override
    public long getLong(int parameterIndex) throws SQLException {
        return this.cStmt.getLong(parameterIndex);
    }

    @Override
    public long getLong(String parameterName) throws SQLException {
        return this.cStmt.getLong(parameterName);
    }

    @Override
    public Object getObject(int parameterIndex) throws SQLException {
        return this.cStmt.getObject(parameterIndex);
    }

    @Override
    public Object getObject(String parameterName) throws SQLException {
        return this.cStmt.getObject(parameterName);
    }

    public Object getObject(int i, Map map) throws SQLException {
        return this.cStmt.getObject(i, map);
    }

    public Object getObject(String parameterName, Map map) throws SQLException {
        return this.cStmt.getObject(parameterName, map);
    }

    @Override
    public Ref getRef(int i) throws SQLException {
        return this.cStmt.getRef(i);
    }

    @Override
    public Ref getRef(String parameterName) throws SQLException {
        return this.cStmt.getRef(parameterName);
    }

    @Override
    public short getShort(int parameterIndex) throws SQLException {
        return this.cStmt.getShort(parameterIndex);
    }

    @Override
    public short getShort(String parameterName) throws SQLException {
        return this.cStmt.getShort(parameterName);
    }

    @Override
    public String getString(int parameterIndex) throws SQLException {
        return this.cStmt.getString(parameterIndex);
    }

    @Override
    public String getString(String parameterName) throws SQLException {
        return this.cStmt.getString(parameterName);
    }

    @Override
    public Time getTime(int parameterIndex) throws SQLException {
        return this.cStmt.getTime(parameterIndex);
    }

    @Override
    public Time getTime(String parameterName) throws SQLException {
        return this.cStmt.getTime(parameterName);
    }

    @Override
    public Time getTime(int parameterIndex, Calendar cal) throws SQLException {
        return this.cStmt.getTime(parameterIndex, cal);
    }

    @Override
    public Time getTime(String parameterName, Calendar cal) throws SQLException {
        return this.cStmt.getTime(parameterName, cal);
    }

    @Override
    public Timestamp getTimestamp(int parameterIndex) throws SQLException {
        return this.cStmt.getTimestamp(parameterIndex);
    }

    @Override
    public Timestamp getTimestamp(String parameterName) throws SQLException {
        return this.cStmt.getTimestamp(parameterName);
    }

    @Override
    public Timestamp getTimestamp(int parameterIndex, Calendar cal) throws SQLException {
        return this.cStmt.getTimestamp(parameterIndex, cal);
    }

    @Override
    public Timestamp getTimestamp(String parameterName, Calendar cal) throws SQLException {
        return this.cStmt.getTimestamp(parameterName, cal);
    }

    @Override
    public URL getURL(int parameterIndex) throws SQLException {
        return this.cStmt.getURL(parameterIndex);
    }

    @Override
    public URL getURL(String parameterName) throws SQLException {
        return this.cStmt.getURL(parameterName);
    }

    @Override
    public void registerOutParameter(int parameterIndex, int sqlType) throws SQLException {
        this.cStmt.registerOutParameter(parameterIndex, sqlType);
    }

    @Override
    public void registerOutParameter(String parameterName, int sqlType) throws SQLException {
        this.cStmt.registerOutParameter(parameterName, sqlType);
    }

    @Override
    public void registerOutParameter(int parameterIndex, int sqlType, int scale) throws SQLException {
        this.cStmt.registerOutParameter(parameterIndex, sqlType, scale);
    }

    @Override
    public void registerOutParameter(int paramIndex, int sqlType, String typeName) throws SQLException {
        this.cStmt.registerOutParameter(paramIndex, sqlType, typeName);
    }

    @Override
    public void registerOutParameter(String parameterName, int sqlType, int scale) throws SQLException {
        this.cStmt.registerOutParameter(parameterName, sqlType, scale);
    }

    @Override
    public void registerOutParameter(String parameterName, int sqlType, String typeName) throws SQLException {
        this.cStmt.registerOutParameter(parameterName, sqlType, typeName);
    }

    @Override
    public void setAsciiStream(String parameterName, InputStream x, int length) throws SQLException {
        this.cStmt.setAsciiStream(parameterName, x, length);
    }

    @Override
    public void setBigDecimal(String parameterName, BigDecimal x) throws SQLException {
        this.cStmt.setBigDecimal(parameterName, x);
    }

    @Override
    public void setBinaryStream(String parameterName, InputStream x, int length) throws SQLException {
        this.cStmt.setBinaryStream(parameterName, x, length);
    }

    @Override
    public void setBoolean(String parameterName, boolean x) throws SQLException {
        this.cStmt.setBoolean(parameterName, x);
    }

    @Override
    public void setByte(String parameterName, byte x) throws SQLException {
        this.cStmt.setByte(parameterName, x);
    }

    @Override
    public void setBytes(String parameterName, byte[] x) throws SQLException {
        this.cStmt.setBytes(parameterName, x);
    }

    @Override
    public void setCharacterStream(String parameterName, Reader reader, int length) throws SQLException {
        this.cStmt.setCharacterStream(parameterName, reader, length);
    }

    @Override
    public void setDate(String parameterName, Date x) throws SQLException {
        this.cStmt.setDate(parameterName, x);
    }

    @Override
    public void setDate(String parameterName, Date x, Calendar cal) throws SQLException {
        this.cStmt.setDate(parameterName, x, cal);
    }

    @Override
    public void setDouble(String parameterName, double x) throws SQLException {
        this.cStmt.setDouble(parameterName, x);
    }

    @Override
    public void setFloat(String parameterName, float x) throws SQLException {
        this.cStmt.setFloat(parameterName, x);
    }

    @Override
    public void setInt(String parameterName, int x) throws SQLException {
        this.cStmt.setInt(parameterName, x);
    }

    @Override
    public void setLong(String parameterName, long x) throws SQLException {
        this.cStmt.setLong(parameterName, x);
    }

    @Override
    public void setNull(String parameterName, int sqlType) throws SQLException {
        this.cStmt.setNull(parameterName, sqlType);
    }

    @Override
    public void setNull(String parameterName, int sqlType, String typeName) throws SQLException {
        this.cStmt.setNull(parameterName, sqlType, typeName);
    }

    @Override
    public void setObject(String parameterName, Object x) throws SQLException {
        this.cStmt.setObject(parameterName, x);
    }

    @Override
    public void setObject(String parameterName, Object x, int targetSqlType) throws SQLException {
        this.cStmt.setObject(parameterName, x, targetSqlType);
    }

    @Override
    public void setObject(String parameterName, Object x, int targetSqlType, int scale) throws SQLException {
        this.cStmt.setObject(parameterName, x, targetSqlType, scale);
    }

    @Override
    public void setShort(String parameterName, short x) throws SQLException {
        this.cStmt.setShort(parameterName, x);
    }

    @Override
    public void setString(String parameterName, String x) throws SQLException {
        this.cStmt.setString(parameterName, x);
    }

    @Override
    public void setTime(String parameterName, Time x) throws SQLException {
        this.cStmt.setTime(parameterName, x);
    }

    @Override
    public void setTime(String parameterName, Time x, Calendar cal) throws SQLException {
        this.cStmt.setTime(parameterName, x, cal);
    }

    @Override
    public void setTimestamp(String parameterName, Timestamp x) throws SQLException {
        this.cStmt.setTimestamp(parameterName, x);
    }

    @Override
    public void setTimestamp(String parameterName, Timestamp x, Calendar cal) throws SQLException {
        this.cStmt.setTimestamp(parameterName, x, cal);
    }

    @Override
    public void setURL(String parameterName, URL val) throws SQLException {
        this.cStmt.setURL(parameterName, val);
    }

    @Override
    public boolean wasNull() throws SQLException {
        return this.cStmt.wasNull();
    }

    @Override
    public void addBatch() throws SQLException {
        this.cStmt.addBatch();
    }

    @Override
    public void clearParameters() throws SQLException {
        this.cStmt.clearParameters();
    }

    @Override
    public boolean execute() throws SQLException {
        boolean result = this.cStmt.execute();
        if (this.isOracleStoredProcedure) {
            return true;
        }
        return result;
    }

    @Override
    public ResultSet executeQuery() throws SQLException {
        return this.cStmt.executeQuery();
    }

    @Override
    public int executeUpdate() throws SQLException {
        return this.cStmt.executeUpdate();
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        return this.cStmt.getMetaData();
    }

    @Override
    public ParameterMetaData getParameterMetaData() throws SQLException {
        return this.cStmt.getParameterMetaData();
    }

    @Override
    public void setArray(int i, Array x) throws SQLException {
        this.cStmt.setArray(i, x);
    }

    @Override
    public void setAsciiStream(int parameterIndex, InputStream x, int length) throws SQLException {
        this.cStmt.setAsciiStream(parameterIndex, x, length);
    }

    @Override
    public void setBigDecimal(int parameterIndex, BigDecimal x) throws SQLException {
        this.cStmt.setBigDecimal(parameterIndex, x);
    }

    @Override
    public void setBinaryStream(int parameterIndex, InputStream x, int length) throws SQLException {
        this.cStmt.setBinaryStream(parameterIndex, x, length);
    }

    @Override
    public void setBlob(int i, Blob x) throws SQLException {
        this.cStmt.setBlob(i, x);
    }

    @Override
    public void setBoolean(int parameterIndex, boolean x) throws SQLException {
        this.cStmt.setBoolean(parameterIndex, x);
    }

    @Override
    public void setByte(int parameterIndex, byte x) throws SQLException {
        this.cStmt.setByte(parameterIndex, x);
    }

    @Override
    public void setBytes(int parameterIndex, byte[] x) throws SQLException {
        this.cStmt.setBytes(parameterIndex, x);
    }

    @Override
    public void setCharacterStream(int parameterIndex, Reader reader, int length) throws SQLException {
        this.cStmt.setCharacterStream(parameterIndex, reader, length);
    }

    @Override
    public void setClob(int i, Clob x) throws SQLException {
        this.cStmt.setClob(i, x);
    }

    @Override
    public void setDate(int parameterIndex, Date x) throws SQLException {
        this.cStmt.setDate(parameterIndex, x);
    }

    @Override
    public void setDate(int parameterIndex, Date x, Calendar cal) throws SQLException {
        this.cStmt.setDate(parameterIndex, x, cal);
    }

    @Override
    public void setDouble(int parameterIndex, double x) throws SQLException {
        this.cStmt.setDouble(parameterIndex, x);
    }

    @Override
    public void setFloat(int parameterIndex, float x) throws SQLException {
        this.cStmt.setFloat(parameterIndex, x);
    }

    @Override
    public void setInt(int parameterIndex, int x) throws SQLException {
        this.cStmt.setInt(parameterIndex, x);
    }

    @Override
    public void setLong(int parameterIndex, long x) throws SQLException {
        this.cStmt.setLong(parameterIndex, x);
    }

    @Override
    public void setNull(int parameterIndex, int sqlType) throws SQLException {
        if (this.isOracleStoredProcedure) {
            this.cStmt.setNull(parameterIndex + 1, sqlType);
        } else {
            this.cStmt.setNull(parameterIndex, sqlType);
        }
    }

    @Override
    public void setNull(int paramIndex, int sqlType, String typeName) throws SQLException {
        if (this.isOracleStoredProcedure) {
            this.cStmt.setNull(paramIndex + 1, sqlType, typeName);
        } else {
            this.cStmt.setNull(paramIndex, sqlType, typeName);
        }
    }

    @Override
    public void setObject(int parameterIndex, Object x) throws SQLException {
        if (this.isOracleStoredProcedure) {
            this.cStmt.setObject(parameterIndex + 1, x);
        } else {
            this.cStmt.setObject(parameterIndex, x);
        }
    }

    @Override
    public void setObject(int parameterIndex, Object x, int targetSqlType) throws SQLException {
        if (this.isOracleStoredProcedure) {
            this.cStmt.setObject(parameterIndex + 1, x, targetSqlType);
        } else {
            this.cStmt.setObject(parameterIndex, x, targetSqlType);
        }
    }

    @Override
    public void setObject(int parameterIndex, Object x, int targetSqlType, int scale) throws SQLException {
        if (this.isOracleStoredProcedure) {
            this.cStmt.setObject(parameterIndex + 1, x, targetSqlType, scale);
        } else {
            this.cStmt.setObject(parameterIndex, x, targetSqlType, scale);
        }
    }

    @Override
    public void setRef(int i, Ref x) throws SQLException {
        this.cStmt.setRef(i, x);
    }

    @Override
    public void setShort(int parameterIndex, short x) throws SQLException {
        this.cStmt.setShort(parameterIndex, x);
    }

    @Override
    public void setString(int parameterIndex, String x) throws SQLException {
        this.cStmt.setString(parameterIndex, x);
    }

    @Override
    public void setTime(int parameterIndex, Time x) throws SQLException {
        this.cStmt.setTime(parameterIndex, x);
    }

    @Override
    public void setTime(int parameterIndex, Time x, Calendar cal) throws SQLException {
        this.cStmt.setTime(parameterIndex, x, cal);
    }

    @Override
    public void setTimestamp(int parameterIndex, Timestamp x) throws SQLException {
        this.cStmt.setTimestamp(parameterIndex, x);
    }

    @Override
    public void setTimestamp(int parameterIndex, Timestamp x, Calendar cal) throws SQLException {
        this.cStmt.setTimestamp(parameterIndex, x, cal);
    }

    @Override
    public void setURL(int parameterIndex, URL x) throws SQLException {
        this.cStmt.setURL(parameterIndex, x);
    }

    @Override
    public void setUnicodeStream(int parameterIndex, InputStream x, int length) throws SQLException {
        this.cStmt.setUnicodeStream(parameterIndex, x, length);
    }

    @Override
    public void addBatch(String sql) throws SQLException {
        this.cStmt.addBatch(sql);
    }

    @Override
    public void cancel() throws SQLException {
        this.cStmt.cancel();
    }

    @Override
    public void clearBatch() throws SQLException {
        this.cStmt.clearBatch();
    }

    @Override
    public void clearWarnings() throws SQLException {
        this.cStmt.clearWarnings();
    }

    @Override
    public void close() throws SQLException {
        this.cStmt.close();
    }

    @Override
    public boolean execute(String sql) throws SQLException {
        return this.cStmt.execute(sql);
    }

    @Override
    public boolean execute(String sql, int autoGeneratedKeys) throws SQLException {
        return this.cStmt.execute(sql, autoGeneratedKeys);
    }

    @Override
    public boolean execute(String sql, int[] columnIndexes) throws SQLException {
        return this.cStmt.execute(sql, columnIndexes);
    }

    @Override
    public boolean execute(String sql, String[] columnNames) throws SQLException {
        return this.cStmt.execute(sql, columnNames);
    }

    @Override
    public int[] executeBatch() throws SQLException {
        return this.cStmt.executeBatch();
    }

    @Override
    public ResultSet executeQuery(String sql) throws SQLException {
        return this.cStmt.executeQuery(sql);
    }

    @Override
    public int executeUpdate(String sql) throws SQLException {
        return this.cStmt.executeUpdate(sql);
    }

    @Override
    public int executeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
        return this.cStmt.executeUpdate(sql, autoGeneratedKeys);
    }

    @Override
    public int executeUpdate(String sql, int[] columnIndexes) throws SQLException {
        return this.cStmt.executeUpdate(sql, columnIndexes);
    }

    @Override
    public int executeUpdate(String sql, String[] columnNames) throws SQLException {
        return this.cStmt.executeUpdate(sql, columnNames);
    }

    @Override
    public Connection getConnection() throws SQLException {
        return this.cStmt.getConnection();
    }

    @Override
    public int getFetchDirection() throws SQLException {
        return this.cStmt.getFetchDirection();
    }

    @Override
    public int getFetchSize() throws SQLException {
        return this.cStmt.getFetchSize();
    }

    @Override
    public ResultSet getGeneratedKeys() throws SQLException {
        return this.cStmt.getGeneratedKeys();
    }

    @Override
    public int getMaxFieldSize() throws SQLException {
        return this.cStmt.getMaxFieldSize();
    }

    @Override
    public int getMaxRows() throws SQLException {
        return this.cStmt.getMaxRows();
    }

    @Override
    public boolean getMoreResults() throws SQLException {
        return this.cStmt.getMoreResults();
    }

    @Override
    public boolean getMoreResults(int current) throws SQLException {
        return this.cStmt.getMoreResults(current);
    }

    @Override
    public int getQueryTimeout() throws SQLException {
        return this.cStmt.getQueryTimeout();
    }

    @Override
    public ResultSet getResultSet() throws SQLException {
        ResultSet rs = this.isOracleStoredProcedure ? (ResultSet)this.cStmt.getObject(1) : this.cStmt.getResultSet();
        return rs;
    }

    @Override
    public int getResultSetConcurrency() throws SQLException {
        return this.cStmt.getResultSetConcurrency();
    }

    @Override
    public int getResultSetHoldability() throws SQLException {
        return this.cStmt.getResultSetHoldability();
    }

    @Override
    public int getResultSetType() throws SQLException {
        return this.cStmt.getResultSetType();
    }

    @Override
    public int getUpdateCount() throws SQLException {
        return this.cStmt.getUpdateCount();
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        return this.cStmt.getWarnings();
    }

    @Override
    public void setCursorName(String name) throws SQLException {
        this.cStmt.setCursorName(name);
    }

    @Override
    public void setEscapeProcessing(boolean enable) throws SQLException {
        this.cStmt.setEscapeProcessing(enable);
    }

    @Override
    public void setFetchDirection(int direction) throws SQLException {
        this.cStmt.setFetchDirection(direction);
    }

    @Override
    public void setFetchSize(int rows) throws SQLException {
        this.cStmt.setFetchSize(rows);
    }

    @Override
    public void setMaxFieldSize(int max) throws SQLException {
        this.cStmt.setMaxFieldSize(max);
    }

    @Override
    public void setMaxRows(int max) throws SQLException {
        this.cStmt.setMaxRows(max);
    }

    @Override
    public void setQueryTimeout(int seconds) throws SQLException {
        this.cStmt.setQueryTimeout(seconds);
    }

    @Override
    public Reader getCharacterStream(int parameterIndex) throws SQLException {
        return this.cStmt.getCharacterStream(parameterIndex);
    }

    @Override
    public Reader getCharacterStream(String parameterName) throws SQLException {
        return this.cStmt.getCharacterStream(parameterName);
    }

    @Override
    public Reader getNCharacterStream(int parameterIndex) throws SQLException {
        return this.cStmt.getNCharacterStream(parameterIndex);
    }

    @Override
    public Reader getNCharacterStream(String parameterName) throws SQLException {
        return this.cStmt.getNCharacterStream(parameterName);
    }

    @Override
    public NClob getNClob(int parameterIndex) throws SQLException {
        return this.cStmt.getNClob(parameterIndex);
    }

    @Override
    public NClob getNClob(String parameterName) throws SQLException {
        return this.cStmt.getNClob(parameterName);
    }

    @Override
    public String getNString(int parameterIndex) throws SQLException {
        return this.cStmt.getNString(parameterIndex);
    }

    @Override
    public String getNString(String parameterName) throws SQLException {
        return this.cStmt.getNString(parameterName);
    }

    @Override
    public RowId getRowId(int parameterIndex) throws SQLException {
        return this.cStmt.getRowId(parameterIndex);
    }

    @Override
    public RowId getRowId(String parameterName) throws SQLException {
        return this.cStmt.getRowId(parameterName);
    }

    @Override
    public SQLXML getSQLXML(int parameterIndex) throws SQLException {
        return this.cStmt.getSQLXML(parameterIndex);
    }

    @Override
    public SQLXML getSQLXML(String parameterName) throws SQLException {
        return this.cStmt.getSQLXML(parameterName);
    }

    @Override
    public boolean isClosed() throws SQLException {
        return this.cStmt.isClosed();
    }

    @Override
    public boolean isPoolable() throws SQLException {
        return this.cStmt.isPoolable();
    }

    @Override
    public void closeOnCompletion() throws SQLException {
        this.cStmt.closeOnCompletion();
    }

    @Override
    public boolean isCloseOnCompletion() throws SQLException {
        return this.cStmt.isCloseOnCompletion();
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return this.cStmt.isWrapperFor(iface);
    }

    @Override
    public void setAsciiStream(int parameterIndex, InputStream x, long length) throws SQLException {
        this.cStmt.setAsciiStream(parameterIndex, x, length);
    }

    @Override
    public void setAsciiStream(int parameterIndex, InputStream x) throws SQLException {
        this.cStmt.setAsciiStream(parameterIndex, x);
    }

    @Override
    public void setAsciiStream(String parameterName, InputStream x, long length) throws SQLException {
        this.cStmt.setAsciiStream(parameterName, x, length);
    }

    @Override
    public void setAsciiStream(String parameterName, InputStream x) throws SQLException {
        this.cStmt.setAsciiStream(parameterName, x);
    }

    @Override
    public void setBinaryStream(int parameterIndex, InputStream x, long length) throws SQLException {
        this.cStmt.setBinaryStream(parameterIndex, x, length);
    }

    @Override
    public void setBinaryStream(int parameterIndex, InputStream x) throws SQLException {
        this.cStmt.setBinaryStream(parameterIndex, x);
    }

    @Override
    public void setBinaryStream(String parameterName, InputStream x, long length) throws SQLException {
        this.cStmt.setBinaryStream(parameterName, x, length);
    }

    @Override
    public void setBinaryStream(String parameterName, InputStream x) throws SQLException {
        this.cStmt.setBinaryStream(parameterName, x);
    }

    @Override
    public void setBlob(int parameterIndex, InputStream inputStream, long length) throws SQLException {
        this.cStmt.setBlob(parameterIndex, inputStream, length);
    }

    @Override
    public void setBlob(int parameterIndex, InputStream inputStream) throws SQLException {
        this.cStmt.setBlob(parameterIndex, inputStream);
    }

    @Override
    public void setBlob(String parameterName, Blob x) throws SQLException {
        this.cStmt.setBlob(parameterName, x);
    }

    @Override
    public void setBlob(String parameterName, InputStream inputStream, long length) throws SQLException {
        this.cStmt.setBlob(parameterName, inputStream, length);
    }

    @Override
    public void setBlob(String parameterName, InputStream inputStream) throws SQLException {
        this.cStmt.setBlob(parameterName, inputStream);
    }

    @Override
    public void setCharacterStream(int parameterIndex, Reader reader, long length) throws SQLException {
        this.cStmt.setCharacterStream(parameterIndex, reader, length);
    }

    @Override
    public void setCharacterStream(int parameterIndex, Reader reader) throws SQLException {
        this.cStmt.setCharacterStream(parameterIndex, reader);
    }

    @Override
    public void setCharacterStream(String parameterName, Reader reader, long length) throws SQLException {
        this.cStmt.setCharacterStream(parameterName, reader, length);
    }

    @Override
    public void setCharacterStream(String parameterName, Reader reader) throws SQLException {
        this.cStmt.setCharacterStream(parameterName, reader);
    }

    @Override
    public void setClob(int parameterIndex, Reader reader, long length) throws SQLException {
        this.cStmt.setClob(parameterIndex, reader, length);
    }

    @Override
    public void setClob(int parameterIndex, Reader reader) throws SQLException {
        this.cStmt.setClob(parameterIndex, reader);
    }

    @Override
    public void setClob(String parameterName, Clob x) throws SQLException {
        this.cStmt.setClob(parameterName, x);
    }

    @Override
    public void setClob(String parameterName, Reader reader, long length) throws SQLException {
        this.cStmt.setClob(parameterName, reader, length);
    }

    @Override
    public void setClob(String parameterName, Reader reader) throws SQLException {
        this.cStmt.setClob(parameterName, reader);
    }

    @Override
    public void setNCharacterStream(int parameterIndex, Reader value, long length) throws SQLException {
        this.cStmt.setNCharacterStream(parameterIndex, value, length);
    }

    @Override
    public void setNCharacterStream(int parameterIndex, Reader value) throws SQLException {
        this.cStmt.setNCharacterStream(parameterIndex, value);
    }

    @Override
    public void setNCharacterStream(String parameterName, Reader value, long length) throws SQLException {
        this.cStmt.setNCharacterStream(parameterName, value, length);
    }

    @Override
    public void setNCharacterStream(String parameterName, Reader value) throws SQLException {
        this.cStmt.setNCharacterStream(parameterName, value);
    }

    @Override
    public void setNClob(int parameterIndex, NClob value) throws SQLException {
        this.cStmt.setNClob(parameterIndex, value);
    }

    @Override
    public void setNClob(int parameterIndex, Reader reader, long length) throws SQLException {
        this.cStmt.setNClob(parameterIndex, reader, length);
    }

    @Override
    public void setNClob(int parameterIndex, Reader reader) throws SQLException {
        this.cStmt.setNClob(parameterIndex, reader);
    }

    @Override
    public void setNClob(String parameterName, NClob value) throws SQLException {
        this.cStmt.setNClob(parameterName, value);
    }

    @Override
    public void setNClob(String parameterName, Reader reader, long length) throws SQLException {
        this.cStmt.setNClob(parameterName, reader, length);
    }

    @Override
    public void setNClob(String parameterName, Reader reader) throws SQLException {
        this.cStmt.setNClob(parameterName, reader);
    }

    @Override
    public <T> T getObject(int parameterIndex, Class<T> type) throws SQLException {
        return this.cStmt.getObject(parameterIndex, type);
    }

    @Override
    public <T> T getObject(String parameterName, Class<T> type) throws SQLException {
        return this.cStmt.getObject(parameterName, type);
    }

    @Override
    public void setNString(int parameterIndex, String value) throws SQLException {
        this.cStmt.setNString(parameterIndex, value);
    }

    @Override
    public void setNString(String parameterName, String value) throws SQLException {
        this.cStmt.setNString(parameterName, value);
    }

    @Override
    public void setPoolable(boolean poolable) throws SQLException {
        this.cStmt.setPoolable(poolable);
    }

    @Override
    public void setRowId(int parameterIndex, RowId x) throws SQLException {
        this.cStmt.setRowId(parameterIndex, x);
    }

    @Override
    public void setRowId(String parameterName, RowId x) throws SQLException {
        this.cStmt.setRowId(parameterName, x);
    }

    @Override
    public void setSQLXML(int parameterIndex, SQLXML xmlObject) throws SQLException {
        this.cStmt.setSQLXML(parameterIndex, xmlObject);
    }

    @Override
    public void setSQLXML(String parameterName, SQLXML xmlObject) throws SQLException {
        this.cStmt.setSQLXML(parameterName, xmlObject);
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        return this.cStmt.unwrap(iface);
    }
}

