/*
 * Decompiled with CFR 0.152.
 */
package quadbase.common.util.internal;

import java.sql.Time;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Vector;

public class QbDateFormat {
    Vector originalDate = null;
    private static String defaultDateTimeFormat = "yyyy-MM-dd hh:mm:ss";
    private static String defaultDateFormat = "yyyy-MM-dd";
    private static String defaultTimeFormat = "hh:mm:ss";
    public static final String sqlDefaultDateTimeFormat = "yyyy-MM-dd HH:mm:ss.SSS";
    public static final String sqlDefaultTimeFormat = "HH:mm:ss";
    public static final String sqlDefaultDateFormat = "yyyy-MM-dd";
    public static final int DATE = 1;
    public static final int DATETIME = 2;
    public static final int TIME = 3;

    public QbDateFormat() {
        this.originalDate = null;
    }

    public QbDateFormat(Object[] datetime) {
        this.originalDate = new Vector();
        for (Object element : datetime) {
            this.originalDate.add(element);
        }
    }

    public QbDateFormat(Vector datetime) {
        this.originalDate = datetime;
    }

    public Vector getFormattedDate(int type, String skipValue) throws Exception {
        if (type == 1 || type == 91) {
            return this.getFormattedDate(defaultDateFormat, skipValue);
        }
        if (type == 2 || type == 93) {
            return this.getFormattedDate(defaultDateTimeFormat, skipValue);
        }
        if (type == 3 || type == 92) {
            return this.getFormattedDate(defaultTimeFormat, skipValue);
        }
        return this.originalDate;
    }

    public Vector getFormattedDate(String dateFormat, String skipValue) throws Exception {
        if (this.originalDate == null) {
            return null;
        }
        Vector result = new Vector();
        for (int i = 0; i < this.originalDate.size(); ++i) {
            SimpleDateFormat format = new SimpleDateFormat(dateFormat);
            Object elem = this.originalDate.get(i);
            if (skipValue != null && skipValue.equals(elem)) {
                result.add(elem);
                continue;
            }
            if (elem instanceof Date) {
                result.add(format.format(elem));
                continue;
            }
            result.add(format.format(new Date(format.parse(elem.toString()).getTime())));
        }
        return result;
    }

    public Vector getFormattedDate(short type, String dateFormat) throws Exception {
        if (this.originalDate == null) {
            return null;
        }
        Vector<String> result = new Vector<String>();
        for (int i = 0; i < this.originalDate.size(); ++i) {
            SimpleDateFormat origFormat;
            SimpleDateFormat format = new SimpleDateFormat(dateFormat);
            Object elem = this.originalDate.get(i);
            if (elem instanceof Date) {
                result.add(format.format(elem));
                continue;
            }
            if (type == 91) {
                origFormat = new SimpleDateFormat(sqlDefaultDateFormat);
                result.add(format.format(new java.sql.Date(origFormat.parse(elem.toString()).getTime())));
                continue;
            }
            if (type == 93) {
                origFormat = new SimpleDateFormat(sqlDefaultDateTimeFormat);
                result.add(format.format(new Timestamp(origFormat.parse(elem.toString()).getTime())));
                continue;
            }
            if (type != 92) continue;
            origFormat = new SimpleDateFormat(sqlDefaultTimeFormat);
            result.add(format.format(new Time(origFormat.parse(elem.toString()).getTime())));
        }
        return result;
    }

    public Object getOriginalDateAt(int i) {
        return this.originalDate.get(i);
    }

    public Vector getOriginalDateVect() {
        return this.originalDate;
    }

    public static synchronized String getFormattedDateTime(Date datetime) {
        return QbDateFormat.getFormattedDateTime(datetime, defaultDateTimeFormat);
    }

    public static synchronized String getFormattedDateTime(Date datetime, String dateFormat) {
        SimpleDateFormat format = new SimpleDateFormat(dateFormat);
        return format.format(datetime);
    }

    public static String getDefaultTimestampFormat() {
        return defaultDateTimeFormat;
    }

    public static void setDefaultTimestampFormat(String defaultDateTimeFormat) {
        QbDateFormat.defaultDateTimeFormat = defaultDateTimeFormat;
    }

    public static String getDefaultDateFormat() {
        return defaultDateFormat;
    }

    public static void setDefaultDateFormat(String defaultDateFormat) {
        QbDateFormat.defaultDateFormat = defaultDateFormat;
    }

    public static String getDefaultTimeFormat() {
        return defaultTimeFormat;
    }

    public static void setDefaultTimeFormat(String defaultTimeFormat) {
        QbDateFormat.defaultTimeFormat = defaultTimeFormat;
    }

    public static String checkDateFormat(String dateFormat) {
        String text = dateFormat;
        text = text.replaceAll("''", "");
        text = text.replaceAll("\\'[^\\']*'", "");
        for (int i = 0; i < text.length(); ++i) {
            char val = text.charAt(i);
            if (val == 'G' || val == 'y' || val == 'M' || val == 'w' || val == 'W' || val == 'D' || val == 'd' || val == 'F' || val == 'E' || val == 'a' || val == 'H' || val == 'k' || val == 'K' || val == 'h' || val == 'm' || val == 's' || val == 'S' || val == 'z' || val == 'Z' || val == '/' || val == '-' || val == ' ' || val == ',' || val == '.' || val == ':' || val == '_') continue;
            if (val == '\'') {
                return "Date format missing closing quote (')";
            }
            return val + " is invalid symbol for date format!";
        }
        return null;
    }
}

