/*
 * Decompiled with CFR 0.152.
 */
package quadbase.common.util.internal;

import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.Date;
import java.sql.NClob;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import quadbase.common.util.internal.QbConnection;

public class QbPreparedStatement
implements PreparedStatement {
    private PreparedStatement ps;
    private QbConnection qbc;
    private String sql;
    private Object[] vals;

    public QbPreparedStatement(PreparedStatement ps, QbConnection conn, String sql) {
        this.ps = ps;
        this.qbc = conn;
        this.sql = sql;
        this.qbc.setQueryTimeout(ps);
        int ct = 0;
        int index = 0;
        while (index < sql.length() && sql.indexOf("?", index) > -1) {
            if (sql.indexOf("?", index) <= -1) continue;
            ++ct;
            index = sql.indexOf("?", index) + 1;
        }
        this.vals = new Object[ct + 1];
    }

    @Override
    public void addBatch(String sql) throws SQLException {
        this.ps.addBatch(sql);
    }

    @Override
    public void cancel() throws SQLException {
        this.ps.cancel();
    }

    @Override
    public void clearBatch() throws SQLException {
        this.ps.clearBatch();
    }

    @Override
    public void clearWarnings() throws SQLException {
        this.ps.clearWarnings();
    }

    @Override
    public void close() throws SQLException {
        this.vals = null;
        this.ps.close();
    }

    @Override
    public boolean execute(String sql, int autoGeneratedKeys) throws SQLException {
        return this.ps.execute(sql, autoGeneratedKeys);
    }

    @Override
    public boolean execute(String sql, int[] columnIndexes) throws SQLException {
        return this.ps.execute(sql, columnIndexes);
    }

    @Override
    public boolean execute(String sql, String[] columnNames) throws SQLException {
        return this.ps.execute(sql, columnNames);
    }

    @Override
    public boolean execute(String sql) throws SQLException {
        return this.ps.execute(sql);
    }

    @Override
    public int[] executeBatch() throws SQLException {
        return this.ps.executeBatch();
    }

    @Override
    public ResultSet executeQuery(String sql) throws SQLException {
        return this.ps.executeQuery(sql);
    }

    @Override
    public int executeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
        return this.ps.executeUpdate(sql, autoGeneratedKeys);
    }

    @Override
    public int executeUpdate(String sql, int[] columnIndexes) throws SQLException {
        return this.ps.executeUpdate(sql, columnIndexes);
    }

    @Override
    public int executeUpdate(String sql, String[] columnNames) throws SQLException {
        return this.ps.executeUpdate(sql, columnNames);
    }

    @Override
    public int executeUpdate(String sql) throws SQLException {
        return this.ps.executeUpdate(sql);
    }

    @Override
    public Connection getConnection() throws SQLException {
        return this.ps.getConnection();
    }

    @Override
    public int getFetchDirection() throws SQLException {
        return this.ps.getFetchDirection();
    }

    @Override
    public int getFetchSize() throws SQLException {
        return this.ps.getFetchSize();
    }

    @Override
    public ResultSet getGeneratedKeys() throws SQLException {
        return this.ps.getGeneratedKeys();
    }

    @Override
    public int getMaxFieldSize() throws SQLException {
        return this.ps.getMaxFieldSize();
    }

    @Override
    public int getMaxRows() throws SQLException {
        return this.ps.getMaxRows();
    }

    @Override
    public boolean getMoreResults() throws SQLException {
        return this.ps.getMoreResults();
    }

    @Override
    public boolean getMoreResults(int current) throws SQLException {
        return this.ps.getMoreResults(current);
    }

    @Override
    public int getQueryTimeout() throws SQLException {
        return this.ps.getQueryTimeout();
    }

    @Override
    public ResultSet getResultSet() throws SQLException {
        return this.ps.getResultSet();
    }

    @Override
    public int getResultSetConcurrency() throws SQLException {
        return this.ps.getResultSetConcurrency();
    }

    @Override
    public int getResultSetHoldability() throws SQLException {
        return this.ps.getResultSetHoldability();
    }

    @Override
    public int getResultSetType() throws SQLException {
        return this.ps.getResultSetType();
    }

    @Override
    public int getUpdateCount() throws SQLException {
        return this.ps.getUpdateCount();
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        return this.ps.getWarnings();
    }

    @Override
    public void setCursorName(String name) throws SQLException {
        this.ps.setCursorName(name);
    }

    @Override
    public void setEscapeProcessing(boolean enable) throws SQLException {
        this.ps.setEscapeProcessing(enable);
    }

    @Override
    public void setFetchDirection(int direction) throws SQLException {
        this.ps.setFetchDirection(direction);
    }

    @Override
    public void setFetchSize(int rows) throws SQLException {
        this.ps.setFetchSize(rows);
    }

    @Override
    public void setMaxFieldSize(int max) throws SQLException {
        this.ps.setMaxFieldSize(max);
    }

    @Override
    public void setMaxRows(int max) throws SQLException {
        this.ps.setMaxRows(max);
    }

    @Override
    public void setQueryTimeout(int seconds) throws SQLException {
        this.ps.setQueryTimeout(seconds);
    }

    @Override
    public void addBatch() throws SQLException {
        this.ps.addBatch();
    }

    @Override
    public void clearParameters() throws SQLException {
        this.ps.clearParameters();
    }

    @Override
    public boolean execute() throws SQLException {
        try {
            return this.ps.execute();
        }
        catch (SQLException e) {
            this.debug("possible connection corruption, reconnecting");
            if (this.qbc.checkConnection()) {
                throw e;
            }
            try {
                try {
                    System.out.println("Connection Error in QbPreparedStatement with executeQuery... Allocating new connection");
                    this.qbc.setBadConnection();
                    this.qbc.allocateNewConnection();
                }
                catch (SQLException e_badConn) {
                    this.qbc.setBadConnection();
                    throw e_badConn;
                }
                catch (ClassNotFoundException ce) {
                    this.qbc.setBadConnection();
                }
                this.debug("recreating statement...");
                QbPreparedStatement qbps = (QbPreparedStatement)this.qbc.prepareStatement(this.sql);
                if (qbps == null) {
                    throw e;
                }
                this.ps = qbps.getPreparedStatement();
                this.setParams(this.ps);
                return this.ps.execute();
            }
            catch (SQLException e1) {
                DatabaseMetaData dbMeta = this.qbc.getMetaData();
                String product = dbMeta.getDatabaseProductName();
                if (product.toLowerCase().indexOf("postgresql") > -1) {
                    this.qbc.rollback();
                }
                throw e1;
            }
        }
    }

    @Override
    public ResultSet executeQuery() throws SQLException {
        this.debug("QBPS execute query on PreparedStatement");
        try {
            return this.ps.executeQuery();
        }
        catch (SQLException e) {
            this.debug("possible connection corruption, reconnecting");
            if (this.qbc.checkConnection()) {
                throw e;
            }
            try {
                try {
                    System.out.println("Connection Error in QbPreparedStatement with executeQuery... Allocating new connection");
                    this.qbc.setBadConnection();
                    this.qbc.allocateNewConnection();
                }
                catch (SQLException e_badConn) {
                    this.qbc.setBadConnection();
                    throw e_badConn;
                }
                catch (ClassNotFoundException ce) {
                    this.qbc.setBadConnection();
                }
                this.debug("recreating statement...");
                QbPreparedStatement qbps = (QbPreparedStatement)this.qbc.prepareStatement(this.sql);
                if (qbps == null) {
                    throw e;
                }
                this.ps = qbps.getPreparedStatement();
                this.setParams(this.ps);
                return this.ps.executeQuery();
            }
            catch (SQLException e1) {
                DatabaseMetaData dbMeta = this.qbc.getMetaData();
                String product = dbMeta.getDatabaseProductName();
                if (product.toLowerCase().indexOf("postgresql") > -1) {
                    this.qbc.rollback();
                }
                throw e1;
            }
        }
    }

    @Override
    public int executeUpdate() throws SQLException {
        this.debug("QBPS execute update on PreparedStatement");
        try {
            return this.ps.executeUpdate();
        }
        catch (SQLException e) {
            this.debug("possible connection corruption, reconnecting");
            if (this.qbc.checkConnection()) {
                throw e;
            }
            try {
                try {
                    System.out.println("Connection Error in QbPreparedStatement with executeQuery... Allocating new connection");
                    this.qbc.setBadConnection();
                    this.qbc.allocateNewConnection();
                }
                catch (SQLException e_badConn) {
                    this.qbc.setBadConnection();
                    throw e_badConn;
                }
                catch (ClassNotFoundException ce) {
                    this.qbc.setBadConnection();
                }
                this.debug("recreating statement...");
                QbPreparedStatement qbps = (QbPreparedStatement)this.qbc.prepareStatement(this.sql);
                if (qbps == null) {
                    throw e;
                }
                this.ps = qbps.getPreparedStatement();
                this.setParams(this.ps);
                return this.ps.executeUpdate();
            }
            catch (SQLException e1) {
                DatabaseMetaData dbMeta = this.qbc.getMetaData();
                String product = dbMeta.getDatabaseProductName();
                if (product.toLowerCase().indexOf("postgresql") > -1) {
                    this.qbc.rollback();
                }
                throw e1;
            }
        }
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        return this.ps.getMetaData();
    }

    @Override
    public ParameterMetaData getParameterMetaData() throws SQLException {
        return this.ps.getParameterMetaData();
    }

    @Override
    public void setArray(int i, Array x) throws SQLException {
        this.ps.setArray(i, x);
        this.vals[i] = x;
    }

    @Override
    public void setAsciiStream(int parameterIndex, InputStream x, int length) throws SQLException {
        this.ps.setAsciiStream(parameterIndex, x, length);
    }

    @Override
    public void setBigDecimal(int parameterIndex, BigDecimal x) throws SQLException {
        this.ps.setBigDecimal(parameterIndex, x);
        this.vals[parameterIndex] = x;
    }

    @Override
    public void setBinaryStream(int parameterIndex, InputStream x, int length) throws SQLException {
        this.ps.setBinaryStream(parameterIndex, x, length);
    }

    @Override
    public void setBlob(int i, Blob x) throws SQLException {
        this.ps.setBlob(i, x);
        this.vals[i] = x;
    }

    @Override
    public void setBoolean(int parameterIndex, boolean x) throws SQLException {
        this.ps.setBoolean(parameterIndex, x);
        this.vals[parameterIndex] = x;
    }

    @Override
    public void setByte(int parameterIndex, byte x) throws SQLException {
        this.ps.setByte(parameterIndex, x);
        this.vals[parameterIndex] = x;
    }

    @Override
    public void setBytes(int parameterIndex, byte[] x) throws SQLException {
        this.ps.setBytes(parameterIndex, x);
        this.vals[parameterIndex] = x;
    }

    @Override
    public void setCharacterStream(int parameterIndex, Reader reader, int length) throws SQLException {
        this.ps.setCharacterStream(parameterIndex, reader, length);
    }

    @Override
    public void setClob(int i, Clob x) throws SQLException {
        this.ps.setClob(i, x);
        this.vals[i] = x;
    }

    @Override
    public void setDate(int parameterIndex, Date x, Calendar cal) throws SQLException {
        this.ps.setDate(parameterIndex, x, cal);
        this.vals[parameterIndex] = x;
    }

    @Override
    public void setDate(int parameterIndex, Date x) throws SQLException {
        this.ps.setDate(parameterIndex, x);
        this.vals[parameterIndex] = x;
    }

    @Override
    public void setDouble(int parameterIndex, double x) throws SQLException {
        this.ps.setDouble(parameterIndex, x);
        this.vals[parameterIndex] = x;
    }

    @Override
    public void setFloat(int parameterIndex, float x) throws SQLException {
        this.ps.setFloat(parameterIndex, x);
        this.vals[parameterIndex] = Float.valueOf(x);
    }

    @Override
    public void setInt(int parameterIndex, int x) throws SQLException {
        this.ps.setInt(parameterIndex, x);
        this.vals[parameterIndex] = x;
    }

    @Override
    public void setLong(int parameterIndex, long x) throws SQLException {
        this.ps.setLong(parameterIndex, x);
        this.vals[parameterIndex] = x;
    }

    @Override
    public void setNull(int paramIndex, int sqlType, String typeName) throws SQLException {
        this.ps.setNull(paramIndex, sqlType, typeName);
        this.vals[paramIndex] = new Object[]{null, sqlType};
    }

    @Override
    public void setNull(int parameterIndex, int sqlType) throws SQLException {
        this.ps.setNull(parameterIndex, sqlType);
        this.vals[parameterIndex] = new Object[]{null, sqlType};
    }

    @Override
    public void setObject(int parameterIndex, Object x, int targetSqlType, int scale) throws SQLException {
        this.ps.setObject(parameterIndex, x, targetSqlType, scale);
        this.vals[parameterIndex] = new Object[]{x, targetSqlType};
    }

    @Override
    public void setObject(int parameterIndex, Object x, int targetSqlType) throws SQLException {
        this.ps.setObject(parameterIndex, x, targetSqlType);
        this.vals[parameterIndex] = new Object[]{x, targetSqlType};
    }

    @Override
    public void setObject(int parameterIndex, Object x) throws SQLException {
        this.ps.setObject(parameterIndex, x);
        this.vals[parameterIndex] = x;
    }

    @Override
    public void setRef(int i, Ref x) throws SQLException {
        this.ps.setRef(i, x);
    }

    @Override
    public void setShort(int parameterIndex, short x) throws SQLException {
        this.ps.setShort(parameterIndex, x);
        this.vals[parameterIndex] = x;
    }

    @Override
    public void setString(int parameterIndex, String x) throws SQLException {
        this.ps.setString(parameterIndex, x);
        this.vals[parameterIndex] = x;
    }

    @Override
    public void setTime(int parameterIndex, Time x, Calendar cal) throws SQLException {
        this.ps.setTime(parameterIndex, x, cal);
        this.vals[parameterIndex] = x;
    }

    @Override
    public void setTime(int parameterIndex, Time x) throws SQLException {
        this.ps.setTime(parameterIndex, x);
        this.vals[parameterIndex] = x;
    }

    @Override
    public void setTimestamp(int parameterIndex, Timestamp x, Calendar cal) throws SQLException {
        this.ps.setTimestamp(parameterIndex, x, cal);
        this.vals[parameterIndex] = x;
    }

    @Override
    public void setTimestamp(int parameterIndex, Timestamp x) throws SQLException {
        this.ps.setTimestamp(parameterIndex, x);
        this.vals[parameterIndex] = x;
    }

    @Override
    public void setUnicodeStream(int parameterIndex, InputStream x, int length) throws SQLException {
        this.ps.setUnicodeStream(parameterIndex, x, length);
    }

    @Override
    public void setURL(int parameterIndex, URL x) throws SQLException {
        this.ps.setURL(parameterIndex, x);
        this.vals[parameterIndex] = x;
    }

    public PreparedStatement getPreparedStatement() {
        return this.ps;
    }

    private void setParams(PreparedStatement ps) throws SQLException {
        for (int i = 1; i < this.vals.length; ++i) {
            if (this.vals[i] == null) continue;
            if (this.vals[i] instanceof Object[] && !(this.vals[i] instanceof byte[])) {
                Object[] val_i = (Object[])this.vals[i];
                if (val_i[0] == null) {
                    ps.setNull(i, (Integer)val_i[1]);
                    continue;
                }
                ps.setObject(i, val_i[0], (Integer)val_i[1]);
                continue;
            }
            if (this.vals[i] instanceof Array) {
                ps.setArray(i, (Array)this.vals[i]);
                continue;
            }
            if (this.vals[i] instanceof BigDecimal) {
                ps.setBigDecimal(i, (BigDecimal)this.vals[i]);
                continue;
            }
            if (this.vals[i] instanceof Blob) {
                ps.setBlob(i, (Blob)this.vals[i]);
                continue;
            }
            if (this.vals[i] instanceof Boolean) {
                ps.setBoolean(i, (Boolean)this.vals[i]);
                continue;
            }
            if (this.vals[i] instanceof Byte) {
                ps.setByte(i, (Byte)this.vals[i]);
                continue;
            }
            if (this.vals[i] instanceof byte[]) {
                ps.setBytes(i, (byte[])this.vals[i]);
                continue;
            }
            if (this.vals[i] instanceof Clob) {
                ps.setClob(i, (Clob)this.vals[i]);
                continue;
            }
            if (this.vals[i] instanceof Date) {
                ps.setDate(i, (Date)this.vals[i]);
                continue;
            }
            if (this.vals[i] instanceof Double) {
                ps.setDouble(i, (Double)this.vals[i]);
                continue;
            }
            if (this.vals[i] instanceof Float) {
                ps.setFloat(i, ((Float)this.vals[i]).floatValue());
                continue;
            }
            if (this.vals[i] instanceof Integer) {
                ps.setInt(i, (Integer)this.vals[i]);
                continue;
            }
            if (this.vals[i] instanceof Long) {
                ps.setLong(i, (Long)this.vals[i]);
                continue;
            }
            if (this.vals[i] instanceof Object) {
                ps.setObject(i, this.vals[i]);
                continue;
            }
            if (this.vals[i] instanceof Short) {
                ps.setShort(i, (Short)this.vals[i]);
                continue;
            }
            if (this.vals[i] instanceof String) {
                ps.setString(i, (String)this.vals[i]);
                continue;
            }
            if (this.vals[i] instanceof Time) {
                ps.setTime(i, (Time)this.vals[i]);
                continue;
            }
            if (this.vals[i] instanceof Timestamp) {
                ps.setTimestamp(i, (Timestamp)this.vals[i]);
                continue;
            }
            if (!(this.vals[i] instanceof URL)) continue;
            ps.setURL(i, (URL)this.vals[i]);
        }
    }

    void debug(String m) {
        if (QbConnection.debug) {
            System.out.println(m);
        }
    }

    @Override
    public boolean isClosed() throws SQLException {
        return this.ps.isClosed();
    }

    @Override
    public boolean isPoolable() throws SQLException {
        return this.ps.isPoolable();
    }

    @Override
    public void closeOnCompletion() throws SQLException {
        this.ps.closeOnCompletion();
    }

    @Override
    public boolean isCloseOnCompletion() throws SQLException {
        return this.ps.isCloseOnCompletion();
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return this.ps.isWrapperFor(iface);
    }

    @Override
    public void setAsciiStream(int parameterIndex, InputStream x, long length) throws SQLException {
        this.ps.setAsciiStream(parameterIndex, x, length);
    }

    @Override
    public void setAsciiStream(int parameterIndex, InputStream x) throws SQLException {
        this.ps.setAsciiStream(parameterIndex, x);
    }

    @Override
    public void setBinaryStream(int parameterIndex, InputStream x, long length) throws SQLException {
        this.ps.setBinaryStream(parameterIndex, x, length);
    }

    @Override
    public void setBinaryStream(int parameterIndex, InputStream x) throws SQLException {
        this.ps.setBinaryStream(parameterIndex, x);
    }

    @Override
    public void setBlob(int parameterIndex, InputStream inputStream, long length) throws SQLException {
        this.ps.setBlob(parameterIndex, inputStream, length);
    }

    @Override
    public void setBlob(int parameterIndex, InputStream inputStream) throws SQLException {
        this.ps.setBlob(parameterIndex, inputStream);
    }

    @Override
    public void setCharacterStream(int parameterIndex, Reader reader, long length) throws SQLException {
        this.ps.setCharacterStream(parameterIndex, reader, length);
    }

    @Override
    public void setCharacterStream(int parameterIndex, Reader reader) throws SQLException {
        this.ps.setCharacterStream(parameterIndex, reader);
    }

    @Override
    public void setClob(int parameterIndex, Reader reader, long length) throws SQLException {
        this.ps.setClob(parameterIndex, reader, length);
    }

    @Override
    public void setClob(int parameterIndex, Reader reader) throws SQLException {
        this.ps.setClob(parameterIndex, reader);
    }

    @Override
    public void setNCharacterStream(int parameterIndex, Reader value, long length) throws SQLException {
        this.ps.setNCharacterStream(parameterIndex, value, length);
    }

    @Override
    public void setNCharacterStream(int parameterIndex, Reader value) throws SQLException {
        this.ps.setNCharacterStream(parameterIndex, value);
    }

    @Override
    public void setNClob(int parameterIndex, NClob value) throws SQLException {
        this.ps.setNClob(parameterIndex, value);
    }

    @Override
    public void setNClob(int parameterIndex, Reader reader, long length) throws SQLException {
        this.ps.setNClob(parameterIndex, reader, length);
    }

    @Override
    public void setNClob(int parameterIndex, Reader reader) throws SQLException {
        this.ps.setNClob(parameterIndex, reader);
    }

    @Override
    public void setNString(int parameterIndex, String value) throws SQLException {
        this.ps.setNString(parameterIndex, value);
    }

    @Override
    public void setPoolable(boolean poolable) throws SQLException {
        this.ps.setPoolable(poolable);
    }

    @Override
    public void setRowId(int parameterIndex, RowId x) throws SQLException {
        this.ps.setRowId(parameterIndex, x);
    }

    @Override
    public void setSQLXML(int parameterIndex, SQLXML xmlObject) throws SQLException {
        this.ps.setSQLXML(parameterIndex, xmlObject);
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        return this.ps.unwrap(iface);
    }
}

