/*
 * Decompiled with CFR 0.152.
 */
package quadbase.common.util.internal;

import java.applet.Applet;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import quadbase.common.client.ServerMessage;
import quadbase.common.network.IConnection;
import quadbase.common.pak.PakFile;
import quadbase.common.util.internal.HttpsIO;
import quadbase.common.util.internal.IOUtil;

public class ReadDataFile {
    InputStream inputstream;

    public DataInputStream getInputStream(String filename) throws Exception {
        return this.getInputStream(filename, false);
    }

    public DataInputStream getInputStream(String filename, boolean isPageViewer) throws Exception {
        return this.getInputStream(filename, isPageViewer, false);
    }

    public DataInputStream getInputStream(String filename, boolean isPageViewer, boolean readOnly) throws Exception {
        DataInputStream din;
        block17: {
            Applet applet = ServerMessage.getApplet();
            String urlfile = filename;
            filename = filename.replace('\\', '/');
            din = null;
            try {
                if (filename.startsWith("http://") || filename.startsWith("file://")) {
                    try {
                        this.inputstream = new URL(urlfile).openConnection().getInputStream();
                        din = new DataInputStream(this.inputstream);
                        break block17;
                    }
                    catch (Exception ex) {
                        return ReadDataFile.getFromServer(filename, isPageViewer, readOnly);
                    }
                }
                if (filename.toLowerCase().startsWith("https")) {
                    try {
                        din = new DataInputStream(HttpsIO.getHttpsInputStream(filename));
                        break block17;
                    }
                    catch (Exception ex) {
                        return ReadDataFile.getFromServer(filename, isPageViewer, readOnly);
                    }
                }
                if (filename.toLowerCase().startsWith("zip:")) {
                    PakFile pakFile = new PakFile(filename);
                    this.inputstream = pakFile.getInputStream();
                    din = new DataInputStream(this.inputstream);
                    break block17;
                }
                if (!ServerMessage.useServer && ServerMessage.isLoadBalancer) {
                    if (!filename.startsWith("/") && filename.indexOf(58) < 0) {
                        if (applet != null) {
                            this.inputstream = new URL(IOUtil.getCodeBase(applet) + filename).openStream();
                            din = new DataInputStream(this.inputstream);
                        } else {
                            this.inputstream = IOUtil.createFileInputStream(filename);
                            din = new DataInputStream(this.inputstream);
                        }
                    } else {
                        this.inputstream = new FileInputStream(filename);
                        din = new DataInputStream(this.inputstream);
                    }
                    break block17;
                }
                return ReadDataFile.getFromServer(filename, isPageViewer, readOnly);
            }
            catch (Exception ex) {
                if (this.inputstream != null) {
                    try {
                        this.inputstream.close();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                throw ex;
            }
        }
        return din;
    }

    public void close() throws Exception {
        if (this.inputstream != null) {
            this.inputstream.close();
        }
    }

    static DataInputStream getFromServer(String file) throws Exception {
        return ReadDataFile.getFromServer(file, false);
    }

    static DataInputStream getFromServer(String file, boolean isPageViewer) throws Exception {
        return ReadDataFile.getFromServer(file, isPageViewer, false);
    }

    static DataInputStream getFromServer(String file, boolean isPageViewer, boolean readOnly) throws Exception {
        byte[] indata;
        file = file.replace('\\', '/');
        IConnection socket = ServerMessage.createConnection();
        ByteArrayOutputStream bstream = new ByteArrayOutputStream(50);
        DataOutputStream dout = new DataOutputStream(bstream);
        int slaveType = 20876;
        if (isPageViewer) {
            slaveType = 20877;
        }
        dout.writeShort(slaveType);
        if (slaveType == 20876) {
            dout.writeBoolean(false);
        }
        IOUtil.writeString(dout, file);
        try {
            byte[] array = bstream.toByteArray();
            socket.setContentLength(array.length);
            socket.getOutputStream().write(array);
            socket.getOutputStream().flush();
        }
        catch (Exception ex) {
            socket.close();
            throw ex;
        }
        try {
            DataInputStream dstream = new DataInputStream(socket.getInputStream());
            int code = dstream.readInt();
            if (code != 0) {
                throw new IOException(IOUtil.getErrorString(code) + IOUtil.readString(dstream, true));
            }
            int len = dstream.readInt();
            indata = new byte[len];
            dstream.readFully(indata, 0, len);
            dstream.close();
            socket.close();
            try {
                if (readOnly) {
                    IOUtil.releaseFileLock(file);
                }
            }
            catch (Exception exception) {}
        }
        catch (Exception ex) {
            try {
                socket.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw ex;
        }
        catch (Error err) {
            try {
                socket.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw new Exception(err.getMessage());
        }
        return new DataInputStream(new ByteArrayInputStream(indata));
    }
}

