/*
 * Decompiled with CFR 0.152.
 */
package quadbase.common.util.internal;

import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Hashtable;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import quadbase.common.client.FileInfo;
import quadbase.common.client.ServerMessage;
import quadbase.common.util.internal.LCKey;
import quadbase.common.util.internal.ReadDataFile;
import quadbase.common.util.internal.WriteDataFile;

public class RecentFiles {
    public static final int REPORT_TEMPLATE = 1;
    public static final int CHART_TEMPLATE = 2;
    public static final int STYLE_TEMPLATE = 3;
    private static final int LIMIT = 4;
    private static boolean init = false;
    private static Hashtable reportPaths = new Hashtable();
    private static Hashtable chartPaths = new Hashtable();
    private static String[] defaultReportPaths = new String[4];
    private static String[] defaultChartPaths = new String[4];
    private static String[] defaultStylePaths = new String[4];
    static String defaultFileName = "espressdefault.cfg";

    public static String[] getFilePaths(String user, int filetype) {
        RecentFiles.init(user);
        if (user == null) {
            if (filetype == 1) {
                return defaultReportPaths;
            }
            if (filetype == 2) {
                return defaultChartPaths;
            }
            if (filetype == 3) {
                return defaultStylePaths;
            }
            return null;
        }
        switch (filetype) {
            case 1: {
                return (String[])reportPaths.get(user);
            }
            case 2: {
                return (String[])chartPaths.get(user);
            }
        }
        return null;
    }

    public static void insertFilePath(String user, int filetype, String filepath) {
        if (filepath == null) {
            return;
        }
        filepath = filepath.replace('\\', '/');
        String[] filepaths = RecentFiles.getFilePaths(user, filetype);
        if (filepaths == null) {
            filepaths = new String[4];
            RecentFiles.setFilePaths(user, filetype, filepaths);
        }
        int i = filepaths.length - 1;
        for (int j = 0; j < filepaths.length; ++j) {
            if (filepaths[j] == null || filepath == null || !filepath.equals(filepaths[j])) continue;
            i = j;
            break;
        }
        while (i > 0) {
            filepaths[i] = filepaths[i - 1];
            --i;
        }
        filepaths[0] = filepath;
        try {
            RecentFiles.syncFilePaths(user, filetype, filepaths);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    static void init(String user) {
        if (!init) {
            try {
                if (user == null) {
                    RecentFiles.loadDefaultFilePaths();
                    init = true;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (user == null) {
            return;
        }
        try {
            if (reportPaths.get(user) == null) {
                RecentFiles.init(1, user);
            }
            if (chartPaths.get(user) == null) {
                RecentFiles.init(2, user);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    static void init(int filetype, String user) throws Exception {
        if (ServerMessage.isServlet() && !LCKey.isERES() && !LCKey.isDashboard()) {
            String path = ServerMessage.getPath("userdb/" + user + ".cfg");
            Pattern pattern = Pattern.compile("^(([a-zA-Z]:[\\\\\\/])|(/))(?:[a-zA-Z0-9])", 2);
            Matcher matcher = pattern.matcher(path);
            boolean isLocalPath = matcher.find();
            File file = new File(path);
            if (!file.exists() && isLocalPath) {
                file.createNewFile();
            }
        }
        InputStream in = null;
        if (ServerMessage.useServer || !ServerMessage.isLoadBalancer) {
            ReadDataFile readfile = new ReadDataFile();
            in = readfile.getInputStream("userdb/" + user + ".cfg");
        } else {
            in = new FileInputStream(new File(ServerMessage.getPath("userdb/" + user + ".cfg")));
        }
        Properties prop = new Properties();
        prop.load(in);
        switch (filetype) {
            case 1: {
                String[] strPaths = RecentFiles.toStringArr(prop.getProperty("REPORT_TEMPLATE"));
                reportPaths.put(user, strPaths);
                break;
            }
            case 2: {
                String[] strPaths = RecentFiles.toStringArr(prop.getProperty("CHART_TEMPLATE"));
                chartPaths.put(user, strPaths);
            }
        }
    }

    static void setFilePaths(String user, int filetype, String[] filepaths) {
        if (user == null) {
            if (filetype == 1) {
                defaultReportPaths = filepaths;
            } else if (filetype == 2) {
                defaultChartPaths = filepaths;
            } else if (filetype == 3) {
                defaultStylePaths = filepaths;
            }
            return;
        }
        switch (filetype) {
            case 1: {
                reportPaths.put(user, filepaths);
                break;
            }
            case 2: {
                chartPaths.put(user, filepaths);
            }
        }
    }

    static void syncFilePaths(String user, int filetype, String[] filepaths) throws IOException {
        if (!ServerMessage.useServer) {
            String filename = user == null ? defaultFileName : "userdb/" + user + ".cfg";
            try {
                RecentFiles.syncFilePathsLocal(new File(filename), filetype, filepaths);
            }
            catch (Exception e) {
                System.out.println("failed to write user preference file");
            }
        } else {
            try {
                RecentFiles.syncFilePathsServer(user, filetype, filepaths);
            }
            catch (Exception e) {
                System.out.println("failed to write user preference file");
            }
        }
    }

    static void syncFilePathsLocal(File cfg, int filetype, String[] filepaths) throws IOException {
        Properties prop = new Properties();
        if (cfg.exists()) {
            FileInputStream in = new FileInputStream(cfg);
            prop.load(in);
        }
        prop.setProperty(RecentFiles.toString(filetype), RecentFiles.toString(filepaths));
        FileOutputStream out = new FileOutputStream(cfg);
        prop.store(out, "espress user preferences");
    }

    static void syncFilePathsServer(String user, int filetype, String[] filepaths) throws Exception {
        ReadDataFile readfile = new ReadDataFile();
        DataInputStream in = readfile.getInputStream("userdb/" + user + ".cfg");
        Properties prop = new Properties();
        prop.load(in);
        prop.setProperty(RecentFiles.toString(filetype), RecentFiles.toString(filepaths));
        ByteArrayOutputStream data = new ByteArrayOutputStream();
        prop.store(data, "espress user preferences");
        WriteDataFile writefile = new WriteDataFile();
        writefile.output(data.toByteArray(), "userdb/" + user + ".cfg");
    }

    static void loadDefaultFilePaths() throws IOException {
        try {
            InputStream in = null;
            if (!new FileInfo(defaultFileName).exists()) {
                return;
            }
            if (ServerMessage.useServer || !ServerMessage.isLoadBalancer) {
                ReadDataFile readfile = new ReadDataFile();
                in = readfile.getInputStream(defaultFileName);
            } else {
                in = new FileInputStream(new File(defaultFileName));
            }
            Properties prop = new Properties();
            prop.load(in);
            defaultReportPaths = RecentFiles.toStringArr(prop.getProperty("REPORT_TEMPLATE"));
            defaultChartPaths = RecentFiles.toStringArr(prop.getProperty("CHART_TEMPLATE"));
            defaultStylePaths = RecentFiles.toStringArr(prop.getProperty("STYLE_TEMPLATE"));
        }
        catch (IOException ex1) {
            throw ex1;
        }
        catch (Exception ex) {
            throw new IOException(ex.toString());
        }
    }

    static String toString(int filetype) {
        switch (filetype) {
            case 1: {
                return "REPORT_TEMPLATE";
            }
            case 2: {
                return "CHART_TEMPLATE";
            }
            case 3: {
                return "STYLE_TEMPLATE";
            }
        }
        return "unknown_property";
    }

    static String toString(String[] list) {
        String result = "";
        for (String element : list) {
            result = result + "<" + element + ">";
        }
        return result;
    }

    static String[] toStringArr(String list) {
        int endIndex;
        String[] result = new String[4];
        if (list == null || list.length() == 0) {
            return result;
        }
        int startIndex = -1;
        int i = 0;
        while ((startIndex = list.indexOf(60)) != -1 && (endIndex = list.indexOf(62)) > startIndex) {
            result[i] = list.substring(startIndex + 1, endIndex);
            ++i;
            list = list.substring(endIndex + 1, list.length());
        }
        return result;
    }
}

