/*
 * Decompiled with CFR 0.152.
 */
package quadbase.common.util.internal;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.OutputStream;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import quadbase.chart.SOAPAccess;
import quadbase.common.client.MessageSender;
import quadbase.common.client.ServerMessage;
import quadbase.common.paramquery.SOAPQueryFileInfo;
import quadbase.common.util.dtd.DTDGenerator;
import quadbase.common.util.internal.IOUtil;
import quadbase.common.util.internal.SOAPUtilServerSide;
import quadbase.common.util.internal.soap.SimpleSOAPDefinition;

public class SOAPUtil {
    public static boolean containsEncodedXML(SOAPQueryFileInfo soapInfo) {
        try {
            InputStream xmlStream = SOAPAccess.getRawXMLStream(soapInfo);
            byte[] bytes = new byte[xmlStream.available()];
            xmlStream.read(bytes);
            String xml = new String(bytes);
            return xml.matches("(?s).*>([^<]*&lt;[^<]*&gt[^<]*)<.*");
        }
        catch (Exception e) {
            return false;
        }
    }

    public static InputStream processEncodedXML(InputStream xmlStream) throws IOException {
        byte[] bytes = new byte[xmlStream.available()];
        xmlStream.read(bytes);
        String xml = new String(bytes);
        Pattern pat = Pattern.compile("(?s).*>([^<]*&lt;[^<]*&gt[^<]*)<.*");
        Matcher matcher = pat.matcher(xml);
        if (matcher.find()) {
            xml = matcher.group(1);
            xml = xml.replaceAll("&lt;", "<");
            xml = xml.replaceAll("&gt;", ">");
            xml = xml.replaceAll("&quot;", "\"");
            xml = xml.replaceAll("encoding.*=.*\"[^\"]+\"", "encoding=\"utf-8\"");
        }
        return new ByteArrayInputStream(xml.getBytes("UTF-8"));
    }

    public static InputStream generateDTD(InputStream xmlStream) throws Exception {
        DTDGenerator gen = new DTDGenerator();
        gen.run(xmlStream);
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        gen.printDTD((OutputStream)os);
        return new ByteArrayInputStream(os.toByteArray());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SimpleSOAPDefinition parseWSDL(String uri) throws Exception {
        if (ServerMessage.useServer) {
            SimpleSOAPDefinition result;
            MessageSender ms = new MessageSender(25503);
            DataOutputStream dout = ms.getDataOutput();
            IOUtil.writeStr(dout, uri);
            DataInputStream dis = ms.sendAndReceive();
            ObjectInputStream ois = null;
            try {
                ois = new ObjectInputStream(dis);
                result = (SimpleSOAPDefinition)ois.readObject();
            }
            finally {
                if (ois != null) {
                    ois.close();
                }
                dis.close();
            }
            return result;
        }
        return SOAPUtilServerSide.parseWSDLLocal(uri);
    }
}

