/*
 * Decompiled with CFR 0.152.
 */
package quadbase.common.util.internal;

import java.io.ByteArrayOutputStream;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.wsdl.Binding;
import javax.wsdl.Definition;
import javax.wsdl.Operation;
import javax.wsdl.Port;
import javax.wsdl.PortType;
import javax.wsdl.Service;
import javax.wsdl.Types;
import javax.wsdl.extensions.ExtensibilityElement;
import javax.wsdl.extensions.schema.Schema;
import javax.wsdl.extensions.soap.SOAPAddress;
import javax.xml.namespace.QName;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.axis.wsdl.gen.Parser;
import org.apache.axis.wsdl.symbolTable.Parameter;
import org.apache.axis.wsdl.symbolTable.Parameters;
import org.apache.axis.wsdl.symbolTable.SymbolTable;
import org.apache.axis.wsdl.symbolTable.Type;
import org.apache.axis.wsdl.symbolTable.TypeEntry;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import quadbase.chart.SOAPAccess;
import quadbase.common.paramquery.SOAPParam;
import quadbase.common.paramquery.SOAPParamEnumeration;
import quadbase.common.util.internal.DataType;
import quadbase.common.util.internal.XMLUtil;
import quadbase.common.util.internal.soap.SimpleSOAPDefinition;
import quadbase.common.util.internal.soap.SimpleSOAPOperation;
import quadbase.common.util.internal.soap.SimpleSOAPPort;
import quadbase.common.util.internal.soap.SimpleSOAPService;

public class SOAPUtilServerSide {
    public static SimpleSOAPDefinition parseWSDLLocal(String uri) throws Exception {
        Parser parser = new Parser();
        parser.run(uri, SOAPAccess.getWSDLFromServer(uri));
        SymbolTable symbolTable = parser.getSymbolTable();
        Definition def = symbolTable.getDefinition();
        Map s = def.getServices();
        SimpleSOAPDefinition simpleDefinition = new SimpleSOAPDefinition();
        try {
            simpleDefinition.setSchema(SOAPUtilServerSide.getSchema(symbolTable));
        }
        catch (Exception exception) {
            // empty catch block
        }
        for (Map.Entry entry : s.entrySet()) {
            Service service = (Service)entry.getValue();
            Map ports = service.getPorts();
            if (ports == null || ports.isEmpty()) continue;
            SimpleSOAPService simpleService = new SimpleSOAPService((QName)entry.getKey());
            simpleService.setDocumentation(SOAPUtilServerSide.getDocumentation(service.getDocumentationElement()));
            for (Map.Entry entry2 : ports.entrySet()) {
                Port port = (Port)entry2.getValue();
                if (!SOAPUtilServerSide.isSoapPort(port)) continue;
                Binding binding = port.getBinding();
                PortType portType = binding.getPortType();
                List operations = portType.getOperations();
                SimpleSOAPPort simplePort = new SimpleSOAPPort(simpleService, entry2.getKey().toString());
                simplePort.setDocumentation(SOAPUtilServerSide.getDocumentation(port.getDocumentationElement()));
                for (Operation operation : operations) {
                    Parameters params;
                    if (operation.isUndefined() || SOAPUtilServerSide.hasComplexTypes(params = symbolTable.getBindingEntry(binding.getQName()).getParameters(operation)) || params.returnParam == null) continue;
                    SOAPParam[] soapParam = SOAPUtilServerSide.convertParams(symbolTable, params);
                    String returnParamName = params.returnParam.getName();
                    SimpleSOAPOperation simpleOperation = new SimpleSOAPOperation(simplePort, operation.getName(), soapParam, returnParamName);
                    simpleOperation.setDocumentation(SOAPUtilServerSide.getDocumentation(operation.getDocumentationElement()));
                    simplePort.addOperation(simpleOperation);
                    TypeEntry returnParamType = params.returnParam.getType();
                    if (returnParamType.isBaseType() || returnParamType.isSimpleType()) continue;
                    simpleDefinition.setSchema(null);
                }
                if (!simplePort.hasOperations()) continue;
                simpleService.addPort(simplePort);
            }
            if (!simpleService.hasPorts()) continue;
            simpleDefinition.addService(simpleService);
        }
        return simpleDefinition;
    }

    private static boolean isSoapPort(Port port) {
        List elements = port.getExtensibilityElements();
        for (ExtensibilityElement el : elements) {
            if (!(el instanceof SOAPAddress)) continue;
            return true;
        }
        return false;
    }

    private static byte[] getSchema(SymbolTable symbolTable) throws Exception {
        try {
            Types t = symbolTable.getDefinition().getTypes();
            if (t == null) {
                throw new IllegalArgumentException("No XML Schema found in the WSDL");
            }
            List types = t.getExtensibilityElements();
            if (types == null) {
                throw new IllegalArgumentException("No XML Schema found in the WSDL");
            }
            Schema schema = null;
            for (Object o : types) {
                if (!(o instanceof Schema)) continue;
                schema = (Schema)o;
            }
            if (schema == null) {
                throw new IllegalArgumentException("No XML Schema found in the WSDL");
            }
            Element schemaElement = schema.getElement();
            SOAPUtilServerSide.setSchemaNamespaces(schemaElement);
            DOMSource source = new DOMSource(schemaElement);
            ByteArrayOutputStream bo = new ByteArrayOutputStream();
            StreamResult result = new StreamResult(bo);
            Transformer xformer = TransformerFactory.newInstance().newTransformer();
            xformer.setOutputProperty("indent", "yes");
            xformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "2");
            xformer.transform(source, result);
            return bo.toByteArray();
        }
        catch (Exception e) {
            throw new Exception("Failed to get XML Schema\n" + e.getLocalizedMessage(), e);
        }
    }

    private static void setSchemaNamespaces(Element el) {
        el.removeAttribute("targetNamespace");
        String prefix = el.getPrefix();
        String namespace = el.getNamespaceURI();
        if (prefix == null || namespace == null) {
            throw new IllegalArgumentException("Failed to obtain response XML Schema from the WSDL.");
        }
        el.setAttribute("xmlns:" + prefix, namespace);
        SOAPUtilServerSide.removeOtherPrefixes(el, prefix);
    }

    private static void removeOtherPrefixes(Element el, String prefix) {
        NamedNodeMap map = el.getAttributes();
        for (int i = 0; i < map.getLength(); ++i) {
            String nodeValue;
            int colonIndex;
            Node attr = map.item(i);
            String name = attr.getLocalName();
            if (name == null || name.indexOf("type") < 0 || (colonIndex = (nodeValue = attr.getNodeValue()).indexOf(58)) <= -1 || nodeValue.subSequence(0, colonIndex).equals(prefix)) continue;
            attr.setNodeValue(nodeValue.substring(colonIndex + 1));
        }
        NodeList list = el.getChildNodes();
        for (int i = 0; i < list.getLength(); ++i) {
            Node node = list.item(i);
            if (!(node instanceof Element)) continue;
            SOAPUtilServerSide.removeOtherPrefixes((Element)node, prefix);
        }
    }

    private static boolean hasComplexTypes(Parameters p) {
        for (Parameter param : p.list) {
            TypeEntry type;
            if (param.getMode() == 2 || (type = param.getType()).isBaseType() || type.isSimpleType()) continue;
            return true;
        }
        return false;
    }

    private static SOAPParam[] convertParams(SymbolTable symbolTable, Parameters params) {
        if (params.inputs + params.inouts == 0) {
            return null;
        }
        SOAPParam[] result = new SOAPParam[params.inputs + params.inouts];
        int i = 0;
        for (Parameter parameter : params.list) {
            if (parameter.getMode() == 2) continue;
            Vector choices = SOAPUtilServerSide.getSelectionChoices(parameter);
            result[i] = choices == null || choices.isEmpty() ? new SOAPParam(parameter.getName(), SOAPUtilServerSide.getSqlType(symbolTable, parameter)) : new SOAPParamEnumeration(parameter.getName(), SOAPUtilServerSide.getSqlType(symbolTable, parameter), choices);
            ++i;
        }
        return result;
    }

    private static Vector getSelectionChoices(Parameter param) {
        TypeEntry type = param.getType();
        if (!type.isSimpleType()) {
            return null;
        }
        Node n = type.getNode();
        if (!(n instanceof Element)) {
            return null;
        }
        Element e = (Element)n;
        NodeList enumerations = e.getElementsByTagNameNS("*", "enumeration");
        if (enumerations.getLength() == 0) {
            return null;
        }
        Vector<String> values = new Vector<String>(enumerations.getLength());
        for (int j = 0; j < enumerations.getLength(); ++j) {
            String value = ((Element)enumerations.item(j)).getAttribute("value");
            values.add(value);
        }
        return values;
    }

    private static int getSqlType(SymbolTable symbolTable, Parameter parameter) {
        HashSet nestedTypes;
        TypeEntry type = parameter.getType();
        String typeName = null;
        if (type.isBaseType()) {
            typeName = SOAPUtilServerSide.getBaseTypeName(type);
        } else if (type.isSimpleType() && (nestedTypes = type.getNestedTypes(symbolTable, true)).size() == 1) {
            Type baseType = (Type)nestedTypes.iterator().next();
            typeName = SOAPUtilServerSide.getBaseTypeName((TypeEntry)baseType);
        }
        if (typeName == null) {
            return 12;
        }
        return DataType.findType(typeName);
    }

    private static String getBaseTypeName(TypeEntry type) {
        String result = type.getName();
        if (result == null) {
            result = type.getQName().getLocalPart();
        }
        return result;
    }

    private static String getDocumentation(Element el) {
        if (el == null) {
            return null;
        }
        try {
            return "<html>" + XMLUtil.readText(el) + "</html>";
        }
        catch (Exception e) {
            return null;
        }
    }
}

