/*
 * Decompiled with CFR 0.152.
 */
package quadbase.common.util.internal;

import com.sforce.soap.partner.CallOptions;
import com.sforce.soap.partner.DescribeGlobalResult;
import com.sforce.soap.partner.DescribeGlobalSObjectResult;
import com.sforce.soap.partner.DescribeSObjectResult;
import com.sforce.soap.partner.Field;
import com.sforce.soap.partner.LoginResult;
import com.sforce.soap.partner.SessionHeader;
import com.sforce.soap.partner.SforceServiceLocator;
import com.sforce.soap.partner.SoapBindingStub;
import com.sforce.soap.partner.fault.ExceptionCode;
import com.sforce.soap.partner.fault.LoginFault;
import com.sforce.soap.partner.fault.UnexpectedErrorFault;
import java.rmi.RemoteException;
import java.util.HashMap;
import javax.xml.rpc.Call;
import javax.xml.rpc.ServiceException;
import quadbase.common.paramquery.SalesForceQueryParser;
import quadbase.common.util.internal.LanguageEncoder;
import quadbase.common.util.internal.SalesForceConnectionPool;

public class SalesForceConnection {
    private static SalesForceConnectionPool pool = new SalesForceConnectionPool();
    private SoapBindingStub binding;
    private DescribeGlobalResult describeGlobal = null;
    private HashMap tableDescriptionCache = new HashMap();

    public static synchronized SalesForceConnection getSalesForceConnection(String username, String password, String clientId) throws Exception {
        SalesForceConnection c = pool.getSalesForceConnection(username, password, clientId);
        if (c != null) {
            return c;
        }
        c = new SalesForceConnection(username, password, clientId);
        pool.putSalesForceConnection(username, password, clientId, c);
        return c;
    }

    public static synchronized SalesForceConnection getSalesForceConnection2(String serverUrl, String sessionId, String clientId) throws Exception {
        SalesForceConnection c = pool.getSalesForceConnection2(serverUrl, sessionId, clientId);
        if (c != null) {
            return c;
        }
        c = new SalesForceConnection(null, serverUrl, sessionId, clientId);
        pool.putSalesForceConnection2(serverUrl, sessionId, clientId, c);
        return c;
    }

    private SalesForceConnection(String username, String password, String clientId) throws Exception {
        this.login(username, password, clientId);
    }

    private SalesForceConnection(SoapBindingStub soapBindingStub, String serverUrl, String sessionId, String clientId) throws Exception {
        CompressedSforceServiceLocator serviceLocator = new CompressedSforceServiceLocator();
        if (soapBindingStub == null) {
            this.binding = (SoapBindingStub)serviceLocator.getSoap();
            this.binding.setTimeout(60000);
        } else {
            this.binding = soapBindingStub;
        }
        this.binding._setProperty("javax.xml.rpc.service.endpoint.address", (Object)serverUrl);
        SessionHeader sh = new SessionHeader();
        sh.setSessionId(sessionId);
        this.binding.setHeader(serviceLocator.getServiceName().getNamespaceURI(), "SessionHeader", (Object)sh);
        if (clientId != null) {
            CallOptions co = new CallOptions();
            co.setClient(clientId);
            this.binding.setHeader(serviceLocator.getServiceName().getNamespaceURI(), "CallOptions", (Object)co);
        }
    }

    public String[] getTableNames() throws Exception {
        DescribeGlobalSObjectResult[] sObjects = this.describeGlobal().getSobjects();
        String[] result = new String[sObjects.length];
        for (int i = 0; i < result.length; ++i) {
            result[i] = sObjects[i].getName();
        }
        return result;
    }

    public String[] getFieldNames(String tableName) throws Exception {
        Field[] fields = this.getTableDescription(tableName).getFields();
        String[] result = new String[fields.length];
        for (int i = 0; i < fields.length; ++i) {
            result[i] = fields[i].getName();
        }
        return result;
    }

    synchronized DescribeSObjectResult getTableDescription(String tableName) throws Exception {
        if (!this.tableDescriptionCache.containsKey(tableName)) {
            this.tableDescriptionCache.put(tableName, this.binding.describeSObject(tableName));
        }
        return (DescribeSObjectResult)this.tableDescriptionCache.get(tableName);
    }

    public int getColumnDataType(String realTableName, String columnName) throws Exception {
        if (SalesForceQueryParser.isAggregatedColumn(columnName)) {
            return -1;
        }
        int lastDot = columnName.lastIndexOf(46);
        String column = lastDot > -1 ? columnName.substring(lastDot + 1) : columnName;
        Field field = this.getField(realTableName, column);
        if (field == null) {
            throw new Exception("Field '" + column + "' not found in the '" + realTableName + "' table");
        }
        return SalesForceQueryParser.mapDataType(field.getType().toString());
    }

    public String getRealTableName(String tableName, String columnName) throws Exception {
        int firstDot = (columnName = SalesForceQueryParser.removeAggregation(columnName)).indexOf(46);
        if (firstDot < 0) {
            return tableName;
        }
        String fieldName = columnName.substring(0, firstDot);
        fieldName = fieldName.endsWith("__r") ? fieldName.substring(0, fieldName.length() - 1) + "c" : fieldName + "Id";
        Field field = this.getField(tableName, fieldName);
        if (field == null && (field = this.getField(tableName, fieldName + "__r")) == null) {
            throw new Exception("Reference to '" + fieldName + "' not found in the '" + tableName + "' table");
        }
        String[] references = field.getReferenceTo();
        if (references == null || references.length == 0) {
            throw new Exception("Field '" + fieldName + "' of table '" + tableName + "' is not reference");
        }
        if (references.length > 1) {
            throw new UnsupportedOperationException("Cannot handle multi-reference field");
        }
        return this.getRealTableName(references[0], columnName.substring(firstDot + 1));
    }

    public SoapBindingStub getBinding() {
        return this.binding;
    }

    Field getField(String tableName, String fieldName) throws Exception {
        Field[] fields;
        for (Field field : fields = this.getTableDescription(tableName).getFields()) {
            if (!field.getName().equals(fieldName)) continue;
            return field;
        }
        return null;
    }

    private DescribeGlobalResult describeGlobal() throws UnexpectedErrorFault, RemoteException {
        if (this.describeGlobal == null) {
            this.describeGlobal = this.binding.describeGlobal();
        }
        return this.describeGlobal;
    }

    private void login(String userName, String password, String clientId) throws Exception {
        LoginResult loginResult;
        CompressedSforceServiceLocator serviceLocator = new CompressedSforceServiceLocator();
        this.binding = (SoapBindingStub)serviceLocator.getSoap();
        this.binding.setTimeout(60000);
        try {
            loginResult = this.binding.login(userName, password);
        }
        catch (LoginFault ex) {
            ExceptionCode exCode = ex.getExceptionCode();
            if (exCode == ExceptionCode.FUNCTIONALITY_NOT_ENABLED || exCode == ExceptionCode.INVALID_CLIENT || exCode == ExceptionCode.INVALID_LOGIN || exCode == ExceptionCode.LOGIN_DURING_RESTRICTED_DOMAIN || exCode == ExceptionCode.LOGIN_DURING_RESTRICTED_TIME || exCode == ExceptionCode.ORG_LOCKED || exCode == ExceptionCode.PASSWORD_LOCKOUT || exCode == ExceptionCode.SERVER_UNAVAILABLE || exCode == ExceptionCode.TRIAL_EXPIRED || exCode == ExceptionCode.UNSUPPORTED_CLIENT) {
                throw new Exception(LanguageEncoder.getText("Please be sure that you have a valid username and password."));
            }
            throw new Exception(LanguageEncoder.getText("An unexpected error has occurred.") + ex.getMessage(), ex);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw new Exception(LanguageEncoder.getText("An unexpected error has occurred.") + ex.getMessage(), ex);
        }
        if (loginResult.isPasswordExpired()) {
            throw new Exception("Your password has expired.");
        }
        this.binding._setProperty("javax.xml.rpc.service.endpoint.address", (Object)loginResult.getServerUrl());
        SessionHeader sh = new SessionHeader();
        sh.setSessionId(loginResult.getSessionId());
        this.binding.setHeader(serviceLocator.getServiceName().getNamespaceURI(), "SessionHeader", (Object)sh);
        if (clientId != null) {
            CallOptions co = new CallOptions();
            co.setClient(clientId);
            this.binding.setHeader(serviceLocator.getServiceName().getNamespaceURI(), "CallOptions", (Object)co);
        }
    }

    private class CompressedSforceServiceLocator
    extends SforceServiceLocator {
        private CompressedSforceServiceLocator() {
        }

        public Call createCall() throws ServiceException {
            Call call = super.createCall();
            call.setProperty("transport.http.acceptGzip", (Object)Boolean.TRUE);
            call.setProperty("transport.http.gzipRequest", (Object)Boolean.TRUE);
            return call;
        }
    }
}

