/*
 * Decompiled with CFR 0.152.
 */
package quadbase.common.util.internal;

import java.io.DataInput;
import java.io.IOException;
import quadbase.common.util.internal.IOUtil;
import quadbase.common.util.internal.VersioningDataType;

public class VersioningDataInput
implements DataInput,
VersioningDataType {
    short productVersion = 1;
    DataInput in = null;
    short product = (short)-1;
    final short PROD_REPORT = 0;
    final short PROD_CHART = 1;
    final short PROD_SCHEDULER = (short)2;
    public static final short PROD_ERES = 3;
    boolean printStackTrace = true;
    public boolean debug = false;

    public VersioningDataInput(DataInput in, short productVersion) {
        this.in = in instanceof VersioningDataInput ? ((VersioningDataInput)in).in : in;
        this.productVersion = productVersion;
        this.product = productVersion == 6612 ? (short)1 : (productVersion == 7004 ? (short)0 : (productVersion == 148 ? (short)2 : (short)3));
    }

    int getChartFeatureVersion(int featureVersion) {
        switch (featureVersion) {
            case 2002: 
            case 4002: {
                return 413;
            }
            case 2003: 
            case 4003: {
                return 414;
            }
            case 4004: {
                return 500;
            }
            case 4005: {
                return 502;
            }
        }
        return featureVersion;
    }

    int getReportFeatureVersion(int featureVersion) {
        return featureVersion;
    }

    public short[] getFeatureVersionAndType() throws IOException {
        short[] res = new short[]{this.in.readShort(), this.in.readShort()};
        return res;
    }

    void skipToNextAvailObject() throws IOException {
        this.skipToNextAvailObject((short)-100, (short)-100);
    }

    void skipToNextAvailObject(short featureVersion, short type) throws IOException {
        this.skipToNextAvailObject(featureVersion, type, (short)-100);
    }

    void skipToNextAvailObject(short featureVersion, short type, short finalFeatureVersion) throws IOException {
        int count = 0;
        while (true) {
            if (count == 0) {
                if (featureVersion == -100) {
                    featureVersion = this.in.readShort();
                }
                if (type == -100) {
                    type = this.in.readShort();
                }
            } else {
                featureVersion = this.in.readShort();
                type = this.in.readShort();
            }
            int byte_len = 0;
            int off = 0;
            int len = 0;
            if (type == 2) {
                byte_len = this.in.readInt();
                off = this.in.readInt();
                len = this.in.readInt();
            }
            if (this.product == 1) {
                if (finalFeatureVersion == -100 ? this.productVersion >= this.getChartFeatureVersion(featureVersion) : this.productVersion >= finalFeatureVersion) {
                    return;
                }
            } else if (this.product == 0) {
                if (this.productVersion >= this.getReportFeatureVersion(featureVersion)) {
                    return;
                }
            } else {
                if (this.product == 2) {
                    return;
                }
                return;
            }
            switch (type) {
                case 1: {
                    this.in.readByte();
                    break;
                }
                case 2: {
                    byte[] tmp = new byte[byte_len];
                    this.in.readFully(tmp, off, len);
                    break;
                }
                case 3: {
                    this.in.readBoolean();
                    break;
                }
                case 4: {
                    this.in.readShort();
                    break;
                }
                case 5: {
                    this.in.readChar();
                    break;
                }
                case 6: {
                    this.in.readInt();
                    break;
                }
                case 7: {
                    this.in.readLong();
                    break;
                }
                case 8: {
                    this.in.readFloat();
                    break;
                }
                case 9: {
                    this.in.readDouble();
                    break;
                }
                case 10: 
                case 11: {
                    this.in.readLine();
                    break;
                }
                case 12: {
                    this.in.readUTF();
                }
            }
            ++count;
        }
    }

    @Override
    public void readFully(byte[] b) throws IOException {
        this.skipToNextAvailObject();
        this.in.readFully(b);
    }

    @Override
    public void readFully(byte[] b, int off, int len) throws IOException {
        this.skipToNextAvailObject();
        this.in.readFully(b, off, len);
    }

    @Override
    public int skipBytes(int n) throws IOException {
        this.skipToNextAvailObject();
        return this.in.skipBytes(n);
    }

    @Override
    public boolean readBoolean() throws IOException {
        this.skipToNextAvailObject();
        return this.in.readBoolean();
    }

    public boolean readBoolean(short featureVersion) throws IOException {
        this.skipToNextAvailObject((short)-100, (short)-100, featureVersion);
        return this.in.readBoolean();
    }

    @Override
    public byte readByte() throws IOException {
        this.skipToNextAvailObject();
        return this.in.readByte();
    }

    @Override
    public int readUnsignedByte() throws IOException {
        this.skipToNextAvailObject();
        return this.in.readUnsignedByte();
    }

    @Override
    public short readShort() throws IOException {
        this.skipToNextAvailObject();
        return this.in.readShort();
    }

    @Override
    public int readUnsignedShort() throws IOException {
        this.skipToNextAvailObject();
        return this.in.readUnsignedShort();
    }

    @Override
    public char readChar() throws IOException {
        this.skipToNextAvailObject();
        return this.in.readChar();
    }

    @Override
    public int readInt() throws IOException {
        this.skipToNextAvailObject();
        return this.in.readInt();
    }

    public int readInt(short featureVersion, short type) throws IOException {
        this.skipToNextAvailObject(featureVersion, type);
        return this.in.readInt();
    }

    public int readInt(short featureVersion) throws IOException {
        this.skipToNextAvailObject((short)-100, (short)-100, featureVersion);
        return this.in.readInt();
    }

    @Override
    public long readLong() throws IOException {
        this.skipToNextAvailObject();
        return this.in.readLong();
    }

    @Override
    public float readFloat() throws IOException {
        this.skipToNextAvailObject();
        return this.in.readFloat();
    }

    @Override
    public double readDouble() throws IOException {
        this.skipToNextAvailObject();
        return this.in.readDouble();
    }

    @Override
    public String readLine() throws IOException {
        this.skipToNextAvailObject();
        return this.in.readLine();
    }

    @Override
    public String readUTF() throws IOException {
        this.skipToNextAvailObject();
        return this.in.readUTF();
    }

    public String readUTF(short featureVersion, short type) throws IOException {
        this.skipToNextAvailObject(featureVersion, type);
        return this.in.readUTF();
    }

    public String readStr() throws IOException {
        return IOUtil.readStr(this);
    }
}

