/*
 * Decompiled with CFR 0.152.
 */
package quadbase.common.util.internal;

import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import quadbase.common.util.internal.FileInMemTable;
import quadbase.common.util.internal.VersioningDataType;

public class VersioningDataOutput
implements DataOutput,
VersioningDataType {
    DataOutput out = null;
    final short OLD_VERSION = 1;
    public static boolean debug = false;
    private FileInMemTable subFilesTable = null;

    public VersioningDataOutput(DataOutput out) {
        this(out, null);
    }

    public VersioningDataOutput(DataOutput out, FileInMemTable subFilesTable) {
        this.out = out;
        this.subFilesTable = subFilesTable;
    }

    public void setSubFilesTable(FileInMemTable table) {
        this.subFilesTable = table;
    }

    public FileInMemTable getSubFilesTables() {
        return this.subFilesTable;
    }

    public void write(int b, short version) throws IOException {
        this.out.writeShort(version);
        this.out.writeShort(1);
        this.out.write(b);
        if (debug) {
            System.out.println("WRITE TYPE = 1");
        }
    }

    public void write(byte[] b, short version) throws IOException {
        this.out.writeShort(version);
        this.out.writeShort(2);
        this.out.writeInt(b.length);
        this.out.writeInt(0);
        this.out.writeInt(b.length);
        this.out.write(b);
        if (debug) {
            System.out.println("WRITE TYPE = 2");
        }
    }

    public void write(byte[] b, int off, int len, short version) throws IOException {
        this.out.writeShort(version);
        this.out.writeShort(2);
        this.out.writeInt(b.length);
        this.out.writeInt(0);
        this.out.writeInt(b.length);
        this.out.write(b, off, len);
        if (debug) {
            System.out.println("WRITE TYPE = 2");
        }
    }

    public void writeBoolean(boolean v, short version) throws IOException {
        this.out.writeShort(version);
        this.out.writeShort(3);
        this.out.writeBoolean(v);
        if (debug) {
            System.out.println("WRITE TYPE = 3");
        }
    }

    public void writeByte(int v, short version) throws IOException {
        this.out.writeShort(version);
        this.out.writeShort(1);
        this.out.writeByte(v);
        if (debug) {
            System.out.println("WRITE TYPE = 1");
        }
    }

    public void writeShort(int v, short version) throws IOException {
        this.out.writeShort(version);
        this.out.writeShort(4);
        this.out.writeShort(v);
        if (debug) {
            System.out.println("WRITE TYPE = 4");
        }
    }

    public void writeChar(int v, short version) throws IOException {
        this.out.writeShort(version);
        this.out.writeShort(5);
        this.out.writeChar(v);
        if (debug) {
            System.out.println("WRITE TYPE = 5");
        }
    }

    public void writeInt(int v, short version) throws IOException {
        this.out.writeShort(version);
        this.out.writeShort(6);
        this.out.writeInt(v);
        if (debug) {
            System.out.println("WRITE TYPE = 6");
        }
    }

    public void writeLong(long v, short version) throws IOException {
        this.out.writeShort(version);
        this.out.writeShort(7);
        this.out.writeLong(v);
        if (debug) {
            System.out.println("WRITE TYPE = 7");
        }
    }

    public void writeFloat(float v, short version) throws IOException {
        this.out.writeShort(version);
        this.out.writeShort(8);
        this.out.writeFloat(v);
        if (debug) {
            System.out.println("WRITE TYPE = 8");
        }
    }

    public void writeDouble(double v, short version) throws IOException {
        this.out.writeShort(version);
        this.out.writeShort(9);
        this.out.writeDouble(v);
        if (debug) {
            System.out.println("WRITE TYPE = 9");
        }
    }

    public void writeBytes(String s, short version) throws IOException {
        this.out.writeShort(version);
        this.out.writeShort(10);
        this.out.writeBytes(s);
        if (debug) {
            System.out.println("WRITE TYPE = 10");
        }
    }

    public void writeChars(String s, short version) throws IOException {
        this.out.writeShort(version);
        this.out.writeShort(11);
        this.out.writeChars(s);
        if (debug) {
            System.out.println("WRITE TYPE = 11");
        }
    }

    public void writeUTF(String str, short version) throws IOException {
        this.out.writeShort(version);
        this.out.writeShort(12);
        this.out.writeUTF(str);
        if (debug) {
            System.out.println("WRITE TYPE = 12");
        }
    }

    public final void writeStr(String string, short version) throws IOException {
        if (string == null) {
            this.writeBoolean(true, version);
        } else {
            this.writeBoolean(false, version);
            this.writeUTF(string, version);
        }
    }

    @Override
    public void write(int b) throws IOException {
        this.write(b, (short)1);
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.write(b, (short)1);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        this.write(b, off, len, (short)1);
    }

    @Override
    public void writeBoolean(boolean v) throws IOException {
        this.writeBoolean(v, (short)1);
    }

    @Override
    public void writeByte(int v) throws IOException {
        this.writeByte(v, (short)1);
    }

    @Override
    public void writeShort(int v) throws IOException {
        this.writeShort(v, (short)1);
    }

    @Override
    public void writeChar(int v) throws IOException {
        this.writeChar(v, (short)1);
    }

    @Override
    public void writeInt(int v) throws IOException {
        this.writeInt(v, (short)1);
    }

    @Override
    public void writeLong(long v) throws IOException {
        this.writeLong(v, (short)1);
    }

    @Override
    public void writeFloat(float v) throws IOException {
        this.writeFloat(v, (short)1);
    }

    @Override
    public void writeDouble(double v) throws IOException {
        this.writeDouble(v, (short)1);
    }

    @Override
    public void writeBytes(String s) throws IOException {
        this.writeBytes(s, (short)1);
    }

    @Override
    public void writeChars(String s) throws IOException {
        this.writeChars(s, (short)1);
    }

    @Override
    public void writeUTF(String str) throws IOException {
        this.writeUTF(str, (short)1);
    }

    public void flush() throws IOException {
        if (this.out instanceof DataOutputStream) {
            ((DataOutputStream)this.out).flush();
        }
    }

    public DataOutput getOriginalDataOutput() {
        return this.out;
    }
}

