/*
 * Decompiled with CFR 0.152.
 */
package quadbase.common.util.internal;

import java.applet.Applet;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Vector;
import quadbase.common.client.ServerMessage;
import quadbase.common.network.IConnection;
import quadbase.common.util.internal.DataType;
import quadbase.common.util.internal.IOUtil;
import quadbase.common.util.internal.XMLFileQueryInfo;
import quadbase.common.util.internal.XMLQueryResultSet;

public class XMLDataSheetProc {
    ServerMessage sm;

    public Vector executeQuery(XMLFileQueryInfo xmlInfo, int startIndex, int displayRow) {
        if (!ServerMessage.useServer && ServerMessage.isLoadBalancer || xmlInfo.getFileName() == null) {
            return this.getResult(xmlInfo, startIndex, displayRow);
        }
        IConnection socket = null;
        try {
            socket = ServerMessage.createConnection();
            ByteArrayOutputStream bstream = new ByteArrayOutputStream(1024);
            DataOutputStream out = new DataOutputStream(bstream);
            out.writeShort(32420);
            xmlInfo.write(out);
            out.writeInt(startIndex);
            out.writeInt(displayRow);
            byte[] array = bstream.toByteArray();
            socket.setContentLength(array.length);
            socket.getOutputStream().write(array);
            socket.getOutputStream().flush();
            DataInputStream din = new DataInputStream(socket.getInputStream());
            int code = din.readInt();
            if (code != 0) {
                throw new IOException(IOUtil.getErrorString(code) + IOUtil.readString(din, true));
            }
            int len = din.readInt();
            byte[] indata = new byte[len];
            din.readFully(indata, 0, len);
            din.close();
            socket.close();
            return this.getResultFromStream(new DataInputStream(new ByteArrayInputStream(indata)));
        }
        catch (Exception ex) {
            try {
                socket.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            ex.printStackTrace();
            return new Vector();
        }
    }

    public Vector getResultFromStream(DataInput din) throws Exception {
        Vector result = new Vector();
        int nRow = din.readInt();
        int nCol = din.readInt();
        String[] columnNames = new String[nCol];
        int[] dataType = new int[nCol];
        for (int j = 0; j < nCol; ++j) {
            columnNames[j] = IOUtil.readString(din, true);
            dataType[j] = din.readInt();
        }
        for (int i = 0; i < nRow; ++i) {
            Vector<Object> row = new Vector<Object>();
            for (int j = 0; j < nCol; ++j) {
                Object obj = DataType.read(din, dataType[j], 6602, true);
                row.addElement(obj);
            }
            result.addElement(row);
        }
        return result;
    }

    private Vector getResult(XMLFileQueryInfo xmlFileQueryInfo, int startIndex, int displayRow) {
        Vector result = new Vector();
        try {
            if (xmlFileQueryInfo != null) {
                XMLQueryResultSet rs = this.createXMLQueryResultSet(xmlFileQueryInfo);
                result = this.setData(rs, startIndex, displayRow);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    XMLQueryResultSet createXMLQueryResultSet(XMLFileQueryInfo xmlInfo) throws Exception {
        Applet applet = ServerMessage.getApplet();
        String filename = xmlInfo.getFileName();
        byte[] data = xmlInfo.getData();
        if (data != null) {
            return new XMLQueryResultSet(new ByteArrayInputStream(data), xmlInfo.getFieldInfo(), xmlInfo.getCondition(), xmlInfo.getConditionInfo(), xmlInfo.getDTDName(), xmlInfo.isVerify(), xmlInfo.getInSet());
        }
        String urlfile = filename;
        if ((filename = filename.replace('\\', '/')).startsWith("http://") || filename.startsWith("https://") || filename.startsWith("file://")) {
            xmlInfo.setFileName(urlfile);
            return new XMLQueryResultSet(xmlInfo);
        }
        if (!filename.startsWith("/") && filename.indexOf(58) < 0) {
            if (applet != null) {
                xmlInfo.setFileName(IOUtil.getCodeBase(applet) + filename);
                return new XMLQueryResultSet(xmlInfo);
            }
            return new XMLQueryResultSet(IOUtil.createFile(filename), xmlInfo.getFieldInfo(), xmlInfo.getCondition(), xmlInfo.getConditionInfo(), xmlInfo.getDTDName(), xmlInfo.isVerify(), xmlInfo.getInSet());
        }
        xmlInfo.setFileName(filename);
        return new XMLQueryResultSet(xmlInfo);
    }

    private Vector setData(XMLQueryResultSet rs, int startIndex, int displayRow) throws Exception {
        if (rs == null) {
            return new Vector();
        }
        int nCol = rs.getColumnCount();
        Vector result = new Vector();
        Vector<Object> row = new Vector<Object>();
        for (int nRow = 0; rs.next() && (displayRow < 0 || nRow < startIndex + displayRow); ++nRow) {
            if (nRow < startIndex) continue;
            row = new Vector();
            for (int i = 1; i <= nCol; ++i) {
                row.addElement(rs.getObject(i));
            }
            result.addElement(row);
        }
        try {
            rs.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result;
    }
}

