/*
 * Decompiled with CFR 0.152.
 */
package quadbase.common.util.internal;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.Writer;
import java.util.StringTokenizer;
import java.util.Vector;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import quadbase.common.util.internal.Coder;
import quadbase.common.util.internal.IOUtil;
import quadbase.common.util.internal.XMLUtil;

public class XMLFieldInfo {
    String[] path;
    String eltDataType = "string";
    String attrName = null;
    String attrDataType = null;
    String dateFormat = null;
    int xmlType = 1;
    boolean isExpandable = true;
    boolean isRequired = false;
    String alias;
    boolean recursive = false;
    public static final String XMLTAG = "XMLFIELDINFO";
    public static final int VERSION = 2;

    public XMLFieldInfo() {
    }

    public XMLFieldInfo(String[] path) {
        this.path = path;
        this.alias = this.getDefaultAlias();
    }

    public XMLFieldInfo(String[] path, String attrName) {
        this.path = path;
        this.attrName = attrName;
        if (attrName != null && !attrName.equals("")) {
            this.xmlType = 2;
            this.attrDataType = "string";
        }
        this.alias = this.getDefaultAlias();
    }

    public boolean equalsPath(XMLFieldInfo tmp) {
        if (this.equals(tmp)) {
            return true;
        }
        if (this.xmlType != tmp.xmlType) {
            return false;
        }
        if (this.path.length != tmp.path.length) {
            return false;
        }
        for (int i = 0; i < this.path.length; ++i) {
            if (this.path[i].equals(tmp.path[i])) continue;
            return false;
        }
        return this.attrName == null || this.attrName.equals(tmp.attrName);
    }

    public String[] getPath() {
        return this.path;
    }

    public void setPath(String[] path) {
        this.path = path;
    }

    public String getDisplayName() {
        if (this.attrName == null || this.attrName.trim().equals("")) {
            return this.getPathToString();
        }
        return this.getPathToString() + "/@" + this.attrName;
    }

    private String getDefaultAlias() {
        if (this.path.length >= 1) {
            if (this.attrName != null && this.attrName.trim() != "") {
                return this.path[this.path.length - 1] + "/@" + this.attrName;
            }
            return this.path[this.path.length - 1];
        }
        return "";
    }

    public String getPathToString() {
        if (this.path == null || this.path.length == 0) {
            return null;
        }
        String str = "/" + this.path[0];
        for (int i = 1; i < this.path.length; ++i) {
            str = str + "/" + this.path[i];
        }
        return str;
    }

    public String getColumnName() {
        String s = this.getPathToString();
        if (this.getAttributeName() != null) {
            s = s + "/@" + this.getAttributeName();
        }
        return s;
    }

    public static String getDisplayName(String[] path, String attrName) {
        if (path == null || path.length == 0) {
            return "";
        }
        String str = "/" + path[0];
        for (int i = 1; i < path.length; ++i) {
            str = str + "/" + path[i];
        }
        if (attrName == null || attrName.trim().equals("")) {
            return str;
        }
        return str + "/@" + attrName;
    }

    public static String[] createPathFromString(String pathStr) {
        return XMLFieldInfo.createPathFromString(pathStr, "/");
    }

    public static String[] createPathFromString(String pathStr, String delimiter) {
        Vector<String> vec = new Vector<String>();
        if (pathStr.startsWith("/")) {
            pathStr = pathStr.substring(1);
        }
        StringTokenizer st = new StringTokenizer(pathStr, delimiter);
        while (st.hasMoreTokens()) {
            String temp = st.nextToken();
            if (temp.startsWith("@")) continue;
            vec.addElement(temp);
        }
        String[] path = new String[vec.size()];
        for (int i = 0; i < vec.size(); ++i) {
            path[i] = (String)vec.elementAt(i);
        }
        return path;
    }

    public static String createAttributeNameFromString(String str) {
        return XMLFieldInfo.createAttributeNameFromString(str, "/");
    }

    public static String createAttributeNameFromString(String str, String delimiter) {
        StringTokenizer st = new StringTokenizer(str, delimiter);
        while (st.hasMoreTokens()) {
            String temp = st.nextToken();
            if (!temp.startsWith("@")) continue;
            if (st.hasMoreTokens()) {
                System.out.println("attribute shouldn't follow by element name!");
            }
            return temp.substring(1);
        }
        return null;
    }

    public String getElementDataType() {
        return this.eltDataType;
    }

    public void setElementDataType(String type) {
        this.eltDataType = type;
    }

    public String getAttributeDataType() {
        return this.attrDataType;
    }

    public void setAttributeDataType(String type) {
        this.attrDataType = type;
    }

    public String getAttributeName() {
        return this.attrName;
    }

    public void setAttributeName(String attr) {
        this.attrName = attr;
    }

    public String getDateFormat() {
        return this.dateFormat;
    }

    public void setDateFormat(String format) {
        this.dateFormat = format;
    }

    public String getDataType() {
        if (this.xmlType == 1) {
            return this.getElementDataType();
        }
        return this.getAttributeDataType();
    }

    public int getXMLType() {
        return this.xmlType;
    }

    public void setXMLType(int type) {
        this.xmlType = type;
    }

    public boolean isExpandable() {
        return this.isExpandable;
    }

    public void setIsExpandable(boolean state) {
        this.isExpandable = state;
    }

    public boolean isRequired() {
        return this.isRequired;
    }

    public void setIsRequired(boolean state) {
        this.isRequired = state;
    }

    public boolean isRecursive() {
        return this.recursive;
    }

    public void setRecursive(boolean state) {
        this.recursive = state;
    }

    public String getAlias() {
        if (this.alias != null) {
            return this.alias;
        }
        return this.getPathToString();
    }

    public void setAlias(String alias) {
        this.alias = alias;
    }

    public void write(DataOutput out) throws IOException {
        this.write(out, false);
    }

    public void write(DataOutput out, boolean encode) throws IOException {
        int len = this.path.length;
        out.writeInt(len);
        for (int i = 0; i < len; ++i) {
            if (encode) {
                IOUtil.writeString(out, Coder.encode(this.path[i]));
                continue;
            }
            IOUtil.writeString(out, this.path[i]);
        }
        out.writeInt(this.xmlType);
        if (this.xmlType == 1) {
            if (encode) {
                IOUtil.writeString(out, Coder.encode(this.eltDataType));
                if (this.eltDataType.equals("date") || this.eltDataType.equals("time") || this.eltDataType.equals("timestamp")) {
                    IOUtil.writeString(out, Coder.encode(this.dateFormat));
                }
            } else {
                IOUtil.writeString(out, this.eltDataType);
                if (this.eltDataType.equals("date") || this.eltDataType.equals("time") || this.eltDataType.equals("timestamp")) {
                    IOUtil.writeString(out, this.dateFormat);
                }
            }
        } else if (this.xmlType == 2) {
            if (encode) {
                IOUtil.writeString(out, Coder.encode(this.attrName));
                IOUtil.writeString(out, Coder.encode(this.attrDataType));
                if (this.attrDataType.equals("date") || this.attrDataType.equals("time") || this.attrDataType.equals("timestamp")) {
                    IOUtil.writeString(out, Coder.encode(this.dateFormat));
                }
            } else {
                IOUtil.writeString(out, this.attrName);
                IOUtil.writeString(out, this.attrDataType);
                if (this.attrDataType.equals("date") || this.attrDataType.equals("time") || this.attrDataType.equals("timestamp")) {
                    IOUtil.writeString(out, this.dateFormat);
                }
            }
        }
        out.writeBoolean(this.isExpandable);
        out.writeBoolean(this.isRequired);
        if (encode) {
            IOUtil.writeString(out, Coder.encode(this.alias));
        } else {
            IOUtil.writeString(out, this.alias);
        }
        out.writeBoolean(this.recursive);
    }

    public static XMLFieldInfo createXMLFieldInfo(DataInput in, int version) throws IOException {
        return XMLFieldInfo.createXMLFieldInfo(in, version, false);
    }

    public static XMLFieldInfo createXMLFieldInfo(DataInput in, int version, boolean decode) throws IOException {
        XMLFieldInfo field = new XMLFieldInfo();
        field.read(in, version, decode);
        return field;
    }

    private void read(DataInput in, int version, boolean decode) throws IOException {
        int len = in.readInt();
        this.path = new String[len];
        for (int i = 0; i < len; ++i) {
            this.path[i] = decode ? Coder.decode(IOUtil.readString(in, true)) : IOUtil.readString(in, true);
        }
        this.xmlType = in.readInt();
        if (this.xmlType == 1) {
            if (decode) {
                this.eltDataType = Coder.decode(IOUtil.readString(in, true));
                if (this.eltDataType.equals("date") || this.eltDataType.equals("time") || this.eltDataType.equals("timestamp")) {
                    this.dateFormat = Coder.decode(IOUtil.readString(in, true));
                }
            } else {
                this.eltDataType = IOUtil.readString(in, true);
                if (this.eltDataType.equals("date") || this.eltDataType.equals("time") || this.eltDataType.equals("timestamp")) {
                    this.dateFormat = IOUtil.readString(in, true);
                }
            }
        } else if (this.xmlType == 2) {
            if (decode) {
                this.attrName = Coder.decode(IOUtil.readString(in, true));
                this.attrDataType = Coder.decode(IOUtil.readString(in, true));
                if (this.attrDataType.equals("date") || this.attrDataType.equals("time") || this.attrDataType.equals("timestamp")) {
                    this.dateFormat = Coder.decode(IOUtil.readString(in, true));
                }
            } else {
                this.attrName = IOUtil.readString(in, true);
                this.attrDataType = IOUtil.readString(in, true);
                if (this.attrDataType.equals("date") || this.attrDataType.equals("time") || this.attrDataType.equals("timestamp")) {
                    this.dateFormat = IOUtil.readString(in, true);
                }
            }
        }
        this.isExpandable = in.readBoolean();
        this.isRequired = in.readBoolean();
        this.alias = decode ? Coder.decode(IOUtil.readString(in, true)) : IOUtil.readString(in, true);
        if (version > 1) {
            this.recursive = in.readBoolean();
        }
    }

    void write(Writer out, String str) throws IOException {
        out.write(str);
    }

    public void writeXML(Writer dout) throws IOException {
        this.write(dout, "<XMLFIELDINFO>\n");
        this.write(dout, "<PATHLENGTH>" + this.path.length + "</PATHLENGTH>\n");
        this.write(dout, "<PATHSTRING>" + XMLUtil.encodeXML(this.getPathToString()) + "</PATHSTRING>\n");
        this.write(dout, "<XMLTYPE>" + this.xmlType + "</XMLTYPE>\n");
        if (this.xmlType == 1) {
            this.write(dout, "<ELTDATATYPE>" + this.eltDataType + "</ELTDATATYPE>\n");
        } else if (this.xmlType == 2) {
            this.write(dout, "<ATTRNAME>" + XMLUtil.encodeXML(this.attrName) + "</ATTRNAME>\n");
            this.write(dout, "<ATTRDATATYPE>" + this.attrDataType + "</ATTRDATATYPE>\n");
        }
        if (this.dateFormat != null && !this.dateFormat.trim().equals("")) {
            this.write(dout, "<DATEFORMAT>" + XMLUtil.encodeXML(this.dateFormat) + "</DATEFORMAT>\n");
        }
        this.write(dout, "<EXPANDABLE>" + this.isExpandable + "</EXPANDABLE>\n");
        this.write(dout, "<REQUIRED>" + this.isRequired + "</REQUIRED>\n");
        this.write(dout, "<ALIAS>" + XMLUtil.encodeXML(this.alias) + "</ALIAS>\n");
        this.write(dout, "<RECURSIVE>" + this.recursive + "</RECURSIVE>\n");
        this.write(dout, "</XMLFIELDINFO>\n");
    }

    public static XMLFieldInfo readXML(Node dnode, int version) throws Exception {
        if (dnode.getNodeName().equalsIgnoreCase(XMLTAG)) {
            int count = 0;
            String pathStr = null;
            int xmlType = 1;
            String eltDataType = null;
            String attrName = null;
            String attrDataType = null;
            String dateFormat = null;
            boolean isExpandable = true;
            boolean isRequired = false;
            String alias = null;
            boolean recursive = false;
            NodeList nodeList = dnode.getChildNodes();
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Node node = nodeList.item(i);
                if (node.getNodeName().equalsIgnoreCase("PATHLENGTH")) {
                    count = Integer.parseInt(XMLUtil.readText(node));
                    continue;
                }
                if (node.getNodeName().equalsIgnoreCase("PATHSTRING")) {
                    pathStr = XMLUtil.readText(node);
                    continue;
                }
                if (node.getNodeName().equalsIgnoreCase("XMLTYPE")) {
                    xmlType = Integer.parseInt(XMLUtil.readText(node));
                    continue;
                }
                if (node.getNodeName().equalsIgnoreCase("ELTDATATYPE")) {
                    eltDataType = XMLUtil.readText(node);
                    continue;
                }
                if (node.getNodeName().equalsIgnoreCase("ATTRNAME")) {
                    attrName = XMLUtil.readText(node);
                    continue;
                }
                if (node.getNodeName().equalsIgnoreCase("ATTRDATATYPE")) {
                    attrDataType = XMLUtil.readText(node);
                    continue;
                }
                if (node.getNodeName().equalsIgnoreCase("DATEFORMAT")) {
                    dateFormat = XMLUtil.readText(node);
                    continue;
                }
                if (node.getNodeName().equalsIgnoreCase("EXPANDABLE")) {
                    isExpandable = XMLUtil.parseBoolean(XMLUtil.readText(node));
                    continue;
                }
                if (node.getNodeName().equalsIgnoreCase("REQUIRED")) {
                    isRequired = XMLUtil.parseBoolean(XMLUtil.readText(node));
                    continue;
                }
                if (node.getNodeName().equalsIgnoreCase("ALIAS")) {
                    alias = XMLUtil.readText(node);
                    continue;
                }
                if (!node.getNodeName().equalsIgnoreCase("RECURSIVE")) continue;
                recursive = XMLUtil.parseBoolean(XMLUtil.readText(node));
            }
            String[] path = new String[count];
            StringTokenizer st = new StringTokenizer(pathStr, "/");
            for (int i = 0; st.hasMoreTokens() && i < count; ++i) {
                path[i] = st.nextToken();
            }
            XMLFieldInfo field = new XMLFieldInfo(path);
            field.setXMLType(xmlType);
            if (eltDataType != null) {
                field.setElementDataType(eltDataType);
            }
            if (attrName != null) {
                field.setAttributeName(attrName);
            }
            if (attrDataType != null) {
                field.setAttributeDataType(attrDataType);
            }
            if (dateFormat != null) {
                field.setDateFormat(dateFormat);
            }
            field.setIsExpandable(isExpandable);
            field.setIsRequired(isRequired);
            if (alias != null) {
                field.setAlias(alias);
            }
            field.setRecursive(recursive);
            return field;
        }
        return null;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("<< XMLFieldInfo >>\n");
        sb.append("path   = " + this.getPathToString() + "\n");
        sb.append("xmlType      = " + this.xmlType + "\n");
        sb.append("eltDataType   = " + this.getElementDataType() + "\n");
        sb.append("attrName   = " + this.getAttributeName() + "\n");
        sb.append("attrDataType   = " + this.getAttributeDataType() + "\n");
        sb.append("dateFormat   = " + this.getDateFormat() + "\n");
        sb.append("isExpandable = " + this.isExpandable() + "\n");
        sb.append("isRequired = " + this.isRequired() + "\n");
        sb.append("alias    = " + this.getAlias() + "\n");
        sb.append("recursive    = " + this.isRecursive() + "\n");
        return sb.toString();
    }
}

